# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['R2BucketSippyArgs', 'R2BucketSippy']

@pulumi.input_type
class R2BucketSippyArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 bucket_name: pulumi.Input[_builtins.str],
                 destination: Optional[pulumi.Input['R2BucketSippyDestinationArgs']] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['R2BucketSippySourceArgs']] = None):
        """
        The set of arguments for constructing a R2BucketSippy resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input['R2BucketSippyDestinationArgs'] destination: R2 bucket to copy objects to.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input['R2BucketSippySourceArgs'] source: AWS S3 bucket to copy objects from.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['R2BucketSippyDestinationArgs']]:
        """
        R2 bucket to copy objects to.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['R2BucketSippyDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['R2BucketSippySourceArgs']]:
        """
        AWS S3 bucket to copy objects from.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['R2BucketSippySourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _R2BucketSippyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['R2BucketSippyDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['R2BucketSippySourceArgs']] = None):
        """
        Input properties used for looking up and filtering R2BucketSippy resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input['R2BucketSippyDestinationArgs'] destination: R2 bucket to copy objects to.
        :param pulumi.Input[_builtins.bool] enabled: State of Sippy for this bucket.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input['R2BucketSippySourceArgs'] source: AWS S3 bucket to copy objects from.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['R2BucketSippyDestinationArgs']]:
        """
        R2 bucket to copy objects to.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['R2BucketSippyDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        State of Sippy for this bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['R2BucketSippySourceArgs']]:
        """
        AWS S3 bucket to copy objects from.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['R2BucketSippySourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.type_token("cloudflare:index/r2BucketSippy:R2BucketSippy")
class R2BucketSippy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['R2BucketSippyDestinationArgs', 'R2BucketSippyDestinationArgsDict']]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['R2BucketSippySourceArgs', 'R2BucketSippySourceArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[Union['R2BucketSippyDestinationArgs', 'R2BucketSippyDestinationArgsDict']] destination: R2 bucket to copy objects to.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[Union['R2BucketSippySourceArgs', 'R2BucketSippySourceArgsDict']] source: AWS S3 bucket to copy objects from.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: R2BucketSippyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param R2BucketSippyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(R2BucketSippyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['R2BucketSippyDestinationArgs', 'R2BucketSippyDestinationArgsDict']]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['R2BucketSippySourceArgs', 'R2BucketSippySourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = R2BucketSippyArgs.__new__(R2BucketSippyArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["destination"] = destination
            __props__.__dict__["jurisdiction"] = jurisdiction
            __props__.__dict__["source"] = source
            __props__.__dict__["enabled"] = None
        super(R2BucketSippy, __self__).__init__(
            'cloudflare:index/r2BucketSippy:R2BucketSippy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['R2BucketSippyDestinationArgs', 'R2BucketSippyDestinationArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['R2BucketSippySourceArgs', 'R2BucketSippySourceArgsDict']]] = None) -> 'R2BucketSippy':
        """
        Get an existing R2BucketSippy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[Union['R2BucketSippyDestinationArgs', 'R2BucketSippyDestinationArgsDict']] destination: R2 bucket to copy objects to.
        :param pulumi.Input[_builtins.bool] enabled: State of Sippy for this bucket.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[Union['R2BucketSippySourceArgs', 'R2BucketSippySourceArgsDict']] source: AWS S3 bucket to copy objects from.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _R2BucketSippyState.__new__(_R2BucketSippyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["destination"] = destination
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["jurisdiction"] = jurisdiction
        __props__.__dict__["source"] = source
        return R2BucketSippy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional['outputs.R2BucketSippyDestination']]:
        """
        R2 bucket to copy objects to.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        State of Sippy for this bucket.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> pulumi.Output[_builtins.str]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional['outputs.R2BucketSippySource']]:
        """
        AWS S3 bucket to copy objects from.
        """
        return pulumi.get(self, "source")

