# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['R2CustomDomainArgs', 'R2CustomDomain']

@pulumi.input_type
class R2CustomDomainArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 bucket_name: pulumi.Input[_builtins.str],
                 domain: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 zone_id: pulumi.Input[_builtins.str],
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a R2CustomDomain resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain to be added.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID of the custom domain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] min_tls: Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
               Available values: "1.0", "1.1", "1.2", "1.3".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "zone_id", zone_id)
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if min_tls is not None:
            pulumi.set(__self__, "min_tls", min_tls)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the custom domain to be added.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Zone ID of the custom domain.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ciphers", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @_builtins.property
    @pulumi.getter(name="minTls")
    def min_tls(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
        Available values: "1.0", "1.1", "1.2", "1.3".
        """
        return pulumi.get(self, "min_tls")

    @min_tls.setter
    def min_tls(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_tls", value)


@pulumi.input_type
class _R2CustomDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input['R2CustomDomainStatusArgs']] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering R2CustomDomain resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain to be added.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] min_tls: Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
               Available values: "1.0", "1.1", "1.2", "1.3".
        :param pulumi.Input[_builtins.str] zone_id: Zone ID of the custom domain.
        :param pulumi.Input[_builtins.str] zone_name: Zone that the custom domain resides in.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if min_tls is not None:
            pulumi.set(__self__, "min_tls", min_tls)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_name is not None:
            pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ciphers", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the custom domain to be added.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @_builtins.property
    @pulumi.getter(name="minTls")
    def min_tls(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
        Available values: "1.0", "1.1", "1.2", "1.3".
        """
        return pulumi.get(self, "min_tls")

    @min_tls.setter
    def min_tls(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_tls", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['R2CustomDomainStatusArgs']]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['R2CustomDomainStatusArgs']]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID of the custom domain.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone that the custom domain resides in.
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_name", value)


@pulumi.type_token("cloudflare:index/r2CustomDomain:R2CustomDomain")
class R2CustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_custom_domain = cloudflare.R2CustomDomain("example_r2_custom_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            domain="prefix.example-domain.com",
            enabled=True,
            zone_id="36ca64a6d92827b8a6b90be344bb1bfd",
            ciphers=["string"],
            min_tls="1.0")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain to be added.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] min_tls: Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
               Available values: "1.0", "1.1", "1.2", "1.3".
        :param pulumi.Input[_builtins.str] zone_id: Zone ID of the custom domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: R2CustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_custom_domain = cloudflare.R2CustomDomain("example_r2_custom_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            domain="prefix.example-domain.com",
            enabled=True,
            zone_id="36ca64a6d92827b8a6b90be344bb1bfd",
            ciphers=["string"],
            min_tls="1.0")
        ```

        :param str resource_name: The name of the resource.
        :param R2CustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(R2CustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = R2CustomDomainArgs.__new__(R2CustomDomainArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["ciphers"] = ciphers
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["jurisdiction"] = jurisdiction
            __props__.__dict__["min_tls"] = min_tls
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
            __props__.__dict__["zone_name"] = None
        super(R2CustomDomain, __self__).__init__(
            'cloudflare:index/r2CustomDomain:R2CustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
            min_tls: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[Union['R2CustomDomainStatusArgs', 'R2CustomDomainStatusArgsDict']]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'R2CustomDomain':
        """
        Get an existing R2CustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain to be added.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] min_tls: Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
               Available values: "1.0", "1.1", "1.2", "1.3".
        :param pulumi.Input[_builtins.str] zone_id: Zone ID of the custom domain.
        :param pulumi.Input[_builtins.str] zone_name: Zone that the custom domain resides in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _R2CustomDomainState.__new__(_R2CustomDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["ciphers"] = ciphers
        __props__.__dict__["domain"] = domain
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["jurisdiction"] = jurisdiction
        __props__.__dict__["min_tls"] = min_tls
        __props__.__dict__["status"] = status
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_name"] = zone_name
        return R2CustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the custom domain to be added.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable public bucket access at the custom domain. If undefined, the domain will be enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> pulumi.Output[_builtins.str]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @_builtins.property
    @pulumi.getter(name="minTls")
    def min_tls(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
        Available values: "1.0", "1.1", "1.2", "1.3".
        """
        return pulumi.get(self, "min_tls")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.R2CustomDomainStatus']:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Zone ID of the custom domain.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Output[_builtins.str]:
        """
        Zone that the custom domain resides in.
        """
        return pulumi.get(self, "zone_name")

