# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['R2ManagedDomainArgs', 'R2ManagedDomain']

@pulumi.input_type
class R2ManagedDomainArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 bucket_name: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a R2ManagedDomain resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the r2.dev domain.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "enabled", enabled)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable public bucket access at the r2.dev domain.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)


@pulumi.input_type
class _R2ManagedDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering R2ManagedDomain resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_id: Bucket ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] domain: Domain name of the bucket's r2.dev domain.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the r2.dev domain.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bucket_id is not None:
            pulumi.set(__self__, "bucket_id", bucket_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bucket ID.
        """
        return pulumi.get(self, "bucket_id")

    @bucket_id.setter
    def bucket_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name of the bucket's r2.dev domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable public bucket access at the r2.dev domain.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)


@pulumi.type_token("cloudflare:index/r2ManagedDomain:R2ManagedDomain")
class R2ManagedDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_managed_domain = cloudflare.R2ManagedDomain("example_r2_managed_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the r2.dev domain.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: R2ManagedDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_managed_domain = cloudflare.R2ManagedDomain("example_r2_managed_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param R2ManagedDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(R2ManagedDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = R2ManagedDomainArgs.__new__(R2ManagedDomainArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["jurisdiction"] = jurisdiction
            __props__.__dict__["bucket_id"] = None
            __props__.__dict__["domain"] = None
        super(R2ManagedDomain, __self__).__init__(
            'cloudflare:index/r2ManagedDomain:R2ManagedDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            jurisdiction: Optional[pulumi.Input[_builtins.str]] = None) -> 'R2ManagedDomain':
        """
        Get an existing R2ManagedDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_id: Bucket ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] domain: Domain name of the bucket's r2.dev domain.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable public bucket access at the r2.dev domain.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _R2ManagedDomainState.__new__(_R2ManagedDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bucket_id"] = bucket_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["jurisdiction"] = jurisdiction
        return R2ManagedDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> pulumi.Output[_builtins.str]:
        """
        Bucket ID.
        """
        return pulumi.get(self, "bucket_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name of the bucket's r2.dev domain.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable public bucket access at the r2.dev domain.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> pulumi.Output[_builtins.str]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

