# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpectrumApplicationArgs', 'SpectrumApplication']

@pulumi.input_type
class SpectrumApplicationArgs:
    def __init__(__self__, *,
                 dns: pulumi.Input['SpectrumApplicationDnsArgs'],
                 protocol: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 argo_smart_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_ips: Optional[pulumi.Input['SpectrumApplicationEdgeIpsArgs']] = None,
                 ip_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_directs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_dns: Optional[pulumi.Input['SpectrumApplicationOriginDnsArgs']] = None,
                 origin_port: Optional[Any] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpectrumApplication resource.
        :param pulumi.Input['SpectrumApplicationDnsArgs'] dns: The name and type of DNS record for the Spectrum application.
        :param pulumi.Input[_builtins.str] protocol: The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        :param pulumi.Input[_builtins.str] zone_id: Zone identifier.
        :param pulumi.Input[_builtins.bool] argo_smart_routing: Enables Argo Smart Routing for this application.
               Notes: Only available for TCP applications with traffic_type set to "direct".
        :param pulumi.Input['SpectrumApplicationEdgeIpsArgs'] edge_ips: The anycast edge IP configuration for the hostname of this application.
        :param pulumi.Input[_builtins.bool] ip_firewall: Enables IP Access Rules for this application.
               Notes: Only available for TCP applications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] origin_directs: List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        :param pulumi.Input['SpectrumApplicationOriginDnsArgs'] origin_dns: The name and type of DNS record for the Spectrum application.
        :param Any origin_port: The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
               Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        :param pulumi.Input[_builtins.str] proxy_protocol: Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
               Available values: "off", "v1", "v2", "simple".
        :param pulumi.Input[_builtins.str] tls: The type of TLS termination associated with the application.
               Available values: "off", "flexible", "full", "strict".
        :param pulumi.Input[_builtins.str] traffic_type: Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
               Available values: "direct", "http", "https".
        """
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "zone_id", zone_id)
        if argo_smart_routing is not None:
            pulumi.set(__self__, "argo_smart_routing", argo_smart_routing)
        if edge_ips is not None:
            pulumi.set(__self__, "edge_ips", edge_ips)
        if ip_firewall is not None:
            pulumi.set(__self__, "ip_firewall", ip_firewall)
        if origin_directs is not None:
            pulumi.set(__self__, "origin_directs", origin_directs)
        if origin_dns is not None:
            pulumi.set(__self__, "origin_dns", origin_dns)
        if origin_port is not None:
            pulumi.set(__self__, "origin_port", origin_port)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if traffic_type is not None:
            pulumi.set(__self__, "traffic_type", traffic_type)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> pulumi.Input['SpectrumApplicationDnsArgs']:
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: pulumi.Input['SpectrumApplicationDnsArgs']):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Zone identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="argoSmartRouting")
    def argo_smart_routing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables Argo Smart Routing for this application.
        Notes: Only available for TCP applications with traffic_type set to "direct".
        """
        return pulumi.get(self, "argo_smart_routing")

    @argo_smart_routing.setter
    def argo_smart_routing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "argo_smart_routing", value)

    @_builtins.property
    @pulumi.getter(name="edgeIps")
    def edge_ips(self) -> Optional[pulumi.Input['SpectrumApplicationEdgeIpsArgs']]:
        """
        The anycast edge IP configuration for the hostname of this application.
        """
        return pulumi.get(self, "edge_ips")

    @edge_ips.setter
    def edge_ips(self, value: Optional[pulumi.Input['SpectrumApplicationEdgeIpsArgs']]):
        pulumi.set(self, "edge_ips", value)

    @_builtins.property
    @pulumi.getter(name="ipFirewall")
    def ip_firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables IP Access Rules for this application.
        Notes: Only available for TCP applications.
        """
        return pulumi.get(self, "ip_firewall")

    @ip_firewall.setter
    def ip_firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_firewall", value)

    @_builtins.property
    @pulumi.getter(name="originDirects")
    def origin_directs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        """
        return pulumi.get(self, "origin_directs")

    @origin_directs.setter
    def origin_directs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "origin_directs", value)

    @_builtins.property
    @pulumi.getter(name="originDns")
    def origin_dns(self) -> Optional[pulumi.Input['SpectrumApplicationOriginDnsArgs']]:
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "origin_dns")

    @origin_dns.setter
    def origin_dns(self, value: Optional[pulumi.Input['SpectrumApplicationOriginDnsArgs']]):
        pulumi.set(self, "origin_dns", value)

    @_builtins.property
    @pulumi.getter(name="originPort")
    def origin_port(self) -> Optional[Any]:
        """
        The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
        Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        """
        return pulumi.get(self, "origin_port")

    @origin_port.setter
    def origin_port(self, value: Optional[Any]):
        pulumi.set(self, "origin_port", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
        Available values: "off", "v1", "v2", "simple".
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_protocol", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of TLS termination associated with the application.
        Available values: "off", "flexible", "full", "strict".
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls", value)

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
        Available values: "direct", "http", "https".
        """
        return pulumi.get(self, "traffic_type")

    @traffic_type.setter
    def traffic_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_type", value)


@pulumi.input_type
class _SpectrumApplicationState:
    def __init__(__self__, *,
                 argo_smart_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input['SpectrumApplicationDnsArgs']] = None,
                 edge_ips: Optional[pulumi.Input['SpectrumApplicationEdgeIpsArgs']] = None,
                 ip_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_directs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_dns: Optional[pulumi.Input['SpectrumApplicationOriginDnsArgs']] = None,
                 origin_port: Optional[Any] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpectrumApplication resources.
        :param pulumi.Input[_builtins.bool] argo_smart_routing: Enables Argo Smart Routing for this application.
               Notes: Only available for TCP applications with traffic_type set to "direct".
        :param pulumi.Input[_builtins.str] created_on: When the Application was created.
        :param pulumi.Input['SpectrumApplicationDnsArgs'] dns: The name and type of DNS record for the Spectrum application.
        :param pulumi.Input['SpectrumApplicationEdgeIpsArgs'] edge_ips: The anycast edge IP configuration for the hostname of this application.
        :param pulumi.Input[_builtins.bool] ip_firewall: Enables IP Access Rules for this application.
               Notes: Only available for TCP applications.
        :param pulumi.Input[_builtins.str] modified_on: When the Application was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] origin_directs: List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        :param pulumi.Input['SpectrumApplicationOriginDnsArgs'] origin_dns: The name and type of DNS record for the Spectrum application.
        :param Any origin_port: The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
               Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        :param pulumi.Input[_builtins.str] protocol: The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        :param pulumi.Input[_builtins.str] proxy_protocol: Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
               Available values: "off", "v1", "v2", "simple".
        :param pulumi.Input[_builtins.str] tls: The type of TLS termination associated with the application.
               Available values: "off", "flexible", "full", "strict".
        :param pulumi.Input[_builtins.str] traffic_type: Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
               Available values: "direct", "http", "https".
        :param pulumi.Input[_builtins.str] zone_id: Zone identifier.
        """
        if argo_smart_routing is not None:
            pulumi.set(__self__, "argo_smart_routing", argo_smart_routing)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if edge_ips is not None:
            pulumi.set(__self__, "edge_ips", edge_ips)
        if ip_firewall is not None:
            pulumi.set(__self__, "ip_firewall", ip_firewall)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if origin_directs is not None:
            pulumi.set(__self__, "origin_directs", origin_directs)
        if origin_dns is not None:
            pulumi.set(__self__, "origin_dns", origin_dns)
        if origin_port is not None:
            pulumi.set(__self__, "origin_port", origin_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if traffic_type is not None:
            pulumi.set(__self__, "traffic_type", traffic_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="argoSmartRouting")
    def argo_smart_routing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables Argo Smart Routing for this application.
        Notes: Only available for TCP applications with traffic_type set to "direct".
        """
        return pulumi.get(self, "argo_smart_routing")

    @argo_smart_routing.setter
    def argo_smart_routing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "argo_smart_routing", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Application was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['SpectrumApplicationDnsArgs']]:
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['SpectrumApplicationDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter(name="edgeIps")
    def edge_ips(self) -> Optional[pulumi.Input['SpectrumApplicationEdgeIpsArgs']]:
        """
        The anycast edge IP configuration for the hostname of this application.
        """
        return pulumi.get(self, "edge_ips")

    @edge_ips.setter
    def edge_ips(self, value: Optional[pulumi.Input['SpectrumApplicationEdgeIpsArgs']]):
        pulumi.set(self, "edge_ips", value)

    @_builtins.property
    @pulumi.getter(name="ipFirewall")
    def ip_firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables IP Access Rules for this application.
        Notes: Only available for TCP applications.
        """
        return pulumi.get(self, "ip_firewall")

    @ip_firewall.setter
    def ip_firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_firewall", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Application was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter(name="originDirects")
    def origin_directs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        """
        return pulumi.get(self, "origin_directs")

    @origin_directs.setter
    def origin_directs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "origin_directs", value)

    @_builtins.property
    @pulumi.getter(name="originDns")
    def origin_dns(self) -> Optional[pulumi.Input['SpectrumApplicationOriginDnsArgs']]:
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "origin_dns")

    @origin_dns.setter
    def origin_dns(self, value: Optional[pulumi.Input['SpectrumApplicationOriginDnsArgs']]):
        pulumi.set(self, "origin_dns", value)

    @_builtins.property
    @pulumi.getter(name="originPort")
    def origin_port(self) -> Optional[Any]:
        """
        The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
        Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        """
        return pulumi.get(self, "origin_port")

    @origin_port.setter
    def origin_port(self, value: Optional[Any]):
        pulumi.set(self, "origin_port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
        Available values: "off", "v1", "v2", "simple".
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_protocol", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of TLS termination associated with the application.
        Available values: "off", "flexible", "full", "strict".
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls", value)

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
        Available values: "direct", "http", "https".
        """
        return pulumi.get(self, "traffic_type")

    @traffic_type.setter
    def traffic_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/spectrumApplication:SpectrumApplication")
class SpectrumApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 argo_smart_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns: Optional[pulumi.Input[Union['SpectrumApplicationDnsArgs', 'SpectrumApplicationDnsArgsDict']]] = None,
                 edge_ips: Optional[pulumi.Input[Union['SpectrumApplicationEdgeIpsArgs', 'SpectrumApplicationEdgeIpsArgsDict']]] = None,
                 ip_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_directs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_dns: Optional[pulumi.Input[Union['SpectrumApplicationOriginDnsArgs', 'SpectrumApplicationOriginDnsArgsDict']]] = None,
                 origin_port: Optional[Any] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_spectrum_application = cloudflare.SpectrumApplication("example_spectrum_application",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            dns={
                "name": "ssh.example.com",
                "type": "CNAME",
            },
            protocol="tcp/22",
            traffic_type="direct",
            argo_smart_routing=True,
            edge_ips={
                "connectivity": "all",
                "type": "dynamic",
            },
            ip_firewall=False,
            origin_directs=["tcp://127.0.0.1:8080"],
            origin_dns={
                "name": "origin.example.com",
                "ttl": 600,
                "type": "",
            },
            origin_port=22,
            proxy_protocol="off",
            tls="off")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/spectrumApplication:SpectrumApplication example '<zone_id>/<app_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] argo_smart_routing: Enables Argo Smart Routing for this application.
               Notes: Only available for TCP applications with traffic_type set to "direct".
        :param pulumi.Input[Union['SpectrumApplicationDnsArgs', 'SpectrumApplicationDnsArgsDict']] dns: The name and type of DNS record for the Spectrum application.
        :param pulumi.Input[Union['SpectrumApplicationEdgeIpsArgs', 'SpectrumApplicationEdgeIpsArgsDict']] edge_ips: The anycast edge IP configuration for the hostname of this application.
        :param pulumi.Input[_builtins.bool] ip_firewall: Enables IP Access Rules for this application.
               Notes: Only available for TCP applications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] origin_directs: List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        :param pulumi.Input[Union['SpectrumApplicationOriginDnsArgs', 'SpectrumApplicationOriginDnsArgsDict']] origin_dns: The name and type of DNS record for the Spectrum application.
        :param Any origin_port: The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
               Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        :param pulumi.Input[_builtins.str] protocol: The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        :param pulumi.Input[_builtins.str] proxy_protocol: Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
               Available values: "off", "v1", "v2", "simple".
        :param pulumi.Input[_builtins.str] tls: The type of TLS termination associated with the application.
               Available values: "off", "flexible", "full", "strict".
        :param pulumi.Input[_builtins.str] traffic_type: Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
               Available values: "direct", "http", "https".
        :param pulumi.Input[_builtins.str] zone_id: Zone identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpectrumApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_spectrum_application = cloudflare.SpectrumApplication("example_spectrum_application",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            dns={
                "name": "ssh.example.com",
                "type": "CNAME",
            },
            protocol="tcp/22",
            traffic_type="direct",
            argo_smart_routing=True,
            edge_ips={
                "connectivity": "all",
                "type": "dynamic",
            },
            ip_firewall=False,
            origin_directs=["tcp://127.0.0.1:8080"],
            origin_dns={
                "name": "origin.example.com",
                "ttl": 600,
                "type": "",
            },
            origin_port=22,
            proxy_protocol="off",
            tls="off")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/spectrumApplication:SpectrumApplication example '<zone_id>/<app_id>'
        ```

        :param str resource_name: The name of the resource.
        :param SpectrumApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpectrumApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 argo_smart_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns: Optional[pulumi.Input[Union['SpectrumApplicationDnsArgs', 'SpectrumApplicationDnsArgsDict']]] = None,
                 edge_ips: Optional[pulumi.Input[Union['SpectrumApplicationEdgeIpsArgs', 'SpectrumApplicationEdgeIpsArgsDict']]] = None,
                 ip_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_directs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_dns: Optional[pulumi.Input[Union['SpectrumApplicationOriginDnsArgs', 'SpectrumApplicationOriginDnsArgsDict']]] = None,
                 origin_port: Optional[Any] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpectrumApplicationArgs.__new__(SpectrumApplicationArgs)

            __props__.__dict__["argo_smart_routing"] = argo_smart_routing
            if dns is None and not opts.urn:
                raise TypeError("Missing required property 'dns'")
            __props__.__dict__["dns"] = dns
            __props__.__dict__["edge_ips"] = edge_ips
            __props__.__dict__["ip_firewall"] = ip_firewall
            __props__.__dict__["origin_directs"] = origin_directs
            __props__.__dict__["origin_dns"] = origin_dns
            __props__.__dict__["origin_port"] = origin_port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["proxy_protocol"] = proxy_protocol
            __props__.__dict__["tls"] = tls
            __props__.__dict__["traffic_type"] = traffic_type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(SpectrumApplication, __self__).__init__(
            'cloudflare:index/spectrumApplication:SpectrumApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            argo_smart_routing: Optional[pulumi.Input[_builtins.bool]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            dns: Optional[pulumi.Input[Union['SpectrumApplicationDnsArgs', 'SpectrumApplicationDnsArgsDict']]] = None,
            edge_ips: Optional[pulumi.Input[Union['SpectrumApplicationEdgeIpsArgs', 'SpectrumApplicationEdgeIpsArgsDict']]] = None,
            ip_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            origin_directs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            origin_dns: Optional[pulumi.Input[Union['SpectrumApplicationOriginDnsArgs', 'SpectrumApplicationOriginDnsArgsDict']]] = None,
            origin_port: Optional[Any] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            tls: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_type: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpectrumApplication':
        """
        Get an existing SpectrumApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] argo_smart_routing: Enables Argo Smart Routing for this application.
               Notes: Only available for TCP applications with traffic_type set to "direct".
        :param pulumi.Input[_builtins.str] created_on: When the Application was created.
        :param pulumi.Input[Union['SpectrumApplicationDnsArgs', 'SpectrumApplicationDnsArgsDict']] dns: The name and type of DNS record for the Spectrum application.
        :param pulumi.Input[Union['SpectrumApplicationEdgeIpsArgs', 'SpectrumApplicationEdgeIpsArgsDict']] edge_ips: The anycast edge IP configuration for the hostname of this application.
        :param pulumi.Input[_builtins.bool] ip_firewall: Enables IP Access Rules for this application.
               Notes: Only available for TCP applications.
        :param pulumi.Input[_builtins.str] modified_on: When the Application was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] origin_directs: List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        :param pulumi.Input[Union['SpectrumApplicationOriginDnsArgs', 'SpectrumApplicationOriginDnsArgsDict']] origin_dns: The name and type of DNS record for the Spectrum application.
        :param Any origin_port: The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
               Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        :param pulumi.Input[_builtins.str] protocol: The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        :param pulumi.Input[_builtins.str] proxy_protocol: Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
               Available values: "off", "v1", "v2", "simple".
        :param pulumi.Input[_builtins.str] tls: The type of TLS termination associated with the application.
               Available values: "off", "flexible", "full", "strict".
        :param pulumi.Input[_builtins.str] traffic_type: Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
               Available values: "direct", "http", "https".
        :param pulumi.Input[_builtins.str] zone_id: Zone identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpectrumApplicationState.__new__(_SpectrumApplicationState)

        __props__.__dict__["argo_smart_routing"] = argo_smart_routing
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["dns"] = dns
        __props__.__dict__["edge_ips"] = edge_ips
        __props__.__dict__["ip_firewall"] = ip_firewall
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["origin_directs"] = origin_directs
        __props__.__dict__["origin_dns"] = origin_dns
        __props__.__dict__["origin_port"] = origin_port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["proxy_protocol"] = proxy_protocol
        __props__.__dict__["tls"] = tls
        __props__.__dict__["traffic_type"] = traffic_type
        __props__.__dict__["zone_id"] = zone_id
        return SpectrumApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="argoSmartRouting")
    def argo_smart_routing(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables Argo Smart Routing for this application.
        Notes: Only available for TCP applications with traffic_type set to "direct".
        """
        return pulumi.get(self, "argo_smart_routing")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the Application was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> pulumi.Output['outputs.SpectrumApplicationDns']:
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="edgeIps")
    def edge_ips(self) -> pulumi.Output['outputs.SpectrumApplicationEdgeIps']:
        """
        The anycast edge IP configuration for the hostname of this application.
        """
        return pulumi.get(self, "edge_ips")

    @_builtins.property
    @pulumi.getter(name="ipFirewall")
    def ip_firewall(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables IP Access Rules for this application.
        Notes: Only available for TCP applications.
        """
        return pulumi.get(self, "ip_firewall")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the Application was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="originDirects")
    def origin_directs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        """
        return pulumi.get(self, "origin_directs")

    @_builtins.property
    @pulumi.getter(name="originDns")
    def origin_dns(self) -> pulumi.Output[Optional['outputs.SpectrumApplicationOriginDns']]:
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "origin_dns")

    @_builtins.property
    @pulumi.getter(name="originPort")
    def origin_port(self) -> pulumi.Output[Optional[Any]]:
        """
        The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
        Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        """
        return pulumi.get(self, "origin_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
        Available values: "off", "v1", "v2", "simple".
        """
        return pulumi.get(self, "proxy_protocol")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> pulumi.Output[_builtins.str]:
        """
        The type of TLS termination associated with the application.
        Available values: "off", "flexible", "full", "strict".
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> pulumi.Output[_builtins.str]:
        """
        Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
        Available values: "direct", "http", "https".
        """
        return pulumi.get(self, "traffic_type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Zone identifier.
        """
        return pulumi.get(self, "zone_id")

