# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustAccessCustomPageArgs', 'ZeroTrustAccessCustomPage']

@pulumi.input_type
class ZeroTrustAccessCustomPageArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 custom_html: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ZeroTrustAccessCustomPage resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] custom_html: Custom page HTML.
        :param pulumi.Input[_builtins.str] name: Custom page name.
        :param pulumi.Input[_builtins.str] type: Custom page type.
               Available values: "identity_denied", "forbidden".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "custom_html", custom_html)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="customHtml")
    def custom_html(self) -> pulumi.Input[_builtins.str]:
        """
        Custom page HTML.
        """
        return pulumi.get(self, "custom_html")

    @custom_html.setter
    def custom_html(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_html", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Custom page name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Custom page type.
        Available values: "identity_denied", "forbidden".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ZeroTrustAccessCustomPageState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessCustomPage resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] custom_html: Custom page HTML.
        :param pulumi.Input[_builtins.str] name: Custom page name.
        :param pulumi.Input[_builtins.str] type: Custom page type.
               Available values: "identity_denied", "forbidden".
        :param pulumi.Input[_builtins.str] uid: UUID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if custom_html is not None:
            pulumi.set(__self__, "custom_html", custom_html)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="customHtml")
    def custom_html(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom page HTML.
        """
        return pulumi.get(self, "custom_html")

    @custom_html.setter
    def custom_html(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_html", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom page name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom page type.
        Available values: "identity_denied", "forbidden".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("cloudflare:index/zeroTrustAccessCustomPage:ZeroTrustAccessCustomPage")
class ZeroTrustAccessCustomPage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_custom_page = cloudflare.ZeroTrustAccessCustomPage("example_zero_trust_access_custom_page",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            custom_html="<html><body><h1>Access Denied</h1></body></html>",
            name="name",
            type="identity_denied")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessCustomPage:ZeroTrustAccessCustomPage example '<account_id>/<custom_page_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] custom_html: Custom page HTML.
        :param pulumi.Input[_builtins.str] name: Custom page name.
        :param pulumi.Input[_builtins.str] type: Custom page type.
               Available values: "identity_denied", "forbidden".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustAccessCustomPageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_custom_page = cloudflare.ZeroTrustAccessCustomPage("example_zero_trust_access_custom_page",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            custom_html="<html><body><h1>Access Denied</h1></body></html>",
            name="name",
            type="identity_denied")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessCustomPage:ZeroTrustAccessCustomPage example '<account_id>/<custom_page_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessCustomPageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessCustomPageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessCustomPageArgs.__new__(ZeroTrustAccessCustomPageArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if custom_html is None and not opts.urn:
                raise TypeError("Missing required property 'custom_html'")
            __props__.__dict__["custom_html"] = custom_html
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uid"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/accessCustomPage:AccessCustomPage")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustAccessCustomPage, __self__).__init__(
            'cloudflare:index/zeroTrustAccessCustomPage:ZeroTrustAccessCustomPage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_html: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZeroTrustAccessCustomPage':
        """
        Get an existing ZeroTrustAccessCustomPage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] custom_html: Custom page HTML.
        :param pulumi.Input[_builtins.str] name: Custom page name.
        :param pulumi.Input[_builtins.str] type: Custom page type.
               Available values: "identity_denied", "forbidden".
        :param pulumi.Input[_builtins.str] uid: UUID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessCustomPageState.__new__(_ZeroTrustAccessCustomPageState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["custom_html"] = custom_html
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        return ZeroTrustAccessCustomPage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="customHtml")
    def custom_html(self) -> pulumi.Output[_builtins.str]:
        """
        Custom page HTML.
        """
        return pulumi.get(self, "custom_html")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Custom page name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Custom page type.
        Available values: "identity_denied", "forbidden".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "uid")

