# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDlpPredefinedProfileArgs', 'ZeroTrustDlpPredefinedProfile']

@pulumi.input_type
class ZeroTrustDlpPredefinedProfileArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 profile_id: pulumi.Input[_builtins.str],
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs']] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpPredefinedProfileEntryArgs']]]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ZeroTrustDlpPredefinedProfile resource.
        :param pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs'] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "profile_id", profile_id)
        if ai_context_enabled is not None:
            pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count is not None:
            pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""context_awareness is deprecated: This attribute is deprecated.""")
        if context_awareness is not None:
            pulumi.set(__self__, "context_awareness", context_awareness)
        if entries is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""entries is deprecated: This attribute is deprecated.""")
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if ocr_enabled is not None:
            pulumi.set(__self__, "ocr_enabled", ocr_enabled)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @ai_context_enabled.setter
    def ai_context_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_context_enabled", value)

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "allowed_match_count")

    @allowed_match_count.setter
    def allowed_match_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allowed_match_count", value)

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "confidence_threshold", value)

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> Optional[pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @context_awareness.setter
    def context_awareness(self, value: Optional[pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs']]):
        pulumi.set(self, "context_awareness", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpPredefinedProfileEntryArgs']]]]:
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpPredefinedProfileEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @ocr_enabled.setter
    def ocr_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocr_enabled", value)


@pulumi.input_type
class _ZeroTrustDlpPredefinedProfileState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpPredefinedProfileEntryArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 open_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDlpPredefinedProfile resources.
        :param pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs'] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[_builtins.str] created_at: When the profile was created.
        :param pulumi.Input[_builtins.str] description: The description of the profile.
        :param pulumi.Input[_builtins.str] name: The name of the profile.
        :param pulumi.Input[_builtins.bool] open_access: Whether this profile can be accessed by anyone.
        :param pulumi.Input[_builtins.str] type: Available values: "custom", "predefined", "integration".
        :param pulumi.Input[_builtins.str] updated_at: When the profile was lasted updated.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if ai_context_enabled is not None:
            pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count is not None:
            pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""context_awareness is deprecated: This attribute is deprecated.""")
        if context_awareness is not None:
            pulumi.set(__self__, "context_awareness", context_awareness)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""entries is deprecated: This attribute is deprecated.""")
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocr_enabled is not None:
            pulumi.set(__self__, "ocr_enabled", ocr_enabled)
        if open_access is not None:
            pulumi.set(__self__, "open_access", open_access)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @ai_context_enabled.setter
    def ai_context_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_context_enabled", value)

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "allowed_match_count")

    @allowed_match_count.setter
    def allowed_match_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allowed_match_count", value)

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "confidence_threshold", value)

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> Optional[pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @context_awareness.setter
    def context_awareness(self, value: Optional[pulumi.Input['ZeroTrustDlpPredefinedProfileContextAwarenessArgs']]):
        pulumi.set(self, "context_awareness", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpPredefinedProfileEntryArgs']]]]:
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpPredefinedProfileEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @ocr_enabled.setter
    def ocr_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocr_enabled", value)

    @_builtins.property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @open_access.setter
    def open_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_access", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("cloudflare:index/zeroTrustDlpPredefinedProfile:ZeroTrustDlpPredefinedProfile")
class ZeroTrustDlpPredefinedProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input[Union['ZeroTrustDlpPredefinedProfileContextAwarenessArgs', 'ZeroTrustDlpPredefinedProfileContextAwarenessArgsDict']]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpPredefinedProfileEntryArgs', 'ZeroTrustDlpPredefinedProfileEntryArgsDict']]]]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dlp_predefined_profile = cloudflare.ZeroTrustDlpPredefinedProfile("example_zero_trust_dlp_predefined_profile",
            account_id="account_id",
            profile_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e",
            ai_context_enabled=True,
            allowed_match_count=5,
            confidence_threshold="confidence_threshold",
            context_awareness={
                "enabled": True,
                "skip": {
                    "files": True,
                },
            },
            entries=[{
                "id": "182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e",
                "enabled": True,
            }],
            ocr_enabled=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDlpPredefinedProfile:ZeroTrustDlpPredefinedProfile example '<account_id>/<profile_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ZeroTrustDlpPredefinedProfileContextAwarenessArgs', 'ZeroTrustDlpPredefinedProfileContextAwarenessArgsDict']] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDlpPredefinedProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dlp_predefined_profile = cloudflare.ZeroTrustDlpPredefinedProfile("example_zero_trust_dlp_predefined_profile",
            account_id="account_id",
            profile_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e",
            ai_context_enabled=True,
            allowed_match_count=5,
            confidence_threshold="confidence_threshold",
            context_awareness={
                "enabled": True,
                "skip": {
                    "files": True,
                },
            },
            entries=[{
                "id": "182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e",
                "enabled": True,
            }],
            ocr_enabled=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDlpPredefinedProfile:ZeroTrustDlpPredefinedProfile example '<account_id>/<profile_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDlpPredefinedProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDlpPredefinedProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input[Union['ZeroTrustDlpPredefinedProfileContextAwarenessArgs', 'ZeroTrustDlpPredefinedProfileContextAwarenessArgsDict']]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpPredefinedProfileEntryArgs', 'ZeroTrustDlpPredefinedProfileEntryArgsDict']]]]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDlpPredefinedProfileArgs.__new__(ZeroTrustDlpPredefinedProfileArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["ai_context_enabled"] = ai_context_enabled
            __props__.__dict__["allowed_match_count"] = allowed_match_count
            __props__.__dict__["confidence_threshold"] = confidence_threshold
            __props__.__dict__["context_awareness"] = context_awareness
            __props__.__dict__["entries"] = entries
            __props__.__dict__["ocr_enabled"] = ocr_enabled
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["open_access"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/dlpPredefinedProfile:DlpPredefinedProfile")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustDlpPredefinedProfile, __self__).__init__(
            'cloudflare:index/zeroTrustDlpPredefinedProfile:ZeroTrustDlpPredefinedProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
            confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
            context_awareness: Optional[pulumi.Input[Union['ZeroTrustDlpPredefinedProfileContextAwarenessArgs', 'ZeroTrustDlpPredefinedProfileContextAwarenessArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpPredefinedProfileEntryArgs', 'ZeroTrustDlpPredefinedProfileEntryArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            open_access: Optional[pulumi.Input[_builtins.bool]] = None,
            profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZeroTrustDlpPredefinedProfile':
        """
        Get an existing ZeroTrustDlpPredefinedProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ZeroTrustDlpPredefinedProfileContextAwarenessArgs', 'ZeroTrustDlpPredefinedProfileContextAwarenessArgsDict']] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[_builtins.str] created_at: When the profile was created.
        :param pulumi.Input[_builtins.str] description: The description of the profile.
        :param pulumi.Input[_builtins.str] name: The name of the profile.
        :param pulumi.Input[_builtins.bool] open_access: Whether this profile can be accessed by anyone.
        :param pulumi.Input[_builtins.str] type: Available values: "custom", "predefined", "integration".
        :param pulumi.Input[_builtins.str] updated_at: When the profile was lasted updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDlpPredefinedProfileState.__new__(_ZeroTrustDlpPredefinedProfileState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["ai_context_enabled"] = ai_context_enabled
        __props__.__dict__["allowed_match_count"] = allowed_match_count
        __props__.__dict__["confidence_threshold"] = confidence_threshold
        __props__.__dict__["context_awareness"] = context_awareness
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["name"] = name
        __props__.__dict__["ocr_enabled"] = ocr_enabled
        __props__.__dict__["open_access"] = open_access
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return ZeroTrustDlpPredefinedProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ai_context_enabled")

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "allowed_match_count")

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "confidence_threshold")

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> pulumi.Output[Optional['outputs.ZeroTrustDlpPredefinedProfileContextAwareness']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def entries(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDlpPredefinedProfileEntry']]]:
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ocr_enabled")

    @_builtins.property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")

