# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustGatewayCertificateArgs', 'ZeroTrustGatewayCertificate']

@pulumi.input_type
class ZeroTrustGatewayCertificateArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 activate: Optional[pulumi.Input[_builtins.bool]] = None,
                 validity_period_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ZeroTrustGatewayCertificate resource.
        :param pulumi.Input[_builtins.int] validity_period_days: Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        pulumi.set(__self__, "account_id", account_id)
        if activate is not None:
            pulumi.set(__self__, "activate", activate)
        if validity_period_days is not None:
            pulumi.set(__self__, "validity_period_days", validity_period_days)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def activate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "activate")

    @activate.setter
    def activate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activate", value)

    @_builtins.property
    @pulumi.getter(name="validityPeriodDays")
    def validity_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        return pulumi.get(self, "validity_period_days")

    @validity_period_days.setter
    def validity_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "validity_period_days", value)


@pulumi.input_type
class _ZeroTrustGatewayCertificateState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 activate: Optional[pulumi.Input[_builtins.bool]] = None,
                 binding_status: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 in_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_org: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_raw: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 uploaded_on: Optional[pulumi.Input[_builtins.str]] = None,
                 validity_period_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustGatewayCertificate resources.
        :param pulumi.Input[_builtins.str] binding_status: Indicate the read-only deployment status of the certificate on Cloudflare's edge. Gateway TLS interception can use certificates in the 'available' (previously called 'active') state.
               Available values: "pending*deployment", "available", "pending*deletion", "inactive".
        :param pulumi.Input[_builtins.str] certificate: Provide the CA certificate (read-only).
        :param pulumi.Input[_builtins.str] fingerprint: Provide the SHA256 fingerprint of the certificate (read-only).
        :param pulumi.Input[_builtins.bool] in_use: Indicate whether Gateway TLS interception uses this certificate (read-only). You cannot set this value directly. To configure interception, use the Gateway configuration setting named `certificate` (read-only).
        :param pulumi.Input[_builtins.str] issuer_org: Indicate the organization that issued the certificate (read-only).
        :param pulumi.Input[_builtins.str] issuer_raw: Provide the entire issuer field of the certificate (read-only).
        :param pulumi.Input[_builtins.str] type: Indicate the read-only certificate type, BYO-PKI (custom) or Gateway-managed.
               Available values: "custom", "gateway_managed".
        :param pulumi.Input[_builtins.int] validity_period_days: Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if activate is not None:
            pulumi.set(__self__, "activate", activate)
        if binding_status is not None:
            pulumi.set(__self__, "binding_status", binding_status)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if issuer_org is not None:
            pulumi.set(__self__, "issuer_org", issuer_org)
        if issuer_raw is not None:
            pulumi.set(__self__, "issuer_raw", issuer_raw)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if uploaded_on is not None:
            pulumi.set(__self__, "uploaded_on", uploaded_on)
        if validity_period_days is not None:
            pulumi.set(__self__, "validity_period_days", validity_period_days)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def activate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "activate")

    @activate.setter
    def activate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activate", value)

    @_builtins.property
    @pulumi.getter(name="bindingStatus")
    def binding_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicate the read-only deployment status of the certificate on Cloudflare's edge. Gateway TLS interception can use certificates in the 'available' (previously called 'active') state.
        Available values: "pending*deployment", "available", "pending*deletion", "inactive".
        """
        return pulumi.get(self, "binding_status")

    @binding_status.setter
    def binding_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binding_status", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide the CA certificate (read-only).
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide the SHA256 fingerprint of the certificate (read-only).
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicate whether Gateway TLS interception uses this certificate (read-only). You cannot set this value directly. To configure interception, use the Gateway configuration setting named `certificate` (read-only).
        """
        return pulumi.get(self, "in_use")

    @in_use.setter
    def in_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "in_use", value)

    @_builtins.property
    @pulumi.getter(name="issuerOrg")
    def issuer_org(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicate the organization that issued the certificate (read-only).
        """
        return pulumi.get(self, "issuer_org")

    @issuer_org.setter
    def issuer_org(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_org", value)

    @_builtins.property
    @pulumi.getter(name="issuerRaw")
    def issuer_raw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide the entire issuer field of the certificate (read-only).
        """
        return pulumi.get(self, "issuer_raw")

    @issuer_raw.setter
    def issuer_raw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_raw", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicate the read-only certificate type, BYO-PKI (custom) or Gateway-managed.
        Available values: "custom", "gateway_managed".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "uploaded_on")

    @uploaded_on.setter
    def uploaded_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uploaded_on", value)

    @_builtins.property
    @pulumi.getter(name="validityPeriodDays")
    def validity_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        return pulumi.get(self, "validity_period_days")

    @validity_period_days.setter
    def validity_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "validity_period_days", value)


@pulumi.type_token("cloudflare:index/zeroTrustGatewayCertificate:ZeroTrustGatewayCertificate")
class ZeroTrustGatewayCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 activate: Optional[pulumi.Input[_builtins.bool]] = None,
                 validity_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_gateway_certificate = cloudflare.ZeroTrustGatewayCertificate("example_zero_trust_gateway_certificate",
            account_id="699d98642c564d2e855e9661899b7252",
            validity_period_days=1826)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustGatewayCertificate:ZeroTrustGatewayCertificate example '<account_id>/<certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] validity_period_days: Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustGatewayCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_gateway_certificate = cloudflare.ZeroTrustGatewayCertificate("example_zero_trust_gateway_certificate",
            account_id="699d98642c564d2e855e9661899b7252",
            validity_period_days=1826)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustGatewayCertificate:ZeroTrustGatewayCertificate example '<account_id>/<certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustGatewayCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustGatewayCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 activate: Optional[pulumi.Input[_builtins.bool]] = None,
                 validity_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustGatewayCertificateArgs.__new__(ZeroTrustGatewayCertificateArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["activate"] = activate
            __props__.__dict__["validity_period_days"] = validity_period_days
            __props__.__dict__["binding_status"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expires_on"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["in_use"] = None
            __props__.__dict__["issuer_org"] = None
            __props__.__dict__["issuer_raw"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["uploaded_on"] = None
        super(ZeroTrustGatewayCertificate, __self__).__init__(
            'cloudflare:index/zeroTrustGatewayCertificate:ZeroTrustGatewayCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            activate: Optional[pulumi.Input[_builtins.bool]] = None,
            binding_status: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            expires_on: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            in_use: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer_org: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_raw: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            uploaded_on: Optional[pulumi.Input[_builtins.str]] = None,
            validity_period_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'ZeroTrustGatewayCertificate':
        """
        Get an existing ZeroTrustGatewayCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] binding_status: Indicate the read-only deployment status of the certificate on Cloudflare's edge. Gateway TLS interception can use certificates in the 'available' (previously called 'active') state.
               Available values: "pending*deployment", "available", "pending*deletion", "inactive".
        :param pulumi.Input[_builtins.str] certificate: Provide the CA certificate (read-only).
        :param pulumi.Input[_builtins.str] fingerprint: Provide the SHA256 fingerprint of the certificate (read-only).
        :param pulumi.Input[_builtins.bool] in_use: Indicate whether Gateway TLS interception uses this certificate (read-only). You cannot set this value directly. To configure interception, use the Gateway configuration setting named `certificate` (read-only).
        :param pulumi.Input[_builtins.str] issuer_org: Indicate the organization that issued the certificate (read-only).
        :param pulumi.Input[_builtins.str] issuer_raw: Provide the entire issuer field of the certificate (read-only).
        :param pulumi.Input[_builtins.str] type: Indicate the read-only certificate type, BYO-PKI (custom) or Gateway-managed.
               Available values: "custom", "gateway_managed".
        :param pulumi.Input[_builtins.int] validity_period_days: Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustGatewayCertificateState.__new__(_ZeroTrustGatewayCertificateState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["activate"] = activate
        __props__.__dict__["binding_status"] = binding_status
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["in_use"] = in_use
        __props__.__dict__["issuer_org"] = issuer_org
        __props__.__dict__["issuer_raw"] = issuer_raw
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["uploaded_on"] = uploaded_on
        __props__.__dict__["validity_period_days"] = validity_period_days
        return ZeroTrustGatewayCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def activate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "activate")

    @_builtins.property
    @pulumi.getter(name="bindingStatus")
    def binding_status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicate the read-only deployment status of the certificate on Cloudflare's edge. Gateway TLS interception can use certificates in the 'available' (previously called 'active') state.
        Available values: "pending*deployment", "available", "pending*deletion", "inactive".
        """
        return pulumi.get(self, "binding_status")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        Provide the CA certificate (read-only).
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "expires_on")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Provide the SHA256 fingerprint of the certificate (read-only).
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicate whether Gateway TLS interception uses this certificate (read-only). You cannot set this value directly. To configure interception, use the Gateway configuration setting named `certificate` (read-only).
        """
        return pulumi.get(self, "in_use")

    @_builtins.property
    @pulumi.getter(name="issuerOrg")
    def issuer_org(self) -> pulumi.Output[_builtins.str]:
        """
        Indicate the organization that issued the certificate (read-only).
        """
        return pulumi.get(self, "issuer_org")

    @_builtins.property
    @pulumi.getter(name="issuerRaw")
    def issuer_raw(self) -> pulumi.Output[_builtins.str]:
        """
        Provide the entire issuer field of the certificate (read-only).
        """
        return pulumi.get(self, "issuer_raw")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicate the read-only certificate type, BYO-PKI (custom) or Gateway-managed.
        Available values: "custom", "gateway_managed".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "uploaded_on")

    @_builtins.property
    @pulumi.getter(name="validityPeriodDays")
    def validity_period_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Sets the certificate validity period in days (range: 1-10,950 days / ~30 years). Defaults to 1,825 days (5 years). **Important**: This field is only settable during the certificate creation.  Certificates becomes immutable after creation - use the `/activate` and `/deactivate` endpoints to manage certificate lifecycle.
        """
        return pulumi.get(self, "validity_period_days")

