# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 account: pulumi.Input['ZoneAccountArgs'],
                 name: pulumi.Input[_builtins.str],
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[_builtins.str] name: The domain name.
        :param pulumi.Input[_builtins.bool] paused: Indicates whether the zone is only using Cloudflare DNS services. A
               true value means the zone will not receive security or performance
               benefits.
        :param pulumi.Input[_builtins.str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is
               typically a partner-hosted zone or a CNAME setup.
               Available values: "full", "partial", "secondary", "internal".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vanity_name_servers: An array of domains used for custom name servers. This is only
               available for Business and Enterprise plans.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "name", name)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vanity_name_servers is not None:
            pulumi.set(__self__, "vanity_name_servers", vanity_name_servers)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Input['ZoneAccountArgs']:
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: pulumi.Input['ZoneAccountArgs']):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the zone is only using Cloudflare DNS services. A
        true value means the zone will not receive security or performance
        benefits.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A full zone implies that DNS is hosted with Cloudflare. A partial zone is
        typically a partner-hosted zone or a CNAME setup.
        Available values: "full", "partial", "secondary", "internal".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of domains used for custom name servers. This is only
        available for Business and Enterprise plans.
        """
        return pulumi.get(self, "vanity_name_servers")

    @vanity_name_servers.setter
    def vanity_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vanity_name_servers", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input['ZoneAccountArgs']] = None,
                 activated_on: Optional[pulumi.Input[_builtins.str]] = None,
                 cname_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 development_mode: Optional[pulumi.Input[_builtins.float]] = None,
                 meta: Optional[pulumi.Input['ZoneMetaArgs']] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 original_dnshost: Optional[pulumi.Input[_builtins.str]] = None,
                 original_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 original_registrar: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input['ZoneOwnerArgs']] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plan: Optional[pulumi.Input['ZonePlanArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input['ZoneTenantArgs']] = None,
                 tenant_unit: Optional[pulumi.Input['ZoneTenantUnitArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 verification_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[_builtins.str] activated_on: The last time proof of ownership was detected and the zone was made
               active.
        :param pulumi.Input[_builtins.str] cname_suffix: Allows the customer to use a custom apex.
               *Tenants Only Configuration*.
        :param pulumi.Input[_builtins.str] created_on: When the zone was created.
        :param pulumi.Input[_builtins.float] development_mode: The interval (in seconds) from when development mode expires
               (positive integer) or last expired (negative integer) for the
               domain. If development mode has never been enabled, this value is 0.
        :param pulumi.Input['ZoneMetaArgs'] meta: Metadata about the zone.
        :param pulumi.Input[_builtins.str] modified_on: When the zone was last modified.
        :param pulumi.Input[_builtins.str] name: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: The name servers Cloudflare assigns to a zone.
        :param pulumi.Input[_builtins.str] original_dnshost: DNS host at the time of switching to Cloudflare.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] original_name_servers: Original name servers before moving to Cloudflare.
        :param pulumi.Input[_builtins.str] original_registrar: Registrar for the domain at the time of switching to Cloudflare.
        :param pulumi.Input['ZoneOwnerArgs'] owner: The owner of the zone.
        :param pulumi.Input[_builtins.bool] paused: Indicates whether the zone is only using Cloudflare DNS services. A
               true value means the zone will not receive security or performance
               benefits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Legacy permissions based on legacy user membership information.
        :param pulumi.Input['ZonePlanArgs'] plan: A Zones subscription information.
        :param pulumi.Input[_builtins.str] status: The zone status on Cloudflare.
               Available values: "initializing", "pending", "active", "moved".
        :param pulumi.Input['ZoneTenantArgs'] tenant: The root organizational unit that this zone belongs to (such as a tenant or organization).
        :param pulumi.Input['ZoneTenantUnitArgs'] tenant_unit: The immediate parent organizational unit that this zone belongs to (such as under a tenant or sub-organization).
        :param pulumi.Input[_builtins.str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is
               typically a partner-hosted zone or a CNAME setup.
               Available values: "full", "partial", "secondary", "internal".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vanity_name_servers: An array of domains used for custom name servers. This is only
               available for Business and Enterprise plans.
        :param pulumi.Input[_builtins.str] verification_key: Verification key for partial zone setup.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if activated_on is not None:
            pulumi.set(__self__, "activated_on", activated_on)
        if cname_suffix is not None:
            pulumi.set(__self__, "cname_suffix", cname_suffix)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if development_mode is not None:
            pulumi.set(__self__, "development_mode", development_mode)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if original_dnshost is not None:
            pulumi.set(__self__, "original_dnshost", original_dnshost)
        if original_name_servers is not None:
            pulumi.set(__self__, "original_name_servers", original_name_servers)
        if original_registrar is not None:
            pulumi.set(__self__, "original_registrar", original_registrar)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if permissions is not None:
            warnings.warn("""This has been replaced by Account memberships.""", DeprecationWarning)
            pulumi.log.warn("""permissions is deprecated: This has been replaced by Account memberships.""")
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if plan is not None:
            warnings.warn("""Please use the `/zones/{zone_id}/subscription` API
to update a zone's plan. Changing this value will create/cancel
associated subscriptions. To view available plans for this zone,
see [Zone Plans](https://developers.cloudflare.com/api/resources/zones/subresources/plans/).""", DeprecationWarning)
            pulumi.log.warn("""plan is deprecated: Please use the `/zones/{zone_id}/subscription` API
to update a zone's plan. Changing this value will create/cancel
associated subscriptions. To view available plans for this zone,
see [Zone Plans](https://developers.cloudflare.com/api/resources/zones/subresources/plans/).""")
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if tenant_unit is not None:
            pulumi.set(__self__, "tenant_unit", tenant_unit)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vanity_name_servers is not None:
            pulumi.set(__self__, "vanity_name_servers", vanity_name_servers)
        if verification_key is not None:
            pulumi.set(__self__, "verification_key", verification_key)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input['ZoneAccountArgs']]:
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input['ZoneAccountArgs']]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter(name="activatedOn")
    def activated_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time proof of ownership was detected and the zone was made
        active.
        """
        return pulumi.get(self, "activated_on")

    @activated_on.setter
    def activated_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activated_on", value)

    @_builtins.property
    @pulumi.getter(name="cnameSuffix")
    def cname_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows the customer to use a custom apex.
        *Tenants Only Configuration*.
        """
        return pulumi.get(self, "cname_suffix")

    @cname_suffix.setter
    def cname_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname_suffix", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the zone was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="developmentMode")
    def development_mode(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The interval (in seconds) from when development mode expires
        (positive integer) or last expired (negative integer) for the
        domain. If development mode has never been enabled, this value is 0.
        """
        return pulumi.get(self, "development_mode")

    @development_mode.setter
    def development_mode(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "development_mode", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input['ZoneMetaArgs']]:
        """
        Metadata about the zone.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input['ZoneMetaArgs']]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the zone was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The name servers Cloudflare assigns to a zone.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "name_servers", value)

    @_builtins.property
    @pulumi.getter(name="originalDnshost")
    def original_dnshost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS host at the time of switching to Cloudflare.
        """
        return pulumi.get(self, "original_dnshost")

    @original_dnshost.setter
    def original_dnshost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "original_dnshost", value)

    @_builtins.property
    @pulumi.getter(name="originalNameServers")
    def original_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Original name servers before moving to Cloudflare.
        """
        return pulumi.get(self, "original_name_servers")

    @original_name_servers.setter
    def original_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "original_name_servers", value)

    @_builtins.property
    @pulumi.getter(name="originalRegistrar")
    def original_registrar(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Registrar for the domain at the time of switching to Cloudflare.
        """
        return pulumi.get(self, "original_registrar")

    @original_registrar.setter
    def original_registrar(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "original_registrar", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input['ZoneOwnerArgs']]:
        """
        The owner of the zone.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input['ZoneOwnerArgs']]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the zone is only using Cloudflare DNS services. A
        true value means the zone will not receive security or performance
        benefits.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This has been replaced by Account memberships.""")
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Legacy permissions based on legacy user membership information.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Please use the `/zones/{zone_id}/subscription` API
to update a zone's plan. Changing this value will create/cancel
associated subscriptions. To view available plans for this zone,
see [Zone Plans](https://developers.cloudflare.com/api/resources/zones/subresources/plans/).""")
    def plan(self) -> Optional[pulumi.Input['ZonePlanArgs']]:
        """
        A Zones subscription information.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['ZonePlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone status on Cloudflare.
        Available values: "initializing", "pending", "active", "moved".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input['ZoneTenantArgs']]:
        """
        The root organizational unit that this zone belongs to (such as a tenant or organization).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input['ZoneTenantArgs']]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="tenantUnit")
    def tenant_unit(self) -> Optional[pulumi.Input['ZoneTenantUnitArgs']]:
        """
        The immediate parent organizational unit that this zone belongs to (such as under a tenant or sub-organization).
        """
        return pulumi.get(self, "tenant_unit")

    @tenant_unit.setter
    def tenant_unit(self, value: Optional[pulumi.Input['ZoneTenantUnitArgs']]):
        pulumi.set(self, "tenant_unit", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A full zone implies that DNS is hosted with Cloudflare. A partial zone is
        typically a partner-hosted zone or a CNAME setup.
        Available values: "full", "partial", "secondary", "internal".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of domains used for custom name servers. This is only
        available for Business and Enterprise plans.
        """
        return pulumi.get(self, "vanity_name_servers")

    @vanity_name_servers.setter
    def vanity_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vanity_name_servers", value)

    @_builtins.property
    @pulumi.getter(name="verificationKey")
    def verification_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Verification key for partial zone setup.
        """
        return pulumi.get(self, "verification_key")

    @verification_key.setter
    def verification_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verification_key", value)


@pulumi.type_token("cloudflare:index/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[Union['ZoneAccountArgs', 'ZoneAccountArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        > If you are attempting to sign up a subdomain of a zone you must first have Subdomain Support entitlement for your account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zone = cloudflare.Zone("example_zone",
            account={
                "id": "023e105f4ecef8ad9ca31a8372d0c353",
            },
            name="example.com",
            type="full")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zone:Zone example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The domain name.
        :param pulumi.Input[_builtins.bool] paused: Indicates whether the zone is only using Cloudflare DNS services. A
               true value means the zone will not receive security or performance
               benefits.
        :param pulumi.Input[_builtins.str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is
               typically a partner-hosted zone or a CNAME setup.
               Available values: "full", "partial", "secondary", "internal".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vanity_name_servers: An array of domains used for custom name servers. This is only
               available for Business and Enterprise plans.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > If you are attempting to sign up a subdomain of a zone you must first have Subdomain Support entitlement for your account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zone = cloudflare.Zone("example_zone",
            account={
                "id": "023e105f4ecef8ad9ca31a8372d0c353",
            },
            name="example.com",
            type="full")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zone:Zone example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[Union['ZoneAccountArgs', 'ZoneAccountArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            if account is None and not opts.urn:
                raise TypeError("Missing required property 'account'")
            __props__.__dict__["account"] = account
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["paused"] = paused
            __props__.__dict__["type"] = type
            __props__.__dict__["vanity_name_servers"] = vanity_name_servers
            __props__.__dict__["activated_on"] = None
            __props__.__dict__["cname_suffix"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["development_mode"] = None
            __props__.__dict__["meta"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["name_servers"] = None
            __props__.__dict__["original_dnshost"] = None
            __props__.__dict__["original_name_servers"] = None
            __props__.__dict__["original_registrar"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["permissions"] = None
            __props__.__dict__["plan"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tenant"] = None
            __props__.__dict__["tenant_unit"] = None
            __props__.__dict__["verification_key"] = None
        super(Zone, __self__).__init__(
            'cloudflare:index/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[Union['ZoneAccountArgs', 'ZoneAccountArgsDict']]] = None,
            activated_on: Optional[pulumi.Input[_builtins.str]] = None,
            cname_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            development_mode: Optional[pulumi.Input[_builtins.float]] = None,
            meta: Optional[pulumi.Input[Union['ZoneMetaArgs', 'ZoneMetaArgsDict']]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            original_dnshost: Optional[pulumi.Input[_builtins.str]] = None,
            original_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            original_registrar: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[Union['ZoneOwnerArgs', 'ZoneOwnerArgsDict']]] = None,
            paused: Optional[pulumi.Input[_builtins.bool]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            plan: Optional[pulumi.Input[Union['ZonePlanArgs', 'ZonePlanArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[Union['ZoneTenantArgs', 'ZoneTenantArgsDict']]] = None,
            tenant_unit: Optional[pulumi.Input[Union['ZoneTenantUnitArgs', 'ZoneTenantUnitArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            verification_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activated_on: The last time proof of ownership was detected and the zone was made
               active.
        :param pulumi.Input[_builtins.str] cname_suffix: Allows the customer to use a custom apex.
               *Tenants Only Configuration*.
        :param pulumi.Input[_builtins.str] created_on: When the zone was created.
        :param pulumi.Input[_builtins.float] development_mode: The interval (in seconds) from when development mode expires
               (positive integer) or last expired (negative integer) for the
               domain. If development mode has never been enabled, this value is 0.
        :param pulumi.Input[Union['ZoneMetaArgs', 'ZoneMetaArgsDict']] meta: Metadata about the zone.
        :param pulumi.Input[_builtins.str] modified_on: When the zone was last modified.
        :param pulumi.Input[_builtins.str] name: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: The name servers Cloudflare assigns to a zone.
        :param pulumi.Input[_builtins.str] original_dnshost: DNS host at the time of switching to Cloudflare.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] original_name_servers: Original name servers before moving to Cloudflare.
        :param pulumi.Input[_builtins.str] original_registrar: Registrar for the domain at the time of switching to Cloudflare.
        :param pulumi.Input[Union['ZoneOwnerArgs', 'ZoneOwnerArgsDict']] owner: The owner of the zone.
        :param pulumi.Input[_builtins.bool] paused: Indicates whether the zone is only using Cloudflare DNS services. A
               true value means the zone will not receive security or performance
               benefits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Legacy permissions based on legacy user membership information.
        :param pulumi.Input[Union['ZonePlanArgs', 'ZonePlanArgsDict']] plan: A Zones subscription information.
        :param pulumi.Input[_builtins.str] status: The zone status on Cloudflare.
               Available values: "initializing", "pending", "active", "moved".
        :param pulumi.Input[Union['ZoneTenantArgs', 'ZoneTenantArgsDict']] tenant: The root organizational unit that this zone belongs to (such as a tenant or organization).
        :param pulumi.Input[Union['ZoneTenantUnitArgs', 'ZoneTenantUnitArgsDict']] tenant_unit: The immediate parent organizational unit that this zone belongs to (such as under a tenant or sub-organization).
        :param pulumi.Input[_builtins.str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is
               typically a partner-hosted zone or a CNAME setup.
               Available values: "full", "partial", "secondary", "internal".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vanity_name_servers: An array of domains used for custom name servers. This is only
               available for Business and Enterprise plans.
        :param pulumi.Input[_builtins.str] verification_key: Verification key for partial zone setup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["account"] = account
        __props__.__dict__["activated_on"] = activated_on
        __props__.__dict__["cname_suffix"] = cname_suffix
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["development_mode"] = development_mode
        __props__.__dict__["meta"] = meta
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["name_servers"] = name_servers
        __props__.__dict__["original_dnshost"] = original_dnshost
        __props__.__dict__["original_name_servers"] = original_name_servers
        __props__.__dict__["original_registrar"] = original_registrar
        __props__.__dict__["owner"] = owner
        __props__.__dict__["paused"] = paused
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["plan"] = plan
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["tenant_unit"] = tenant_unit
        __props__.__dict__["type"] = type
        __props__.__dict__["vanity_name_servers"] = vanity_name_servers
        __props__.__dict__["verification_key"] = verification_key
        return Zone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Output['outputs.ZoneAccount']:
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter(name="activatedOn")
    def activated_on(self) -> pulumi.Output[_builtins.str]:
        """
        The last time proof of ownership was detected and the zone was made
        active.
        """
        return pulumi.get(self, "activated_on")

    @_builtins.property
    @pulumi.getter(name="cnameSuffix")
    def cname_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        Allows the customer to use a custom apex.
        *Tenants Only Configuration*.
        """
        return pulumi.get(self, "cname_suffix")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the zone was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="developmentMode")
    def development_mode(self) -> pulumi.Output[_builtins.float]:
        """
        The interval (in seconds) from when development mode expires
        (positive integer) or last expired (negative integer) for the
        domain. If development mode has never been enabled, this value is 0.
        """
        return pulumi.get(self, "development_mode")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output['outputs.ZoneMeta']:
        """
        Metadata about the zone.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the zone was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The name servers Cloudflare assigns to a zone.
        """
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter(name="originalDnshost")
    def original_dnshost(self) -> pulumi.Output[_builtins.str]:
        """
        DNS host at the time of switching to Cloudflare.
        """
        return pulumi.get(self, "original_dnshost")

    @_builtins.property
    @pulumi.getter(name="originalNameServers")
    def original_name_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Original name servers before moving to Cloudflare.
        """
        return pulumi.get(self, "original_name_servers")

    @_builtins.property
    @pulumi.getter(name="originalRegistrar")
    def original_registrar(self) -> pulumi.Output[_builtins.str]:
        """
        Registrar for the domain at the time of switching to Cloudflare.
        """
        return pulumi.get(self, "original_registrar")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output['outputs.ZoneOwner']:
        """
        The owner of the zone.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the zone is only using Cloudflare DNS services. A
        true value means the zone will not receive security or performance
        benefits.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This has been replaced by Account memberships.""")
    def permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Legacy permissions based on legacy user membership information.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Please use the `/zones/{zone_id}/subscription` API
to update a zone's plan. Changing this value will create/cancel
associated subscriptions. To view available plans for this zone,
see [Zone Plans](https://developers.cloudflare.com/api/resources/zones/subresources/plans/).""")
    def plan(self) -> pulumi.Output['outputs.ZonePlan']:
        """
        A Zones subscription information.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The zone status on Cloudflare.
        Available values: "initializing", "pending", "active", "moved".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output['outputs.ZoneTenant']:
        """
        The root organizational unit that this zone belongs to (such as a tenant or organization).
        """
        return pulumi.get(self, "tenant")

    @_builtins.property
    @pulumi.getter(name="tenantUnit")
    def tenant_unit(self) -> pulumi.Output['outputs.ZoneTenantUnit']:
        """
        The immediate parent organizational unit that this zone belongs to (such as under a tenant or sub-organization).
        """
        return pulumi.get(self, "tenant_unit")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        A full zone implies that DNS is hosted with Cloudflare. A partial zone is
        typically a partner-hosted zone or a CNAME setup.
        Available values: "full", "partial", "secondary", "internal".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of domains used for custom name servers. This is only
        available for Business and Enterprise plans.
        """
        return pulumi.get(self, "vanity_name_servers")

    @_builtins.property
    @pulumi.getter(name="verificationKey")
    def verification_key(self) -> pulumi.Output[_builtins.str]:
        """
        Verification key for partial zone setup.
        """
        return pulumi.get(self, "verification_key")

