# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZoneDnssecArgs', 'ZoneDnssec']

@pulumi.input_type
class ZoneDnssecArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[_builtins.str],
                 dnssec_multi_signer: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_presigned: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_use_nsec3: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ZoneDnssec resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.bool] dnssec_multi_signer: If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
               providers to serve a DNSSEC-signed zone at the same time.
               This is required for DNSKEY records (except those automatically
               generated by Cloudflare) to be added to the zone.
        :param pulumi.Input[_builtins.bool] dnssec_presigned: If true, allows Cloudflare to transfer in a DNSSEC-signed zone
               including signatures from an external provider, without requiring
               Cloudflare to sign any records on the fly.
               
               Note that this feature has some limitations.
               See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        :param pulumi.Input[_builtins.bool] dnssec_use_nsec3: If true, enables the use of NSEC3 together with DNSSEC on the zone.
               Combined with setting dnssec_presigned to true, this enables the use of
               NSEC3 records when transferring in from an external provider.
               If dnssec_presigned is instead set to false (default), NSEC3 records will be
               generated and signed at request time.
               
               See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        :param pulumi.Input[_builtins.str] status: Status of DNSSEC, based on user-desired state and presence of necessary records.
               Available values: "active", "disabled".
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if dnssec_multi_signer is not None:
            pulumi.set(__self__, "dnssec_multi_signer", dnssec_multi_signer)
        if dnssec_presigned is not None:
            pulumi.set(__self__, "dnssec_presigned", dnssec_presigned)
        if dnssec_use_nsec3 is not None:
            pulumi.set(__self__, "dnssec_use_nsec3", dnssec_use_nsec3)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="dnssecMultiSigner")
    def dnssec_multi_signer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
        providers to serve a DNSSEC-signed zone at the same time.
        This is required for DNSKEY records (except those automatically
        generated by Cloudflare) to be added to the zone.
        """
        return pulumi.get(self, "dnssec_multi_signer")

    @dnssec_multi_signer.setter
    def dnssec_multi_signer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_multi_signer", value)

    @_builtins.property
    @pulumi.getter(name="dnssecPresigned")
    def dnssec_presigned(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, allows Cloudflare to transfer in a DNSSEC-signed zone
        including signatures from an external provider, without requiring
        Cloudflare to sign any records on the fly.

        Note that this feature has some limitations.
        See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        """
        return pulumi.get(self, "dnssec_presigned")

    @dnssec_presigned.setter
    def dnssec_presigned(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_presigned", value)

    @_builtins.property
    @pulumi.getter(name="dnssecUseNsec3")
    def dnssec_use_nsec3(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables the use of NSEC3 together with DNSSEC on the zone.
        Combined with setting dnssec_presigned to true, this enables the use of
        NSEC3 records when transferring in from an external provider.
        If dnssec_presigned is instead set to false (default), NSEC3 records will be
        generated and signed at request time.

        See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        """
        return pulumi.get(self, "dnssec_use_nsec3")

    @dnssec_use_nsec3.setter
    def dnssec_use_nsec3(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_use_nsec3", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of DNSSEC, based on user-desired state and presence of necessary records.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ZoneDnssecState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 digest_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dnssec_multi_signer: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_presigned: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_use_nsec3: Optional[pulumi.Input[_builtins.bool]] = None,
                 ds: Optional[pulumi.Input[_builtins.str]] = None,
                 flags: Optional[pulumi.Input[_builtins.float]] = None,
                 key_tag: Optional[pulumi.Input[_builtins.float]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneDnssec resources.
        :param pulumi.Input[_builtins.str] algorithm: Algorithm key code.
        :param pulumi.Input[_builtins.str] digest: Digest hash.
        :param pulumi.Input[_builtins.str] digest_algorithm: Type of digest algorithm.
        :param pulumi.Input[_builtins.str] digest_type: Coded type for digest algorithm.
        :param pulumi.Input[_builtins.bool] dnssec_multi_signer: If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
               providers to serve a DNSSEC-signed zone at the same time.
               This is required for DNSKEY records (except those automatically
               generated by Cloudflare) to be added to the zone.
        :param pulumi.Input[_builtins.bool] dnssec_presigned: If true, allows Cloudflare to transfer in a DNSSEC-signed zone
               including signatures from an external provider, without requiring
               Cloudflare to sign any records on the fly.
               
               Note that this feature has some limitations.
               See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        :param pulumi.Input[_builtins.bool] dnssec_use_nsec3: If true, enables the use of NSEC3 together with DNSSEC on the zone.
               Combined with setting dnssec_presigned to true, this enables the use of
               NSEC3 records when transferring in from an external provider.
               If dnssec_presigned is instead set to false (default), NSEC3 records will be
               generated and signed at request time.
               
               See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        :param pulumi.Input[_builtins.str] ds: Full DS record.
        :param pulumi.Input[_builtins.float] flags: Flag for DNSSEC record.
        :param pulumi.Input[_builtins.float] key_tag: Code for key tag.
        :param pulumi.Input[_builtins.str] key_type: Algorithm key type.
        :param pulumi.Input[_builtins.str] modified_on: When DNSSEC was last modified.
        :param pulumi.Input[_builtins.str] public_key: Public key for DS record.
        :param pulumi.Input[_builtins.str] status: Status of DNSSEC, based on user-desired state and presence of necessary records.
               Available values: "active", "disabled".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if digest_type is not None:
            pulumi.set(__self__, "digest_type", digest_type)
        if dnssec_multi_signer is not None:
            pulumi.set(__self__, "dnssec_multi_signer", dnssec_multi_signer)
        if dnssec_presigned is not None:
            pulumi.set(__self__, "dnssec_presigned", dnssec_presigned)
        if dnssec_use_nsec3 is not None:
            pulumi.set(__self__, "dnssec_use_nsec3", dnssec_use_nsec3)
        if ds is not None:
            pulumi.set(__self__, "ds", ds)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)
        if key_tag is not None:
            pulumi.set(__self__, "key_tag", key_tag)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Algorithm key code.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Digest hash.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of digest algorithm.
        """
        return pulumi.get(self, "digest_algorithm")

    @digest_algorithm.setter
    def digest_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="digestType")
    def digest_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Coded type for digest algorithm.
        """
        return pulumi.get(self, "digest_type")

    @digest_type.setter
    def digest_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest_type", value)

    @_builtins.property
    @pulumi.getter(name="dnssecMultiSigner")
    def dnssec_multi_signer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
        providers to serve a DNSSEC-signed zone at the same time.
        This is required for DNSKEY records (except those automatically
        generated by Cloudflare) to be added to the zone.
        """
        return pulumi.get(self, "dnssec_multi_signer")

    @dnssec_multi_signer.setter
    def dnssec_multi_signer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_multi_signer", value)

    @_builtins.property
    @pulumi.getter(name="dnssecPresigned")
    def dnssec_presigned(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, allows Cloudflare to transfer in a DNSSEC-signed zone
        including signatures from an external provider, without requiring
        Cloudflare to sign any records on the fly.

        Note that this feature has some limitations.
        See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        """
        return pulumi.get(self, "dnssec_presigned")

    @dnssec_presigned.setter
    def dnssec_presigned(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_presigned", value)

    @_builtins.property
    @pulumi.getter(name="dnssecUseNsec3")
    def dnssec_use_nsec3(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables the use of NSEC3 together with DNSSEC on the zone.
        Combined with setting dnssec_presigned to true, this enables the use of
        NSEC3 records when transferring in from an external provider.
        If dnssec_presigned is instead set to false (default), NSEC3 records will be
        generated and signed at request time.

        See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        """
        return pulumi.get(self, "dnssec_use_nsec3")

    @dnssec_use_nsec3.setter
    def dnssec_use_nsec3(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_use_nsec3", value)

    @_builtins.property
    @pulumi.getter
    def ds(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full DS record.
        """
        return pulumi.get(self, "ds")

    @ds.setter
    def ds(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ds", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Flag for DNSSEC record.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "flags", value)

    @_builtins.property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Code for key tag.
        """
        return pulumi.get(self, "key_tag")

    @key_tag.setter
    def key_tag(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "key_tag", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Algorithm key type.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When DNSSEC was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public key for DS record.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of DNSSEC, based on user-desired state and presence of necessary records.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/zoneDnssec:ZoneDnssec")
class ZoneDnssec(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dnssec_multi_signer: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_presigned: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_use_nsec3: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zone_dnssec = cloudflare.ZoneDnssec("example_zone_dnssec",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            dnssec_multi_signer=False,
            dnssec_presigned=True,
            dnssec_use_nsec3=False,
            status="active")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zoneDnssec:ZoneDnssec example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dnssec_multi_signer: If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
               providers to serve a DNSSEC-signed zone at the same time.
               This is required for DNSKEY records (except those automatically
               generated by Cloudflare) to be added to the zone.
        :param pulumi.Input[_builtins.bool] dnssec_presigned: If true, allows Cloudflare to transfer in a DNSSEC-signed zone
               including signatures from an external provider, without requiring
               Cloudflare to sign any records on the fly.
               
               Note that this feature has some limitations.
               See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        :param pulumi.Input[_builtins.bool] dnssec_use_nsec3: If true, enables the use of NSEC3 together with DNSSEC on the zone.
               Combined with setting dnssec_presigned to true, this enables the use of
               NSEC3 records when transferring in from an external provider.
               If dnssec_presigned is instead set to false (default), NSEC3 records will be
               generated and signed at request time.
               
               See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        :param pulumi.Input[_builtins.str] status: Status of DNSSEC, based on user-desired state and presence of necessary records.
               Available values: "active", "disabled".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneDnssecArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zone_dnssec = cloudflare.ZoneDnssec("example_zone_dnssec",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            dnssec_multi_signer=False,
            dnssec_presigned=True,
            dnssec_use_nsec3=False,
            status="active")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zoneDnssec:ZoneDnssec example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZoneDnssecArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneDnssecArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dnssec_multi_signer: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_presigned: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_use_nsec3: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneDnssecArgs.__new__(ZoneDnssecArgs)

            __props__.__dict__["dnssec_multi_signer"] = dnssec_multi_signer
            __props__.__dict__["dnssec_presigned"] = dnssec_presigned
            __props__.__dict__["dnssec_use_nsec3"] = dnssec_use_nsec3
            __props__.__dict__["status"] = status
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["algorithm"] = None
            __props__.__dict__["digest"] = None
            __props__.__dict__["digest_algorithm"] = None
            __props__.__dict__["digest_type"] = None
            __props__.__dict__["ds"] = None
            __props__.__dict__["flags"] = None
            __props__.__dict__["key_tag"] = None
            __props__.__dict__["key_type"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["public_key"] = None
        super(ZoneDnssec, __self__).__init__(
            'cloudflare:index/zoneDnssec:ZoneDnssec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            digest: Optional[pulumi.Input[_builtins.str]] = None,
            digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            digest_type: Optional[pulumi.Input[_builtins.str]] = None,
            dnssec_multi_signer: Optional[pulumi.Input[_builtins.bool]] = None,
            dnssec_presigned: Optional[pulumi.Input[_builtins.bool]] = None,
            dnssec_use_nsec3: Optional[pulumi.Input[_builtins.bool]] = None,
            ds: Optional[pulumi.Input[_builtins.str]] = None,
            flags: Optional[pulumi.Input[_builtins.float]] = None,
            key_tag: Optional[pulumi.Input[_builtins.float]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZoneDnssec':
        """
        Get an existing ZoneDnssec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: Algorithm key code.
        :param pulumi.Input[_builtins.str] digest: Digest hash.
        :param pulumi.Input[_builtins.str] digest_algorithm: Type of digest algorithm.
        :param pulumi.Input[_builtins.str] digest_type: Coded type for digest algorithm.
        :param pulumi.Input[_builtins.bool] dnssec_multi_signer: If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
               providers to serve a DNSSEC-signed zone at the same time.
               This is required for DNSKEY records (except those automatically
               generated by Cloudflare) to be added to the zone.
        :param pulumi.Input[_builtins.bool] dnssec_presigned: If true, allows Cloudflare to transfer in a DNSSEC-signed zone
               including signatures from an external provider, without requiring
               Cloudflare to sign any records on the fly.
               
               Note that this feature has some limitations.
               See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        :param pulumi.Input[_builtins.bool] dnssec_use_nsec3: If true, enables the use of NSEC3 together with DNSSEC on the zone.
               Combined with setting dnssec_presigned to true, this enables the use of
               NSEC3 records when transferring in from an external provider.
               If dnssec_presigned is instead set to false (default), NSEC3 records will be
               generated and signed at request time.
               
               See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        :param pulumi.Input[_builtins.str] ds: Full DS record.
        :param pulumi.Input[_builtins.float] flags: Flag for DNSSEC record.
        :param pulumi.Input[_builtins.float] key_tag: Code for key tag.
        :param pulumi.Input[_builtins.str] key_type: Algorithm key type.
        :param pulumi.Input[_builtins.str] modified_on: When DNSSEC was last modified.
        :param pulumi.Input[_builtins.str] public_key: Public key for DS record.
        :param pulumi.Input[_builtins.str] status: Status of DNSSEC, based on user-desired state and presence of necessary records.
               Available values: "active", "disabled".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneDnssecState.__new__(_ZoneDnssecState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["digest"] = digest
        __props__.__dict__["digest_algorithm"] = digest_algorithm
        __props__.__dict__["digest_type"] = digest_type
        __props__.__dict__["dnssec_multi_signer"] = dnssec_multi_signer
        __props__.__dict__["dnssec_presigned"] = dnssec_presigned
        __props__.__dict__["dnssec_use_nsec3"] = dnssec_use_nsec3
        __props__.__dict__["ds"] = ds
        __props__.__dict__["flags"] = flags
        __props__.__dict__["key_tag"] = key_tag
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["status"] = status
        __props__.__dict__["zone_id"] = zone_id
        return ZoneDnssec(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Algorithm key code.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> pulumi.Output[_builtins.str]:
        """
        Digest hash.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Type of digest algorithm.
        """
        return pulumi.get(self, "digest_algorithm")

    @_builtins.property
    @pulumi.getter(name="digestType")
    def digest_type(self) -> pulumi.Output[_builtins.str]:
        """
        Coded type for digest algorithm.
        """
        return pulumi.get(self, "digest_type")

    @_builtins.property
    @pulumi.getter(name="dnssecMultiSigner")
    def dnssec_multi_signer(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
        providers to serve a DNSSEC-signed zone at the same time.
        This is required for DNSKEY records (except those automatically
        generated by Cloudflare) to be added to the zone.
        """
        return pulumi.get(self, "dnssec_multi_signer")

    @_builtins.property
    @pulumi.getter(name="dnssecPresigned")
    def dnssec_presigned(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, allows Cloudflare to transfer in a DNSSEC-signed zone
        including signatures from an external provider, without requiring
        Cloudflare to sign any records on the fly.

        Note that this feature has some limitations.
        See [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec) for details.
        """
        return pulumi.get(self, "dnssec_presigned")

    @_builtins.property
    @pulumi.getter(name="dnssecUseNsec3")
    def dnssec_use_nsec3(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, enables the use of NSEC3 together with DNSSEC on the zone.
        Combined with setting dnssec_presigned to true, this enables the use of
        NSEC3 records when transferring in from an external provider.
        If dnssec_presigned is instead set to false (default), NSEC3 records will be
        generated and signed at request time.

        See [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/) for details.
        """
        return pulumi.get(self, "dnssec_use_nsec3")

    @_builtins.property
    @pulumi.getter
    def ds(self) -> pulumi.Output[_builtins.str]:
        """
        Full DS record.
        """
        return pulumi.get(self, "ds")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> pulumi.Output[_builtins.float]:
        """
        Flag for DNSSEC record.
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> pulumi.Output[_builtins.float]:
        """
        Code for key tag.
        """
        return pulumi.get(self, "key_tag")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[_builtins.str]:
        """
        Algorithm key type.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When DNSSEC was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        Public key for DS record.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status of DNSSEC, based on user-desired state and presence of necessary records.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

