'''
# `upcloud_loadbalancer_backend`

Refer to the Terraform Registory for docs: [`upcloud_loadbalancer_backend`](https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf
import constructs


class LoadbalancerBackend(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-upcloud.loadbalancerBackend.LoadbalancerBackend",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend upcloud_loadbalancer_backend}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id_: builtins.str,
        *,
        loadbalancer: builtins.str,
        name: builtins.str,
        id: typing.Optional[builtins.str] = None,
        properties: typing.Optional[typing.Union["LoadbalancerBackendProperties", typing.Dict[str, typing.Any]]] = None,
        resolver_name: typing.Optional[builtins.str] = None,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend upcloud_loadbalancer_backend} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param loadbalancer: ID of the load balancer to which the backend is connected. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#loadbalancer LoadbalancerBackend#loadbalancer}
        :param name: The name of the backend must be unique within the load balancer service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#name LoadbalancerBackend#name}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#id LoadbalancerBackend#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param properties: properties block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#properties LoadbalancerBackend#properties}
        :param resolver_name: Domain Name Resolver used with dynamic type members. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#resolver_name LoadbalancerBackend#resolver_name}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(LoadbalancerBackend.__init__)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = LoadbalancerBackendConfig(
            loadbalancer=loadbalancer,
            name=name,
            id=id,
            properties=properties,
            resolver_name=resolver_name,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putProperties")
    def put_properties(
        self,
        *,
        health_check_expected_status: typing.Optional[jsii.Number] = None,
        health_check_fall: typing.Optional[jsii.Number] = None,
        health_check_interval: typing.Optional[jsii.Number] = None,
        health_check_rise: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        health_check_url: typing.Optional[builtins.str] = None,
        outbound_proxy_protocol: typing.Optional[builtins.str] = None,
        sticky_session_cookie_name: typing.Optional[builtins.str] = None,
        timeout_server: typing.Optional[jsii.Number] = None,
        timeout_tunnel: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param health_check_expected_status: Expected HTTP status code returned by the customer application to mark server as healthy. Ignored for tcp type. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_expected_status LoadbalancerBackend#health_check_expected_status}
        :param health_check_fall: Sets how many failed health checks are allowed until the backend member is taken off from the rotation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_fall LoadbalancerBackend#health_check_fall}
        :param health_check_interval: Interval between health checks. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_interval LoadbalancerBackend#health_check_interval}
        :param health_check_rise: Sets how many passing checks there must be before returning the backend member to the rotation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_rise LoadbalancerBackend#health_check_rise}
        :param health_check_type: Health check type. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_type LoadbalancerBackend#health_check_type}
        :param health_check_url: Target path for health check HTTP GET requests. Ignored for tcp type. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_url LoadbalancerBackend#health_check_url}
        :param outbound_proxy_protocol: Enable outbound proxy protocol by setting the desired version. Empty string disables proxy protocol. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#outbound_proxy_protocol LoadbalancerBackend#outbound_proxy_protocol}
        :param sticky_session_cookie_name: Sets sticky session cookie name. Empty string disables sticky session. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#sticky_session_cookie_name LoadbalancerBackend#sticky_session_cookie_name}
        :param timeout_server: Backend server timeout in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_server LoadbalancerBackend#timeout_server}
        :param timeout_tunnel: Maximum inactivity time on the client and server side for tunnels in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_tunnel LoadbalancerBackend#timeout_tunnel}
        '''
        value = LoadbalancerBackendProperties(
            health_check_expected_status=health_check_expected_status,
            health_check_fall=health_check_fall,
            health_check_interval=health_check_interval,
            health_check_rise=health_check_rise,
            health_check_type=health_check_type,
            health_check_url=health_check_url,
            outbound_proxy_protocol=outbound_proxy_protocol,
            sticky_session_cookie_name=sticky_session_cookie_name,
            timeout_server=timeout_server,
            timeout_tunnel=timeout_tunnel,
        )

        return typing.cast(None, jsii.invoke(self, "putProperties", [value]))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetProperties")
    def reset_properties(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetProperties", []))

    @jsii.member(jsii_name="resetResolverName")
    def reset_resolver_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResolverName", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "members"))

    @builtins.property
    @jsii.member(jsii_name="properties")
    def properties(self) -> "LoadbalancerBackendPropertiesOutputReference":
        return typing.cast("LoadbalancerBackendPropertiesOutputReference", jsii.get(self, "properties"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="loadbalancerInput")
    def loadbalancer_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "loadbalancerInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="propertiesInput")
    def properties_input(self) -> typing.Optional["LoadbalancerBackendProperties"]:
        return typing.cast(typing.Optional["LoadbalancerBackendProperties"], jsii.get(self, "propertiesInput"))

    @builtins.property
    @jsii.member(jsii_name="resolverNameInput")
    def resolver_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resolverNameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackend, "id").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="loadbalancer")
    def loadbalancer(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "loadbalancer"))

    @loadbalancer.setter
    def loadbalancer(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackend, "loadbalancer").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "loadbalancer", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackend, "name").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="resolverName")
    def resolver_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resolverName"))

    @resolver_name.setter
    def resolver_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackend, "resolver_name").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resolverName", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-upcloud.loadbalancerBackend.LoadbalancerBackendConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "loadbalancer": "loadbalancer",
        "name": "name",
        "id": "id",
        "properties": "properties",
        "resolver_name": "resolverName",
    },
)
class LoadbalancerBackendConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
        loadbalancer: builtins.str,
        name: builtins.str,
        id: typing.Optional[builtins.str] = None,
        properties: typing.Optional[typing.Union["LoadbalancerBackendProperties", typing.Dict[str, typing.Any]]] = None,
        resolver_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param loadbalancer: ID of the load balancer to which the backend is connected. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#loadbalancer LoadbalancerBackend#loadbalancer}
        :param name: The name of the backend must be unique within the load balancer service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#name LoadbalancerBackend#name}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#id LoadbalancerBackend#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param properties: properties block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#properties LoadbalancerBackend#properties}
        :param resolver_name: Domain Name Resolver used with dynamic type members. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#resolver_name LoadbalancerBackend#resolver_name}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(properties, dict):
            properties = LoadbalancerBackendProperties(**properties)
        if __debug__:
            type_hints = typing.get_type_hints(LoadbalancerBackendConfig.__init__)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument loadbalancer", value=loadbalancer, expected_type=type_hints["loadbalancer"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
            check_type(argname="argument resolver_name", value=resolver_name, expected_type=type_hints["resolver_name"])
        self._values: typing.Dict[str, typing.Any] = {
            "loadbalancer": loadbalancer,
            "name": name,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if id is not None:
            self._values["id"] = id
        if properties is not None:
            self._values["properties"] = properties
        if resolver_name is not None:
            self._values["resolver_name"] = resolver_name

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[cdktf.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[cdktf.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]], result)

    @builtins.property
    def loadbalancer(self) -> builtins.str:
        '''ID of the load balancer to which the backend is connected.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#loadbalancer LoadbalancerBackend#loadbalancer}
        '''
        result = self._values.get("loadbalancer")
        assert result is not None, "Required property 'loadbalancer' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the backend must be unique within the load balancer service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#name LoadbalancerBackend#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#id LoadbalancerBackend#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def properties(self) -> typing.Optional["LoadbalancerBackendProperties"]:
        '''properties block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#properties LoadbalancerBackend#properties}
        '''
        result = self._values.get("properties")
        return typing.cast(typing.Optional["LoadbalancerBackendProperties"], result)

    @builtins.property
    def resolver_name(self) -> typing.Optional[builtins.str]:
        '''Domain Name Resolver used with dynamic type members.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#resolver_name LoadbalancerBackend#resolver_name}
        '''
        result = self._values.get("resolver_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LoadbalancerBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-upcloud.loadbalancerBackend.LoadbalancerBackendProperties",
    jsii_struct_bases=[],
    name_mapping={
        "health_check_expected_status": "healthCheckExpectedStatus",
        "health_check_fall": "healthCheckFall",
        "health_check_interval": "healthCheckInterval",
        "health_check_rise": "healthCheckRise",
        "health_check_type": "healthCheckType",
        "health_check_url": "healthCheckUrl",
        "outbound_proxy_protocol": "outboundProxyProtocol",
        "sticky_session_cookie_name": "stickySessionCookieName",
        "timeout_server": "timeoutServer",
        "timeout_tunnel": "timeoutTunnel",
    },
)
class LoadbalancerBackendProperties:
    def __init__(
        self,
        *,
        health_check_expected_status: typing.Optional[jsii.Number] = None,
        health_check_fall: typing.Optional[jsii.Number] = None,
        health_check_interval: typing.Optional[jsii.Number] = None,
        health_check_rise: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        health_check_url: typing.Optional[builtins.str] = None,
        outbound_proxy_protocol: typing.Optional[builtins.str] = None,
        sticky_session_cookie_name: typing.Optional[builtins.str] = None,
        timeout_server: typing.Optional[jsii.Number] = None,
        timeout_tunnel: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param health_check_expected_status: Expected HTTP status code returned by the customer application to mark server as healthy. Ignored for tcp type. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_expected_status LoadbalancerBackend#health_check_expected_status}
        :param health_check_fall: Sets how many failed health checks are allowed until the backend member is taken off from the rotation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_fall LoadbalancerBackend#health_check_fall}
        :param health_check_interval: Interval between health checks. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_interval LoadbalancerBackend#health_check_interval}
        :param health_check_rise: Sets how many passing checks there must be before returning the backend member to the rotation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_rise LoadbalancerBackend#health_check_rise}
        :param health_check_type: Health check type. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_type LoadbalancerBackend#health_check_type}
        :param health_check_url: Target path for health check HTTP GET requests. Ignored for tcp type. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_url LoadbalancerBackend#health_check_url}
        :param outbound_proxy_protocol: Enable outbound proxy protocol by setting the desired version. Empty string disables proxy protocol. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#outbound_proxy_protocol LoadbalancerBackend#outbound_proxy_protocol}
        :param sticky_session_cookie_name: Sets sticky session cookie name. Empty string disables sticky session. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#sticky_session_cookie_name LoadbalancerBackend#sticky_session_cookie_name}
        :param timeout_server: Backend server timeout in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_server LoadbalancerBackend#timeout_server}
        :param timeout_tunnel: Maximum inactivity time on the client and server side for tunnels in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_tunnel LoadbalancerBackend#timeout_tunnel}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(LoadbalancerBackendProperties.__init__)
            check_type(argname="argument health_check_expected_status", value=health_check_expected_status, expected_type=type_hints["health_check_expected_status"])
            check_type(argname="argument health_check_fall", value=health_check_fall, expected_type=type_hints["health_check_fall"])
            check_type(argname="argument health_check_interval", value=health_check_interval, expected_type=type_hints["health_check_interval"])
            check_type(argname="argument health_check_rise", value=health_check_rise, expected_type=type_hints["health_check_rise"])
            check_type(argname="argument health_check_type", value=health_check_type, expected_type=type_hints["health_check_type"])
            check_type(argname="argument health_check_url", value=health_check_url, expected_type=type_hints["health_check_url"])
            check_type(argname="argument outbound_proxy_protocol", value=outbound_proxy_protocol, expected_type=type_hints["outbound_proxy_protocol"])
            check_type(argname="argument sticky_session_cookie_name", value=sticky_session_cookie_name, expected_type=type_hints["sticky_session_cookie_name"])
            check_type(argname="argument timeout_server", value=timeout_server, expected_type=type_hints["timeout_server"])
            check_type(argname="argument timeout_tunnel", value=timeout_tunnel, expected_type=type_hints["timeout_tunnel"])
        self._values: typing.Dict[str, typing.Any] = {}
        if health_check_expected_status is not None:
            self._values["health_check_expected_status"] = health_check_expected_status
        if health_check_fall is not None:
            self._values["health_check_fall"] = health_check_fall
        if health_check_interval is not None:
            self._values["health_check_interval"] = health_check_interval
        if health_check_rise is not None:
            self._values["health_check_rise"] = health_check_rise
        if health_check_type is not None:
            self._values["health_check_type"] = health_check_type
        if health_check_url is not None:
            self._values["health_check_url"] = health_check_url
        if outbound_proxy_protocol is not None:
            self._values["outbound_proxy_protocol"] = outbound_proxy_protocol
        if sticky_session_cookie_name is not None:
            self._values["sticky_session_cookie_name"] = sticky_session_cookie_name
        if timeout_server is not None:
            self._values["timeout_server"] = timeout_server
        if timeout_tunnel is not None:
            self._values["timeout_tunnel"] = timeout_tunnel

    @builtins.property
    def health_check_expected_status(self) -> typing.Optional[jsii.Number]:
        '''Expected HTTP status code returned by the customer application to mark server as healthy. Ignored for tcp type.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_expected_status LoadbalancerBackend#health_check_expected_status}
        '''
        result = self._values.get("health_check_expected_status")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_fall(self) -> typing.Optional[jsii.Number]:
        '''Sets how many failed health checks are allowed until the backend member is taken off from the rotation.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_fall LoadbalancerBackend#health_check_fall}
        '''
        result = self._values.get("health_check_fall")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_interval(self) -> typing.Optional[jsii.Number]:
        '''Interval between health checks.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_interval LoadbalancerBackend#health_check_interval}
        '''
        result = self._values.get("health_check_interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_rise(self) -> typing.Optional[jsii.Number]:
        '''Sets how many passing checks there must be before returning the backend member to the rotation.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_rise LoadbalancerBackend#health_check_rise}
        '''
        result = self._values.get("health_check_rise")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_type(self) -> typing.Optional[builtins.str]:
        '''Health check type.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_type LoadbalancerBackend#health_check_type}
        '''
        result = self._values.get("health_check_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def health_check_url(self) -> typing.Optional[builtins.str]:
        '''Target path for health check HTTP GET requests. Ignored for tcp type.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_url LoadbalancerBackend#health_check_url}
        '''
        result = self._values.get("health_check_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def outbound_proxy_protocol(self) -> typing.Optional[builtins.str]:
        '''Enable outbound proxy protocol by setting the desired version. Empty string disables proxy protocol.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#outbound_proxy_protocol LoadbalancerBackend#outbound_proxy_protocol}
        '''
        result = self._values.get("outbound_proxy_protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sticky_session_cookie_name(self) -> typing.Optional[builtins.str]:
        '''Sets sticky session cookie name. Empty string disables sticky session.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#sticky_session_cookie_name LoadbalancerBackend#sticky_session_cookie_name}
        '''
        result = self._values.get("sticky_session_cookie_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeout_server(self) -> typing.Optional[jsii.Number]:
        '''Backend server timeout in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_server LoadbalancerBackend#timeout_server}
        '''
        result = self._values.get("timeout_server")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_tunnel(self) -> typing.Optional[jsii.Number]:
        '''Maximum inactivity time on the client and server side for tunnels in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_tunnel LoadbalancerBackend#timeout_tunnel}
        '''
        result = self._values.get("timeout_tunnel")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LoadbalancerBackendProperties(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LoadbalancerBackendPropertiesOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-upcloud.loadbalancerBackend.LoadbalancerBackendPropertiesOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(LoadbalancerBackendPropertiesOutputReference.__init__)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetHealthCheckExpectedStatus")
    def reset_health_check_expected_status(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckExpectedStatus", []))

    @jsii.member(jsii_name="resetHealthCheckFall")
    def reset_health_check_fall(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckFall", []))

    @jsii.member(jsii_name="resetHealthCheckInterval")
    def reset_health_check_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckInterval", []))

    @jsii.member(jsii_name="resetHealthCheckRise")
    def reset_health_check_rise(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckRise", []))

    @jsii.member(jsii_name="resetHealthCheckType")
    def reset_health_check_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckType", []))

    @jsii.member(jsii_name="resetHealthCheckUrl")
    def reset_health_check_url(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckUrl", []))

    @jsii.member(jsii_name="resetOutboundProxyProtocol")
    def reset_outbound_proxy_protocol(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOutboundProxyProtocol", []))

    @jsii.member(jsii_name="resetStickySessionCookieName")
    def reset_sticky_session_cookie_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStickySessionCookieName", []))

    @jsii.member(jsii_name="resetTimeoutServer")
    def reset_timeout_server(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeoutServer", []))

    @jsii.member(jsii_name="resetTimeoutTunnel")
    def reset_timeout_tunnel(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeoutTunnel", []))

    @builtins.property
    @jsii.member(jsii_name="healthCheckExpectedStatusInput")
    def health_check_expected_status_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "healthCheckExpectedStatusInput"))

    @builtins.property
    @jsii.member(jsii_name="healthCheckFallInput")
    def health_check_fall_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "healthCheckFallInput"))

    @builtins.property
    @jsii.member(jsii_name="healthCheckIntervalInput")
    def health_check_interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "healthCheckIntervalInput"))

    @builtins.property
    @jsii.member(jsii_name="healthCheckRiseInput")
    def health_check_rise_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "healthCheckRiseInput"))

    @builtins.property
    @jsii.member(jsii_name="healthCheckTypeInput")
    def health_check_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "healthCheckTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="healthCheckUrlInput")
    def health_check_url_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "healthCheckUrlInput"))

    @builtins.property
    @jsii.member(jsii_name="outboundProxyProtocolInput")
    def outbound_proxy_protocol_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "outboundProxyProtocolInput"))

    @builtins.property
    @jsii.member(jsii_name="stickySessionCookieNameInput")
    def sticky_session_cookie_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "stickySessionCookieNameInput"))

    @builtins.property
    @jsii.member(jsii_name="timeoutServerInput")
    def timeout_server_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "timeoutServerInput"))

    @builtins.property
    @jsii.member(jsii_name="timeoutTunnelInput")
    def timeout_tunnel_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "timeoutTunnelInput"))

    @builtins.property
    @jsii.member(jsii_name="healthCheckExpectedStatus")
    def health_check_expected_status(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "healthCheckExpectedStatus"))

    @health_check_expected_status.setter
    def health_check_expected_status(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "health_check_expected_status").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "healthCheckExpectedStatus", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckFall")
    def health_check_fall(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "healthCheckFall"))

    @health_check_fall.setter
    def health_check_fall(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "health_check_fall").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "healthCheckFall", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckInterval")
    def health_check_interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "healthCheckInterval"))

    @health_check_interval.setter
    def health_check_interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "health_check_interval").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "healthCheckInterval", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckRise")
    def health_check_rise(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "healthCheckRise"))

    @health_check_rise.setter
    def health_check_rise(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "health_check_rise").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "healthCheckRise", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckType")
    def health_check_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "healthCheckType"))

    @health_check_type.setter
    def health_check_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "health_check_type").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "healthCheckType", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckUrl")
    def health_check_url(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "healthCheckUrl"))

    @health_check_url.setter
    def health_check_url(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "health_check_url").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "healthCheckUrl", value)

    @builtins.property
    @jsii.member(jsii_name="outboundProxyProtocol")
    def outbound_proxy_protocol(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "outboundProxyProtocol"))

    @outbound_proxy_protocol.setter
    def outbound_proxy_protocol(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "outbound_proxy_protocol").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "outboundProxyProtocol", value)

    @builtins.property
    @jsii.member(jsii_name="stickySessionCookieName")
    def sticky_session_cookie_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stickySessionCookieName"))

    @sticky_session_cookie_name.setter
    def sticky_session_cookie_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "sticky_session_cookie_name").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stickySessionCookieName", value)

    @builtins.property
    @jsii.member(jsii_name="timeoutServer")
    def timeout_server(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "timeoutServer"))

    @timeout_server.setter
    def timeout_server(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "timeout_server").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "timeoutServer", value)

    @builtins.property
    @jsii.member(jsii_name="timeoutTunnel")
    def timeout_tunnel(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "timeoutTunnel"))

    @timeout_tunnel.setter
    def timeout_tunnel(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "timeout_tunnel").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "timeoutTunnel", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[LoadbalancerBackendProperties]:
        return typing.cast(typing.Optional[LoadbalancerBackendProperties], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[LoadbalancerBackendProperties],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(LoadbalancerBackendPropertiesOutputReference, "internal_value").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "LoadbalancerBackend",
    "LoadbalancerBackendConfig",
    "LoadbalancerBackendProperties",
    "LoadbalancerBackendPropertiesOutputReference",
]

publication.publish()
