import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudZonesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/zones#filter_type DataUpcloudZones#filter_type}
    */
    readonly filterType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/zones#id DataUpcloudZones#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/zones upcloud_zones}
*/
export declare class DataUpcloudZones extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_zones";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/zones upcloud_zones} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudZonesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataUpcloudZonesConfig);
    private _filterType?;
    get filterType(): string;
    set filterType(value: string);
    resetFilterType(): void;
    get filterTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get zoneIds(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
