import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallRulesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#id FirewallRules#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The unique id of the server to be protected the firewall rules
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#server_id FirewallRules#server_id}
    */
    readonly serverId: string;
    /**
    * firewall_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#firewall_rule FirewallRules#firewall_rule}
    */
    readonly firewallRule: FirewallRulesFirewallRule[] | cdktf.IResolvable;
}
export interface FirewallRulesFirewallRule {
    /**
    * Action to take if the rule conditions are met
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#action FirewallRules#action}
    */
    readonly action: string;
    /**
    * Freeform comment string for the rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#comment FirewallRules#comment}
    */
    readonly comment?: string;
    /**
    * The destination address range ends from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_address_end FirewallRules#destination_address_end}
    */
    readonly destinationAddressEnd?: string;
    /**
    * The destination address range starts from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_address_start FirewallRules#destination_address_start}
    */
    readonly destinationAddressStart?: string;
    /**
    * The destination port range ends from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_port_end FirewallRules#destination_port_end}
    */
    readonly destinationPortEnd?: string;
    /**
    * The destination port range starts from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_port_start FirewallRules#destination_port_start}
    */
    readonly destinationPortStart?: string;
    /**
    * The direction of network traffic this rule will be applied to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#direction FirewallRules#direction}
    */
    readonly direction: string;
    /**
    * The address family of new firewall rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#family FirewallRules#family}
    */
    readonly family?: string;
    /**
    * The ICMP type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#icmp_type FirewallRules#icmp_type}
    */
    readonly icmpType?: string;
    /**
    * The protocol this rule will be applied to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#protocol FirewallRules#protocol}
    */
    readonly protocol?: string;
    /**
    * The source address range ends from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_address_end FirewallRules#source_address_end}
    */
    readonly sourceAddressEnd?: string;
    /**
    * The source address range starts from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_address_start FirewallRules#source_address_start}
    */
    readonly sourceAddressStart?: string;
    /**
    * The source port range ends from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_port_end FirewallRules#source_port_end}
    */
    readonly sourcePortEnd?: string;
    /**
    * The source port range starts from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_port_start FirewallRules#source_port_start}
    */
    readonly sourcePortStart?: string;
}
export declare function firewallRulesFirewallRuleToTerraform(struct?: FirewallRulesFirewallRule | cdktf.IResolvable): any;
export declare class FirewallRulesFirewallRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallRulesFirewallRule | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallRulesFirewallRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _destinationAddressEnd?;
    get destinationAddressEnd(): string;
    set destinationAddressEnd(value: string);
    resetDestinationAddressEnd(): void;
    get destinationAddressEndInput(): string | undefined;
    private _destinationAddressStart?;
    get destinationAddressStart(): string;
    set destinationAddressStart(value: string);
    resetDestinationAddressStart(): void;
    get destinationAddressStartInput(): string | undefined;
    private _destinationPortEnd?;
    get destinationPortEnd(): string;
    set destinationPortEnd(value: string);
    resetDestinationPortEnd(): void;
    get destinationPortEndInput(): string | undefined;
    private _destinationPortStart?;
    get destinationPortStart(): string;
    set destinationPortStart(value: string);
    resetDestinationPortStart(): void;
    get destinationPortStartInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _family?;
    get family(): string;
    set family(value: string);
    resetFamily(): void;
    get familyInput(): string | undefined;
    private _icmpType?;
    get icmpType(): string;
    set icmpType(value: string);
    resetIcmpType(): void;
    get icmpTypeInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _sourceAddressEnd?;
    get sourceAddressEnd(): string;
    set sourceAddressEnd(value: string);
    resetSourceAddressEnd(): void;
    get sourceAddressEndInput(): string | undefined;
    private _sourceAddressStart?;
    get sourceAddressStart(): string;
    set sourceAddressStart(value: string);
    resetSourceAddressStart(): void;
    get sourceAddressStartInput(): string | undefined;
    private _sourcePortEnd?;
    get sourcePortEnd(): string;
    set sourcePortEnd(value: string);
    resetSourcePortEnd(): void;
    get sourcePortEndInput(): string | undefined;
    private _sourcePortStart?;
    get sourcePortStart(): string;
    set sourcePortStart(value: string);
    resetSourcePortStart(): void;
    get sourcePortStartInput(): string | undefined;
}
export declare class FirewallRulesFirewallRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallRulesFirewallRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallRulesFirewallRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules upcloud_firewall_rules}
*/
export declare class FirewallRules extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_firewall_rules";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules upcloud_firewall_rules} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallRulesConfig
    */
    constructor(scope: Construct, id: string, config: FirewallRulesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _firewallRule;
    get firewallRule(): FirewallRulesFirewallRuleList;
    putFirewallRule(value: FirewallRulesFirewallRule[] | cdktf.IResolvable): void;
    get firewallRuleInput(): cdktf.IResolvable | FirewallRulesFirewallRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
