// Code generated by github.com/Khan/genqlient, DO NOT EDIT.

package gql

import (
	"context"
	"encoding/json"

	"github.com/Khan/genqlient/graphql"
)

type AlertSeverity string

const (
	AlertSeverityInfo  AlertSeverity = "INFO"
	AlertSeverityWarn  AlertSeverity = "WARN"
	AlertSeverityError AlertSeverity = "ERROR"
)

var AllAlertSeverity = []AlertSeverity{
	AlertSeverityInfo,
	AlertSeverityWarn,
	AlertSeverityError,
}

type ArtifactAliasInput struct {
	ArtifactCollectionName string `json:"artifactCollectionName"`
	Alias                  string `json:"alias"`
}

// GetArtifactCollectionName returns ArtifactAliasInput.ArtifactCollectionName, and is useful for accessing the field via an interface.
func (v *ArtifactAliasInput) GetArtifactCollectionName() string { return v.ArtifactCollectionName }

// GetAlias returns ArtifactAliasInput.Alias, and is useful for accessing the field via an interface.
func (v *ArtifactAliasInput) GetAlias() string { return v.Alias }

type ArtifactDigestAlgorithm string

const (
	ArtifactDigestAlgorithmManifestMd5 ArtifactDigestAlgorithm = "MANIFEST_MD5"
)

var AllArtifactDigestAlgorithm = []ArtifactDigestAlgorithm{
	ArtifactDigestAlgorithmManifestMd5,
}

// ArtifactFileURLsArtifact includes the requested fields of the GraphQL type Artifact.
type ArtifactFileURLsArtifact struct {
	Files *ArtifactFileURLsArtifactFilesFileConnection `json:"files"`
}

// GetFiles returns ArtifactFileURLsArtifact.Files, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifact) GetFiles() *ArtifactFileURLsArtifactFilesFileConnection {
	return v.Files
}

// ArtifactFileURLsArtifactFilesFileConnection includes the requested fields of the GraphQL type FileConnection.
type ArtifactFileURLsArtifactFilesFileConnection struct {
	PageInfo ArtifactFileURLsArtifactFilesFileConnectionPageInfo        `json:"pageInfo"`
	Edges    []ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdge `json:"edges"`
}

// GetPageInfo returns ArtifactFileURLsArtifactFilesFileConnection.PageInfo, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnection) GetPageInfo() ArtifactFileURLsArtifactFilesFileConnectionPageInfo {
	return v.PageInfo
}

// GetEdges returns ArtifactFileURLsArtifactFilesFileConnection.Edges, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnection) GetEdges() []ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdge {
	return v.Edges
}

// ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdge includes the requested fields of the GraphQL type FileEdge.
type ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdge struct {
	Node *ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile `json:"node"`
}

// GetNode returns ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdge.Node, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdge) GetNode() *ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile {
	return v.Node
}

// ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile includes the requested fields of the GraphQL type File.
type ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile struct {
	Name      string `json:"name"`
	DirectUrl string `json:"directUrl"`
}

// GetName returns ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile.Name, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile) GetName() string {
	return v.Name
}

// GetDirectUrl returns ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile.DirectUrl, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnectionEdgesFileEdgeNodeFile) GetDirectUrl() string {
	return v.DirectUrl
}

// ArtifactFileURLsArtifactFilesFileConnectionPageInfo includes the requested fields of the GraphQL type PageInfo.
type ArtifactFileURLsArtifactFilesFileConnectionPageInfo struct {
	HasNextPage bool    `json:"hasNextPage"`
	EndCursor   *string `json:"endCursor"`
}

// GetHasNextPage returns ArtifactFileURLsArtifactFilesFileConnectionPageInfo.HasNextPage, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnectionPageInfo) GetHasNextPage() bool {
	return v.HasNextPage
}

// GetEndCursor returns ArtifactFileURLsArtifactFilesFileConnectionPageInfo.EndCursor, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsArtifactFilesFileConnectionPageInfo) GetEndCursor() *string {
	return v.EndCursor
}

// ArtifactFileURLsByManifestEntriesArtifact includes the requested fields of the GraphQL type Artifact.
type ArtifactFileURLsByManifestEntriesArtifact struct {
	FilesByManifestEntries *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection `json:"filesByManifestEntries"`
}

// GetFilesByManifestEntries returns ArtifactFileURLsByManifestEntriesArtifact.FilesByManifestEntries, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifact) GetFilesByManifestEntries() *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection {
	return v.FilesByManifestEntries
}

// ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection includes the requested fields of the GraphQL type FileConnection.
type ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection struct {
	PageInfo ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo        `json:"pageInfo"`
	Edges    []ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdge `json:"edges"`
}

// GetPageInfo returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection.PageInfo, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection) GetPageInfo() ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo {
	return v.PageInfo
}

// GetEdges returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection.Edges, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnection) GetEdges() []ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdge {
	return v.Edges
}

// ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdge includes the requested fields of the GraphQL type FileEdge.
type ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdge struct {
	Node *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile `json:"node"`
}

// GetNode returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdge.Node, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdge) GetNode() *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile {
	return v.Node
}

// ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile includes the requested fields of the GraphQL type File.
type ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile struct {
	Name      string `json:"name"`
	DirectUrl string `json:"directUrl"`
}

// GetName returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile.Name, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile) GetName() string {
	return v.Name
}

// GetDirectUrl returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile.DirectUrl, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionEdgesFileEdgeNodeFile) GetDirectUrl() string {
	return v.DirectUrl
}

// ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo includes the requested fields of the GraphQL type PageInfo.
type ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo struct {
	HasNextPage bool    `json:"hasNextPage"`
	EndCursor   *string `json:"endCursor"`
}

// GetHasNextPage returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo.HasNextPage, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo) GetHasNextPage() bool {
	return v.HasNextPage
}

// GetEndCursor returns ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo.EndCursor, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesArtifactFilesByManifestEntriesFileConnectionPageInfo) GetEndCursor() *string {
	return v.EndCursor
}

// ArtifactFileURLsByManifestEntriesResponse is returned by ArtifactFileURLsByManifestEntries on success.
type ArtifactFileURLsByManifestEntriesResponse struct {
	Artifact *ArtifactFileURLsByManifestEntriesArtifact `json:"artifact"`
}

// GetArtifact returns ArtifactFileURLsByManifestEntriesResponse.Artifact, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsByManifestEntriesResponse) GetArtifact() *ArtifactFileURLsByManifestEntriesArtifact {
	return v.Artifact
}

// ArtifactFileURLsResponse is returned by ArtifactFileURLs on success.
type ArtifactFileURLsResponse struct {
	Artifact *ArtifactFileURLsArtifact `json:"artifact"`
}

// GetArtifact returns ArtifactFileURLsResponse.Artifact, and is useful for accessing the field via an interface.
func (v *ArtifactFileURLsResponse) GetArtifact() *ArtifactFileURLsArtifact { return v.Artifact }

// ArtifactManifestArtifact includes the requested fields of the GraphQL type Artifact.
type ArtifactManifestArtifact struct {
	CurrentManifest *ArtifactManifestArtifactCurrentManifestArtifactManifest `json:"currentManifest"`
}

// GetCurrentManifest returns ArtifactManifestArtifact.CurrentManifest, and is useful for accessing the field via an interface.
func (v *ArtifactManifestArtifact) GetCurrentManifest() *ArtifactManifestArtifactCurrentManifestArtifactManifest {
	return v.CurrentManifest
}

// ArtifactManifestArtifactCurrentManifestArtifactManifest includes the requested fields of the GraphQL type ArtifactManifest.
type ArtifactManifestArtifactCurrentManifestArtifactManifest struct {
	File ArtifactManifestArtifactCurrentManifestArtifactManifestFile `json:"file"`
}

// GetFile returns ArtifactManifestArtifactCurrentManifestArtifactManifest.File, and is useful for accessing the field via an interface.
func (v *ArtifactManifestArtifactCurrentManifestArtifactManifest) GetFile() ArtifactManifestArtifactCurrentManifestArtifactManifestFile {
	return v.File
}

// ArtifactManifestArtifactCurrentManifestArtifactManifestFile includes the requested fields of the GraphQL type File.
type ArtifactManifestArtifactCurrentManifestArtifactManifestFile struct {
	DirectUrl string `json:"directUrl"`
}

// GetDirectUrl returns ArtifactManifestArtifactCurrentManifestArtifactManifestFile.DirectUrl, and is useful for accessing the field via an interface.
func (v *ArtifactManifestArtifactCurrentManifestArtifactManifestFile) GetDirectUrl() string {
	return v.DirectUrl
}

type ArtifactManifestEntryInput struct {
	Name            string  `json:"name"`
	Digest          string  `json:"digest"`
	BirthArtifactID *string `json:"birthArtifactID"`
	Ref             *string `json:"ref"`
	Size            *int64  `json:"size"`
}

// GetName returns ArtifactManifestEntryInput.Name, and is useful for accessing the field via an interface.
func (v *ArtifactManifestEntryInput) GetName() string { return v.Name }

// GetDigest returns ArtifactManifestEntryInput.Digest, and is useful for accessing the field via an interface.
func (v *ArtifactManifestEntryInput) GetDigest() string { return v.Digest }

// GetBirthArtifactID returns ArtifactManifestEntryInput.BirthArtifactID, and is useful for accessing the field via an interface.
func (v *ArtifactManifestEntryInput) GetBirthArtifactID() *string { return v.BirthArtifactID }

// GetRef returns ArtifactManifestEntryInput.Ref, and is useful for accessing the field via an interface.
func (v *ArtifactManifestEntryInput) GetRef() *string { return v.Ref }

// GetSize returns ArtifactManifestEntryInput.Size, and is useful for accessing the field via an interface.
func (v *ArtifactManifestEntryInput) GetSize() *int64 { return v.Size }

// ArtifactManifestResponse is returned by ArtifactManifest on success.
type ArtifactManifestResponse struct {
	Artifact *ArtifactManifestArtifact `json:"artifact"`
}

// GetArtifact returns ArtifactManifestResponse.Artifact, and is useful for accessing the field via an interface.
func (v *ArtifactManifestResponse) GetArtifact() *ArtifactManifestArtifact { return v.Artifact }

type ArtifactManifestType string

const (
	ArtifactManifestTypeFull        ArtifactManifestType = "FULL"
	ArtifactManifestTypePatch       ArtifactManifestType = "PATCH"
	ArtifactManifestTypeIncremental ArtifactManifestType = "INCREMENTAL"
)

var AllArtifactManifestType = []ArtifactManifestType{
	ArtifactManifestTypeFull,
	ArtifactManifestTypePatch,
	ArtifactManifestTypeIncremental,
}

type ArtifactState string

const (
	ArtifactStatePending   ArtifactState = "PENDING"
	ArtifactStateCommitted ArtifactState = "COMMITTED"
	ArtifactStateDeleted   ArtifactState = "DELETED"
)

var AllArtifactState = []ArtifactState{
	ArtifactStatePending,
	ArtifactStateCommitted,
	ArtifactStateDeleted,
}

type ArtifactStorageLayout string

const (
	ArtifactStorageLayoutV1 ArtifactStorageLayout = "V1"
	ArtifactStorageLayoutV2 ArtifactStorageLayout = "V2"
)

var AllArtifactStorageLayout = []ArtifactStorageLayout{
	ArtifactStorageLayoutV1,
	ArtifactStorageLayoutV2,
}

// ClientIDMappingClientIDMapping includes the requested fields of the GraphQL type ClientIDMapping.
type ClientIDMappingClientIDMapping struct {
	ServerID string `json:"serverID"`
}

// GetServerID returns ClientIDMappingClientIDMapping.ServerID, and is useful for accessing the field via an interface.
func (v *ClientIDMappingClientIDMapping) GetServerID() string { return v.ServerID }

// ClientIDMappingResponse is returned by ClientIDMapping on success.
type ClientIDMappingResponse struct {
	ClientIDMapping *ClientIDMappingClientIDMapping `json:"clientIDMapping"`
}

// GetClientIDMapping returns ClientIDMappingResponse.ClientIDMapping, and is useful for accessing the field via an interface.
func (v *ClientIDMappingResponse) GetClientIDMapping() *ClientIDMappingClientIDMapping {
	return v.ClientIDMapping
}

// CommitArtifactCommitArtifactCommitArtifactPayload includes the requested fields of the GraphQL type CommitArtifactPayload.
type CommitArtifactCommitArtifactCommitArtifactPayload struct {
	Artifact CommitArtifactCommitArtifactCommitArtifactPayloadArtifact `json:"artifact"`
}

// GetArtifact returns CommitArtifactCommitArtifactCommitArtifactPayload.Artifact, and is useful for accessing the field via an interface.
func (v *CommitArtifactCommitArtifactCommitArtifactPayload) GetArtifact() CommitArtifactCommitArtifactCommitArtifactPayloadArtifact {
	return v.Artifact
}

// CommitArtifactCommitArtifactCommitArtifactPayloadArtifact includes the requested fields of the GraphQL type Artifact.
type CommitArtifactCommitArtifactCommitArtifactPayloadArtifact struct {
	Id     string `json:"id"`
	Digest string `json:"digest"`
}

// GetId returns CommitArtifactCommitArtifactCommitArtifactPayloadArtifact.Id, and is useful for accessing the field via an interface.
func (v *CommitArtifactCommitArtifactCommitArtifactPayloadArtifact) GetId() string { return v.Id }

// GetDigest returns CommitArtifactCommitArtifactCommitArtifactPayloadArtifact.Digest, and is useful for accessing the field via an interface.
func (v *CommitArtifactCommitArtifactCommitArtifactPayloadArtifact) GetDigest() string {
	return v.Digest
}

// CommitArtifactResponse is returned by CommitArtifact on success.
type CommitArtifactResponse struct {
	CommitArtifact *CommitArtifactCommitArtifactCommitArtifactPayload `json:"commitArtifact"`
}

// GetCommitArtifact returns CommitArtifactResponse.CommitArtifact, and is useful for accessing the field via an interface.
func (v *CommitArtifactResponse) GetCommitArtifact() *CommitArtifactCommitArtifactCommitArtifactPayload {
	return v.CommitArtifact
}

type CompleteMultipartAction string

const (
	CompleteMultipartActionComplete CompleteMultipartAction = "Complete"
)

var AllCompleteMultipartAction = []CompleteMultipartAction{
	CompleteMultipartActionComplete,
}

// CompleteMultipartUploadArtifactCompleteMultipartUploadArtifactCompleteMultipartUploadArtifactPayload includes the requested fields of the GraphQL type CompleteMultipartUploadArtifactPayload.
type CompleteMultipartUploadArtifactCompleteMultipartUploadArtifactCompleteMultipartUploadArtifactPayload struct {
	Digest *string `json:"digest"`
}

// GetDigest returns CompleteMultipartUploadArtifactCompleteMultipartUploadArtifactCompleteMultipartUploadArtifactPayload.Digest, and is useful for accessing the field via an interface.
func (v *CompleteMultipartUploadArtifactCompleteMultipartUploadArtifactCompleteMultipartUploadArtifactPayload) GetDigest() *string {
	return v.Digest
}

// CompleteMultipartUploadArtifactResponse is returned by CompleteMultipartUploadArtifact on success.
type CompleteMultipartUploadArtifactResponse struct {
	CompleteMultipartUploadArtifact *CompleteMultipartUploadArtifactCompleteMultipartUploadArtifactCompleteMultipartUploadArtifactPayload `json:"completeMultipartUploadArtifact"`
}

// GetCompleteMultipartUploadArtifact returns CompleteMultipartUploadArtifactResponse.CompleteMultipartUploadArtifact, and is useful for accessing the field via an interface.
func (v *CompleteMultipartUploadArtifactResponse) GetCompleteMultipartUploadArtifact() *CompleteMultipartUploadArtifactCompleteMultipartUploadArtifactCompleteMultipartUploadArtifactPayload {
	return v.CompleteMultipartUploadArtifact
}

// CreateArtifactCreateArtifactCreateArtifactPayload includes the requested fields of the GraphQL type CreateArtifactPayload.
type CreateArtifactCreateArtifactCreateArtifactPayload struct {
	CreatedArtifact `json:"-"`
}

// GetArtifact returns CreateArtifactCreateArtifactCreateArtifactPayload.Artifact, and is useful for accessing the field via an interface.
func (v *CreateArtifactCreateArtifactCreateArtifactPayload) GetArtifact() CreatedArtifactArtifact {
	return v.CreatedArtifact.Artifact
}

func (v *CreateArtifactCreateArtifactCreateArtifactPayload) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*CreateArtifactCreateArtifactCreateArtifactPayload
		graphql.NoUnmarshalJSON
	}
	firstPass.CreateArtifactCreateArtifactCreateArtifactPayload = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.CreatedArtifact)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalCreateArtifactCreateArtifactCreateArtifactPayload struct {
	Artifact CreatedArtifactArtifact `json:"artifact"`
}

func (v *CreateArtifactCreateArtifactCreateArtifactPayload) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *CreateArtifactCreateArtifactCreateArtifactPayload) __premarshalJSON() (*__premarshalCreateArtifactCreateArtifactCreateArtifactPayload, error) {
	var retval __premarshalCreateArtifactCreateArtifactCreateArtifactPayload

	retval.Artifact = v.CreatedArtifact.Artifact
	return &retval, nil
}

type CreateArtifactFileSpecInput struct {
	ArtifactID         string             `json:"artifactID"`
	Name               string             `json:"name"`
	Md5                string             `json:"md5"`
	Mimetype           *string            `json:"mimetype"`
	ArtifactManifestID *string            `json:"artifactManifestID"`
	UploadPartsInput   []UploadPartsInput `json:"uploadPartsInput"`
}

// GetArtifactID returns CreateArtifactFileSpecInput.ArtifactID, and is useful for accessing the field via an interface.
func (v *CreateArtifactFileSpecInput) GetArtifactID() string { return v.ArtifactID }

// GetName returns CreateArtifactFileSpecInput.Name, and is useful for accessing the field via an interface.
func (v *CreateArtifactFileSpecInput) GetName() string { return v.Name }

// GetMd5 returns CreateArtifactFileSpecInput.Md5, and is useful for accessing the field via an interface.
func (v *CreateArtifactFileSpecInput) GetMd5() string { return v.Md5 }

// GetMimetype returns CreateArtifactFileSpecInput.Mimetype, and is useful for accessing the field via an interface.
func (v *CreateArtifactFileSpecInput) GetMimetype() *string { return v.Mimetype }

// GetArtifactManifestID returns CreateArtifactFileSpecInput.ArtifactManifestID, and is useful for accessing the field via an interface.
func (v *CreateArtifactFileSpecInput) GetArtifactManifestID() *string { return v.ArtifactManifestID }

// GetUploadPartsInput returns CreateArtifactFileSpecInput.UploadPartsInput, and is useful for accessing the field via an interface.
func (v *CreateArtifactFileSpecInput) GetUploadPartsInput() []UploadPartsInput {
	return v.UploadPartsInput
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayload includes the requested fields of the GraphQL type CreateArtifactFilesPayload.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayload struct {
	Files CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnection `json:"files"`
}

// GetFiles returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayload.Files, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayload) GetFiles() CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnection {
	return v.Files
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnection includes the requested fields of the GraphQL type FileConnection.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnection struct {
	Edges []CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdge `json:"edges"`
}

// GetEdges returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnection.Edges, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnection) GetEdges() []CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdge {
	return v.Edges
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdge includes the requested fields of the GraphQL type FileEdge.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdge struct {
	Node *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile `json:"node"`
}

// GetNode returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdge.Node, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdge) GetNode() *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile {
	return v.Node
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile includes the requested fields of the GraphQL type File.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile struct {
	StoragePath         *string                                                                                                                      `json:"storagePath"`
	UploadUrl           *string                                                                                                                      `json:"uploadUrl"`
	UploadHeaders       []string                                                                                                                     `json:"uploadHeaders"`
	UploadMultipartUrls *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls `json:"uploadMultipartUrls"`
	Artifact            *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileArtifact            `json:"artifact"`
}

// GetStoragePath returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile.StoragePath, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile) GetStoragePath() *string {
	return v.StoragePath
}

// GetUploadUrl returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile.UploadUrl, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile) GetUploadUrl() *string {
	return v.UploadUrl
}

// GetUploadHeaders returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile.UploadHeaders, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile) GetUploadHeaders() []string {
	return v.UploadHeaders
}

// GetUploadMultipartUrls returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile.UploadMultipartUrls, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile) GetUploadMultipartUrls() *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls {
	return v.UploadMultipartUrls
}

// GetArtifact returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile.Artifact, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFile) GetArtifact() *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileArtifact {
	return v.Artifact
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileArtifact includes the requested fields of the GraphQL type Artifact.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileArtifact struct {
	Id string `json:"id"`
}

// GetId returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileArtifact.Id, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileArtifact) GetId() string {
	return v.Id
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls includes the requested fields of the GraphQL type UploadMultipartUrls.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls struct {
	UploadID       string                                                                                                                                                   `json:"uploadID"`
	UploadUrlParts []CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart `json:"uploadUrlParts"`
}

// GetUploadID returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls.UploadID, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls) GetUploadID() string {
	return v.UploadID
}

// GetUploadUrlParts returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls.UploadUrlParts, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrls) GetUploadUrlParts() []CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart {
	return v.UploadUrlParts
}

// CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart includes the requested fields of the GraphQL type UploadUrlPart.
type CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart struct {
	PartNumber int64  `json:"partNumber"`
	UploadUrl  string `json:"uploadUrl"`
}

// GetPartNumber returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart.PartNumber, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart) GetPartNumber() int64 {
	return v.PartNumber
}

// GetUploadUrl returns CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart.UploadUrl, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayloadFilesFileConnectionEdgesFileEdgeNodeFileUploadMultipartUrlsUploadUrlPartsUploadUrlPart) GetUploadUrl() string {
	return v.UploadUrl
}

// CreateArtifactFilesResponse is returned by CreateArtifactFiles on success.
type CreateArtifactFilesResponse struct {
	CreateArtifactFiles *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayload `json:"createArtifactFiles"`
}

// GetCreateArtifactFiles returns CreateArtifactFilesResponse.CreateArtifactFiles, and is useful for accessing the field via an interface.
func (v *CreateArtifactFilesResponse) GetCreateArtifactFiles() *CreateArtifactFilesCreateArtifactFilesCreateArtifactFilesPayload {
	return v.CreateArtifactFiles
}

type CreateArtifactInput struct {
	EntityName                string                  `json:"entityName"`
	ProjectName               string                  `json:"projectName"`
	ArtifactTypeName          string                  `json:"artifactTypeName"`
	ArtifactCollectionName    string                  `json:"artifactCollectionName"`
	ArtifactCollectionNames   []string                `json:"artifactCollectionNames"`
	RunName                   *string                 `json:"runName"`
	Digest                    string                  `json:"digest"`
	DigestAlgorithm           ArtifactDigestAlgorithm `json:"digestAlgorithm"`
	Description               *string                 `json:"description"`
	Labels                    *string                 `json:"labels"`
	Aliases                   []ArtifactAliasInput    `json:"aliases"`
	Tags                      []TagInput              `json:"tags,omitempty"`
	Metadata                  *string                 `json:"metadata"`
	TtlDurationSeconds        *int64                  `json:"ttlDurationSeconds"`
	HistoryStep               *int64                  `json:"historyStep"`
	EnableDigestDeduplication bool                    `json:"enableDigestDeduplication"`
	DistributedID             *string                 `json:"distributedID"`
	ClientID                  string                  `json:"clientID"`
	SequenceClientID          string                  `json:"sequenceClientID"`
	StorageRegion             *string                 `json:"storageRegion"`
	ClientMutationId          *string                 `json:"clientMutationId"`
}

// GetEntityName returns CreateArtifactInput.EntityName, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetEntityName() string { return v.EntityName }

// GetProjectName returns CreateArtifactInput.ProjectName, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetProjectName() string { return v.ProjectName }

// GetArtifactTypeName returns CreateArtifactInput.ArtifactTypeName, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetArtifactTypeName() string { return v.ArtifactTypeName }

// GetArtifactCollectionName returns CreateArtifactInput.ArtifactCollectionName, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetArtifactCollectionName() string { return v.ArtifactCollectionName }

// GetArtifactCollectionNames returns CreateArtifactInput.ArtifactCollectionNames, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetArtifactCollectionNames() []string { return v.ArtifactCollectionNames }

// GetRunName returns CreateArtifactInput.RunName, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetRunName() *string { return v.RunName }

// GetDigest returns CreateArtifactInput.Digest, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetDigest() string { return v.Digest }

// GetDigestAlgorithm returns CreateArtifactInput.DigestAlgorithm, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetDigestAlgorithm() ArtifactDigestAlgorithm { return v.DigestAlgorithm }

// GetDescription returns CreateArtifactInput.Description, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetDescription() *string { return v.Description }

// GetLabels returns CreateArtifactInput.Labels, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetLabels() *string { return v.Labels }

// GetAliases returns CreateArtifactInput.Aliases, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetAliases() []ArtifactAliasInput { return v.Aliases }

// GetTags returns CreateArtifactInput.Tags, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetTags() []TagInput { return v.Tags }

// GetMetadata returns CreateArtifactInput.Metadata, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetMetadata() *string { return v.Metadata }

// GetTtlDurationSeconds returns CreateArtifactInput.TtlDurationSeconds, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetTtlDurationSeconds() *int64 { return v.TtlDurationSeconds }

// GetHistoryStep returns CreateArtifactInput.HistoryStep, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetHistoryStep() *int64 { return v.HistoryStep }

// GetEnableDigestDeduplication returns CreateArtifactInput.EnableDigestDeduplication, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetEnableDigestDeduplication() bool { return v.EnableDigestDeduplication }

// GetDistributedID returns CreateArtifactInput.DistributedID, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetDistributedID() *string { return v.DistributedID }

// GetClientID returns CreateArtifactInput.ClientID, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetClientID() string { return v.ClientID }

// GetSequenceClientID returns CreateArtifactInput.SequenceClientID, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetSequenceClientID() string { return v.SequenceClientID }

// GetStorageRegion returns CreateArtifactInput.StorageRegion, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetStorageRegion() *string { return v.StorageRegion }

// GetClientMutationId returns CreateArtifactInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *CreateArtifactInput) GetClientMutationId() *string { return v.ClientMutationId }

// CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayload includes the requested fields of the GraphQL type CreateArtifactManifestPayload.
type CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayload struct {
	ArtifactManifest CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest `json:"artifactManifest"`
}

// GetArtifactManifest returns CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayload.ArtifactManifest, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayload) GetArtifactManifest() CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest {
	return v.ArtifactManifest
}

// CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest includes the requested fields of the GraphQL type ArtifactManifest.
type CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest struct {
	Id   string                                                                                        `json:"id"`
	File CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile `json:"file"`
}

// GetId returns CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest.Id, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest) GetId() string {
	return v.Id
}

// GetFile returns CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest.File, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifest) GetFile() CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile {
	return v.File
}

// CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile includes the requested fields of the GraphQL type File.
type CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile struct {
	Id            string   `json:"id"`
	UploadUrl     *string  `json:"uploadUrl"`
	UploadHeaders []string `json:"uploadHeaders"`
}

// GetId returns CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile.Id, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile) GetId() string {
	return v.Id
}

// GetUploadUrl returns CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile.UploadUrl, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile) GetUploadUrl() *string {
	return v.UploadUrl
}

// GetUploadHeaders returns CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile.UploadHeaders, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayloadArtifactManifestFile) GetUploadHeaders() []string {
	return v.UploadHeaders
}

// CreateArtifactManifestResponse is returned by CreateArtifactManifest on success.
type CreateArtifactManifestResponse struct {
	CreateArtifactManifest *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayload `json:"createArtifactManifest"`
}

// GetCreateArtifactManifest returns CreateArtifactManifestResponse.CreateArtifactManifest, and is useful for accessing the field via an interface.
func (v *CreateArtifactManifestResponse) GetCreateArtifactManifest() *CreateArtifactManifestCreateArtifactManifestCreateArtifactManifestPayload {
	return v.CreateArtifactManifest
}

// CreateArtifactResponse is returned by CreateArtifact on success.
type CreateArtifactResponse struct {
	CreateArtifact *CreateArtifactCreateArtifactCreateArtifactPayload `json:"createArtifact"`
}

// GetCreateArtifact returns CreateArtifactResponse.CreateArtifact, and is useful for accessing the field via an interface.
func (v *CreateArtifactResponse) GetCreateArtifact() *CreateArtifactCreateArtifactCreateArtifactPayload {
	return v.CreateArtifact
}

// CreateRunFilesCreateRunFilesCreateRunFilesPayload includes the requested fields of the GraphQL type CreateRunFilesPayload.
type CreateRunFilesCreateRunFilesCreateRunFilesPayload struct {
	RunID         string                                                       `json:"runID"`
	UploadHeaders []string                                                     `json:"uploadHeaders"`
	Files         []CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile `json:"files"`
}

// GetRunID returns CreateRunFilesCreateRunFilesCreateRunFilesPayload.RunID, and is useful for accessing the field via an interface.
func (v *CreateRunFilesCreateRunFilesCreateRunFilesPayload) GetRunID() string { return v.RunID }

// GetUploadHeaders returns CreateRunFilesCreateRunFilesCreateRunFilesPayload.UploadHeaders, and is useful for accessing the field via an interface.
func (v *CreateRunFilesCreateRunFilesCreateRunFilesPayload) GetUploadHeaders() []string {
	return v.UploadHeaders
}

// GetFiles returns CreateRunFilesCreateRunFilesCreateRunFilesPayload.Files, and is useful for accessing the field via an interface.
func (v *CreateRunFilesCreateRunFilesCreateRunFilesPayload) GetFiles() []CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile {
	return v.Files
}

// CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile includes the requested fields of the GraphQL type File.
type CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile struct {
	Name      string  `json:"name"`
	UploadUrl *string `json:"uploadUrl"`
}

// GetName returns CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile.Name, and is useful for accessing the field via an interface.
func (v *CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile) GetName() string { return v.Name }

// GetUploadUrl returns CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile.UploadUrl, and is useful for accessing the field via an interface.
func (v *CreateRunFilesCreateRunFilesCreateRunFilesPayloadFilesFile) GetUploadUrl() *string {
	return v.UploadUrl
}

// CreateRunFilesResponse is returned by CreateRunFiles on success.
type CreateRunFilesResponse struct {
	CreateRunFiles *CreateRunFilesCreateRunFilesCreateRunFilesPayload `json:"createRunFiles"`
}

// GetCreateRunFiles returns CreateRunFilesResponse.CreateRunFiles, and is useful for accessing the field via an interface.
func (v *CreateRunFilesResponse) GetCreateRunFiles() *CreateRunFilesCreateRunFilesCreateRunFilesPayload {
	return v.CreateRunFiles
}

// CreatedArtifact includes the GraphQL fields of CreateArtifactPayload requested by the fragment CreatedArtifact.
type CreatedArtifact struct {
	Artifact CreatedArtifactArtifact `json:"artifact"`
}

// GetArtifact returns CreatedArtifact.Artifact, and is useful for accessing the field via an interface.
func (v *CreatedArtifact) GetArtifact() CreatedArtifactArtifact { return v.Artifact }

// CreatedArtifactArtifact includes the requested fields of the GraphQL type Artifact.
type CreatedArtifactArtifact struct {
	Id               string                                  `json:"id"`
	State            ArtifactState                           `json:"state"`
	ArtifactSequence CreatedArtifactArtifactArtifactSequence `json:"artifactSequence"`
}

// GetId returns CreatedArtifactArtifact.Id, and is useful for accessing the field via an interface.
func (v *CreatedArtifactArtifact) GetId() string { return v.Id }

// GetState returns CreatedArtifactArtifact.State, and is useful for accessing the field via an interface.
func (v *CreatedArtifactArtifact) GetState() ArtifactState { return v.State }

// GetArtifactSequence returns CreatedArtifactArtifact.ArtifactSequence, and is useful for accessing the field via an interface.
func (v *CreatedArtifactArtifact) GetArtifactSequence() CreatedArtifactArtifactArtifactSequence {
	return v.ArtifactSequence
}

// CreatedArtifactArtifactArtifactSequence includes the requested fields of the GraphQL type ArtifactSequence.
type CreatedArtifactArtifactArtifactSequence struct {
	LatestArtifact *CreatedArtifactArtifactArtifactSequenceLatestArtifact `json:"latestArtifact"`
}

// GetLatestArtifact returns CreatedArtifactArtifactArtifactSequence.LatestArtifact, and is useful for accessing the field via an interface.
func (v *CreatedArtifactArtifactArtifactSequence) GetLatestArtifact() *CreatedArtifactArtifactArtifactSequenceLatestArtifact {
	return v.LatestArtifact
}

// CreatedArtifactArtifactArtifactSequenceLatestArtifact includes the requested fields of the GraphQL type Artifact.
type CreatedArtifactArtifactArtifactSequenceLatestArtifact struct {
	Id string `json:"id"`
}

// GetId returns CreatedArtifactArtifactArtifactSequenceLatestArtifact.Id, and is useful for accessing the field via an interface.
func (v *CreatedArtifactArtifactArtifactSequenceLatestArtifact) GetId() string { return v.Id }

// FetchOrgEntityFromEntityEntity includes the requested fields of the GraphQL type Entity.
type FetchOrgEntityFromEntityEntity struct {
	Organization *FetchOrgEntityFromEntityEntityOrganization `json:"organization"`
}

// GetOrganization returns FetchOrgEntityFromEntityEntity.Organization, and is useful for accessing the field via an interface.
func (v *FetchOrgEntityFromEntityEntity) GetOrganization() *FetchOrgEntityFromEntityEntityOrganization {
	return v.Organization
}

// FetchOrgEntityFromEntityEntityOrganization includes the requested fields of the GraphQL type Organization.
type FetchOrgEntityFromEntityEntityOrganization struct {
	Name      string                                               `json:"name"`
	OrgEntity *FetchOrgEntityFromEntityEntityOrganizationOrgEntity `json:"orgEntity"`
}

// GetName returns FetchOrgEntityFromEntityEntityOrganization.Name, and is useful for accessing the field via an interface.
func (v *FetchOrgEntityFromEntityEntityOrganization) GetName() string { return v.Name }

// GetOrgEntity returns FetchOrgEntityFromEntityEntityOrganization.OrgEntity, and is useful for accessing the field via an interface.
func (v *FetchOrgEntityFromEntityEntityOrganization) GetOrgEntity() *FetchOrgEntityFromEntityEntityOrganizationOrgEntity {
	return v.OrgEntity
}

// FetchOrgEntityFromEntityEntityOrganizationOrgEntity includes the requested fields of the GraphQL type Entity.
type FetchOrgEntityFromEntityEntityOrganizationOrgEntity struct {
	Name string `json:"name"`
}

// GetName returns FetchOrgEntityFromEntityEntityOrganizationOrgEntity.Name, and is useful for accessing the field via an interface.
func (v *FetchOrgEntityFromEntityEntityOrganizationOrgEntity) GetName() string { return v.Name }

// FetchOrgEntityFromEntityResponse is returned by FetchOrgEntityFromEntity on success.
type FetchOrgEntityFromEntityResponse struct {
	Entity *FetchOrgEntityFromEntityEntity `json:"entity"`
}

// GetEntity returns FetchOrgEntityFromEntityResponse.Entity, and is useful for accessing the field via an interface.
func (v *FetchOrgEntityFromEntityResponse) GetEntity() *FetchOrgEntityFromEntityEntity {
	return v.Entity
}

// InputFieldsResponse is returned by InputFields on success.
type InputFieldsResponse struct {
	TypeInfo *InputFieldsTypeInfoType `json:"TypeInfo"`
}

// GetTypeInfo returns InputFieldsResponse.TypeInfo, and is useful for accessing the field via an interface.
func (v *InputFieldsResponse) GetTypeInfo() *InputFieldsTypeInfoType { return v.TypeInfo }

// InputFieldsTypeInfoType includes the requested fields of the GraphQL type __Type.
// The GraphQL type's documentation follows.
//
// The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.
//
// Depending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByURL`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.
type InputFieldsTypeInfoType struct {
	InputFields []InputFieldsTypeInfoTypeInputFieldsInputValue `json:"inputFields"`
}

// GetInputFields returns InputFieldsTypeInfoType.InputFields, and is useful for accessing the field via an interface.
func (v *InputFieldsTypeInfoType) GetInputFields() []InputFieldsTypeInfoTypeInputFieldsInputValue {
	return v.InputFields
}

// InputFieldsTypeInfoTypeInputFieldsInputValue includes the requested fields of the GraphQL type __InputValue.
// The GraphQL type's documentation follows.
//
// Arguments provided to Fields or Directives and the input fields of an InputObject are represented as Input Values which describe their type and optionally a default value.
type InputFieldsTypeInfoTypeInputFieldsInputValue struct {
	Name string `json:"name"`
}

// GetName returns InputFieldsTypeInfoTypeInputFieldsInputValue.Name, and is useful for accessing the field via an interface.
func (v *InputFieldsTypeInfoTypeInputFieldsInputValue) GetName() string { return v.Name }

// LinkArtifactLinkArtifactLinkArtifactPayload includes the requested fields of the GraphQL type LinkArtifactPayload.
type LinkArtifactLinkArtifactLinkArtifactPayload struct {
	VersionIndex *int `json:"versionIndex"`
}

// GetVersionIndex returns LinkArtifactLinkArtifactLinkArtifactPayload.VersionIndex, and is useful for accessing the field via an interface.
func (v *LinkArtifactLinkArtifactLinkArtifactPayload) GetVersionIndex() *int { return v.VersionIndex }

// LinkArtifactResponse is returned by LinkArtifact on success.
type LinkArtifactResponse struct {
	LinkArtifact *LinkArtifactLinkArtifactLinkArtifactPayload `json:"linkArtifact"`
}

// GetLinkArtifact returns LinkArtifactResponse.LinkArtifact, and is useful for accessing the field via an interface.
func (v *LinkArtifactResponse) GetLinkArtifact() *LinkArtifactLinkArtifactLinkArtifactPayload {
	return v.LinkArtifact
}

// NotifyScriptableRunAlertNotifyScriptableRunAlertNotifyScriptableRunAlertPayload includes the requested fields of the GraphQL type NotifyScriptableRunAlertPayload.
type NotifyScriptableRunAlertNotifyScriptableRunAlertNotifyScriptableRunAlertPayload struct {
	Success bool `json:"success"`
}

// GetSuccess returns NotifyScriptableRunAlertNotifyScriptableRunAlertNotifyScriptableRunAlertPayload.Success, and is useful for accessing the field via an interface.
func (v *NotifyScriptableRunAlertNotifyScriptableRunAlertNotifyScriptableRunAlertPayload) GetSuccess() bool {
	return v.Success
}

// NotifyScriptableRunAlertResponse is returned by NotifyScriptableRunAlert on success.
type NotifyScriptableRunAlertResponse struct {
	NotifyScriptableRunAlert *NotifyScriptableRunAlertNotifyScriptableRunAlertNotifyScriptableRunAlertPayload `json:"notifyScriptableRunAlert"`
}

// GetNotifyScriptableRunAlert returns NotifyScriptableRunAlertResponse.NotifyScriptableRunAlert, and is useful for accessing the field via an interface.
func (v *NotifyScriptableRunAlertResponse) GetNotifyScriptableRunAlert() *NotifyScriptableRunAlertNotifyScriptableRunAlertNotifyScriptableRunAlertPayload {
	return v.NotifyScriptableRunAlert
}

// OrganizationCoreWeaveOrganizationIDEntity includes the requested fields of the GraphQL type Entity.
type OrganizationCoreWeaveOrganizationIDEntity struct {
	Organization *OrganizationCoreWeaveOrganizationIDEntityOrganization `json:"organization"`
}

// GetOrganization returns OrganizationCoreWeaveOrganizationIDEntity.Organization, and is useful for accessing the field via an interface.
func (v *OrganizationCoreWeaveOrganizationIDEntity) GetOrganization() *OrganizationCoreWeaveOrganizationIDEntityOrganization {
	return v.Organization
}

// OrganizationCoreWeaveOrganizationIDEntityOrganization includes the requested fields of the GraphQL type Organization.
type OrganizationCoreWeaveOrganizationIDEntityOrganization struct {
	CoreWeaveOrganizationId *string `json:"coreWeaveOrganizationId"`
}

// GetCoreWeaveOrganizationId returns OrganizationCoreWeaveOrganizationIDEntityOrganization.CoreWeaveOrganizationId, and is useful for accessing the field via an interface.
func (v *OrganizationCoreWeaveOrganizationIDEntityOrganization) GetCoreWeaveOrganizationId() *string {
	return v.CoreWeaveOrganizationId
}

// OrganizationCoreWeaveOrganizationIDResponse is returned by OrganizationCoreWeaveOrganizationID on success.
type OrganizationCoreWeaveOrganizationIDResponse struct {
	Entity *OrganizationCoreWeaveOrganizationIDEntity `json:"entity"`
}

// GetEntity returns OrganizationCoreWeaveOrganizationIDResponse.Entity, and is useful for accessing the field via an interface.
func (v *OrganizationCoreWeaveOrganizationIDResponse) GetEntity() *OrganizationCoreWeaveOrganizationIDEntity {
	return v.Entity
}

// RewindRunResponse is returned by RewindRun on success.
type RewindRunResponse struct {
	RewindRun *RewindRunRewindRunRewindRunPayload `json:"rewindRun"`
}

// GetRewindRun returns RewindRunResponse.RewindRun, and is useful for accessing the field via an interface.
func (v *RewindRunResponse) GetRewindRun() *RewindRunRewindRunRewindRunPayload { return v.RewindRun }

// RewindRunRewindRunRewindRunPayload includes the requested fields of the GraphQL type RewindRunPayload.
type RewindRunRewindRunRewindRunPayload struct {
	RewoundRun *RewindRunRewindRunRewindRunPayloadRewoundRun `json:"rewoundRun"`
}

// GetRewoundRun returns RewindRunRewindRunRewindRunPayload.RewoundRun, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayload) GetRewoundRun() *RewindRunRewindRunRewindRunPayloadRewoundRun {
	return v.RewoundRun
}

// RewindRunRewindRunRewindRunPayloadRewoundRun includes the requested fields of the GraphQL type Run.
type RewindRunRewindRunRewindRunPayloadRewoundRun struct {
	Id               string                                               `json:"id"`
	Name             string                                               `json:"name"`
	DisplayName      *string                                              `json:"displayName"`
	Description      *string                                              `json:"description"`
	Config           *string                                              `json:"config"`
	SweepName        *string                                              `json:"sweepName"`
	Project          *RewindRunRewindRunRewindRunPayloadRewoundRunProject `json:"project"`
	HistoryLineCount *int                                                 `json:"historyLineCount"`
}

// GetId returns RewindRunRewindRunRewindRunPayloadRewoundRun.Id, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetId() string { return v.Id }

// GetName returns RewindRunRewindRunRewindRunPayloadRewoundRun.Name, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetName() string { return v.Name }

// GetDisplayName returns RewindRunRewindRunRewindRunPayloadRewoundRun.DisplayName, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetDisplayName() *string { return v.DisplayName }

// GetDescription returns RewindRunRewindRunRewindRunPayloadRewoundRun.Description, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetDescription() *string { return v.Description }

// GetConfig returns RewindRunRewindRunRewindRunPayloadRewoundRun.Config, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetConfig() *string { return v.Config }

// GetSweepName returns RewindRunRewindRunRewindRunPayloadRewoundRun.SweepName, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetSweepName() *string { return v.SweepName }

// GetProject returns RewindRunRewindRunRewindRunPayloadRewoundRun.Project, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetProject() *RewindRunRewindRunRewindRunPayloadRewoundRunProject {
	return v.Project
}

// GetHistoryLineCount returns RewindRunRewindRunRewindRunPayloadRewoundRun.HistoryLineCount, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRun) GetHistoryLineCount() *int {
	return v.HistoryLineCount
}

// RewindRunRewindRunRewindRunPayloadRewoundRunProject includes the requested fields of the GraphQL type Project.
type RewindRunRewindRunRewindRunPayloadRewoundRunProject struct {
	Id     string                                                    `json:"id"`
	Name   string                                                    `json:"name"`
	Entity RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity `json:"entity"`
}

// GetId returns RewindRunRewindRunRewindRunPayloadRewoundRunProject.Id, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRunProject) GetId() string { return v.Id }

// GetName returns RewindRunRewindRunRewindRunPayloadRewoundRunProject.Name, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRunProject) GetName() string { return v.Name }

// GetEntity returns RewindRunRewindRunRewindRunPayloadRewoundRunProject.Entity, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRunProject) GetEntity() RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity {
	return v.Entity
}

// RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity includes the requested fields of the GraphQL type Entity.
type RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity.Id, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity) GetId() string { return v.Id }

// GetName returns RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity.Name, and is useful for accessing the field via an interface.
func (v *RewindRunRewindRunRewindRunPayloadRewoundRunProjectEntity) GetName() string { return v.Name }

// RunResumeStatusModelProject includes the requested fields of the GraphQL type Project.
type RunResumeStatusModelProject struct {
	Id     string                                `json:"id"`
	Name   string                                `json:"name"`
	Entity RunResumeStatusModelProjectEntity     `json:"entity"`
	Bucket *RunResumeStatusModelProjectBucketRun `json:"bucket"`
}

// GetId returns RunResumeStatusModelProject.Id, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProject) GetId() string { return v.Id }

// GetName returns RunResumeStatusModelProject.Name, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProject) GetName() string { return v.Name }

// GetEntity returns RunResumeStatusModelProject.Entity, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProject) GetEntity() RunResumeStatusModelProjectEntity { return v.Entity }

// GetBucket returns RunResumeStatusModelProject.Bucket, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProject) GetBucket() *RunResumeStatusModelProjectBucketRun {
	return v.Bucket
}

// RunResumeStatusModelProjectBucketRun includes the requested fields of the GraphQL type Run.
type RunResumeStatusModelProjectBucketRun struct {
	Id               string   `json:"id"`
	Name             string   `json:"name"`
	SummaryMetrics   *string  `json:"summaryMetrics"`
	DisplayName      *string  `json:"displayName"`
	LogLineCount     *int     `json:"logLineCount"`
	HistoryLineCount *int     `json:"historyLineCount"`
	EventsLineCount  *int     `json:"eventsLineCount"`
	HistoryTail      *string  `json:"historyTail"`
	EventsTail       *string  `json:"eventsTail"`
	Config           *string  `json:"config"`
	Tags             []string `json:"tags"`
	Notes            *string  `json:"notes"`
	WandbConfig      *string  `json:"wandbConfig"`
}

// GetId returns RunResumeStatusModelProjectBucketRun.Id, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetId() string { return v.Id }

// GetName returns RunResumeStatusModelProjectBucketRun.Name, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetName() string { return v.Name }

// GetSummaryMetrics returns RunResumeStatusModelProjectBucketRun.SummaryMetrics, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetSummaryMetrics() *string { return v.SummaryMetrics }

// GetDisplayName returns RunResumeStatusModelProjectBucketRun.DisplayName, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetDisplayName() *string { return v.DisplayName }

// GetLogLineCount returns RunResumeStatusModelProjectBucketRun.LogLineCount, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetLogLineCount() *int { return v.LogLineCount }

// GetHistoryLineCount returns RunResumeStatusModelProjectBucketRun.HistoryLineCount, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetHistoryLineCount() *int { return v.HistoryLineCount }

// GetEventsLineCount returns RunResumeStatusModelProjectBucketRun.EventsLineCount, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetEventsLineCount() *int { return v.EventsLineCount }

// GetHistoryTail returns RunResumeStatusModelProjectBucketRun.HistoryTail, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetHistoryTail() *string { return v.HistoryTail }

// GetEventsTail returns RunResumeStatusModelProjectBucketRun.EventsTail, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetEventsTail() *string { return v.EventsTail }

// GetConfig returns RunResumeStatusModelProjectBucketRun.Config, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetConfig() *string { return v.Config }

// GetTags returns RunResumeStatusModelProjectBucketRun.Tags, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetTags() []string { return v.Tags }

// GetNotes returns RunResumeStatusModelProjectBucketRun.Notes, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetNotes() *string { return v.Notes }

// GetWandbConfig returns RunResumeStatusModelProjectBucketRun.WandbConfig, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectBucketRun) GetWandbConfig() *string { return v.WandbConfig }

// RunResumeStatusModelProjectEntity includes the requested fields of the GraphQL type Entity.
type RunResumeStatusModelProjectEntity struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns RunResumeStatusModelProjectEntity.Id, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectEntity) GetId() string { return v.Id }

// GetName returns RunResumeStatusModelProjectEntity.Name, and is useful for accessing the field via an interface.
func (v *RunResumeStatusModelProjectEntity) GetName() string { return v.Name }

// RunResumeStatusResponse is returned by RunResumeStatus on success.
type RunResumeStatusResponse struct {
	Model *RunResumeStatusModelProject `json:"model"`
}

// GetModel returns RunResumeStatusResponse.Model, and is useful for accessing the field via an interface.
func (v *RunResumeStatusResponse) GetModel() *RunResumeStatusModelProject { return v.Model }

// RunStoppedStatusProject includes the requested fields of the GraphQL type Project.
type RunStoppedStatusProject struct {
	Run *RunStoppedStatusProjectRun `json:"run"`
}

// GetRun returns RunStoppedStatusProject.Run, and is useful for accessing the field via an interface.
func (v *RunStoppedStatusProject) GetRun() *RunStoppedStatusProjectRun { return v.Run }

// RunStoppedStatusProjectRun includes the requested fields of the GraphQL type Run.
type RunStoppedStatusProjectRun struct {
	Stopped *bool `json:"stopped"`
}

// GetStopped returns RunStoppedStatusProjectRun.Stopped, and is useful for accessing the field via an interface.
func (v *RunStoppedStatusProjectRun) GetStopped() *bool { return v.Stopped }

// RunStoppedStatusResponse is returned by RunStoppedStatus on success.
type RunStoppedStatusResponse struct {
	Project *RunStoppedStatusProject `json:"project"`
}

// GetProject returns RunStoppedStatusResponse.Project, and is useful for accessing the field via an interface.
func (v *RunStoppedStatusResponse) GetProject() *RunStoppedStatusProject { return v.Project }

// ServerFeaturesQueryResponse is returned by ServerFeaturesQuery on success.
type ServerFeaturesQueryResponse struct {
	ServerInfo *ServerFeaturesQueryServerInfo `json:"serverInfo"`
}

// GetServerInfo returns ServerFeaturesQueryResponse.ServerInfo, and is useful for accessing the field via an interface.
func (v *ServerFeaturesQueryResponse) GetServerInfo() *ServerFeaturesQueryServerInfo {
	return v.ServerInfo
}

// ServerFeaturesQueryServerInfo includes the requested fields of the GraphQL type ServerInfo.
type ServerFeaturesQueryServerInfo struct {
	Features []*ServerFeaturesQueryServerInfoFeaturesServerFeature `json:"features"`
}

// GetFeatures returns ServerFeaturesQueryServerInfo.Features, and is useful for accessing the field via an interface.
func (v *ServerFeaturesQueryServerInfo) GetFeatures() []*ServerFeaturesQueryServerInfoFeaturesServerFeature {
	return v.Features
}

// ServerFeaturesQueryServerInfoFeaturesServerFeature includes the requested fields of the GraphQL type ServerFeature.
type ServerFeaturesQueryServerInfoFeaturesServerFeature struct {
	Name      string `json:"name"`
	IsEnabled bool   `json:"isEnabled"`
}

// GetName returns ServerFeaturesQueryServerInfoFeaturesServerFeature.Name, and is useful for accessing the field via an interface.
func (v *ServerFeaturesQueryServerInfoFeaturesServerFeature) GetName() string { return v.Name }

// GetIsEnabled returns ServerFeaturesQueryServerInfoFeaturesServerFeature.IsEnabled, and is useful for accessing the field via an interface.
func (v *ServerFeaturesQueryServerInfoFeaturesServerFeature) GetIsEnabled() bool { return v.IsEnabled }

// ServerInfoResponse is returned by ServerInfo on success.
type ServerInfoResponse struct {
	ServerInfo *ServerInfoServerInfo `json:"serverInfo"`
}

// GetServerInfo returns ServerInfoResponse.ServerInfo, and is useful for accessing the field via an interface.
func (v *ServerInfoResponse) GetServerInfo() *ServerInfoServerInfo { return v.ServerInfo }

// ServerInfoServerInfo includes the requested fields of the GraphQL type ServerInfo.
type ServerInfoServerInfo struct {
	CliVersionInfo         interface{}                                 `json:"cliVersionInfo"`
	LatestLocalVersionInfo *ServerInfoServerInfoLatestLocalVersionInfo `json:"latestLocalVersionInfo"`
}

// GetCliVersionInfo returns ServerInfoServerInfo.CliVersionInfo, and is useful for accessing the field via an interface.
func (v *ServerInfoServerInfo) GetCliVersionInfo() interface{} { return v.CliVersionInfo }

// GetLatestLocalVersionInfo returns ServerInfoServerInfo.LatestLocalVersionInfo, and is useful for accessing the field via an interface.
func (v *ServerInfoServerInfo) GetLatestLocalVersionInfo() *ServerInfoServerInfoLatestLocalVersionInfo {
	return v.LatestLocalVersionInfo
}

// ServerInfoServerInfoLatestLocalVersionInfo includes the requested fields of the GraphQL type LocalVersionInfo.
type ServerInfoServerInfoLatestLocalVersionInfo struct {
	OutOfDate                   bool   `json:"outOfDate"`
	LatestVersionString         string `json:"latestVersionString"`
	VersionOnThisInstanceString string `json:"versionOnThisInstanceString"`
}

// GetOutOfDate returns ServerInfoServerInfoLatestLocalVersionInfo.OutOfDate, and is useful for accessing the field via an interface.
func (v *ServerInfoServerInfoLatestLocalVersionInfo) GetOutOfDate() bool { return v.OutOfDate }

// GetLatestVersionString returns ServerInfoServerInfoLatestLocalVersionInfo.LatestVersionString, and is useful for accessing the field via an interface.
func (v *ServerInfoServerInfoLatestLocalVersionInfo) GetLatestVersionString() string {
	return v.LatestVersionString
}

// GetVersionOnThisInstanceString returns ServerInfoServerInfoLatestLocalVersionInfo.VersionOnThisInstanceString, and is useful for accessing the field via an interface.
func (v *ServerInfoServerInfoLatestLocalVersionInfo) GetVersionOnThisInstanceString() string {
	return v.VersionOnThisInstanceString
}

type TagInput struct {
	TagCategoryName *string `json:"tagCategoryName"`
	TagName         string  `json:"tagName"`
	Attributes      *string `json:"attributes"`
}

// GetTagCategoryName returns TagInput.TagCategoryName, and is useful for accessing the field via an interface.
func (v *TagInput) GetTagCategoryName() *string { return v.TagCategoryName }

// GetTagName returns TagInput.TagName, and is useful for accessing the field via an interface.
func (v *TagInput) GetTagName() string { return v.TagName }

// GetAttributes returns TagInput.Attributes, and is useful for accessing the field via an interface.
func (v *TagInput) GetAttributes() *string { return v.Attributes }

// TypeFieldsResponse is returned by TypeFields on success.
type TypeFieldsResponse struct {
	TypeInfo *TypeFieldsTypeInfoType `json:"TypeInfo"`
}

// GetTypeInfo returns TypeFieldsResponse.TypeInfo, and is useful for accessing the field via an interface.
func (v *TypeFieldsResponse) GetTypeInfo() *TypeFieldsTypeInfoType { return v.TypeInfo }

// TypeFieldsTypeInfoType includes the requested fields of the GraphQL type __Type.
// The GraphQL type's documentation follows.
//
// The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.
//
// Depending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByURL`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.
type TypeFieldsTypeInfoType struct {
	Fields []TypeFieldsTypeInfoTypeFieldsField `json:"fields"`
}

// GetFields returns TypeFieldsTypeInfoType.Fields, and is useful for accessing the field via an interface.
func (v *TypeFieldsTypeInfoType) GetFields() []TypeFieldsTypeInfoTypeFieldsField { return v.Fields }

// TypeFieldsTypeInfoTypeFieldsField includes the requested fields of the GraphQL type __Field.
// The GraphQL type's documentation follows.
//
// Object and Interface types are described by a list of Fields, each of which has a name, potentially a list of arguments, and a return type.
type TypeFieldsTypeInfoTypeFieldsField struct {
	Name string `json:"name"`
}

// GetName returns TypeFieldsTypeInfoTypeFieldsField.Name, and is useful for accessing the field via an interface.
func (v *TypeFieldsTypeInfoTypeFieldsField) GetName() string { return v.Name }

// UpdateArtifactManifestResponse is returned by UpdateArtifactManifest on success.
type UpdateArtifactManifestResponse struct {
	UpdateArtifactManifest *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayload `json:"updateArtifactManifest"`
}

// GetUpdateArtifactManifest returns UpdateArtifactManifestResponse.UpdateArtifactManifest, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestResponse) GetUpdateArtifactManifest() *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayload {
	return v.UpdateArtifactManifest
}

// UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayload includes the requested fields of the GraphQL type UpdateArtifactManifestPayload.
type UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayload struct {
	ArtifactManifest UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest `json:"artifactManifest"`
}

// GetArtifactManifest returns UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayload.ArtifactManifest, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayload) GetArtifactManifest() UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest {
	return v.ArtifactManifest
}

// UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest includes the requested fields of the GraphQL type ArtifactManifest.
type UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest struct {
	Id   string                                                                                        `json:"id"`
	File UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile `json:"file"`
}

// GetId returns UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest.Id, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest) GetId() string {
	return v.Id
}

// GetFile returns UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest.File, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifest) GetFile() UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile {
	return v.File
}

// UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile includes the requested fields of the GraphQL type File.
type UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile struct {
	Id            string   `json:"id"`
	UploadUrl     *string  `json:"uploadUrl"`
	UploadHeaders []string `json:"uploadHeaders"`
}

// GetId returns UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile.Id, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile) GetId() string {
	return v.Id
}

// GetUploadUrl returns UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile.UploadUrl, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile) GetUploadUrl() *string {
	return v.UploadUrl
}

// GetUploadHeaders returns UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile.UploadHeaders, and is useful for accessing the field via an interface.
func (v *UpdateArtifactManifestUpdateArtifactManifestUpdateArtifactManifestPayloadArtifactManifestFile) GetUploadHeaders() []string {
	return v.UploadHeaders
}

// UpdateArtifactResponse is returned by UpdateArtifact on success.
type UpdateArtifactResponse struct {
	UpdateArtifact *UpdateArtifactUpdateArtifactUpdateArtifactPayload `json:"updateArtifact"`
}

// GetUpdateArtifact returns UpdateArtifactResponse.UpdateArtifact, and is useful for accessing the field via an interface.
func (v *UpdateArtifactResponse) GetUpdateArtifact() *UpdateArtifactUpdateArtifactUpdateArtifactPayload {
	return v.UpdateArtifact
}

// UpdateArtifactUpdateArtifactUpdateArtifactPayload includes the requested fields of the GraphQL type UpdateArtifactPayload.
type UpdateArtifactUpdateArtifactUpdateArtifactPayload struct {
	Artifact UpdateArtifactUpdateArtifactUpdateArtifactPayloadArtifact `json:"artifact"`
}

// GetArtifact returns UpdateArtifactUpdateArtifactUpdateArtifactPayload.Artifact, and is useful for accessing the field via an interface.
func (v *UpdateArtifactUpdateArtifactUpdateArtifactPayload) GetArtifact() UpdateArtifactUpdateArtifactUpdateArtifactPayloadArtifact {
	return v.Artifact
}

// UpdateArtifactUpdateArtifactUpdateArtifactPayloadArtifact includes the requested fields of the GraphQL type Artifact.
type UpdateArtifactUpdateArtifactUpdateArtifactPayloadArtifact struct {
	Id string `json:"id"`
}

// GetId returns UpdateArtifactUpdateArtifactUpdateArtifactPayloadArtifact.Id, and is useful for accessing the field via an interface.
func (v *UpdateArtifactUpdateArtifactUpdateArtifactPayloadArtifact) GetId() string { return v.Id }

type UploadPartsInput struct {
	PartNumber int64  `json:"partNumber"`
	HexMD5     string `json:"hexMD5"`
}

// GetPartNumber returns UploadPartsInput.PartNumber, and is useful for accessing the field via an interface.
func (v *UploadPartsInput) GetPartNumber() int64 { return v.PartNumber }

// GetHexMD5 returns UploadPartsInput.HexMD5, and is useful for accessing the field via an interface.
func (v *UploadPartsInput) GetHexMD5() string { return v.HexMD5 }

// UpsertBucketResponse is returned by UpsertBucket on success.
type UpsertBucketResponse struct {
	UpsertBucket *UpsertBucketUpsertBucketUpsertBucketPayload `json:"upsertBucket"`
}

// GetUpsertBucket returns UpsertBucketResponse.UpsertBucket, and is useful for accessing the field via an interface.
func (v *UpsertBucketResponse) GetUpsertBucket() *UpsertBucketUpsertBucketUpsertBucketPayload {
	return v.UpsertBucket
}

// UpsertBucketUpsertBucketUpsertBucketPayload includes the requested fields of the GraphQL type UpsertBucketPayload.
type UpsertBucketUpsertBucketUpsertBucketPayload struct {
	Bucket   *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun `json:"bucket"`
	Inserted *bool                                                 `json:"inserted"`
}

// GetBucket returns UpsertBucketUpsertBucketUpsertBucketPayload.Bucket, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayload) GetBucket() *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun {
	return v.Bucket
}

// GetInserted returns UpsertBucketUpsertBucketUpsertBucketPayload.Inserted, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayload) GetInserted() *bool { return v.Inserted }

// UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun includes the requested fields of the GraphQL type Run.
type UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun struct {
	Id               string                                                       `json:"id"`
	Name             string                                                       `json:"name"`
	DisplayName      *string                                                      `json:"displayName"`
	Description      *string                                                      `json:"description"`
	Config           *string                                                      `json:"config"`
	SweepName        *string                                                      `json:"sweepName"`
	Project          *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject `json:"project"`
	HistoryLineCount *int                                                         `json:"historyLineCount"`
}

// GetId returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.Id, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetId() string { return v.Id }

// GetName returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.Name, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetName() string { return v.Name }

// GetDisplayName returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.DisplayName, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetDisplayName() *string {
	return v.DisplayName
}

// GetDescription returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.Description, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetDescription() *string {
	return v.Description
}

// GetConfig returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.Config, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetConfig() *string { return v.Config }

// GetSweepName returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.SweepName, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetSweepName() *string {
	return v.SweepName
}

// GetProject returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.Project, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetProject() *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject {
	return v.Project
}

// GetHistoryLineCount returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun.HistoryLineCount, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRun) GetHistoryLineCount() *int {
	return v.HistoryLineCount
}

// UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject includes the requested fields of the GraphQL type Project.
type UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject struct {
	Id     string                                                            `json:"id"`
	Name   string                                                            `json:"name"`
	Entity UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity `json:"entity"`
}

// GetId returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject.Id, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject) GetId() string { return v.Id }

// GetName returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject.Name, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject) GetName() string { return v.Name }

// GetEntity returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject.Entity, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProject) GetEntity() UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity {
	return v.Entity
}

// UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity includes the requested fields of the GraphQL type Entity.
type UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity.Id, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity) GetId() string {
	return v.Id
}

// GetName returns UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity.Name, and is useful for accessing the field via an interface.
func (v *UpsertBucketUpsertBucketUpsertBucketPayloadBucketRunProjectEntity) GetName() string {
	return v.Name
}

type UseArtifactInput struct {
	EntityName          string  `json:"entityName"`
	ProjectName         string  `json:"projectName"`
	RunName             string  `json:"runName"`
	ArtifactID          string  `json:"artifactID"`
	ArtifactEntityName  *string `json:"artifactEntityName,omitempty"`
	ArtifactProjectName *string `json:"artifactProjectName,omitempty"`
	UsedAs              *string `json:"usedAs"`
	ClientMutationId    *string `json:"clientMutationId"`
}

// GetEntityName returns UseArtifactInput.EntityName, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetEntityName() string { return v.EntityName }

// GetProjectName returns UseArtifactInput.ProjectName, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetProjectName() string { return v.ProjectName }

// GetRunName returns UseArtifactInput.RunName, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetRunName() string { return v.RunName }

// GetArtifactID returns UseArtifactInput.ArtifactID, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetArtifactID() string { return v.ArtifactID }

// GetArtifactEntityName returns UseArtifactInput.ArtifactEntityName, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetArtifactEntityName() *string { return v.ArtifactEntityName }

// GetArtifactProjectName returns UseArtifactInput.ArtifactProjectName, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetArtifactProjectName() *string { return v.ArtifactProjectName }

// GetUsedAs returns UseArtifactInput.UsedAs, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetUsedAs() *string { return v.UsedAs }

// GetClientMutationId returns UseArtifactInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *UseArtifactInput) GetClientMutationId() *string { return v.ClientMutationId }

// UseArtifactResponse is returned by UseArtifact on success.
type UseArtifactResponse struct {
	UseArtifact *UseArtifactUseArtifactUseArtifactPayload `json:"useArtifact"`
}

// GetUseArtifact returns UseArtifactResponse.UseArtifact, and is useful for accessing the field via an interface.
func (v *UseArtifactResponse) GetUseArtifact() *UseArtifactUseArtifactUseArtifactPayload {
	return v.UseArtifact
}

// UseArtifactUseArtifactUseArtifactPayload includes the requested fields of the GraphQL type UseArtifactPayload.
type UseArtifactUseArtifactUseArtifactPayload struct {
	Artifact UseArtifactUseArtifactUseArtifactPayloadArtifact `json:"artifact"`
}

// GetArtifact returns UseArtifactUseArtifactUseArtifactPayload.Artifact, and is useful for accessing the field via an interface.
func (v *UseArtifactUseArtifactUseArtifactPayload) GetArtifact() UseArtifactUseArtifactUseArtifactPayloadArtifact {
	return v.Artifact
}

// UseArtifactUseArtifactUseArtifactPayloadArtifact includes the requested fields of the GraphQL type Artifact.
type UseArtifactUseArtifactUseArtifactPayloadArtifact struct {
	Id string `json:"id"`
}

// GetId returns UseArtifactUseArtifactUseArtifactPayloadArtifact.Id, and is useful for accessing the field via an interface.
func (v *UseArtifactUseArtifactUseArtifactPayloadArtifact) GetId() string { return v.Id }

// ViewerResponse is returned by Viewer on success.
type ViewerResponse struct {
	Viewer *ViewerViewerUser `json:"viewer"`
}

// GetViewer returns ViewerResponse.Viewer, and is useful for accessing the field via an interface.
func (v *ViewerResponse) GetViewer() *ViewerViewerUser { return v.Viewer }

// ViewerViewerUser includes the requested fields of the GraphQL type User.
type ViewerViewerUser struct {
	Id     string                                 `json:"id"`
	Entity *string                                `json:"entity"`
	Flags  *string                                `json:"flags"`
	Teams  *ViewerViewerUserTeamsEntityConnection `json:"teams"`
}

// GetId returns ViewerViewerUser.Id, and is useful for accessing the field via an interface.
func (v *ViewerViewerUser) GetId() string { return v.Id }

// GetEntity returns ViewerViewerUser.Entity, and is useful for accessing the field via an interface.
func (v *ViewerViewerUser) GetEntity() *string { return v.Entity }

// GetFlags returns ViewerViewerUser.Flags, and is useful for accessing the field via an interface.
func (v *ViewerViewerUser) GetFlags() *string { return v.Flags }

// GetTeams returns ViewerViewerUser.Teams, and is useful for accessing the field via an interface.
func (v *ViewerViewerUser) GetTeams() *ViewerViewerUserTeamsEntityConnection { return v.Teams }

// ViewerViewerUserTeamsEntityConnection includes the requested fields of the GraphQL type EntityConnection.
type ViewerViewerUserTeamsEntityConnection struct {
	Edges []ViewerViewerUserTeamsEntityConnectionEdgesEntityEdge `json:"edges"`
}

// GetEdges returns ViewerViewerUserTeamsEntityConnection.Edges, and is useful for accessing the field via an interface.
func (v *ViewerViewerUserTeamsEntityConnection) GetEdges() []ViewerViewerUserTeamsEntityConnectionEdgesEntityEdge {
	return v.Edges
}

// ViewerViewerUserTeamsEntityConnectionEdgesEntityEdge includes the requested fields of the GraphQL type EntityEdge.
type ViewerViewerUserTeamsEntityConnectionEdgesEntityEdge struct {
	Node *ViewerViewerUserTeamsEntityConnectionEdgesEntityEdgeNodeEntity `json:"node"`
}

// GetNode returns ViewerViewerUserTeamsEntityConnectionEdgesEntityEdge.Node, and is useful for accessing the field via an interface.
func (v *ViewerViewerUserTeamsEntityConnectionEdgesEntityEdge) GetNode() *ViewerViewerUserTeamsEntityConnectionEdgesEntityEdgeNodeEntity {
	return v.Node
}

// ViewerViewerUserTeamsEntityConnectionEdgesEntityEdgeNodeEntity includes the requested fields of the GraphQL type Entity.
type ViewerViewerUserTeamsEntityConnectionEdgesEntityEdgeNodeEntity struct {
	Name string `json:"name"`
}

// GetName returns ViewerViewerUserTeamsEntityConnectionEdgesEntityEdgeNodeEntity.Name, and is useful for accessing the field via an interface.
func (v *ViewerViewerUserTeamsEntityConnectionEdgesEntityEdgeNodeEntity) GetName() string {
	return v.Name
}

// __ArtifactFileURLsByManifestEntriesInput is used internally by genqlient
type __ArtifactFileURLsByManifestEntriesInput struct {
	Id              string                       `json:"id"`
	Entries         []ArtifactManifestEntryInput `json:"entries"`
	StorageLayout   string                       `json:"storageLayout"`
	ManifestVersion string                       `json:"manifestVersion"`
	StorageRegion   *string                      `json:"storageRegion"`
}

// GetId returns __ArtifactFileURLsByManifestEntriesInput.Id, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsByManifestEntriesInput) GetId() string { return v.Id }

// GetEntries returns __ArtifactFileURLsByManifestEntriesInput.Entries, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsByManifestEntriesInput) GetEntries() []ArtifactManifestEntryInput {
	return v.Entries
}

// GetStorageLayout returns __ArtifactFileURLsByManifestEntriesInput.StorageLayout, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsByManifestEntriesInput) GetStorageLayout() string { return v.StorageLayout }

// GetManifestVersion returns __ArtifactFileURLsByManifestEntriesInput.ManifestVersion, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsByManifestEntriesInput) GetManifestVersion() string {
	return v.ManifestVersion
}

// GetStorageRegion returns __ArtifactFileURLsByManifestEntriesInput.StorageRegion, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsByManifestEntriesInput) GetStorageRegion() *string { return v.StorageRegion }

// __ArtifactFileURLsInput is used internally by genqlient
type __ArtifactFileURLsInput struct {
	Id      string  `json:"id"`
	Cursor  *string `json:"cursor"`
	PerPage *int    `json:"perPage"`
}

// GetId returns __ArtifactFileURLsInput.Id, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsInput) GetId() string { return v.Id }

// GetCursor returns __ArtifactFileURLsInput.Cursor, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsInput) GetCursor() *string { return v.Cursor }

// GetPerPage returns __ArtifactFileURLsInput.PerPage, and is useful for accessing the field via an interface.
func (v *__ArtifactFileURLsInput) GetPerPage() *int { return v.PerPage }

// __ArtifactManifestInput is used internally by genqlient
type __ArtifactManifestInput struct {
	Artifact_id string `json:"artifact_id"`
}

// GetArtifact_id returns __ArtifactManifestInput.Artifact_id, and is useful for accessing the field via an interface.
func (v *__ArtifactManifestInput) GetArtifact_id() string { return v.Artifact_id }

// __ClientIDMappingInput is used internally by genqlient
type __ClientIDMappingInput struct {
	ClientID string `json:"clientID"`
}

// GetClientID returns __ClientIDMappingInput.ClientID, and is useful for accessing the field via an interface.
func (v *__ClientIDMappingInput) GetClientID() string { return v.ClientID }

// __CommitArtifactInput is used internally by genqlient
type __CommitArtifactInput struct {
	ArtifactID string `json:"artifactID"`
}

// GetArtifactID returns __CommitArtifactInput.ArtifactID, and is useful for accessing the field via an interface.
func (v *__CommitArtifactInput) GetArtifactID() string { return v.ArtifactID }

// __CompleteMultipartUploadArtifactInput is used internally by genqlient
type __CompleteMultipartUploadArtifactInput struct {
	CompleteMultipartAction CompleteMultipartAction `json:"completeMultipartAction"`
	CompletedParts          []UploadPartsInput      `json:"completedParts"`
	ArtifactID              string                  `json:"artifactID"`
	StoragePath             string                  `json:"storagePath"`
	UploadID                string                  `json:"uploadID"`
}

// GetCompleteMultipartAction returns __CompleteMultipartUploadArtifactInput.CompleteMultipartAction, and is useful for accessing the field via an interface.
func (v *__CompleteMultipartUploadArtifactInput) GetCompleteMultipartAction() CompleteMultipartAction {
	return v.CompleteMultipartAction
}

// GetCompletedParts returns __CompleteMultipartUploadArtifactInput.CompletedParts, and is useful for accessing the field via an interface.
func (v *__CompleteMultipartUploadArtifactInput) GetCompletedParts() []UploadPartsInput {
	return v.CompletedParts
}

// GetArtifactID returns __CompleteMultipartUploadArtifactInput.ArtifactID, and is useful for accessing the field via an interface.
func (v *__CompleteMultipartUploadArtifactInput) GetArtifactID() string { return v.ArtifactID }

// GetStoragePath returns __CompleteMultipartUploadArtifactInput.StoragePath, and is useful for accessing the field via an interface.
func (v *__CompleteMultipartUploadArtifactInput) GetStoragePath() string { return v.StoragePath }

// GetUploadID returns __CompleteMultipartUploadArtifactInput.UploadID, and is useful for accessing the field via an interface.
func (v *__CompleteMultipartUploadArtifactInput) GetUploadID() string { return v.UploadID }

// __CreateArtifactFilesInput is used internally by genqlient
type __CreateArtifactFilesInput struct {
	ArtifactFiles []CreateArtifactFileSpecInput `json:"artifactFiles"`
	StorageLayout ArtifactStorageLayout         `json:"storageLayout"`
}

// GetArtifactFiles returns __CreateArtifactFilesInput.ArtifactFiles, and is useful for accessing the field via an interface.
func (v *__CreateArtifactFilesInput) GetArtifactFiles() []CreateArtifactFileSpecInput {
	return v.ArtifactFiles
}

// GetStorageLayout returns __CreateArtifactFilesInput.StorageLayout, and is useful for accessing the field via an interface.
func (v *__CreateArtifactFilesInput) GetStorageLayout() ArtifactStorageLayout { return v.StorageLayout }

// __CreateArtifactInput is used internally by genqlient
type __CreateArtifactInput struct {
	Input CreateArtifactInput `json:"input"`
}

// GetInput returns __CreateArtifactInput.Input, and is useful for accessing the field via an interface.
func (v *__CreateArtifactInput) GetInput() CreateArtifactInput { return v.Input }

// __CreateArtifactManifestInput is used internally by genqlient
type __CreateArtifactManifestInput struct {
	ArtifactID     string               `json:"artifactID"`
	BaseArtifactID *string              `json:"baseArtifactID"`
	Name           string               `json:"name"`
	Digest         string               `json:"digest"`
	EntityName     string               `json:"entityName"`
	ProjectName    string               `json:"projectName"`
	RunName        string               `json:"runName"`
	ManifestType   ArtifactManifestType `json:"manifestType"`
	IncludeUpload  bool                 `json:"includeUpload"`
}

// GetArtifactID returns __CreateArtifactManifestInput.ArtifactID, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetArtifactID() string { return v.ArtifactID }

// GetBaseArtifactID returns __CreateArtifactManifestInput.BaseArtifactID, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetBaseArtifactID() *string { return v.BaseArtifactID }

// GetName returns __CreateArtifactManifestInput.Name, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetName() string { return v.Name }

// GetDigest returns __CreateArtifactManifestInput.Digest, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetDigest() string { return v.Digest }

// GetEntityName returns __CreateArtifactManifestInput.EntityName, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetEntityName() string { return v.EntityName }

// GetProjectName returns __CreateArtifactManifestInput.ProjectName, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetProjectName() string { return v.ProjectName }

// GetRunName returns __CreateArtifactManifestInput.RunName, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetRunName() string { return v.RunName }

// GetManifestType returns __CreateArtifactManifestInput.ManifestType, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetManifestType() ArtifactManifestType { return v.ManifestType }

// GetIncludeUpload returns __CreateArtifactManifestInput.IncludeUpload, and is useful for accessing the field via an interface.
func (v *__CreateArtifactManifestInput) GetIncludeUpload() bool { return v.IncludeUpload }

// __CreateRunFilesInput is used internally by genqlient
type __CreateRunFilesInput struct {
	Entity  string   `json:"entity"`
	Project string   `json:"project"`
	Run     string   `json:"run"`
	Files   []string `json:"files"`
}

// GetEntity returns __CreateRunFilesInput.Entity, and is useful for accessing the field via an interface.
func (v *__CreateRunFilesInput) GetEntity() string { return v.Entity }

// GetProject returns __CreateRunFilesInput.Project, and is useful for accessing the field via an interface.
func (v *__CreateRunFilesInput) GetProject() string { return v.Project }

// GetRun returns __CreateRunFilesInput.Run, and is useful for accessing the field via an interface.
func (v *__CreateRunFilesInput) GetRun() string { return v.Run }

// GetFiles returns __CreateRunFilesInput.Files, and is useful for accessing the field via an interface.
func (v *__CreateRunFilesInput) GetFiles() []string { return v.Files }

// __FetchOrgEntityFromEntityInput is used internally by genqlient
type __FetchOrgEntityFromEntityInput struct {
	EntityName string `json:"entityName"`
}

// GetEntityName returns __FetchOrgEntityFromEntityInput.EntityName, and is useful for accessing the field via an interface.
func (v *__FetchOrgEntityFromEntityInput) GetEntityName() string { return v.EntityName }

// __InputFieldsInput is used internally by genqlient
type __InputFieldsInput struct {
	TypeName string `json:"typeName"`
}

// GetTypeName returns __InputFieldsInput.TypeName, and is useful for accessing the field via an interface.
func (v *__InputFieldsInput) GetTypeName() string { return v.TypeName }

// __LinkArtifactInput is used internally by genqlient
type __LinkArtifactInput struct {
	ArtifactPortfolioName string               `json:"artifactPortfolioName"`
	EntityName            string               `json:"entityName"`
	ProjectName           string               `json:"projectName"`
	Aliases               []ArtifactAliasInput `json:"aliases"`
	ClientId              *string              `json:"clientId"`
	ArtifactId            *string              `json:"artifactId"`
}

// GetArtifactPortfolioName returns __LinkArtifactInput.ArtifactPortfolioName, and is useful for accessing the field via an interface.
func (v *__LinkArtifactInput) GetArtifactPortfolioName() string { return v.ArtifactPortfolioName }

// GetEntityName returns __LinkArtifactInput.EntityName, and is useful for accessing the field via an interface.
func (v *__LinkArtifactInput) GetEntityName() string { return v.EntityName }

// GetProjectName returns __LinkArtifactInput.ProjectName, and is useful for accessing the field via an interface.
func (v *__LinkArtifactInput) GetProjectName() string { return v.ProjectName }

// GetAliases returns __LinkArtifactInput.Aliases, and is useful for accessing the field via an interface.
func (v *__LinkArtifactInput) GetAliases() []ArtifactAliasInput { return v.Aliases }

// GetClientId returns __LinkArtifactInput.ClientId, and is useful for accessing the field via an interface.
func (v *__LinkArtifactInput) GetClientId() *string { return v.ClientId }

// GetArtifactId returns __LinkArtifactInput.ArtifactId, and is useful for accessing the field via an interface.
func (v *__LinkArtifactInput) GetArtifactId() *string { return v.ArtifactId }

// __NotifyScriptableRunAlertInput is used internally by genqlient
type __NotifyScriptableRunAlertInput struct {
	EntityName   string         `json:"entityName"`
	ProjectName  string         `json:"projectName"`
	RunName      string         `json:"runName"`
	Title        string         `json:"title"`
	Text         string         `json:"text"`
	Severity     *AlertSeverity `json:"severity"`
	WaitDuration *int64         `json:"waitDuration"`
}

// GetEntityName returns __NotifyScriptableRunAlertInput.EntityName, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetEntityName() string { return v.EntityName }

// GetProjectName returns __NotifyScriptableRunAlertInput.ProjectName, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetProjectName() string { return v.ProjectName }

// GetRunName returns __NotifyScriptableRunAlertInput.RunName, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetRunName() string { return v.RunName }

// GetTitle returns __NotifyScriptableRunAlertInput.Title, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetTitle() string { return v.Title }

// GetText returns __NotifyScriptableRunAlertInput.Text, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetText() string { return v.Text }

// GetSeverity returns __NotifyScriptableRunAlertInput.Severity, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetSeverity() *AlertSeverity { return v.Severity }

// GetWaitDuration returns __NotifyScriptableRunAlertInput.WaitDuration, and is useful for accessing the field via an interface.
func (v *__NotifyScriptableRunAlertInput) GetWaitDuration() *int64 { return v.WaitDuration }

// __OrganizationCoreWeaveOrganizationIDInput is used internally by genqlient
type __OrganizationCoreWeaveOrganizationIDInput struct {
	EntityName string `json:"entityName"`
}

// GetEntityName returns __OrganizationCoreWeaveOrganizationIDInput.EntityName, and is useful for accessing the field via an interface.
func (v *__OrganizationCoreWeaveOrganizationIDInput) GetEntityName() string { return v.EntityName }

// __RewindRunInput is used internally by genqlient
type __RewindRunInput struct {
	RunName     string  `json:"runName"`
	Entity      *string `json:"entity"`
	Project     *string `json:"project"`
	MetricName  string  `json:"metricName"`
	MetricValue float64 `json:"metricValue"`
}

// GetRunName returns __RewindRunInput.RunName, and is useful for accessing the field via an interface.
func (v *__RewindRunInput) GetRunName() string { return v.RunName }

// GetEntity returns __RewindRunInput.Entity, and is useful for accessing the field via an interface.
func (v *__RewindRunInput) GetEntity() *string { return v.Entity }

// GetProject returns __RewindRunInput.Project, and is useful for accessing the field via an interface.
func (v *__RewindRunInput) GetProject() *string { return v.Project }

// GetMetricName returns __RewindRunInput.MetricName, and is useful for accessing the field via an interface.
func (v *__RewindRunInput) GetMetricName() string { return v.MetricName }

// GetMetricValue returns __RewindRunInput.MetricValue, and is useful for accessing the field via an interface.
func (v *__RewindRunInput) GetMetricValue() float64 { return v.MetricValue }

// __RunResumeStatusInput is used internally by genqlient
type __RunResumeStatusInput struct {
	Project *string `json:"project"`
	Entity  *string `json:"entity"`
	Name    string  `json:"name"`
}

// GetProject returns __RunResumeStatusInput.Project, and is useful for accessing the field via an interface.
func (v *__RunResumeStatusInput) GetProject() *string { return v.Project }

// GetEntity returns __RunResumeStatusInput.Entity, and is useful for accessing the field via an interface.
func (v *__RunResumeStatusInput) GetEntity() *string { return v.Entity }

// GetName returns __RunResumeStatusInput.Name, and is useful for accessing the field via an interface.
func (v *__RunResumeStatusInput) GetName() string { return v.Name }

// __RunStoppedStatusInput is used internally by genqlient
type __RunStoppedStatusInput struct {
	EntityName  *string `json:"entityName"`
	ProjectName *string `json:"projectName"`
	RunId       string  `json:"runId"`
}

// GetEntityName returns __RunStoppedStatusInput.EntityName, and is useful for accessing the field via an interface.
func (v *__RunStoppedStatusInput) GetEntityName() *string { return v.EntityName }

// GetProjectName returns __RunStoppedStatusInput.ProjectName, and is useful for accessing the field via an interface.
func (v *__RunStoppedStatusInput) GetProjectName() *string { return v.ProjectName }

// GetRunId returns __RunStoppedStatusInput.RunId, and is useful for accessing the field via an interface.
func (v *__RunStoppedStatusInput) GetRunId() string { return v.RunId }

// __TypeFieldsInput is used internally by genqlient
type __TypeFieldsInput struct {
	TypeName string `json:"typeName"`
}

// GetTypeName returns __TypeFieldsInput.TypeName, and is useful for accessing the field via an interface.
func (v *__TypeFieldsInput) GetTypeName() string { return v.TypeName }

// __UpdateArtifactInput is used internally by genqlient
type __UpdateArtifactInput struct {
	ArtifactID string  `json:"artifactID"`
	Metadata   *string `json:"metadata"`
}

// GetArtifactID returns __UpdateArtifactInput.ArtifactID, and is useful for accessing the field via an interface.
func (v *__UpdateArtifactInput) GetArtifactID() string { return v.ArtifactID }

// GetMetadata returns __UpdateArtifactInput.Metadata, and is useful for accessing the field via an interface.
func (v *__UpdateArtifactInput) GetMetadata() *string { return v.Metadata }

// __UpdateArtifactManifestInput is used internally by genqlient
type __UpdateArtifactManifestInput struct {
	ArtifactManifestID string  `json:"artifactManifestID"`
	Digest             *string `json:"digest"`
	BaseArtifactID     *string `json:"baseArtifactID"`
	IncludeUpload      bool    `json:"includeUpload"`
}

// GetArtifactManifestID returns __UpdateArtifactManifestInput.ArtifactManifestID, and is useful for accessing the field via an interface.
func (v *__UpdateArtifactManifestInput) GetArtifactManifestID() string { return v.ArtifactManifestID }

// GetDigest returns __UpdateArtifactManifestInput.Digest, and is useful for accessing the field via an interface.
func (v *__UpdateArtifactManifestInput) GetDigest() *string { return v.Digest }

// GetBaseArtifactID returns __UpdateArtifactManifestInput.BaseArtifactID, and is useful for accessing the field via an interface.
func (v *__UpdateArtifactManifestInput) GetBaseArtifactID() *string { return v.BaseArtifactID }

// GetIncludeUpload returns __UpdateArtifactManifestInput.IncludeUpload, and is useful for accessing the field via an interface.
func (v *__UpdateArtifactManifestInput) GetIncludeUpload() bool { return v.IncludeUpload }

// __UpsertBucketInput is used internally by genqlient
type __UpsertBucketInput struct {
	Id             *string  `json:"id"`
	Name           *string  `json:"name"`
	Project        *string  `json:"project"`
	Entity         *string  `json:"entity"`
	GroupName      *string  `json:"groupName"`
	Description    *string  `json:"description"`
	DisplayName    *string  `json:"displayName"`
	Notes          *string  `json:"notes"`
	Commit         *string  `json:"commit"`
	Config         *string  `json:"config"`
	Host           *string  `json:"host"`
	Debug          *bool    `json:"debug"`
	Program        *string  `json:"program"`
	Repo           *string  `json:"repo"`
	JobType        *string  `json:"jobType"`
	State          *string  `json:"state"`
	Sweep          *string  `json:"sweep"`
	Tags           []string `json:"tags"`
	SummaryMetrics *string  `json:"summaryMetrics"`
}

// GetId returns __UpsertBucketInput.Id, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetId() *string { return v.Id }

// GetName returns __UpsertBucketInput.Name, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetName() *string { return v.Name }

// GetProject returns __UpsertBucketInput.Project, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetProject() *string { return v.Project }

// GetEntity returns __UpsertBucketInput.Entity, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetEntity() *string { return v.Entity }

// GetGroupName returns __UpsertBucketInput.GroupName, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetGroupName() *string { return v.GroupName }

// GetDescription returns __UpsertBucketInput.Description, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetDescription() *string { return v.Description }

// GetDisplayName returns __UpsertBucketInput.DisplayName, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetDisplayName() *string { return v.DisplayName }

// GetNotes returns __UpsertBucketInput.Notes, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetNotes() *string { return v.Notes }

// GetCommit returns __UpsertBucketInput.Commit, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetCommit() *string { return v.Commit }

// GetConfig returns __UpsertBucketInput.Config, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetConfig() *string { return v.Config }

// GetHost returns __UpsertBucketInput.Host, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetHost() *string { return v.Host }

// GetDebug returns __UpsertBucketInput.Debug, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetDebug() *bool { return v.Debug }

// GetProgram returns __UpsertBucketInput.Program, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetProgram() *string { return v.Program }

// GetRepo returns __UpsertBucketInput.Repo, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetRepo() *string { return v.Repo }

// GetJobType returns __UpsertBucketInput.JobType, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetJobType() *string { return v.JobType }

// GetState returns __UpsertBucketInput.State, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetState() *string { return v.State }

// GetSweep returns __UpsertBucketInput.Sweep, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetSweep() *string { return v.Sweep }

// GetTags returns __UpsertBucketInput.Tags, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetTags() []string { return v.Tags }

// GetSummaryMetrics returns __UpsertBucketInput.SummaryMetrics, and is useful for accessing the field via an interface.
func (v *__UpsertBucketInput) GetSummaryMetrics() *string { return v.SummaryMetrics }

// __UseArtifactInput is used internally by genqlient
type __UseArtifactInput struct {
	Input UseArtifactInput `json:"input"`
}

// GetInput returns __UseArtifactInput.Input, and is useful for accessing the field via an interface.
func (v *__UseArtifactInput) GetInput() UseArtifactInput { return v.Input }

// The query executed by ArtifactFileURLs.
const ArtifactFileURLs_Operation = `
query ArtifactFileURLs ($id: ID!, $cursor: String, $perPage: Int) {
	artifact(id: $id) {
		files(after: $cursor, first: $perPage) {
			pageInfo {
				hasNextPage
				endCursor
			}
			edges {
				node {
					name
					directUrl
				}
			}
		}
	}
}
`

func ArtifactFileURLs(
	ctx_ context.Context,
	client_ graphql.Client,
	id string,
	cursor *string,
	perPage *int,
) (data_ *ArtifactFileURLsResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "ArtifactFileURLs",
		Query:  ArtifactFileURLs_Operation,
		Variables: &__ArtifactFileURLsInput{
			Id:      id,
			Cursor:  cursor,
			PerPage: perPage,
		},
	}

	data_ = &ArtifactFileURLsResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by ArtifactFileURLsByManifestEntries.
const ArtifactFileURLsByManifestEntries_Operation = `
query ArtifactFileURLsByManifestEntries ($id: ID!, $entries: [ArtifactManifestEntryInput!], $storageLayout: String!, $manifestVersion: String!, $storageRegion: String) {
	artifact(id: $id) {
		filesByManifestEntries(storageLayout: $storageLayout, manifestVersion: $manifestVersion, entries: $entries, storageRegion: $storageRegion) {
			pageInfo {
				hasNextPage
				endCursor
			}
			edges {
				node {
					name
					directUrl
				}
			}
		}
	}
}
`

func ArtifactFileURLsByManifestEntries(
	ctx_ context.Context,
	client_ graphql.Client,
	id string,
	entries []ArtifactManifestEntryInput,
	storageLayout string,
	manifestVersion string,
	storageRegion *string,
) (data_ *ArtifactFileURLsByManifestEntriesResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "ArtifactFileURLsByManifestEntries",
		Query:  ArtifactFileURLsByManifestEntries_Operation,
		Variables: &__ArtifactFileURLsByManifestEntriesInput{
			Id:              id,
			Entries:         entries,
			StorageLayout:   storageLayout,
			ManifestVersion: manifestVersion,
			StorageRegion:   storageRegion,
		},
	}

	data_ = &ArtifactFileURLsByManifestEntriesResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by ArtifactManifest.
const ArtifactManifest_Operation = `
query ArtifactManifest ($artifact_id: ID!) {
	artifact(id: $artifact_id) {
		currentManifest {
			file {
				directUrl
			}
		}
	}
}
`

func ArtifactManifest(
	ctx_ context.Context,
	client_ graphql.Client,
	artifact_id string,
) (data_ *ArtifactManifestResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "ArtifactManifest",
		Query:  ArtifactManifest_Operation,
		Variables: &__ArtifactManifestInput{
			Artifact_id: artifact_id,
		},
	}

	data_ = &ArtifactManifestResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by ClientIDMapping.
const ClientIDMapping_Operation = `
query ClientIDMapping ($clientID: ID!) {
	clientIDMapping(clientID: $clientID) {
		serverID
	}
}
`

func ClientIDMapping(
	ctx_ context.Context,
	client_ graphql.Client,
	clientID string,
) (data_ *ClientIDMappingResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "ClientIDMapping",
		Query:  ClientIDMapping_Operation,
		Variables: &__ClientIDMappingInput{
			ClientID: clientID,
		},
	}

	data_ = &ClientIDMappingResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by CommitArtifact.
const CommitArtifact_Operation = `
mutation CommitArtifact ($artifactID: ID!) {
	commitArtifact(input: {artifactID:$artifactID}) {
		artifact {
			id
			digest
		}
	}
}
`

func CommitArtifact(
	ctx_ context.Context,
	client_ graphql.Client,
	artifactID string,
) (data_ *CommitArtifactResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "CommitArtifact",
		Query:  CommitArtifact_Operation,
		Variables: &__CommitArtifactInput{
			ArtifactID: artifactID,
		},
	}

	data_ = &CommitArtifactResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by CompleteMultipartUploadArtifact.
const CompleteMultipartUploadArtifact_Operation = `
mutation CompleteMultipartUploadArtifact ($completeMultipartAction: CompleteMultipartAction!, $completedParts: [UploadPartsInput!]!, $artifactID: ID!, $storagePath: String!, $uploadID: String!) {
	completeMultipartUploadArtifact(input: {completeMultipartAction:$completeMultipartAction,completedParts:$completedParts,artifactID:$artifactID,storagePath:$storagePath,uploadID:$uploadID}) {
		digest
	}
}
`

func CompleteMultipartUploadArtifact(
	ctx_ context.Context,
	client_ graphql.Client,
	completeMultipartAction CompleteMultipartAction,
	completedParts []UploadPartsInput,
	artifactID string,
	storagePath string,
	uploadID string,
) (data_ *CompleteMultipartUploadArtifactResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "CompleteMultipartUploadArtifact",
		Query:  CompleteMultipartUploadArtifact_Operation,
		Variables: &__CompleteMultipartUploadArtifactInput{
			CompleteMultipartAction: completeMultipartAction,
			CompletedParts:          completedParts,
			ArtifactID:              artifactID,
			StoragePath:             storagePath,
			UploadID:                uploadID,
		},
	}

	data_ = &CompleteMultipartUploadArtifactResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by CreateArtifact.
const CreateArtifact_Operation = `
mutation CreateArtifact ($input: CreateArtifactInput!) {
	createArtifact(input: $input) {
		... CreatedArtifact
	}
}
fragment CreatedArtifact on CreateArtifactPayload {
	artifact {
		id
		state
		artifactSequence {
			latestArtifact {
				id
			}
		}
	}
}
`

// These are "required" fields in practice, even if they're formally optional in the input schema
//
// CreateArtifactInput.tags added in server version: 0.58
func CreateArtifact(
	ctx_ context.Context,
	client_ graphql.Client,
	input CreateArtifactInput,
) (data_ *CreateArtifactResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "CreateArtifact",
		Query:  CreateArtifact_Operation,
		Variables: &__CreateArtifactInput{
			Input: input,
		},
	}

	data_ = &CreateArtifactResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by CreateArtifactFiles.
const CreateArtifactFiles_Operation = `
mutation CreateArtifactFiles ($artifactFiles: [CreateArtifactFileSpecInput!]!, $storageLayout: ArtifactStorageLayout!) {
	createArtifactFiles(input: {artifactFiles:$artifactFiles,storageLayout:$storageLayout}) {
		files {
			edges {
				node {
					storagePath
					uploadUrl
					uploadHeaders
					uploadMultipartUrls {
						uploadID
						uploadUrlParts {
							partNumber
							uploadUrl
						}
					}
					artifact {
						id
					}
				}
			}
		}
	}
}
`

func CreateArtifactFiles(
	ctx_ context.Context,
	client_ graphql.Client,
	artifactFiles []CreateArtifactFileSpecInput,
	storageLayout ArtifactStorageLayout,
) (data_ *CreateArtifactFilesResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "CreateArtifactFiles",
		Query:  CreateArtifactFiles_Operation,
		Variables: &__CreateArtifactFilesInput{
			ArtifactFiles: artifactFiles,
			StorageLayout: storageLayout,
		},
	}

	data_ = &CreateArtifactFilesResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by CreateArtifactManifest.
const CreateArtifactManifest_Operation = `
mutation CreateArtifactManifest ($artifactID: ID!, $baseArtifactID: ID, $name: String!, $digest: String!, $entityName: String!, $projectName: String!, $runName: String!, $manifestType: ArtifactManifestType!, $includeUpload: Boolean!) {
	createArtifactManifest(input: {artifactID:$artifactID,baseArtifactID:$baseArtifactID,name:$name,digest:$digest,entityName:$entityName,projectName:$projectName,runName:$runName,type:$manifestType}) {
		artifactManifest {
			id
			file {
				id
				uploadUrl @include(if: $includeUpload)
				uploadHeaders @include(if: $includeUpload)
			}
		}
	}
}
`

func CreateArtifactManifest(
	ctx_ context.Context,
	client_ graphql.Client,
	artifactID string,
	baseArtifactID *string,
	name string,
	digest string,
	entityName string,
	projectName string,
	runName string,
	manifestType ArtifactManifestType,
	includeUpload bool,
) (data_ *CreateArtifactManifestResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "CreateArtifactManifest",
		Query:  CreateArtifactManifest_Operation,
		Variables: &__CreateArtifactManifestInput{
			ArtifactID:     artifactID,
			BaseArtifactID: baseArtifactID,
			Name:           name,
			Digest:         digest,
			EntityName:     entityName,
			ProjectName:    projectName,
			RunName:        runName,
			ManifestType:   manifestType,
			IncludeUpload:  includeUpload,
		},
	}

	data_ = &CreateArtifactManifestResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by CreateRunFiles.
const CreateRunFiles_Operation = `
mutation CreateRunFiles ($entity: String!, $project: String!, $run: String!, $files: [String!]!) {
	createRunFiles(input: {entityName:$entity,projectName:$project,runName:$run,files:$files}) {
		runID
		uploadHeaders
		files {
			name
			uploadUrl
		}
	}
}
`

func CreateRunFiles(
	ctx_ context.Context,
	client_ graphql.Client,
	entity string,
	project string,
	run string,
	files []string,
) (data_ *CreateRunFilesResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "CreateRunFiles",
		Query:  CreateRunFiles_Operation,
		Variables: &__CreateRunFilesInput{
			Entity:  entity,
			Project: project,
			Run:     run,
			Files:   files,
		},
	}

	data_ = &CreateRunFilesResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by FetchOrgEntityFromEntity.
const FetchOrgEntityFromEntity_Operation = `
query FetchOrgEntityFromEntity ($entityName: String!) {
	entity(name: $entityName) {
		organization {
			name
			orgEntity {
				name
			}
		}
	}
}
`

func FetchOrgEntityFromEntity(
	ctx_ context.Context,
	client_ graphql.Client,
	entityName string,
) (data_ *FetchOrgEntityFromEntityResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "FetchOrgEntityFromEntity",
		Query:  FetchOrgEntityFromEntity_Operation,
		Variables: &__FetchOrgEntityFromEntityInput{
			EntityName: entityName,
		},
	}

	data_ = &FetchOrgEntityFromEntityResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by InputFields.
const InputFields_Operation = `
query InputFields ($typeName: String!) {
	TypeInfo: __type(name: $typeName) {
		inputFields {
			name
		}
	}
}
`

func InputFields(
	ctx_ context.Context,
	client_ graphql.Client,
	typeName string,
) (data_ *InputFieldsResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "InputFields",
		Query:  InputFields_Operation,
		Variables: &__InputFieldsInput{
			TypeName: typeName,
		},
	}

	data_ = &InputFieldsResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by LinkArtifact.
const LinkArtifact_Operation = `
mutation LinkArtifact ($artifactPortfolioName: String!, $entityName: String!, $projectName: String!, $aliases: [ArtifactAliasInput!], $clientId: ID, $artifactId: ID) {
	linkArtifact(input: {artifactPortfolioName:$artifactPortfolioName,entityName:$entityName,projectName:$projectName,aliases:$aliases,artifactID:$artifactId,clientID:$clientId}) {
		versionIndex
	}
}
`

func LinkArtifact(
	ctx_ context.Context,
	client_ graphql.Client,
	artifactPortfolioName string,
	entityName string,
	projectName string,
	aliases []ArtifactAliasInput,
	clientId *string,
	artifactId *string,
) (data_ *LinkArtifactResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "LinkArtifact",
		Query:  LinkArtifact_Operation,
		Variables: &__LinkArtifactInput{
			ArtifactPortfolioName: artifactPortfolioName,
			EntityName:            entityName,
			ProjectName:           projectName,
			Aliases:               aliases,
			ClientId:              clientId,
			ArtifactId:            artifactId,
		},
	}

	data_ = &LinkArtifactResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by NotifyScriptableRunAlert.
const NotifyScriptableRunAlert_Operation = `
mutation NotifyScriptableRunAlert ($entityName: String!, $projectName: String!, $runName: String!, $title: String!, $text: String!, $severity: AlertSeverity = INFO, $waitDuration: Duration) {
	notifyScriptableRunAlert(input: {entityName:$entityName,projectName:$projectName,runName:$runName,title:$title,text:$text,severity:$severity,waitDuration:$waitDuration}) {
		success
	}
}
`

func NotifyScriptableRunAlert(
	ctx_ context.Context,
	client_ graphql.Client,
	entityName string,
	projectName string,
	runName string,
	title string,
	text string,
	severity *AlertSeverity,
	waitDuration *int64,
) (data_ *NotifyScriptableRunAlertResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "NotifyScriptableRunAlert",
		Query:  NotifyScriptableRunAlert_Operation,
		Variables: &__NotifyScriptableRunAlertInput{
			EntityName:   entityName,
			ProjectName:  projectName,
			RunName:      runName,
			Title:        title,
			Text:         text,
			Severity:     severity,
			WaitDuration: waitDuration,
		},
	}

	data_ = &NotifyScriptableRunAlertResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by OrganizationCoreWeaveOrganizationID.
const OrganizationCoreWeaveOrganizationID_Operation = `
query OrganizationCoreWeaveOrganizationID ($entityName: String!) {
	entity(name: $entityName) {
		organization {
			coreWeaveOrganizationId
		}
	}
}
`

func OrganizationCoreWeaveOrganizationID(
	ctx_ context.Context,
	client_ graphql.Client,
	entityName string,
) (data_ *OrganizationCoreWeaveOrganizationIDResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "OrganizationCoreWeaveOrganizationID",
		Query:  OrganizationCoreWeaveOrganizationID_Operation,
		Variables: &__OrganizationCoreWeaveOrganizationIDInput{
			EntityName: entityName,
		},
	}

	data_ = &OrganizationCoreWeaveOrganizationIDResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by RewindRun.
const RewindRun_Operation = `
mutation RewindRun ($runName: String!, $entity: String, $project: String, $metricName: String!, $metricValue: Float!) {
	rewindRun(input: {runName:$runName,entityName:$entity,projectName:$project,metricName:$metricName,metricValue:$metricValue}) {
		rewoundRun {
			id
			name
			displayName
			description
			config
			sweepName
			project {
				id
				name
				entity {
					id
					name
				}
			}
			historyLineCount
		}
	}
}
`

func RewindRun(
	ctx_ context.Context,
	client_ graphql.Client,
	runName string,
	entity *string,
	project *string,
	metricName string,
	metricValue float64,
) (data_ *RewindRunResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "RewindRun",
		Query:  RewindRun_Operation,
		Variables: &__RewindRunInput{
			RunName:     runName,
			Entity:      entity,
			Project:     project,
			MetricName:  metricName,
			MetricValue: metricValue,
		},
	}

	data_ = &RewindRunResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by RunResumeStatus.
const RunResumeStatus_Operation = `
query RunResumeStatus ($project: String, $entity: String, $name: String!) {
	model(name: $project, entityName: $entity) {
		id
		name
		entity {
			id
			name
		}
		bucket(name: $name, missingOk: true) {
			id
			name
			summaryMetrics
			displayName
			logLineCount
			historyLineCount
			eventsLineCount
			historyTail
			eventsTail
			config
			tags
			notes
			wandbConfig(keys: ["t"])
		}
	}
}
`

func RunResumeStatus(
	ctx_ context.Context,
	client_ graphql.Client,
	project *string,
	entity *string,
	name string,
) (data_ *RunResumeStatusResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "RunResumeStatus",
		Query:  RunResumeStatus_Operation,
		Variables: &__RunResumeStatusInput{
			Project: project,
			Entity:  entity,
			Name:    name,
		},
	}

	data_ = &RunResumeStatusResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by RunStoppedStatus.
const RunStoppedStatus_Operation = `
query RunStoppedStatus ($entityName: String, $projectName: String, $runId: String!) {
	project(name: $projectName, entityName: $entityName) {
		run(name: $runId) {
			stopped
		}
	}
}
`

func RunStoppedStatus(
	ctx_ context.Context,
	client_ graphql.Client,
	entityName *string,
	projectName *string,
	runId string,
) (data_ *RunStoppedStatusResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "RunStoppedStatus",
		Query:  RunStoppedStatus_Operation,
		Variables: &__RunStoppedStatusInput{
			EntityName:  entityName,
			ProjectName: projectName,
			RunId:       runId,
		},
	}

	data_ = &RunStoppedStatusResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by ServerFeaturesQuery.
const ServerFeaturesQuery_Operation = `
query ServerFeaturesQuery {
	serverInfo {
		features {
			name
			isEnabled
		}
	}
}
`

// This query is used to fetch the features supported by the server.
// It is used to determine if certain code paths should be used in the SDK.
func ServerFeaturesQuery(
	ctx_ context.Context,
	client_ graphql.Client,
) (data_ *ServerFeaturesQueryResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "ServerFeaturesQuery",
		Query:  ServerFeaturesQuery_Operation,
	}

	data_ = &ServerFeaturesQueryResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by ServerInfo.
const ServerInfo_Operation = `
query ServerInfo {
	serverInfo {
		cliVersionInfo
		latestLocalVersionInfo {
			outOfDate
			latestVersionString
			versionOnThisInstanceString
		}
	}
}
`

func ServerInfo(
	ctx_ context.Context,
	client_ graphql.Client,
) (data_ *ServerInfoResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "ServerInfo",
		Query:  ServerInfo_Operation,
	}

	data_ = &ServerInfoResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by TypeFields.
const TypeFields_Operation = `
query TypeFields ($typeName: String!) {
	TypeInfo: __type(name: $typeName) {
		fields {
			name
		}
	}
}
`

// Query is used to fetch the fields of a given type to check server compatibility
func TypeFields(
	ctx_ context.Context,
	client_ graphql.Client,
	typeName string,
) (data_ *TypeFieldsResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "TypeFields",
		Query:  TypeFields_Operation,
		Variables: &__TypeFieldsInput{
			TypeName: typeName,
		},
	}

	data_ = &TypeFieldsResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by UpdateArtifact.
const UpdateArtifact_Operation = `
mutation UpdateArtifact ($artifactID: ID!, $metadata: JSONString) {
	updateArtifact(input: {artifactID:$artifactID,metadata:$metadata}) {
		artifact {
			id
		}
	}
}
`

func UpdateArtifact(
	ctx_ context.Context,
	client_ graphql.Client,
	artifactID string,
	metadata *string,
) (data_ *UpdateArtifactResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "UpdateArtifact",
		Query:  UpdateArtifact_Operation,
		Variables: &__UpdateArtifactInput{
			ArtifactID: artifactID,
			Metadata:   metadata,
		},
	}

	data_ = &UpdateArtifactResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by UpdateArtifactManifest.
const UpdateArtifactManifest_Operation = `
mutation UpdateArtifactManifest ($artifactManifestID: ID!, $digest: String, $baseArtifactID: ID, $includeUpload: Boolean!) {
	updateArtifactManifest(input: {artifactManifestID:$artifactManifestID,digest:$digest,baseArtifactID:$baseArtifactID}) {
		artifactManifest {
			id
			file {
				id
				uploadUrl @include(if: $includeUpload)
				uploadHeaders @include(if: $includeUpload)
			}
		}
	}
}
`

func UpdateArtifactManifest(
	ctx_ context.Context,
	client_ graphql.Client,
	artifactManifestID string,
	digest *string,
	baseArtifactID *string,
	includeUpload bool,
) (data_ *UpdateArtifactManifestResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "UpdateArtifactManifest",
		Query:  UpdateArtifactManifest_Operation,
		Variables: &__UpdateArtifactManifestInput{
			ArtifactManifestID: artifactManifestID,
			Digest:             digest,
			BaseArtifactID:     baseArtifactID,
			IncludeUpload:      includeUpload,
		},
	}

	data_ = &UpdateArtifactManifestResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by UpsertBucket.
const UpsertBucket_Operation = `
mutation UpsertBucket ($id: String, $name: String, $project: String, $entity: String, $groupName: String, $description: String, $displayName: String, $notes: String, $commit: String, $config: JSONString, $host: String, $debug: Boolean, $program: String, $repo: String, $jobType: String, $state: String, $sweep: String, $tags: [String!], $summaryMetrics: JSONString) {
	upsertBucket(input: {id:$id,name:$name,groupName:$groupName,modelName:$project,entityName:$entity,description:$description,displayName:$displayName,notes:$notes,config:$config,commit:$commit,host:$host,debug:$debug,jobProgram:$program,jobRepo:$repo,jobType:$jobType,state:$state,sweep:$sweep,tags:$tags,summaryMetrics:$summaryMetrics}) {
		bucket {
			id
			name
			displayName
			description
			config
			sweepName
			project {
				id
				name
				entity {
					id
					name
				}
			}
			historyLineCount
		}
		inserted
	}
}
`

func UpsertBucket(
	ctx_ context.Context,
	client_ graphql.Client,
	id *string,
	name *string,
	project *string,
	entity *string,
	groupName *string,
	description *string,
	displayName *string,
	notes *string,
	commit *string,
	config *string,
	host *string,
	debug *bool,
	program *string,
	repo *string,
	jobType *string,
	state *string,
	sweep *string,
	tags []string,
	summaryMetrics *string,
) (data_ *UpsertBucketResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "UpsertBucket",
		Query:  UpsertBucket_Operation,
		Variables: &__UpsertBucketInput{
			Id:             id,
			Name:           name,
			Project:        project,
			Entity:         entity,
			GroupName:      groupName,
			Description:    description,
			DisplayName:    displayName,
			Notes:          notes,
			Commit:         commit,
			Config:         config,
			Host:           host,
			Debug:          debug,
			Program:        program,
			Repo:           repo,
			JobType:        jobType,
			State:          state,
			Sweep:          sweep,
			Tags:           tags,
			SummaryMetrics: summaryMetrics,
		},
	}

	data_ = &UpsertBucketResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The mutation executed by UseArtifact.
const UseArtifact_Operation = `
mutation UseArtifact ($input: UseArtifactInput!) {
	useArtifact(input: $input) {
		artifact {
			id
		}
	}
}
`

// artifactEntityName and artifactProjectName are in a later server version
func UseArtifact(
	ctx_ context.Context,
	client_ graphql.Client,
	input UseArtifactInput,
) (data_ *UseArtifactResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "UseArtifact",
		Query:  UseArtifact_Operation,
		Variables: &__UseArtifactInput{
			Input: input,
		},
	}

	data_ = &UseArtifactResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}

// The query executed by Viewer.
const Viewer_Operation = `
query Viewer {
	viewer {
		id
		entity
		flags
		teams {
			edges {
				node {
					name
				}
			}
		}
	}
}
`

func Viewer(
	ctx_ context.Context,
	client_ graphql.Client,
) (data_ *ViewerResponse, err_ error) {
	req_ := &graphql.Request{
		OpName: "Viewer",
		Query:  Viewer_Operation,
	}

	data_ = &ViewerResponse{}
	resp_ := &graphql.Response{Data: data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return data_, err_
}
