// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v5.29.3
// source: core/internal/monitor/tpuproto/tpu_metric_service.proto

package tpuproto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Exemplar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value      float64                `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	Timestamp  *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Attributes []*Attribute           `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *Exemplar) Reset() {
	*x = Exemplar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Exemplar) ProtoMessage() {}

func (x *Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Exemplar.ProtoReflect.Descriptor instead.
func (*Exemplar) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{0}
}

func (x *Exemplar) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *Exemplar) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *Exemplar) GetAttributes() []*Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

type Distribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Count                 int64   `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Mean                  float64 `protobuf:"fixed64,2,opt,name=mean,proto3" json:"mean,omitempty"`
	Min                   float64 `protobuf:"fixed64,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                   float64 `protobuf:"fixed64,4,opt,name=max,proto3" json:"max,omitempty"`
	SumOfSquaredDeviation float64 `protobuf:"fixed64,5,opt,name=sum_of_squared_deviation,json=sumOfSquaredDeviation,proto3" json:"sum_of_squared_deviation,omitempty"`
	// Defines the histogram bucket boundaries.
	BucketOptions *Distribution_BucketOptions `protobuf:"bytes,6,opt,name=bucket_options,json=bucketOptions,proto3" json:"bucket_options,omitempty"`
	BucketCounts  []int64                     `protobuf:"varint,7,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
	Exemplars     []*Exemplar                 `protobuf:"bytes,8,rep,name=exemplars,proto3" json:"exemplars,omitempty"`
}

func (x *Distribution) Reset() {
	*x = Distribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution) ProtoMessage() {}

func (x *Distribution) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution.ProtoReflect.Descriptor instead.
func (*Distribution) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1}
}

func (x *Distribution) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *Distribution) GetMean() float64 {
	if x != nil {
		return x.Mean
	}
	return 0
}

func (x *Distribution) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *Distribution) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

func (x *Distribution) GetSumOfSquaredDeviation() float64 {
	if x != nil {
		return x.SumOfSquaredDeviation
	}
	return 0
}

func (x *Distribution) GetBucketOptions() *Distribution_BucketOptions {
	if x != nil {
		return x.BucketOptions
	}
	return nil
}

func (x *Distribution) GetBucketCounts() []int64 {
	if x != nil {
		return x.BucketCounts
	}
	return nil
}

func (x *Distribution) GetExemplars() []*Exemplar {
	if x != nil {
		return x.Exemplars
	}
	return nil
}

// Gauge represents a single-point measure.
type Gauge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Gauge_AsDouble
	//	*Gauge_AsInt
	//	*Gauge_AsString
	//	*Gauge_AsBool
	Value isGauge_Value `protobuf_oneof:"value"`
}

func (x *Gauge) Reset() {
	*x = Gauge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Gauge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gauge) ProtoMessage() {}

func (x *Gauge) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Gauge.ProtoReflect.Descriptor instead.
func (*Gauge) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{2}
}

func (m *Gauge) GetValue() isGauge_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Gauge) GetAsDouble() float64 {
	if x, ok := x.GetValue().(*Gauge_AsDouble); ok {
		return x.AsDouble
	}
	return 0
}

func (x *Gauge) GetAsInt() int64 {
	if x, ok := x.GetValue().(*Gauge_AsInt); ok {
		return x.AsInt
	}
	return 0
}

func (x *Gauge) GetAsString() string {
	if x, ok := x.GetValue().(*Gauge_AsString); ok {
		return x.AsString
	}
	return ""
}

func (x *Gauge) GetAsBool() bool {
	if x, ok := x.GetValue().(*Gauge_AsBool); ok {
		return x.AsBool
	}
	return false
}

type isGauge_Value interface {
	isGauge_Value()
}

type Gauge_AsDouble struct {
	AsDouble float64 `protobuf:"fixed64,1,opt,name=as_double,json=asDouble,proto3,oneof"`
}

type Gauge_AsInt struct {
	AsInt int64 `protobuf:"varint,2,opt,name=as_int,json=asInt,proto3,oneof"`
}

type Gauge_AsString struct {
	AsString string `protobuf:"bytes,3,opt,name=as_string,json=asString,proto3,oneof"`
}

type Gauge_AsBool struct {
	AsBool bool `protobuf:"varint,4,opt,name=as_bool,json=asBool,proto3,oneof"`
}

func (*Gauge_AsDouble) isGauge_Value() {}

func (*Gauge_AsInt) isGauge_Value() {}

func (*Gauge_AsString) isGauge_Value() {}

func (*Gauge_AsBool) isGauge_Value() {}

// Counter is a monotonically increasing measure (until reset to zero).
type Counter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value MUST not be negative.
	//
	// Types that are assignable to Value:
	//
	//	*Counter_AsDouble
	//	*Counter_AsInt
	Value    isCounter_Value `protobuf_oneof:"value"`
	Exemplar *Exemplar       `protobuf:"bytes,3,opt,name=exemplar,proto3" json:"exemplar,omitempty"`
}

func (x *Counter) Reset() {
	*x = Counter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Counter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Counter) ProtoMessage() {}

func (x *Counter) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Counter.ProtoReflect.Descriptor instead.
func (*Counter) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{3}
}

func (m *Counter) GetValue() isCounter_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Counter) GetAsDouble() float64 {
	if x, ok := x.GetValue().(*Counter_AsDouble); ok {
		return x.AsDouble
	}
	return 0
}

func (x *Counter) GetAsInt() uint64 {
	if x, ok := x.GetValue().(*Counter_AsInt); ok {
		return x.AsInt
	}
	return 0
}

func (x *Counter) GetExemplar() *Exemplar {
	if x != nil {
		return x.Exemplar
	}
	return nil
}

type isCounter_Value interface {
	isCounter_Value()
}

type Counter_AsDouble struct {
	AsDouble float64 `protobuf:"fixed64,1,opt,name=as_double,json=asDouble,proto3,oneof"`
}

type Counter_AsInt struct {
	AsInt uint64 `protobuf:"varint,2,opt,name=as_int,json=asInt,proto3,oneof"`
}

func (*Counter_AsDouble) isCounter_Value() {}

func (*Counter_AsInt) isCounter_Value() {}

// Quantile represents the value at a given quantile of a distribution.
type Quantile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The quantile of a distribution. Must be in the interval [0.0, 1.0].
	Quantile float64 `protobuf:"fixed64,1,opt,name=quantile,proto3" json:"quantile,omitempty"`
	// The value at the given quantile of a distribution.
	// Quantile values must NOT be negative.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Quantile) Reset() {
	*x = Quantile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Quantile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Quantile) ProtoMessage() {}

func (x *Quantile) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Quantile.ProtoReflect.Descriptor instead.
func (*Quantile) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{4}
}

func (x *Quantile) GetQuantile() float64 {
	if x != nil {
		return x.Quantile
	}
	return 0
}

func (x *Quantile) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// SummaryMetric represents observed sampling for different quantiles including
// sum of all the observations and total count of observations.
type SummaryMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SampleCount uint64      `protobuf:"varint,1,opt,name=sample_count,json=sampleCount,proto3" json:"sample_count,omitempty"`
	SampleSum   float64     `protobuf:"fixed64,2,opt,name=sample_sum,json=sampleSum,proto3" json:"sample_sum,omitempty"`
	Quantile    []*Quantile `protobuf:"bytes,3,rep,name=quantile,proto3" json:"quantile,omitempty"`
}

func (x *SummaryMetric) Reset() {
	*x = SummaryMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SummaryMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummaryMetric) ProtoMessage() {}

func (x *SummaryMetric) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummaryMetric.ProtoReflect.Descriptor instead.
func (*SummaryMetric) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{5}
}

func (x *SummaryMetric) GetSampleCount() uint64 {
	if x != nil {
		return x.SampleCount
	}
	return 0
}

func (x *SummaryMetric) GetSampleSum() float64 {
	if x != nil {
		return x.SampleSum
	}
	return 0
}

func (x *SummaryMetric) GetQuantile() []*Quantile {
	if x != nil {
		return x.Quantile
	}
	return nil
}

// AttrValue represents an attribute value.
// AttrValue is considered to be "empty" if all values are unspecified.
type AttrValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Attr:
	//
	//	*AttrValue_StringAttr
	//	*AttrValue_BoolAttr
	//	*AttrValue_IntAttr
	//	*AttrValue_DoubleAttr
	//	*AttrValue_ArrayAttr
	//	*AttrValue_KvlistAttr
	//	*AttrValue_BytesAttr
	Attr isAttrValue_Attr `protobuf_oneof:"attr"`
}

func (x *AttrValue) Reset() {
	*x = AttrValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttrValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttrValue) ProtoMessage() {}

func (x *AttrValue) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttrValue.ProtoReflect.Descriptor instead.
func (*AttrValue) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{6}
}

func (m *AttrValue) GetAttr() isAttrValue_Attr {
	if m != nil {
		return m.Attr
	}
	return nil
}

func (x *AttrValue) GetStringAttr() string {
	if x, ok := x.GetAttr().(*AttrValue_StringAttr); ok {
		return x.StringAttr
	}
	return ""
}

func (x *AttrValue) GetBoolAttr() bool {
	if x, ok := x.GetAttr().(*AttrValue_BoolAttr); ok {
		return x.BoolAttr
	}
	return false
}

func (x *AttrValue) GetIntAttr() int64 {
	if x, ok := x.GetAttr().(*AttrValue_IntAttr); ok {
		return x.IntAttr
	}
	return 0
}

func (x *AttrValue) GetDoubleAttr() float64 {
	if x, ok := x.GetAttr().(*AttrValue_DoubleAttr); ok {
		return x.DoubleAttr
	}
	return 0
}

func (x *AttrValue) GetArrayAttr() *ArrayAttrValue {
	if x, ok := x.GetAttr().(*AttrValue_ArrayAttr); ok {
		return x.ArrayAttr
	}
	return nil
}

func (x *AttrValue) GetKvlistAttr() *KeyValueList {
	if x, ok := x.GetAttr().(*AttrValue_KvlistAttr); ok {
		return x.KvlistAttr
	}
	return nil
}

func (x *AttrValue) GetBytesAttr() []byte {
	if x, ok := x.GetAttr().(*AttrValue_BytesAttr); ok {
		return x.BytesAttr
	}
	return nil
}

type isAttrValue_Attr interface {
	isAttrValue_Attr()
}

type AttrValue_StringAttr struct {
	StringAttr string `protobuf:"bytes,1,opt,name=string_attr,json=stringAttr,proto3,oneof"`
}

type AttrValue_BoolAttr struct {
	BoolAttr bool `protobuf:"varint,2,opt,name=bool_attr,json=boolAttr,proto3,oneof"`
}

type AttrValue_IntAttr struct {
	IntAttr int64 `protobuf:"varint,3,opt,name=int_attr,json=intAttr,proto3,oneof"`
}

type AttrValue_DoubleAttr struct {
	DoubleAttr float64 `protobuf:"fixed64,4,opt,name=double_attr,json=doubleAttr,proto3,oneof"`
}

type AttrValue_ArrayAttr struct {
	ArrayAttr *ArrayAttrValue `protobuf:"bytes,5,opt,name=array_attr,json=arrayAttr,proto3,oneof"`
}

type AttrValue_KvlistAttr struct {
	KvlistAttr *KeyValueList `protobuf:"bytes,6,opt,name=kvlist_attr,json=kvlistAttr,proto3,oneof"`
}

type AttrValue_BytesAttr struct {
	BytesAttr []byte `protobuf:"bytes,7,opt,name=bytes_attr,json=bytesAttr,proto3,oneof"`
}

func (*AttrValue_StringAttr) isAttrValue_Attr() {}

func (*AttrValue_BoolAttr) isAttrValue_Attr() {}

func (*AttrValue_IntAttr) isAttrValue_Attr() {}

func (*AttrValue_DoubleAttr) isAttrValue_Attr() {}

func (*AttrValue_ArrayAttr) isAttrValue_Attr() {}

func (*AttrValue_KvlistAttr) isAttrValue_Attr() {}

func (*AttrValue_BytesAttr) isAttrValue_Attr() {}

// ArrayAttrValue is a list of AttrValue messages.
type ArrayAttrValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Array of attribute. The array may be empty (contain 0 elements).
	Attrs []*AttrValue `protobuf:"bytes,1,rep,name=attrs,proto3" json:"attrs,omitempty"`
}

func (x *ArrayAttrValue) Reset() {
	*x = ArrayAttrValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArrayAttrValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayAttrValue) ProtoMessage() {}

func (x *ArrayAttrValue) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrayAttrValue.ProtoReflect.Descriptor instead.
func (*ArrayAttrValue) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{7}
}

func (x *ArrayAttrValue) GetAttrs() []*AttrValue {
	if x != nil {
		return x.Attrs
	}
	return nil
}

// KeyValueList is a list of Key-AttrValue messages.
type KeyValueList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of key/value attributes. The list may be empty.
	// The keys in attributes MUST be unique.
	Attributes []*Attribute `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *KeyValueList) Reset() {
	*x = KeyValueList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValueList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValueList) ProtoMessage() {}

func (x *KeyValueList) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValueList.ProtoReflect.Descriptor instead.
func (*KeyValueList) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{8}
}

func (x *KeyValueList) GetAttributes() []*Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Attribute is a key-value pair to store the attributes of a metric.
// For example, device-id of the metric, host-id of the metric.
type Attribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string     `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value *AttrValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Attribute) Reset() {
	*x = Attribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attribute) ProtoMessage() {}

func (x *Attribute) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attribute.ProtoReflect.Descriptor instead.
func (*Attribute) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{9}
}

func (x *Attribute) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Attribute) GetValue() *AttrValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// Metric represents a metric datapoint.
// A metric has a reporting time, attribute and a measure value.
type Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Attribute *Attribute             `protobuf:"bytes,1,opt,name=attribute,proto3" json:"attribute,omitempty"`
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Types that are assignable to Measure:
	//
	//	*Metric_Gauge
	//	*Metric_Counter
	//	*Metric_Distribution
	//	*Metric_Summary
	Measure isMetric_Measure `protobuf_oneof:"measure"`
}

func (x *Metric) Reset() {
	*x = Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{10}
}

func (x *Metric) GetAttribute() *Attribute {
	if x != nil {
		return x.Attribute
	}
	return nil
}

func (x *Metric) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (m *Metric) GetMeasure() isMetric_Measure {
	if m != nil {
		return m.Measure
	}
	return nil
}

func (x *Metric) GetGauge() *Gauge {
	if x, ok := x.GetMeasure().(*Metric_Gauge); ok {
		return x.Gauge
	}
	return nil
}

func (x *Metric) GetCounter() *Counter {
	if x, ok := x.GetMeasure().(*Metric_Counter); ok {
		return x.Counter
	}
	return nil
}

func (x *Metric) GetDistribution() *Distribution {
	if x, ok := x.GetMeasure().(*Metric_Distribution); ok {
		return x.Distribution
	}
	return nil
}

func (x *Metric) GetSummary() *SummaryMetric {
	if x, ok := x.GetMeasure().(*Metric_Summary); ok {
		return x.Summary
	}
	return nil
}

type isMetric_Measure interface {
	isMetric_Measure()
}

type Metric_Gauge struct {
	Gauge *Gauge `protobuf:"bytes,3,opt,name=gauge,proto3,oneof"`
}

type Metric_Counter struct {
	Counter *Counter `protobuf:"bytes,4,opt,name=counter,proto3,oneof"`
}

type Metric_Distribution struct {
	Distribution *Distribution `protobuf:"bytes,5,opt,name=distribution,proto3,oneof"`
}

type Metric_Summary struct {
	Summary *SummaryMetric `protobuf:"bytes,6,opt,name=summary,proto3,oneof"`
}

func (*Metric_Gauge) isMetric_Measure() {}

func (*Metric_Counter) isMetric_Measure() {}

func (*Metric_Distribution) isMetric_Measure() {}

func (*Metric_Summary) isMetric_Measure() {}

// TPUMetric is a standalone metric object, exposed externally to a consumer.
type TPUMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description string    `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	Metrics     []*Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *TPUMetric) Reset() {
	*x = TPUMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TPUMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TPUMetric) ProtoMessage() {}

func (x *TPUMetric) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TPUMetric.ProtoReflect.Descriptor instead.
func (*TPUMetric) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{11}
}

func (x *TPUMetric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TPUMetric) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TPUMetric) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// MetricRequest is the request object to fetch metrics from LibTPU.
// MetricRequest contains the metric name with which metrics can be fetched
// from the RuntimeMetricsService.GetRuntimeMetric.
type MetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// skip_node_aggregation provides options to the client to skip aggregated
	// lookup of metrics for a worker node. If the field is unset or set as false,
	// an aggregated view of metrics for a TPU worker node would be provided.
	// The aggregation feature is enabled by libTPU during initialization.
	// By default, the worker node aggregation would be turned on in libTPU if the
	// metrics server is supported. If the libTPU initialization turns off the
	// feature explicitly, then the aggregated view would not be provided.
	SkipNodeAggregation bool `protobuf:"varint,2,opt,name=skip_node_aggregation,json=skipNodeAggregation,proto3" json:"skip_node_aggregation,omitempty"`
}

func (x *MetricRequest) Reset() {
	*x = MetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricRequest) ProtoMessage() {}

func (x *MetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricRequest.ProtoReflect.Descriptor instead.
func (*MetricRequest) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{12}
}

func (x *MetricRequest) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

func (x *MetricRequest) GetSkipNodeAggregation() bool {
	if x != nil {
		return x.SkipNodeAggregation
	}
	return false
}

// MetricResponse is the response object for RuntimeService.GetRuntimeMetric.
// The response contains the TPUMetric as response which holds the metric data
// for the requested metric.
type MetricResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metric *TPUMetric `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (x *MetricResponse) Reset() {
	*x = MetricResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricResponse) ProtoMessage() {}

func (x *MetricResponse) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricResponse.ProtoReflect.Descriptor instead.
func (*MetricResponse) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{13}
}

func (x *MetricResponse) GetMetric() *TPUMetric {
	if x != nil {
		return x.Metric
	}
	return nil
}

// ListSupportedMetricsRequest is the request object for
// RuntimeService.ListSupportedMetrics.
// Empty request means no filters. All the metrics supported from the LibTPU
// would be returned as the response.
type ListSupportedMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A regex filter to apply to the supported metrics.
	// If the field is empty or not set, no filter is applied. All the supported
	// metrics are returned.
	//
	// Example: `.*memory.*`, `.*memory.*|.*duty_cycle.*`
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSupportedMetricsRequest) Reset() {
	*x = ListSupportedMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSupportedMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSupportedMetricsRequest) ProtoMessage() {}

func (x *ListSupportedMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSupportedMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListSupportedMetricsRequest) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListSupportedMetricsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type SupportedMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
}

func (x *SupportedMetric) Reset() {
	*x = SupportedMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedMetric) ProtoMessage() {}

func (x *SupportedMetric) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedMetric.ProtoReflect.Descriptor instead.
func (*SupportedMetric) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{15}
}

func (x *SupportedMetric) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// ListSupportedMetricsResponse is the response object for
// RuntimeService.ListSupportedMetrics.
// It contains all the metrics supported in the LibTPU for the
// ListSupportedMetricsRequest.
type ListSupportedMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of supported metric.
	SupportedMetric []*SupportedMetric `protobuf:"bytes,1,rep,name=supported_metric,json=supportedMetric,proto3" json:"supported_metric,omitempty"`
}

func (x *ListSupportedMetricsResponse) Reset() {
	*x = ListSupportedMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSupportedMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSupportedMetricsResponse) ProtoMessage() {}

func (x *ListSupportedMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSupportedMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListSupportedMetricsResponse) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListSupportedMetricsResponse) GetSupportedMetric() []*SupportedMetric {
	if x != nil {
		return x.SupportedMetric
	}
	return nil
}

type Distribution_BucketOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Options:
	//
	//	*Distribution_BucketOptions_RegularBuckets
	//	*Distribution_BucketOptions_ExponentialBuckets
	//	*Distribution_BucketOptions_ExplicitBuckets
	//	*Distribution_BucketOptions_LinearBuckets
	Options isDistribution_BucketOptions_Options `protobuf_oneof:"options"`
}

func (x *Distribution_BucketOptions) Reset() {
	*x = Distribution_BucketOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution_BucketOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution_BucketOptions) ProtoMessage() {}

func (x *Distribution_BucketOptions) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution_BucketOptions.ProtoReflect.Descriptor instead.
func (*Distribution_BucketOptions) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1, 0}
}

func (m *Distribution_BucketOptions) GetOptions() isDistribution_BucketOptions_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in core/internal/monitor/tpuproto/tpu_metric_service.proto.
func (x *Distribution_BucketOptions) GetRegularBuckets() *Distribution_BucketOptions_Regular {
	if x, ok := x.GetOptions().(*Distribution_BucketOptions_RegularBuckets); ok {
		return x.RegularBuckets
	}
	return nil
}

func (x *Distribution_BucketOptions) GetExponentialBuckets() *Distribution_BucketOptions_Exponential {
	if x, ok := x.GetOptions().(*Distribution_BucketOptions_ExponentialBuckets); ok {
		return x.ExponentialBuckets
	}
	return nil
}

func (x *Distribution_BucketOptions) GetExplicitBuckets() *Distribution_BucketOptions_Explicit {
	if x, ok := x.GetOptions().(*Distribution_BucketOptions_ExplicitBuckets); ok {
		return x.ExplicitBuckets
	}
	return nil
}

func (x *Distribution_BucketOptions) GetLinearBuckets() *Distribution_BucketOptions_Linear {
	if x, ok := x.GetOptions().(*Distribution_BucketOptions_LinearBuckets); ok {
		return x.LinearBuckets
	}
	return nil
}

type isDistribution_BucketOptions_Options interface {
	isDistribution_BucketOptions_Options()
}

type Distribution_BucketOptions_RegularBuckets struct {
	// Deprecated: Marked as deprecated in core/internal/monitor/tpuproto/tpu_metric_service.proto.
	RegularBuckets *Distribution_BucketOptions_Regular `protobuf:"bytes,1,opt,name=regular_buckets,json=regularBuckets,proto3,oneof"`
}

type Distribution_BucketOptions_ExponentialBuckets struct {
	ExponentialBuckets *Distribution_BucketOptions_Exponential `protobuf:"bytes,2,opt,name=exponential_buckets,json=exponentialBuckets,proto3,oneof"`
}

type Distribution_BucketOptions_ExplicitBuckets struct {
	ExplicitBuckets *Distribution_BucketOptions_Explicit `protobuf:"bytes,3,opt,name=explicit_buckets,json=explicitBuckets,proto3,oneof"`
}

type Distribution_BucketOptions_LinearBuckets struct {
	LinearBuckets *Distribution_BucketOptions_Linear `protobuf:"bytes,4,opt,name=linear_buckets,json=linearBuckets,proto3,oneof"`
}

func (*Distribution_BucketOptions_RegularBuckets) isDistribution_BucketOptions_Options() {}

func (*Distribution_BucketOptions_ExponentialBuckets) isDistribution_BucketOptions_Options() {}

func (*Distribution_BucketOptions_ExplicitBuckets) isDistribution_BucketOptions_Options() {}

func (*Distribution_BucketOptions_LinearBuckets) isDistribution_BucketOptions_Options() {}

// Deprecated: Marked as deprecated in core/internal/monitor/tpuproto/tpu_metric_service.proto.
type Distribution_BucketOptions_Regular struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// A linear distribution has only one bound with overall width and offset
	// of the lowest bucket.
	// An explicit distribution will have monotonically increasing buckets
	// with width and the offset from the previous bucket.
	Bounds []*Distribution_BucketOptions_Bound `protobuf:"bytes,2,rep,name=bounds,proto3" json:"bounds,omitempty"`
}

func (x *Distribution_BucketOptions_Regular) Reset() {
	*x = Distribution_BucketOptions_Regular{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution_BucketOptions_Regular) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution_BucketOptions_Regular) ProtoMessage() {}

func (x *Distribution_BucketOptions_Regular) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution_BucketOptions_Regular.ProtoReflect.Descriptor instead.
func (*Distribution_BucketOptions_Regular) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *Distribution_BucketOptions_Regular) GetNumFiniteBuckets() int32 {
	if x != nil {
		return x.NumFiniteBuckets
	}
	return 0
}

func (x *Distribution_BucketOptions_Regular) GetBounds() []*Distribution_BucketOptions_Bound {
	if x != nil {
		return x.Bounds
	}
	return nil
}

type Distribution_BucketOptions_Exponential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 1.
	GrowthFactor float64 `protobuf:"fixed64,2,opt,name=growth_factor,json=growthFactor,proto3" json:"growth_factor,omitempty"`
	// Must be greater than 0.
	Scale float64 `protobuf:"fixed64,3,opt,name=scale,proto3" json:"scale,omitempty"`
}

func (x *Distribution_BucketOptions_Exponential) Reset() {
	*x = Distribution_BucketOptions_Exponential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution_BucketOptions_Exponential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution_BucketOptions_Exponential) ProtoMessage() {}

func (x *Distribution_BucketOptions_Exponential) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution_BucketOptions_Exponential.ProtoReflect.Descriptor instead.
func (*Distribution_BucketOptions_Exponential) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *Distribution_BucketOptions_Exponential) GetNumFiniteBuckets() int32 {
	if x != nil {
		return x.NumFiniteBuckets
	}
	return 0
}

func (x *Distribution_BucketOptions_Exponential) GetGrowthFactor() float64 {
	if x != nil {
		return x.GrowthFactor
	}
	return 0
}

func (x *Distribution_BucketOptions_Exponential) GetScale() float64 {
	if x != nil {
		return x.Scale
	}
	return 0
}

// Deprecated: Marked as deprecated in core/internal/monitor/tpuproto/tpu_metric_service.proto.
type Distribution_BucketOptions_Bound struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Width  float64 `protobuf:"fixed64,1,opt,name=width,proto3" json:"width,omitempty"`
	Offset float64 `protobuf:"fixed64,2,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *Distribution_BucketOptions_Bound) Reset() {
	*x = Distribution_BucketOptions_Bound{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution_BucketOptions_Bound) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution_BucketOptions_Bound) ProtoMessage() {}

func (x *Distribution_BucketOptions_Bound) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution_BucketOptions_Bound.ProtoReflect.Descriptor instead.
func (*Distribution_BucketOptions_Bound) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1, 0, 2}
}

func (x *Distribution_BucketOptions_Bound) GetWidth() float64 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *Distribution_BucketOptions_Bound) GetOffset() float64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Specifies a linear sequence of buckets that all have the same width
// (except overflow and underflow). Each bucket represents a constant
// absolute uncertainty on the specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
// following boundaries:
//
//	Upper bound (0 <= i < N-1):     offset + (width * i).
//
//	Lower bound (1 <= i < N):       offset + (width * (i - 1)).
type Distribution_BucketOptions_Linear struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 0.
	Width float64 `protobuf:"fixed64,2,opt,name=width,proto3" json:"width,omitempty"`
	// Lower bound of the first bucket.
	Offset float64 `protobuf:"fixed64,3,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *Distribution_BucketOptions_Linear) Reset() {
	*x = Distribution_BucketOptions_Linear{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution_BucketOptions_Linear) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution_BucketOptions_Linear) ProtoMessage() {}

func (x *Distribution_BucketOptions_Linear) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution_BucketOptions_Linear.ProtoReflect.Descriptor instead.
func (*Distribution_BucketOptions_Linear) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1, 0, 3}
}

func (x *Distribution_BucketOptions_Linear) GetNumFiniteBuckets() int32 {
	if x != nil {
		return x.NumFiniteBuckets
	}
	return 0
}

func (x *Distribution_BucketOptions_Linear) GetWidth() float64 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *Distribution_BucketOptions_Linear) GetOffset() float64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Specifies a set of buckets with arbitrary widths.
//
// There are `size(bounds) + 1` (= N) buckets. Bucket `i` has the following
// boundaries:
//
//	Upper bound (0 <= i < N-1):     bounds[i]
//	Lower bound (1 <= i < N);       bounds[i - 1]
//
// The `bounds` field must contain at least one element. If `bounds` has
// only one element, then there are no finite buckets, and that single
// element is the common boundary of the overflow and underflow buckets.
type Distribution_BucketOptions_Explicit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The values must be monotonically increasing.
	Bounds []float64 `protobuf:"fixed64,1,rep,packed,name=bounds,proto3" json:"bounds,omitempty"`
}

func (x *Distribution_BucketOptions_Explicit) Reset() {
	*x = Distribution_BucketOptions_Explicit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution_BucketOptions_Explicit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution_BucketOptions_Explicit) ProtoMessage() {}

func (x *Distribution_BucketOptions_Explicit) ProtoReflect() protoreflect.Message {
	mi := &file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution_BucketOptions_Explicit.ProtoReflect.Descriptor instead.
func (*Distribution_BucketOptions_Explicit) Descriptor() ([]byte, []int) {
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP(), []int{1, 0, 4}
}

func (x *Distribution_BucketOptions_Explicit) GetBounds() []float64 {
	if x != nil {
		return x.Bounds
	}
	return nil
}

var File_core_internal_monitor_tpuproto_tpu_metric_service_proto protoreflect.FileDescriptor

var file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDesc = []byte{
	0x0a, 0x37, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2f, 0x74, 0x70, 0x75, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x74, 0x70, 0x75, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x74, 0x70, 0x75, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x9d, 0x01, 0x0a, 0x08, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x41, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x22, 0xeb, 0x09, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x65, 0x61,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x12, 0x10, 0x0a,
	0x03, 0x6d, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12,
	0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x6d, 0x61,
	0x78, 0x12, 0x37, 0x0a, 0x18, 0x73, 0x75, 0x6d, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x71, 0x75, 0x61,
	0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x15, 0x73, 0x75, 0x6d, 0x4f, 0x66, 0x53, 0x71, 0x75, 0x61, 0x72, 0x65,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0e, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0c, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x09, 0x65, 0x78,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52,
	0x09, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x1a, 0x93, 0x07, 0x0a, 0x0d, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x69, 0x0a, 0x0f,
	0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61,
	0x72, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x71, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x68, 0x0a, 0x10, 0x65, 0x78,
	0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69,
	0x74, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x12, 0x62, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x5f, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x74,
	0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x72, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x8d, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x67,
	0x75, 0x6c, 0x61, 0x72, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x10, 0x6e, 0x75, 0x6d, 0x46, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x12, 0x50, 0x0a, 0x06, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x06, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x76, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x10, 0x6e, 0x75, 0x6d, 0x46, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x67, 0x72, 0x6f, 0x77, 0x74, 0x68, 0x5f,
	0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x67, 0x72,
	0x6f, 0x77, 0x74, 0x68, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63,
	0x61, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65,
	0x1a, 0x39, 0x0a, 0x05, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12,
	0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x64, 0x0a, 0x06, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x72, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x10, 0x6e, 0x75, 0x6d, 0x46, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x1a, 0x22, 0x0a, 0x08, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x52, 0x06, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x82, 0x01, 0x0a, 0x05, 0x47, 0x61, 0x75, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x73,
	0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52,
	0x08, 0x61, 0x73, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x06, 0x61, 0x73, 0x5f,
	0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x61, 0x73, 0x49,
	0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x73, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x61, 0x73, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x12, 0x19, 0x0a, 0x07, 0x61, 0x73, 0x5f, 0x62, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x61, 0x73, 0x42, 0x6f, 0x6f, 0x6c, 0x42, 0x07, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x07, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x73, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x08, 0x61, 0x73, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x12, 0x17, 0x0a, 0x06, 0x61, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x48, 0x00, 0x52, 0x05, 0x61, 0x73, 0x49, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x08, 0x65, 0x78, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x70,
	0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52, 0x08, 0x65,
	0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x3c, 0x0a, 0x08, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08,
	0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8f,
	0x01, 0x0a, 0x0d, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x75,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53,
	0x75, 0x6d, 0x12, 0x3c, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x51, 0x75,
	0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65,
	0x22, 0xc8, 0x02, 0x0a, 0x09, 0x41, 0x74, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21,
	0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x74, 0x74,
	0x72, 0x12, 0x1d, 0x0a, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x6c, 0x41, 0x74, 0x74, 0x72,
	0x12, 0x1b, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x07, 0x69, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x12, 0x21, 0x0a,
	0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x41, 0x74, 0x74, 0x72,
	0x12, 0x47, 0x0a, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x41, 0x74, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09,
	0x61, 0x72, 0x72, 0x61, 0x79, 0x41, 0x74, 0x74, 0x72, 0x12, 0x47, 0x0a, 0x0b, 0x6b, 0x76, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6b, 0x76, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x74,
	0x74, 0x72, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x74, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x41,
	0x74, 0x74, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x61, 0x74, 0x74, 0x72, 0x22, 0x49, 0x0a, 0x0e, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x41, 0x74, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a,
	0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74,
	0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x22, 0x51, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x70, 0x75,
	0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0x56, 0x0a, 0x09, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x37, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x91, 0x03, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x3f, 0x0a, 0x09,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x38, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x35, 0x0a, 0x05, 0x67, 0x61, 0x75, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x47, 0x61, 0x75, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x67, 0x61, 0x75, 0x67, 0x65, 0x12, 0x3b,
	0x0a, 0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48,
	0x00, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x22, 0x7b, 0x0a, 0x09, 0x54, 0x50, 0x55, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x70, 0x75, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x22, 0x64, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x6b, 0x69, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4b, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x70, 0x75,
	0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x54, 0x50, 0x55, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x35, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x32, 0x0a, 0x0f,
	0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12,
	0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x72, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x52, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x70, 0x75,
	0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x0f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x32, 0xfd, 0x01, 0x0a, 0x14, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x61, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x25, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x81, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x33, 0x2e, 0x74, 0x70, 0x75, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x74, 0x70, 0x75, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x42, 0x37, 0x5a, 0x35, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x77, 0x61, 0x6e, 0x64, 0x62, 0x2f, 0x77, 0x61, 0x6e, 0x64, 0x62, 0x2f, 0x63,
	0x6f, 0x72, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x2f, 0x74, 0x70, 0x75, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescOnce sync.Once
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescData = file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDesc
)

func file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescGZIP() []byte {
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescOnce.Do(func() {
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescData)
	})
	return file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDescData
}

var file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_core_internal_monitor_tpuproto_tpu_metric_service_proto_goTypes = []interface{}{
	(*Exemplar)(nil),                               // 0: tpu.monitoring.runtime.Exemplar
	(*Distribution)(nil),                           // 1: tpu.monitoring.runtime.Distribution
	(*Gauge)(nil),                                  // 2: tpu.monitoring.runtime.Gauge
	(*Counter)(nil),                                // 3: tpu.monitoring.runtime.Counter
	(*Quantile)(nil),                               // 4: tpu.monitoring.runtime.Quantile
	(*SummaryMetric)(nil),                          // 5: tpu.monitoring.runtime.SummaryMetric
	(*AttrValue)(nil),                              // 6: tpu.monitoring.runtime.AttrValue
	(*ArrayAttrValue)(nil),                         // 7: tpu.monitoring.runtime.ArrayAttrValue
	(*KeyValueList)(nil),                           // 8: tpu.monitoring.runtime.KeyValueList
	(*Attribute)(nil),                              // 9: tpu.monitoring.runtime.Attribute
	(*Metric)(nil),                                 // 10: tpu.monitoring.runtime.Metric
	(*TPUMetric)(nil),                              // 11: tpu.monitoring.runtime.TPUMetric
	(*MetricRequest)(nil),                          // 12: tpu.monitoring.runtime.MetricRequest
	(*MetricResponse)(nil),                         // 13: tpu.monitoring.runtime.MetricResponse
	(*ListSupportedMetricsRequest)(nil),            // 14: tpu.monitoring.runtime.ListSupportedMetricsRequest
	(*SupportedMetric)(nil),                        // 15: tpu.monitoring.runtime.SupportedMetric
	(*ListSupportedMetricsResponse)(nil),           // 16: tpu.monitoring.runtime.ListSupportedMetricsResponse
	(*Distribution_BucketOptions)(nil),             // 17: tpu.monitoring.runtime.Distribution.BucketOptions
	(*Distribution_BucketOptions_Regular)(nil),     // 18: tpu.monitoring.runtime.Distribution.BucketOptions.Regular
	(*Distribution_BucketOptions_Exponential)(nil), // 19: tpu.monitoring.runtime.Distribution.BucketOptions.Exponential
	(*Distribution_BucketOptions_Bound)(nil),       // 20: tpu.monitoring.runtime.Distribution.BucketOptions.Bound
	(*Distribution_BucketOptions_Linear)(nil),      // 21: tpu.monitoring.runtime.Distribution.BucketOptions.Linear
	(*Distribution_BucketOptions_Explicit)(nil),    // 22: tpu.monitoring.runtime.Distribution.BucketOptions.Explicit
	(*timestamppb.Timestamp)(nil),                  // 23: google.protobuf.Timestamp
}
var file_core_internal_monitor_tpuproto_tpu_metric_service_proto_depIdxs = []int32{
	23, // 0: tpu.monitoring.runtime.Exemplar.timestamp:type_name -> google.protobuf.Timestamp
	9,  // 1: tpu.monitoring.runtime.Exemplar.attributes:type_name -> tpu.monitoring.runtime.Attribute
	17, // 2: tpu.monitoring.runtime.Distribution.bucket_options:type_name -> tpu.monitoring.runtime.Distribution.BucketOptions
	0,  // 3: tpu.monitoring.runtime.Distribution.exemplars:type_name -> tpu.monitoring.runtime.Exemplar
	0,  // 4: tpu.monitoring.runtime.Counter.exemplar:type_name -> tpu.monitoring.runtime.Exemplar
	4,  // 5: tpu.monitoring.runtime.SummaryMetric.quantile:type_name -> tpu.monitoring.runtime.Quantile
	7,  // 6: tpu.monitoring.runtime.AttrValue.array_attr:type_name -> tpu.monitoring.runtime.ArrayAttrValue
	8,  // 7: tpu.monitoring.runtime.AttrValue.kvlist_attr:type_name -> tpu.monitoring.runtime.KeyValueList
	6,  // 8: tpu.monitoring.runtime.ArrayAttrValue.attrs:type_name -> tpu.monitoring.runtime.AttrValue
	9,  // 9: tpu.monitoring.runtime.KeyValueList.attributes:type_name -> tpu.monitoring.runtime.Attribute
	6,  // 10: tpu.monitoring.runtime.Attribute.value:type_name -> tpu.monitoring.runtime.AttrValue
	9,  // 11: tpu.monitoring.runtime.Metric.attribute:type_name -> tpu.monitoring.runtime.Attribute
	23, // 12: tpu.monitoring.runtime.Metric.timestamp:type_name -> google.protobuf.Timestamp
	2,  // 13: tpu.monitoring.runtime.Metric.gauge:type_name -> tpu.monitoring.runtime.Gauge
	3,  // 14: tpu.monitoring.runtime.Metric.counter:type_name -> tpu.monitoring.runtime.Counter
	1,  // 15: tpu.monitoring.runtime.Metric.distribution:type_name -> tpu.monitoring.runtime.Distribution
	5,  // 16: tpu.monitoring.runtime.Metric.summary:type_name -> tpu.monitoring.runtime.SummaryMetric
	10, // 17: tpu.monitoring.runtime.TPUMetric.metrics:type_name -> tpu.monitoring.runtime.Metric
	11, // 18: tpu.monitoring.runtime.MetricResponse.metric:type_name -> tpu.monitoring.runtime.TPUMetric
	15, // 19: tpu.monitoring.runtime.ListSupportedMetricsResponse.supported_metric:type_name -> tpu.monitoring.runtime.SupportedMetric
	18, // 20: tpu.monitoring.runtime.Distribution.BucketOptions.regular_buckets:type_name -> tpu.monitoring.runtime.Distribution.BucketOptions.Regular
	19, // 21: tpu.monitoring.runtime.Distribution.BucketOptions.exponential_buckets:type_name -> tpu.monitoring.runtime.Distribution.BucketOptions.Exponential
	22, // 22: tpu.monitoring.runtime.Distribution.BucketOptions.explicit_buckets:type_name -> tpu.monitoring.runtime.Distribution.BucketOptions.Explicit
	21, // 23: tpu.monitoring.runtime.Distribution.BucketOptions.linear_buckets:type_name -> tpu.monitoring.runtime.Distribution.BucketOptions.Linear
	20, // 24: tpu.monitoring.runtime.Distribution.BucketOptions.Regular.bounds:type_name -> tpu.monitoring.runtime.Distribution.BucketOptions.Bound
	12, // 25: tpu.monitoring.runtime.RuntimeMetricService.GetRuntimeMetric:input_type -> tpu.monitoring.runtime.MetricRequest
	14, // 26: tpu.monitoring.runtime.RuntimeMetricService.ListSupportedMetrics:input_type -> tpu.monitoring.runtime.ListSupportedMetricsRequest
	13, // 27: tpu.monitoring.runtime.RuntimeMetricService.GetRuntimeMetric:output_type -> tpu.monitoring.runtime.MetricResponse
	16, // 28: tpu.monitoring.runtime.RuntimeMetricService.ListSupportedMetrics:output_type -> tpu.monitoring.runtime.ListSupportedMetricsResponse
	27, // [27:29] is the sub-list for method output_type
	25, // [25:27] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_core_internal_monitor_tpuproto_tpu_metric_service_proto_init() }
func file_core_internal_monitor_tpuproto_tpu_metric_service_proto_init() {
	if File_core_internal_monitor_tpuproto_tpu_metric_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Exemplar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Gauge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Counter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Quantile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SummaryMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttrValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArrayAttrValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValueList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TPUMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSupportedMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportedMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSupportedMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution_BucketOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution_BucketOptions_Regular); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution_BucketOptions_Exponential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution_BucketOptions_Bound); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution_BucketOptions_Linear); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution_BucketOptions_Explicit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Gauge_AsDouble)(nil),
		(*Gauge_AsInt)(nil),
		(*Gauge_AsString)(nil),
		(*Gauge_AsBool)(nil),
	}
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Counter_AsDouble)(nil),
		(*Counter_AsInt)(nil),
	}
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*AttrValue_StringAttr)(nil),
		(*AttrValue_BoolAttr)(nil),
		(*AttrValue_IntAttr)(nil),
		(*AttrValue_DoubleAttr)(nil),
		(*AttrValue_ArrayAttr)(nil),
		(*AttrValue_KvlistAttr)(nil),
		(*AttrValue_BytesAttr)(nil),
	}
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*Metric_Gauge)(nil),
		(*Metric_Counter)(nil),
		(*Metric_Distribution)(nil),
		(*Metric_Summary)(nil),
	}
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*Distribution_BucketOptions_RegularBuckets)(nil),
		(*Distribution_BucketOptions_ExponentialBuckets)(nil),
		(*Distribution_BucketOptions_ExplicitBuckets)(nil),
		(*Distribution_BucketOptions_LinearBuckets)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_core_internal_monitor_tpuproto_tpu_metric_service_proto_goTypes,
		DependencyIndexes: file_core_internal_monitor_tpuproto_tpu_metric_service_proto_depIdxs,
		MessageInfos:      file_core_internal_monitor_tpuproto_tpu_metric_service_proto_msgTypes,
	}.Build()
	File_core_internal_monitor_tpuproto_tpu_metric_service_proto = out.File
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_rawDesc = nil
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_goTypes = nil
	file_core_internal_monitor_tpuproto_tpu_metric_service_proto_depIdxs = nil
}
