// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.29.3
// source: core/internal/monitor/tpuproto/tpu_metric_service.proto

package tpuproto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RuntimeMetricService_GetRuntimeMetric_FullMethodName     = "/tpu.monitoring.runtime.RuntimeMetricService/GetRuntimeMetric"
	RuntimeMetricService_ListSupportedMetrics_FullMethodName = "/tpu.monitoring.runtime.RuntimeMetricService/ListSupportedMetrics"
)

// RuntimeMetricServiceClient is the client API for RuntimeMetricService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RuntimeMetricServiceClient interface {
	// GetRuntimeMetric returns the TPU metrics data for the MetricRequest.
	GetRuntimeMetric(ctx context.Context, in *MetricRequest, opts ...grpc.CallOption) (*MetricResponse, error)
	// ListSupportedMetrics lists the supported metrics for
	// ListSupportedMetricsRequest.
	ListSupportedMetrics(ctx context.Context, in *ListSupportedMetricsRequest, opts ...grpc.CallOption) (*ListSupportedMetricsResponse, error)
}

type runtimeMetricServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRuntimeMetricServiceClient(cc grpc.ClientConnInterface) RuntimeMetricServiceClient {
	return &runtimeMetricServiceClient{cc}
}

func (c *runtimeMetricServiceClient) GetRuntimeMetric(ctx context.Context, in *MetricRequest, opts ...grpc.CallOption) (*MetricResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MetricResponse)
	err := c.cc.Invoke(ctx, RuntimeMetricService_GetRuntimeMetric_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeMetricServiceClient) ListSupportedMetrics(ctx context.Context, in *ListSupportedMetricsRequest, opts ...grpc.CallOption) (*ListSupportedMetricsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSupportedMetricsResponse)
	err := c.cc.Invoke(ctx, RuntimeMetricService_ListSupportedMetrics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RuntimeMetricServiceServer is the server API for RuntimeMetricService service.
// All implementations must embed UnimplementedRuntimeMetricServiceServer
// for forward compatibility.
type RuntimeMetricServiceServer interface {
	// GetRuntimeMetric returns the TPU metrics data for the MetricRequest.
	GetRuntimeMetric(context.Context, *MetricRequest) (*MetricResponse, error)
	// ListSupportedMetrics lists the supported metrics for
	// ListSupportedMetricsRequest.
	ListSupportedMetrics(context.Context, *ListSupportedMetricsRequest) (*ListSupportedMetricsResponse, error)
	mustEmbedUnimplementedRuntimeMetricServiceServer()
}

// UnimplementedRuntimeMetricServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRuntimeMetricServiceServer struct{}

func (UnimplementedRuntimeMetricServiceServer) GetRuntimeMetric(context.Context, *MetricRequest) (*MetricResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRuntimeMetric not implemented")
}
func (UnimplementedRuntimeMetricServiceServer) ListSupportedMetrics(context.Context, *ListSupportedMetricsRequest) (*ListSupportedMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSupportedMetrics not implemented")
}
func (UnimplementedRuntimeMetricServiceServer) mustEmbedUnimplementedRuntimeMetricServiceServer() {}
func (UnimplementedRuntimeMetricServiceServer) testEmbeddedByValue()                              {}

// UnsafeRuntimeMetricServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RuntimeMetricServiceServer will
// result in compilation errors.
type UnsafeRuntimeMetricServiceServer interface {
	mustEmbedUnimplementedRuntimeMetricServiceServer()
}

func RegisterRuntimeMetricServiceServer(s grpc.ServiceRegistrar, srv RuntimeMetricServiceServer) {
	// If the following call pancis, it indicates UnimplementedRuntimeMetricServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RuntimeMetricService_ServiceDesc, srv)
}

func _RuntimeMetricService_GetRuntimeMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeMetricServiceServer).GetRuntimeMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RuntimeMetricService_GetRuntimeMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeMetricServiceServer).GetRuntimeMetric(ctx, req.(*MetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeMetricService_ListSupportedMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSupportedMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeMetricServiceServer).ListSupportedMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RuntimeMetricService_ListSupportedMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeMetricServiceServer).ListSupportedMetrics(ctx, req.(*ListSupportedMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RuntimeMetricService_ServiceDesc is the grpc.ServiceDesc for RuntimeMetricService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RuntimeMetricService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "tpu.monitoring.runtime.RuntimeMetricService",
	HandlerType: (*RuntimeMetricServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRuntimeMetric",
			Handler:    _RuntimeMetricService_GetRuntimeMetric_Handler,
		},
		{
			MethodName: "ListSupportedMetrics",
			Handler:    _RuntimeMetricService_ListSupportedMetrics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "core/internal/monitor/tpuproto/tpu_metric_service.proto",
}
