// Code generated by Wire. DO NOT EDIT.

//go:generate go run -mod=mod github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package runsync

import (
	"github.com/google/wire"
	"github.com/wandb/wandb/core/internal/api"
	"github.com/wandb/wandb/core/internal/featurechecker"
	"github.com/wandb/wandb/core/internal/filestream"
	"github.com/wandb/wandb/core/internal/filetransfer"
	"github.com/wandb/wandb/core/internal/mailbox"
	"github.com/wandb/wandb/core/internal/observability"
	"github.com/wandb/wandb/core/internal/runfiles"
	"github.com/wandb/wandb/core/internal/runhandle"
	"github.com/wandb/wandb/core/internal/settings"
	"github.com/wandb/wandb/core/internal/sharedmode"
	"github.com/wandb/wandb/core/internal/stream"
	"github.com/wandb/wandb/core/internal/tensorboard"
	"github.com/wandb/wandb/core/internal/watcher"
	"github.com/wandb/wandb/core/internal/wboperation"
	"log/slog"
)

// Injectors from wire.go:

func InjectRunSyncerFactory(settings2 *settings.Settings) *RunSyncerFactory {
	coreLogger := todoLogger()
	wandbOperations := wboperation.NewOperations()
	printer := observability.NewPrinter()
	backend := stream.NewBackend(coreLogger, settings2)
	peeker := &observability.Peeker{}
	clientID := sharedmode.RandomClientID()
	client := stream.NewGraphQLClient(backend, settings2, peeker, clientID)
	serverFeaturesCache := featurechecker.NewServerFeaturesCache(client, coreLogger)
	runHandle := runhandle.New()
	recordParserFactory := &stream.RecordParserFactory{
		FeatureProvider:    serverFeaturesCache,
		GraphqlClientOrNil: client,
		Logger:             coreLogger,
		Operations:         wandbOperations,
		RunHandle:          runHandle,
		ClientID:           clientID,
		Settings:           settings2,
	}
	runReaderFactory := &RunReaderFactory{
		Logger: coreLogger,
	}
	fileStreamFactory := &filestream.FileStreamFactory{
		Logger:     coreLogger,
		Operations: wandbOperations,
		Printer:    printer,
		Settings:   settings2,
	}
	fileTransferStats := filetransfer.NewFileTransferStats()
	fileTransferManager := stream.NewFileTransferManager(fileTransferStats, coreLogger, settings2)
	watcher := provideFileWatcher(coreLogger)
	uploaderFactory := &runfiles.UploaderFactory{
		FileTransfer: fileTransferManager,
		FileWatcher:  watcher,
		GraphQL:      client,
		Logger:       coreLogger,
		Operations:   wandbOperations,
		RunHandle:    runHandle,
		Settings:     settings2,
	}
	mailboxMailbox := mailbox.New()
	senderFactory := &stream.SenderFactory{
		ClientID:                clientID,
		Logger:                  coreLogger,
		Operations:              wandbOperations,
		Settings:                settings2,
		Backend:                 backend,
		FeatureProvider:         serverFeaturesCache,
		FileStreamFactory:       fileStreamFactory,
		FileTransferManager:     fileTransferManager,
		FileTransferStats:       fileTransferStats,
		FileWatcher:             watcher,
		RunfilesUploaderFactory: uploaderFactory,
		GraphqlClient:           client,
		Peeker:                  peeker,
		RunHandle:               runHandle,
		Mailbox:                 mailboxMailbox,
	}
	tbHandlerFactory := &tensorboard.TBHandlerFactory{
		Logger:   coreLogger,
		Settings: settings2,
	}
	runSyncerFactory := &RunSyncerFactory{
		Logger:              coreLogger,
		Operations:          wandbOperations,
		Printer:             printer,
		RecordParserFactory: recordParserFactory,
		RunReaderFactory:    runReaderFactory,
		SenderFactory:       senderFactory,
		TBHandlerFactory:    tbHandlerFactory,
	}
	return runSyncerFactory
}

// wire.go:

var runSyncerFactoryBindings = wire.NewSet(wire.Bind(new(api.Peeker), new(*observability.Peeker)), wire.Struct(new(observability.Peeker)), featurechecker.NewServerFeaturesCache, filestream.FileStreamProviders, filetransfer.NewFileTransferStats, mailbox.New, observability.NewPrinter, provideFileWatcher, runfiles.UploaderProviders, runhandle.New, runReaderProviders,
	runSyncerProviders, sharedmode.RandomClientID, stream.NewBackend, stream.NewFileTransferManager, stream.NewGraphQLClient, stream.RecordParserProviders, stream.SenderProviders, tensorboard.TBHandlerProviders, todoLogger, wboperation.NewOperations,
)

func todoLogger() *observability.CoreLogger {

	return observability.NewCoreLogger(slog.Default(), nil)
}

func provideFileWatcher(logger *observability.CoreLogger) watcher.Watcher {
	return watcher.New(watcher.Params{Logger: logger})
}
