// Code generated by Wire. DO NOT EDIT.

//go:generate go run -mod=mod github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package stream

import (
	"github.com/google/wire"
	"github.com/wandb/wandb/core/internal/api"
	"github.com/wandb/wandb/core/internal/featurechecker"
	"github.com/wandb/wandb/core/internal/filestream"
	"github.com/wandb/wandb/core/internal/filetransfer"
	"github.com/wandb/wandb/core/internal/mailbox"
	"github.com/wandb/wandb/core/internal/monitor"
	"github.com/wandb/wandb/core/internal/observability"
	"github.com/wandb/wandb/core/internal/runfiles"
	"github.com/wandb/wandb/core/internal/runhandle"
	"github.com/wandb/wandb/core/internal/sentry_ext"
	"github.com/wandb/wandb/core/internal/settings"
	"github.com/wandb/wandb/core/internal/sharedmode"
	"github.com/wandb/wandb/core/internal/tensorboard"
	"github.com/wandb/wandb/core/internal/watcher"
	"github.com/wandb/wandb/core/internal/wboperation"
	"log/slog"
)

// Injectors from streaminject.go:

// InjectStream returns a new Stream.
func InjectStream(commit GitCommitHash, gpuResourceManager *monitor.GPUResourceManager, debugCorePath DebugCorePath, logLevel slog.Level, sentry *sentry_ext.Client, settings2 *settings.Settings) *Stream {
	clientID := sharedmode.RandomClientID()
	streamStreamLoggerFile := openStreamLoggerFile(settings2)
	coreLogger := streamLogger(streamStreamLoggerFile, settings2, sentry, logLevel)
	backend := NewBackend(coreLogger, settings2)
	peeker := &observability.Peeker{}
	client := NewGraphQLClient(backend, settings2, peeker, clientID)
	serverFeaturesCache := featurechecker.NewServerFeaturesCache(client, coreLogger)
	flowControlFactory := &FlowControlFactory{
		Logger: coreLogger,
	}
	fileTransferStats := filetransfer.NewFileTransferStats()
	mailboxMailbox := mailbox.New()
	wandbOperations := wboperation.NewOperations()
	runHandle := runhandle.New()
	systemMonitorFactory := &monitor.SystemMonitorFactory{
		Logger:             coreLogger,
		RunHandle:          runHandle,
		Settings:           settings2,
		GpuResourceManager: gpuResourceManager,
		GraphqlClient:      client,
		WriterID:           clientID,
	}
	printer := observability.NewPrinter()
	handlerFactory := &HandlerFactory{
		Commit:               commit,
		FileTransferStats:    fileTransferStats,
		Logger:               coreLogger,
		Mailbox:              mailboxMailbox,
		Operations:           wandbOperations,
		Settings:             settings2,
		SystemMonitorFactory: systemMonitorFactory,
		TerminalPrinter:      printer,
	}
	recordParserFactory := &RecordParserFactory{
		FeatureProvider:    serverFeaturesCache,
		GraphqlClientOrNil: client,
		Logger:             coreLogger,
		Operations:         wandbOperations,
		RunHandle:          runHandle,
		ClientID:           clientID,
		Settings:           settings2,
	}
	fileStreamFactory := &filestream.FileStreamFactory{
		Logger:     coreLogger,
		Operations: wandbOperations,
		Printer:    printer,
		Settings:   settings2,
	}
	fileTransferManager := NewFileTransferManager(fileTransferStats, coreLogger, settings2)
	watcher := provideFileWatcher(coreLogger)
	uploaderFactory := &runfiles.UploaderFactory{
		FileTransfer: fileTransferManager,
		FileWatcher:  watcher,
		GraphQL:      client,
		Logger:       coreLogger,
		Operations:   wandbOperations,
		RunHandle:    runHandle,
		Settings:     settings2,
	}
	senderFactory := &SenderFactory{
		ClientID:                clientID,
		Logger:                  coreLogger,
		Operations:              wandbOperations,
		Settings:                settings2,
		Backend:                 backend,
		FeatureProvider:         serverFeaturesCache,
		FileStreamFactory:       fileStreamFactory,
		FileTransferManager:     fileTransferManager,
		FileTransferStats:       fileTransferStats,
		FileWatcher:             watcher,
		RunfilesUploaderFactory: uploaderFactory,
		GraphqlClient:           client,
		Peeker:                  peeker,
		RunHandle:               runHandle,
		Mailbox:                 mailboxMailbox,
	}
	tbHandlerFactory := &tensorboard.TBHandlerFactory{
		Logger:   coreLogger,
		Settings: settings2,
	}
	writerFactory := &WriterFactory{
		Logger:   coreLogger,
		Settings: settings2,
	}
	stream := NewStream(clientID, debugCorePath, serverFeaturesCache, flowControlFactory, client, handlerFactory, streamStreamLoggerFile, coreLogger, wandbOperations, recordParserFactory, senderFactory, sentry, settings2, runHandle, tbHandlerFactory, writerFactory)
	return stream
}

// streaminject.go:

var streamProviders = wire.NewSet(
	NewStream, wire.Bind(new(api.Peeker), new(*observability.Peeker)), wire.Struct(new(observability.Peeker)), featurechecker.NewServerFeaturesCache, filestream.FileStreamProviders, filetransfer.NewFileTransferStats, flowControlProviders,
	handlerProviders, mailbox.New, monitor.SystemMonitorProviders, NewBackend,
	NewFileTransferManager,
	NewGraphQLClient, observability.NewPrinter, provideFileWatcher,
	RecordParserProviders, runfiles.UploaderProviders, runhandle.New, SenderProviders, sharedmode.RandomClientID, streamLoggerProviders, tensorboard.TBHandlerProviders, wboperation.NewOperations, WriterProviders,
)

func provideFileWatcher(logger *observability.CoreLogger) watcher.Watcher {
	return watcher.New(watcher.Params{Logger: logger})
}
