# Generated by ariadne-codegen
# Source: tools/graphql_codegen/automations/

__all__ = [
    "CREATE_AUTOMATION_GQL",
    "CREATE_GENERIC_WEBHOOK_INTEGRATION_GQL",
    "DELETE_AUTOMATION_GQL",
    "GENERIC_WEBHOOK_INTEGRATIONS_BY_ENTITY_GQL",
    "GET_AUTOMATIONS_BY_ENTITY_GQL",
    "GET_AUTOMATIONS_GQL",
    "INTEGRATIONS_BY_ENTITY_GQL",
    "SLACK_INTEGRATIONS_BY_ENTITY_GQL",
    "UPDATE_AUTOMATION_GQL",
]

GET_AUTOMATIONS_GQL = """
query GetAutomations($cursor: String, $perPage: Int) {
  searchScope: viewer {
    projects(after: $cursor, first: $perPage) {
      ...ProjectConnectionFields
    }
  }
}

fragment ArtifactPortfolioScopeFields on ArtifactPortfolio {
  __typename
  id
  name
}

fragment ArtifactSequenceScopeFields on ArtifactSequence {
  __typename
  id
  name
}

fragment FilterEventFields on FilterEventTriggeringCondition {
  __typename
  eventType
  filter
}

fragment GenericWebhookActionFields on GenericWebhookTriggeredAction {
  __typename
  integration {
    __typename
    ...GenericWebhookIntegrationFields
  }
  requestPayload
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}

fragment NoOpActionFields on NoOpTriggeredAction {
  __typename
  noOp
}

fragment NotificationActionFields on NotificationTriggeredAction {
  __typename
  integration {
    __typename
    ...SlackIntegrationFields
  }
  title
  message
  severity
}

fragment PageInfoFields on PageInfo {
  endCursor
  hasNextPage
}

fragment ProjectConnectionFields on ProjectConnection {
  __typename
  pageInfo {
    ...PageInfoFields
  }
  edges {
    cursor
    node {
      triggers {
        ...TriggerFields
      }
    }
  }
}

fragment ProjectScopeFields on Project {
  __typename
  id
  name
}

fragment QueueJobActionFields on QueueJobTriggeredAction {
  __typename
  queue {
    id
    name
  }
  template
}

fragment SlackIntegrationFields on SlackIntegration {
  __typename
  id
  teamName
  channelName
}

fragment TriggerFields on Trigger {
  __typename
  id
  createdAt
  updatedAt
  name
  description
  enabled
  scope {
    __typename
    ...ProjectScopeFields
    ...ArtifactPortfolioScopeFields
    ...ArtifactSequenceScopeFields
  }
  event: triggeringCondition {
    __typename
    ...FilterEventFields
  }
  action: triggeredAction {
    __typename
    ...QueueJobActionFields
    ...NotificationActionFields
    ...GenericWebhookActionFields
    ...NoOpActionFields
  }
}
"""

GET_AUTOMATIONS_BY_ENTITY_GQL = """
query GetAutomationsByEntity($entityName: String!, $cursor: String, $perPage: Int) {
  searchScope: entity(name: $entityName) {
    projects(after: $cursor, first: $perPage) {
      ...ProjectConnectionFields
    }
  }
}

fragment ArtifactPortfolioScopeFields on ArtifactPortfolio {
  __typename
  id
  name
}

fragment ArtifactSequenceScopeFields on ArtifactSequence {
  __typename
  id
  name
}

fragment FilterEventFields on FilterEventTriggeringCondition {
  __typename
  eventType
  filter
}

fragment GenericWebhookActionFields on GenericWebhookTriggeredAction {
  __typename
  integration {
    __typename
    ...GenericWebhookIntegrationFields
  }
  requestPayload
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}

fragment NoOpActionFields on NoOpTriggeredAction {
  __typename
  noOp
}

fragment NotificationActionFields on NotificationTriggeredAction {
  __typename
  integration {
    __typename
    ...SlackIntegrationFields
  }
  title
  message
  severity
}

fragment PageInfoFields on PageInfo {
  endCursor
  hasNextPage
}

fragment ProjectConnectionFields on ProjectConnection {
  __typename
  pageInfo {
    ...PageInfoFields
  }
  edges {
    cursor
    node {
      triggers {
        ...TriggerFields
      }
    }
  }
}

fragment ProjectScopeFields on Project {
  __typename
  id
  name
}

fragment QueueJobActionFields on QueueJobTriggeredAction {
  __typename
  queue {
    id
    name
  }
  template
}

fragment SlackIntegrationFields on SlackIntegration {
  __typename
  id
  teamName
  channelName
}

fragment TriggerFields on Trigger {
  __typename
  id
  createdAt
  updatedAt
  name
  description
  enabled
  scope {
    __typename
    ...ProjectScopeFields
    ...ArtifactPortfolioScopeFields
    ...ArtifactSequenceScopeFields
  }
  event: triggeringCondition {
    __typename
    ...FilterEventFields
  }
  action: triggeredAction {
    __typename
    ...QueueJobActionFields
    ...NotificationActionFields
    ...GenericWebhookActionFields
    ...NoOpActionFields
  }
}
"""

CREATE_AUTOMATION_GQL = """
mutation CreateAutomation($input: CreateFilterTriggerInput!) {
  result: createFilterTrigger(input: $input) {
    ...CreateAutomationResult
  }
}

fragment ArtifactPortfolioScopeFields on ArtifactPortfolio {
  __typename
  id
  name
}

fragment ArtifactSequenceScopeFields on ArtifactSequence {
  __typename
  id
  name
}

fragment CreateAutomationResult on CreateFilterTriggerPayload {
  __typename
  trigger {
    ...TriggerFields
  }
}

fragment FilterEventFields on FilterEventTriggeringCondition {
  __typename
  eventType
  filter
}

fragment GenericWebhookActionFields on GenericWebhookTriggeredAction {
  __typename
  integration {
    __typename
    ...GenericWebhookIntegrationFields
  }
  requestPayload
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}

fragment NoOpActionFields on NoOpTriggeredAction {
  __typename
  noOp
}

fragment NotificationActionFields on NotificationTriggeredAction {
  __typename
  integration {
    __typename
    ...SlackIntegrationFields
  }
  title
  message
  severity
}

fragment ProjectScopeFields on Project {
  __typename
  id
  name
}

fragment QueueJobActionFields on QueueJobTriggeredAction {
  __typename
  queue {
    id
    name
  }
  template
}

fragment SlackIntegrationFields on SlackIntegration {
  __typename
  id
  teamName
  channelName
}

fragment TriggerFields on Trigger {
  __typename
  id
  createdAt
  updatedAt
  name
  description
  enabled
  scope {
    __typename
    ...ProjectScopeFields
    ...ArtifactPortfolioScopeFields
    ...ArtifactSequenceScopeFields
  }
  event: triggeringCondition {
    __typename
    ...FilterEventFields
  }
  action: triggeredAction {
    __typename
    ...QueueJobActionFields
    ...NotificationActionFields
    ...GenericWebhookActionFields
    ...NoOpActionFields
  }
}
"""

UPDATE_AUTOMATION_GQL = """
mutation UpdateAutomation($input: UpdateFilterTriggerInput!) {
  result: updateFilterTrigger(input: $input) {
    ...UpdateAutomationResult
  }
}

fragment ArtifactPortfolioScopeFields on ArtifactPortfolio {
  __typename
  id
  name
}

fragment ArtifactSequenceScopeFields on ArtifactSequence {
  __typename
  id
  name
}

fragment FilterEventFields on FilterEventTriggeringCondition {
  __typename
  eventType
  filter
}

fragment GenericWebhookActionFields on GenericWebhookTriggeredAction {
  __typename
  integration {
    __typename
    ...GenericWebhookIntegrationFields
  }
  requestPayload
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}

fragment NoOpActionFields on NoOpTriggeredAction {
  __typename
  noOp
}

fragment NotificationActionFields on NotificationTriggeredAction {
  __typename
  integration {
    __typename
    ...SlackIntegrationFields
  }
  title
  message
  severity
}

fragment ProjectScopeFields on Project {
  __typename
  id
  name
}

fragment QueueJobActionFields on QueueJobTriggeredAction {
  __typename
  queue {
    id
    name
  }
  template
}

fragment SlackIntegrationFields on SlackIntegration {
  __typename
  id
  teamName
  channelName
}

fragment TriggerFields on Trigger {
  __typename
  id
  createdAt
  updatedAt
  name
  description
  enabled
  scope {
    __typename
    ...ProjectScopeFields
    ...ArtifactPortfolioScopeFields
    ...ArtifactSequenceScopeFields
  }
  event: triggeringCondition {
    __typename
    ...FilterEventFields
  }
  action: triggeredAction {
    __typename
    ...QueueJobActionFields
    ...NotificationActionFields
    ...GenericWebhookActionFields
    ...NoOpActionFields
  }
}

fragment UpdateAutomationResult on UpdateFilterTriggerPayload {
  __typename
  trigger {
    ...TriggerFields
  }
}
"""

DELETE_AUTOMATION_GQL = """
mutation DeleteAutomation($id: ID!) {
  result: deleteTrigger(input: {triggerID: $id}) {
    ...DeleteAutomationResult
  }
}

fragment DeleteAutomationResult on DeleteTriggerPayload {
  __typename
  success
}
"""

INTEGRATIONS_BY_ENTITY_GQL = """
query IntegrationsByEntity($entityName: String!, $cursor: String, $perPage: Int) {
  entity(name: $entityName) {
    integrations(after: $cursor, first: $perPage) {
      ...IntegrationConnectionFields
    }
  }
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}

fragment IntegrationConnectionFields on IntegrationConnection {
  __typename
  pageInfo {
    ...PageInfoFields
  }
  edges {
    cursor
    node {
      __typename
      ...SlackIntegrationFields
      ...GenericWebhookIntegrationFields
    }
  }
}

fragment PageInfoFields on PageInfo {
  endCursor
  hasNextPage
}

fragment SlackIntegrationFields on SlackIntegration {
  __typename
  id
  teamName
  channelName
}
"""

SLACK_INTEGRATIONS_BY_ENTITY_GQL = """
query SlackIntegrationsByEntity($entityName: String!, $cursor: String, $perPage: Int) {
  entity(name: $entityName) {
    integrations(after: $cursor, first: $perPage) {
      ...SlackIntegrationConnectionFields
    }
  }
}

fragment PageInfoFields on PageInfo {
  endCursor
  hasNextPage
}

fragment SlackIntegrationConnectionFields on IntegrationConnection {
  __typename
  pageInfo {
    ...PageInfoFields
  }
  edges {
    cursor
    node {
      __typename
      ...SlackIntegrationFields
    }
  }
}

fragment SlackIntegrationFields on SlackIntegration {
  __typename
  id
  teamName
  channelName
}
"""

GENERIC_WEBHOOK_INTEGRATIONS_BY_ENTITY_GQL = """
query GenericWebhookIntegrationsByEntity($entityName: String!, $cursor: String, $perPage: Int) {
  entity(name: $entityName) {
    integrations(after: $cursor, first: $perPage) {
      ...GenericWebhookIntegrationConnectionFields
    }
  }
}

fragment GenericWebhookIntegrationConnectionFields on IntegrationConnection {
  __typename
  pageInfo {
    ...PageInfoFields
  }
  edges {
    cursor
    node {
      __typename
      ...GenericWebhookIntegrationFields
    }
  }
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}

fragment PageInfoFields on PageInfo {
  endCursor
  hasNextPage
}
"""

CREATE_GENERIC_WEBHOOK_INTEGRATION_GQL = """
mutation CreateGenericWebhookIntegration($input: CreateGenericWebhookIntegrationInput!) {
  createGenericWebhookIntegration(input: $input) {
    integration {
      __typename
      ...GenericWebhookIntegrationFields
    }
  }
}

fragment GenericWebhookIntegrationFields on GenericWebhookIntegration {
  __typename
  id
  name
  urlEndpoint
}
"""
