# Generated by ariadne-codegen
# Source: tools/graphql_codegen/artifacts/

from __future__ import annotations

from typing import List, Literal, Optional

from pydantic import Field

from wandb._pydantic import GQLId, GQLResult, Typename

from .enums import ArtifactState


class ArtifactAliasFragment(GQLResult):
    typename__: Typename[Literal["ArtifactAlias"]] = "ArtifactAlias"
    id: GQLId
    alias: str


class ArtifactCollectionConnectionFragment(GQLResult):
    total_count: int = Field(alias="totalCount")
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[ArtifactCollectionConnectionFragmentEdges]


class ArtifactCollectionConnectionFragmentEdges(GQLResult):
    node: Optional[ArtifactCollectionFragment]


class ArtifactCollectionFragment(GQLResult):
    typename__: Typename[Literal["ArtifactSequence", "ArtifactPortfolio"]]
    id: GQLId
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")
    tags: ArtifactCollectionFragmentTags
    aliases: Optional[ArtifactCollectionFragmentAliases] = None


class ArtifactCollectionFragmentAliases(GQLResult):
    edges: List[ArtifactCollectionFragmentAliasesEdges]


class ArtifactCollectionFragmentAliasesEdges(GQLResult):
    node: Optional[ArtifactAliasFragment]


class ArtifactCollectionFragmentTags(GQLResult):
    edges: List[ArtifactCollectionFragmentTagsEdges]


class ArtifactCollectionFragmentTagsEdges(GQLResult):
    node: TagFragment


class ArtifactCollectionSummary(GQLResult):
    typename__: Typename[Literal["ArtifactSequence", "ArtifactPortfolio"]]
    id: GQLId
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")


class ArtifactFragmentWithoutAliases(GQLResult):
    id: GQLId
    artifact_sequence: SourceCollectionInfoFragment = Field(alias="artifactSequence")
    version_index: Optional[int] = Field(alias="versionIndex")
    artifact_type: ArtifactFragmentWithoutAliasesArtifactType = Field(
        alias="artifactType"
    )
    description: Optional[str]
    metadata: Optional[str]
    ttl_duration_seconds: Optional[int] = Field(
        alias="ttlDurationSeconds", default=None
    )
    ttl_is_inherited: Optional[bool] = Field(alias="ttlIsInherited", default=None)
    tags: Optional[List[TagFragment]] = None
    history_step: Optional[int] = Field(alias="historyStep", default=None)
    state: ArtifactState
    size: int
    digest: str
    commit_hash: Optional[str] = Field(alias="commitHash")
    file_count: int = Field(alias="fileCount")
    created_at: str = Field(alias="createdAt")
    updated_at: Optional[str] = Field(alias="updatedAt")


class ArtifactFragmentWithoutAliasesArtifactType(GQLResult):
    name: str


class ArtifactMembershipFragment(GQLResult):
    typename__: Typename[Literal["ArtifactCollectionMembership"]] = (
        "ArtifactCollectionMembership"
    )
    id: GQLId
    version_index: Optional[int] = Field(alias="versionIndex")
    aliases: List[ArtifactAliasFragment]
    artifact_collection: Optional[CollectionInfoFragment] = Field(
        alias="artifactCollection"
    )
    artifact: Optional[ArtifactFragment]


class ArtifactPortfolioTypeFields(GQLResult):
    typename__: Typename[Literal["ArtifactPortfolio"]] = "ArtifactPortfolio"
    id: GQLId
    name: str


class ArtifactSequenceTypeFields(GQLResult):
    typename__: Typename[Literal["ArtifactSequence"]] = "ArtifactSequence"
    id: GQLId
    name: str


class ArtifactTypeFragment(GQLResult):
    typename__: Typename[Literal["ArtifactType"]] = "ArtifactType"
    id: GQLId
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")


class CollectionInfoFragment(GQLResult):
    typename__: Typename[Literal["ArtifactSequence", "ArtifactPortfolio"]]
    id: GQLId
    name: str
    project: Optional[ProjectInfoFragment]


class DeferredManifestFragment(GQLResult):
    file: DeferredManifestFragmentFile


class DeferredManifestFragmentFile(GQLResult):
    direct_url: str = Field(alias="directUrl")


class FileFragment(GQLResult):
    typename__: Typename[Literal["File"]] = "File"
    id: GQLId
    name: str
    url: Optional[str]
    size_bytes: int = Field(alias="sizeBytes")
    storage_path: Optional[str] = Field(alias="storagePath", default=None)
    mimetype: Optional[str]
    updated_at: Optional[str] = Field(alias="updatedAt")
    digest: Optional[str]
    md_5: Optional[str] = Field(alias="md5")
    direct_url: str = Field(alias="directUrl")


class FileWithUrlFragment(GQLResult):
    typename__: Typename[Literal["File"]] = "File"
    name: str
    direct_url: str = Field(alias="directUrl")


class OrgInfoFragment(GQLResult):
    name: str
    org_entity: Optional[OrgInfoFragmentOrgEntity] = Field(
        alias="orgEntity", default=None
    )


class OrgInfoFragmentOrgEntity(GQLResult):
    name: str


class PageInfoFragment(GQLResult):
    typename__: Typename[Literal["PageInfo"]] = "PageInfo"
    end_cursor: Optional[str] = Field(alias="endCursor")
    has_next_page: bool = Field(alias="hasNextPage")


class ProjectInfoFragment(GQLResult):
    typename__: Typename[Literal["Project"]] = "Project"
    id: GQLId
    name: str
    entity_name: str = Field(alias="entityName")


class RegistryCollectionConnectionFragment(GQLResult):
    total_count: int = Field(alias="totalCount")
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[RegistryCollectionConnectionFragmentEdges]


class RegistryCollectionConnectionFragmentEdges(GQLResult):
    node: Optional[RegistryCollectionFragment]


class RegistryCollectionFragment(GQLResult):
    typename__: Typename[Literal["ArtifactSequence", "ArtifactPortfolio"]]
    id: GQLId
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")
    tags: RegistryCollectionFragmentTags
    project: Optional[ProjectInfoFragment]
    default_artifact_type: RegistryCollectionFragmentDefaultArtifactType = Field(
        alias="defaultArtifactType"
    )
    aliases: RegistryCollectionFragmentAliases


class RegistryCollectionFragmentAliases(GQLResult):
    edges: List[RegistryCollectionFragmentAliasesEdges]


class RegistryCollectionFragmentAliasesEdges(GQLResult):
    node: Optional[ArtifactAliasFragment]


class RegistryCollectionFragmentDefaultArtifactType(GQLResult):
    name: str


class RegistryCollectionFragmentTags(GQLResult):
    edges: List[RegistryCollectionFragmentTagsEdges]


class RegistryCollectionFragmentTagsEdges(GQLResult):
    node: TagFragment


class RegistryConnectionFragment(GQLResult):
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[RegistryConnectionFragmentEdges]


class RegistryConnectionFragmentEdges(GQLResult):
    node: Optional[RegistryFragment]


class RegistryFragment(GQLResult):
    id: GQLId
    allow_all_artifact_types_in_registry: bool = Field(
        alias="allowAllArtifactTypesInRegistry"
    )
    artifact_types: RegistryFragmentArtifactTypes = Field(alias="artifactTypes")
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")
    updated_at: Optional[str] = Field(alias="updatedAt")
    access: Optional[str]


class RegistryFragmentArtifactTypes(GQLResult):
    edges: List[RegistryFragmentArtifactTypesEdges]


class RegistryFragmentArtifactTypesEdges(GQLResult):
    node: Optional[RegistryFragmentArtifactTypesEdgesNode]


class RegistryFragmentArtifactTypesEdgesNode(GQLResult):
    name: str


class RegistryVersionConnectionFragment(GQLResult):
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[RegistryVersionConnectionFragmentEdges]


class RegistryVersionConnectionFragmentEdges(GQLResult):
    node: Optional[ArtifactMembershipFragment]


class RunInfoFragment(GQLResult):
    typename__: Typename[Literal["Run"]] = "Run"
    id: GQLId
    name: str
    project: Optional[ProjectInfoFragment]


class RunInputArtifactConnectionFragment(GQLResult):
    total_count: int = Field(alias="totalCount")
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[RunInputArtifactConnectionFragmentEdges]


class RunInputArtifactConnectionFragmentEdges(GQLResult):
    node: Optional[ArtifactFragment]


class RunOutputArtifactConnectionFragment(GQLResult):
    total_count: int = Field(alias="totalCount")
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[RunOutputArtifactConnectionFragmentEdges]


class RunOutputArtifactConnectionFragmentEdges(GQLResult):
    node: Optional[ArtifactFragment]


class SourceCollectionInfoFragment(GQLResult):
    typename__: Typename[Literal["ArtifactSequence"]] = "ArtifactSequence"
    id: GQLId
    name: str
    project: Optional[ProjectInfoFragment]


class TagFragment(GQLResult):
    typename__: Typename[Literal["Tag"]] = "Tag"
    id: GQLId
    name: str


class TypeInfoFragment(GQLResult):
    name: Optional[str]
    fields: Optional[List[TypeInfoFragmentFields]]
    input_fields: Optional[List[TypeInfoFragmentInputFields]] = Field(
        alias="inputFields"
    )


class TypeInfoFragmentFields(GQLResult):
    name: str
    args: List[TypeInfoFragmentFieldsArgs]


class TypeInfoFragmentFieldsArgs(GQLResult):
    name: str


class TypeInfoFragmentInputFields(GQLResult):
    name: str


class VersionedArtifactConnectionFragment(GQLResult):
    total_count: int = Field(alias="totalCount")
    page_info: PageInfoFragment = Field(alias="pageInfo")
    edges: List[VersionedArtifactConnectionFragmentEdges]


class VersionedArtifactConnectionFragmentEdges(GQLResult):
    node: ArtifactFragment
    version: str


class ArtifactFragmentAliases(ArtifactAliasFragment):
    artifact_collection: Optional[CollectionInfoFragment] = Field(
        alias="artifactCollection"
    )


class ArtifactFragment(ArtifactFragmentWithoutAliases):
    aliases: Optional[List[ArtifactFragmentAliases]] = None


ArtifactAliasFragment.model_rebuild()
ArtifactCollectionConnectionFragment.model_rebuild()
ArtifactCollectionConnectionFragmentEdges.model_rebuild()
ArtifactCollectionFragment.model_rebuild()
ArtifactCollectionFragmentAliases.model_rebuild()
ArtifactCollectionFragmentAliasesEdges.model_rebuild()
ArtifactCollectionFragmentTags.model_rebuild()
ArtifactCollectionFragmentTagsEdges.model_rebuild()
ArtifactCollectionSummary.model_rebuild()
ArtifactFragmentWithoutAliases.model_rebuild()
ArtifactFragmentWithoutAliasesArtifactType.model_rebuild()
ArtifactMembershipFragment.model_rebuild()
ArtifactPortfolioTypeFields.model_rebuild()
ArtifactSequenceTypeFields.model_rebuild()
ArtifactTypeFragment.model_rebuild()
CollectionInfoFragment.model_rebuild()
DeferredManifestFragment.model_rebuild()
DeferredManifestFragmentFile.model_rebuild()
FileFragment.model_rebuild()
FileWithUrlFragment.model_rebuild()
OrgInfoFragment.model_rebuild()
OrgInfoFragmentOrgEntity.model_rebuild()
PageInfoFragment.model_rebuild()
ProjectInfoFragment.model_rebuild()
RegistryCollectionConnectionFragment.model_rebuild()
RegistryCollectionConnectionFragmentEdges.model_rebuild()
RegistryCollectionFragment.model_rebuild()
RegistryCollectionFragmentAliases.model_rebuild()
RegistryCollectionFragmentAliasesEdges.model_rebuild()
RegistryCollectionFragmentDefaultArtifactType.model_rebuild()
RegistryCollectionFragmentTags.model_rebuild()
RegistryCollectionFragmentTagsEdges.model_rebuild()
RegistryConnectionFragment.model_rebuild()
RegistryConnectionFragmentEdges.model_rebuild()
RegistryFragment.model_rebuild()
RegistryFragmentArtifactTypes.model_rebuild()
RegistryFragmentArtifactTypesEdges.model_rebuild()
RegistryFragmentArtifactTypesEdgesNode.model_rebuild()
RegistryVersionConnectionFragment.model_rebuild()
RegistryVersionConnectionFragmentEdges.model_rebuild()
RunInfoFragment.model_rebuild()
RunInputArtifactConnectionFragment.model_rebuild()
RunInputArtifactConnectionFragmentEdges.model_rebuild()
RunOutputArtifactConnectionFragment.model_rebuild()
RunOutputArtifactConnectionFragmentEdges.model_rebuild()
SourceCollectionInfoFragment.model_rebuild()
TagFragment.model_rebuild()
TypeInfoFragment.model_rebuild()
TypeInfoFragmentFields.model_rebuild()
TypeInfoFragmentFieldsArgs.model_rebuild()
TypeInfoFragmentInputFields.model_rebuild()
VersionedArtifactConnectionFragment.model_rebuild()
VersionedArtifactConnectionFragmentEdges.model_rebuild()
ArtifactFragmentAliases.model_rebuild()
ArtifactFragment.model_rebuild()
