# Generated by ariadne-codegen
# Source: core/api/graphql/schemas/schema-latest.graphql

from __future__ import annotations

from typing import List, Optional

from pydantic import Field

from wandb._pydantic import GQLId, GQLInput


class UpdateArtifactSequenceInput(GQLInput):
    artifact_sequence_id: GQLId = Field(alias="artifactSequenceID")
    name: Optional[str] = None
    description: Optional[str] = None
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class MoveArtifactSequenceInput(GQLInput):
    artifact_sequence_id: GQLId = Field(alias="artifactSequenceID")
    destination_artifact_type_name: str = Field(alias="destinationArtifactTypeName")
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class UpdateArtifactPortfolioInput(GQLInput):
    artifact_portfolio_id: GQLId = Field(alias="artifactPortfolioID")
    name: Optional[str] = None
    description: Optional[str] = None
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class ArtifactAliasInput(GQLInput):
    artifact_collection_name: str = Field(alias="artifactCollectionName")
    alias: str


class UpdateArtifactInput(GQLInput):
    artifact_id: GQLId = Field(alias="artifactID")
    description: Optional[str] = None
    labels: Optional[str] = None
    aliases: Optional[List[ArtifactAliasInput]] = None
    tags_to_add: Optional[List[TagInput]] = Field(alias="tagsToAdd", default=None)
    tags_to_delete: Optional[List[TagInput]] = Field(alias="tagsToDelete", default=None)
    metadata: Optional[str] = None
    ttl_duration_seconds: Optional[int] = Field(
        alias="ttlDurationSeconds", default=None
    )
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class DeleteArtifactInput(GQLInput):
    artifact_id: GQLId = Field(alias="artifactID")
    delete_aliases: Optional[bool] = Field(alias="deleteAliases", default=False)
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class LinkArtifactInput(GQLInput):
    artifact_id: Optional[GQLId] = Field(alias="artifactID", default=None)
    artifact_portfolio_id: Optional[GQLId] = Field(
        alias="artifactPortfolioID", default=None
    )
    artifact_portfolio_name: Optional[str] = Field(
        alias="artifactPortfolioName", default=None
    )
    entity_name: Optional[str] = Field(alias="entityName", default=None)
    project_name: Optional[str] = Field(alias="projectName", default=None)
    aliases: Optional[List[ArtifactAliasInput]] = None
    client_id: Optional[GQLId] = Field(alias="clientID", default=None)
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class UnlinkArtifactInput(GQLInput):
    artifact_id: GQLId = Field(alias="artifactID")
    artifact_portfolio_id: GQLId = Field(alias="artifactPortfolioID")
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class ArtifactCollectionAliasInput(GQLInput):
    alias: str
    entity_name: str = Field(alias="entityName")
    project_name: str = Field(alias="projectName")
    artifact_collection_name: str = Field(alias="artifactCollectionName")


class AddAliasesInput(GQLInput):
    aliases: List[ArtifactCollectionAliasInput]
    artifact_id: GQLId = Field(alias="artifactID")
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class DeleteAliasesInput(GQLInput):
    aliases: List[ArtifactCollectionAliasInput]
    artifact_id: GQLId = Field(alias="artifactID")
    client_mutation_id: Optional[str] = Field(alias="clientMutationId", default=None)


class TagInput(GQLInput):
    tag_category_name: Optional[str] = Field(alias="tagCategoryName", default=None)
    tag_name: str = Field(alias="tagName")
    attributes: Optional[str] = None


class CreateArtifactCollectionTagAssignmentsInput(GQLInput):
    entity_name: str = Field(alias="entityName")
    project_name: str = Field(alias="projectName")
    artifact_collection_name: str = Field(alias="artifactCollectionName")
    tags: List[TagInput]
    client_mutation_id: Optional[str] = Field(alias="clientMutationID", default=None)


class DeleteArtifactCollectionTagAssignmentsInput(GQLInput):
    entity_name: str = Field(alias="entityName")
    project_name: str = Field(alias="projectName")
    artifact_collection_name: str = Field(alias="artifactCollectionName")
    tags: List[TagInput]
    client_mutation_id: Optional[str] = Field(alias="clientMutationID", default=None)


UpdateArtifactInput.model_rebuild()
LinkArtifactInput.model_rebuild()
AddAliasesInput.model_rebuild()
DeleteAliasesInput.model_rebuild()
CreateArtifactCollectionTagAssignmentsInput.model_rebuild()
DeleteArtifactCollectionTagAssignmentsInput.model_rebuild()
