# Generated by ariadne-codegen
# Source: tools/graphql_codegen/artifacts/

__all__ = [
    "ADD_ALIASES_GQL",
    "ARTIFACT_BY_ID_GQL",
    "ARTIFACT_BY_NAME_GQL",
    "ARTIFACT_COLLECTION_MEMBERSHIP_FILES_GQL",
    "ARTIFACT_COLLECTION_MEMBERSHIP_FILE_URLS_GQL",
    "ARTIFACT_CREATED_BY_GQL",
    "ARTIFACT_FILE_URLS_GQL",
    "ARTIFACT_MEMBERSHIP_BY_NAME_GQL",
    "ARTIFACT_TYPE_GQL",
    "ARTIFACT_USED_BY_GQL",
    "ARTIFACT_VERSION_FILES_GQL",
    "CREATE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL",
    "DELETE_ALIASES_GQL",
    "DELETE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL",
    "DELETE_ARTIFACT_GQL",
    "DELETE_ARTIFACT_PORTFOLIO_GQL",
    "DELETE_ARTIFACT_SEQUENCE_GQL",
    "FETCH_ARTIFACT_MANIFEST_GQL",
    "FETCH_LINKED_ARTIFACTS_GQL",
    "FETCH_ORG_INFO_FROM_ENTITY_GQL",
    "FETCH_REGISTRIES_GQL",
    "LINK_ARTIFACT_GQL",
    "MOVE_ARTIFACT_COLLECTION_GQL",
    "PROJECT_ARTIFACTS_GQL",
    "PROJECT_ARTIFACT_COLLECTIONS_GQL",
    "PROJECT_ARTIFACT_COLLECTION_GQL",
    "PROJECT_ARTIFACT_TYPES_GQL",
    "PROJECT_ARTIFACT_TYPE_GQL",
    "REGISTRY_COLLECTIONS_GQL",
    "REGISTRY_VERSIONS_GQL",
    "RUN_INPUT_ARTIFACTS_GQL",
    "RUN_OUTPUT_ARTIFACTS_GQL",
    "TYPE_INFO_GQL",
    "UNLINK_ARTIFACT_GQL",
    "UPDATE_ARTIFACT_GQL",
    "UPDATE_ARTIFACT_PORTFOLIO_GQL",
    "UPDATE_ARTIFACT_SEQUENCE_GQL",
]

DELETE_ARTIFACT_SEQUENCE_GQL = """
mutation DeleteArtifactSequence($id: ID!) {
  deleteArtifactSequence(input: {artifactSequenceID: $id}) {
    artifactCollection {
      __typename
      state
    }
  }
}
"""

DELETE_ARTIFACT_PORTFOLIO_GQL = """
mutation DeleteArtifactPortfolio($id: ID!) {
  deleteArtifactPortfolio(input: {artifactPortfolioID: $id}) {
    artifactCollection {
      __typename
      state
    }
  }
}
"""

UPDATE_ARTIFACT_SEQUENCE_GQL = """
mutation UpdateArtifactSequence($input: UpdateArtifactSequenceInput!) {
  updateArtifactSequence(input: $input) {
    artifactCollection {
      __typename
      ...ArtifactCollectionSummary
    }
  }
}

fragment ArtifactCollectionSummary on ArtifactCollection {
  __typename
  id
  name
  description
  createdAt
}
"""

UPDATE_ARTIFACT_PORTFOLIO_GQL = """
mutation UpdateArtifactPortfolio($input: UpdateArtifactPortfolioInput!) {
  updateArtifactPortfolio(input: $input) {
    artifactCollection {
      __typename
      ...ArtifactCollectionSummary
    }
  }
}

fragment ArtifactCollectionSummary on ArtifactCollection {
  __typename
  id
  name
  description
  createdAt
}
"""

MOVE_ARTIFACT_COLLECTION_GQL = """
mutation MoveArtifactCollection($input: MoveArtifactSequenceInput!) {
  moveArtifactSequence(input: $input) {
    artifactCollection {
      __typename
      ...ArtifactCollectionSummary
    }
  }
}

fragment ArtifactCollectionSummary on ArtifactCollection {
  __typename
  id
  name
  description
  createdAt
}
"""

CREATE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL = """
mutation CreateArtifactCollectionTagAssignments($input: CreateArtifactCollectionTagAssignmentsInput!) {
  createArtifactCollectionTagAssignments(input: $input) {
    tags {
      ...TagFragment
    }
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

DELETE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL = """
mutation DeleteArtifactCollectionTagAssignments($input: DeleteArtifactCollectionTagAssignmentsInput!) {
  deleteArtifactCollectionTagAssignments(input: $input) {
    success
  }
}
"""

PROJECT_ARTIFACT_COLLECTIONS_GQL = """
query ProjectArtifactCollections($entityName: String!, $projectName: String!, $artifactTypeName: String!, $cursor: String, $aliasesCursor: String, $aliasesPerPage: Int = 0, $includeAliases: Boolean = false) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifactCollections: artifactCollections(after: $cursor) {
        ...ArtifactCollectionConnectionFragment
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactCollectionConnectionFragment on ArtifactCollectionConnection {
  totalCount
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...ArtifactCollectionFragment
    }
  }
}

fragment ArtifactCollectionFragment on ArtifactCollection {
  __typename
  id
  name
  description
  createdAt
  tags {
    edges {
      node {
        ...TagFragment
      }
    }
  }
  aliases(after: $aliasesCursor, first: $aliasesPerPage) @include(if: $includeAliases) {
    edges {
      node {
        ...ArtifactAliasFragment
      }
    }
  }
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

PROJECT_ARTIFACT_COLLECTION_GQL = """
query ProjectArtifactCollection($entityName: String!, $projectName: String!, $artifactTypeName: String!, $artifactCollectionName: String!, $aliasesCursor: String, $aliasesPerPage: Int = 1000, $includeAliases: Boolean = true) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifactCollection: artifactCollection(name: $artifactCollectionName) {
        __typename
        ...ArtifactCollectionFragment
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactCollectionFragment on ArtifactCollection {
  __typename
  id
  name
  description
  createdAt
  tags {
    edges {
      node {
        ...TagFragment
      }
    }
  }
  aliases(after: $aliasesCursor, first: $aliasesPerPage) @include(if: $includeAliases) {
    edges {
      node {
        ...ArtifactAliasFragment
      }
    }
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

ARTIFACT_VERSION_FILES_GQL = """
query ArtifactVersionFiles($entityName: String!, $projectName: String!, $artifactTypeName: String!, $artifactName: String!, $fileNames: [String!], $cursor: String, $perPage: Int = 50) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifact(name: $artifactName) {
        files(names: $fileNames, after: $cursor, first: $perPage) {
          pageInfo {
            ...PageInfoFragment
          }
          edges {
            node {
              ...FileFragment
            }
          }
        }
      }
    }
  }
}

fragment FileFragment on File {
  __typename
  id
  name: displayName
  url
  sizeBytes
  storagePath @include(if: true)
  mimetype
  updatedAt
  digest
  md5
  directUrl
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}
"""

ARTIFACT_COLLECTION_MEMBERSHIP_FILES_GQL = """
query ArtifactCollectionMembershipFiles($entityName: String!, $projectName: String!, $artifactName: String!, $artifactVersionIndex: String!, $fileNames: [String!], $cursor: String, $perPage: Int = 50) {
  project(name: $projectName, entityName: $entityName) {
    artifactCollection(name: $artifactName) {
      __typename
      artifactMembership(aliasName: $artifactVersionIndex) {
        files(names: $fileNames, after: $cursor, first: $perPage) {
          pageInfo {
            ...PageInfoFragment
          }
          edges {
            node {
              ...FileFragment
            }
          }
        }
      }
    }
  }
}

fragment FileFragment on File {
  __typename
  id
  name: displayName
  url
  sizeBytes
  storagePath @include(if: true)
  mimetype
  updatedAt
  digest
  md5
  directUrl
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}
"""

ARTIFACT_COLLECTION_MEMBERSHIP_FILE_URLS_GQL = """
query ArtifactCollectionMembershipFileUrls($entityName: String!, $projectName: String!, $artifactName: String!, $artifactVersionIndex: String!, $cursor: String, $perPage: Int) {
  project(name: $projectName, entityName: $entityName) {
    artifactCollection(name: $artifactName) {
      __typename
      artifactMembership(aliasName: $artifactVersionIndex) {
        files(after: $cursor, first: $perPage) {
          pageInfo {
            ...PageInfoFragment
          }
          edges {
            node {
              ...FileWithUrlFragment
            }
          }
        }
      }
    }
  }
}

fragment FileWithUrlFragment on File {
  __typename
  name
  directUrl
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}
"""

ARTIFACT_FILE_URLS_GQL = """
query ArtifactFileUrls($id: ID!, $cursor: String, $perPage: Int) {
  artifact(id: $id) {
    files(after: $cursor, first: $perPage) {
      pageInfo {
        ...PageInfoFragment
      }
      edges {
        node {
          ...FileWithUrlFragment
        }
      }
    }
  }
}

fragment FileWithUrlFragment on File {
  __typename
  name
  directUrl
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}
"""

PROJECT_ARTIFACT_TYPES_GQL = """
query ProjectArtifactTypes($entityName: String!, $projectName: String!, $cursor: String) {
  project(name: $projectName, entityName: $entityName) {
    artifactTypes(after: $cursor) {
      edges {
        node {
          ...ArtifactTypeFragment
        }
      }
      pageInfo {
        ...PageInfoFragment
      }
    }
  }
}

fragment ArtifactTypeFragment on ArtifactType {
  __typename
  id
  name
  description
  createdAt
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}
"""

PROJECT_ARTIFACT_TYPE_GQL = """
query ProjectArtifactType($entityName: String!, $projectName: String!, $artifactTypeName: String!) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      ...ArtifactTypeFragment
    }
  }
}

fragment ArtifactTypeFragment on ArtifactType {
  __typename
  id
  name
  description
  createdAt
}
"""

PROJECT_ARTIFACTS_GQL = """
query ProjectArtifacts($project: String!, $entity: String!, $type: String!, $collection: String!, $cursor: String, $perPage: Int = 50, $order: String, $filters: JSONString) {
  project(name: $project, entityName: $entity) {
    artifactType(name: $type) {
      artifactCollection: artifactCollection(name: $collection) {
        __typename
        artifacts(filters: $filters, after: $cursor, first: $perPage, order: $order) {
          ...VersionedArtifactConnectionFragment
        }
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}

fragment VersionedArtifactConnectionFragment on VersionedArtifactConnection {
  totalCount
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...ArtifactFragment
    }
    version
  }
}
"""

RUN_OUTPUT_ARTIFACTS_GQL = """
query RunOutputArtifacts($entity: String!, $project: String!, $runName: String!, $cursor: String, $perPage: Int) {
  project(name: $project, entityName: $entity) {
    run(name: $runName) {
      artifacts: outputArtifacts(after: $cursor, first: $perPage) {
        ...RunOutputArtifactConnectionFragment
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment RunOutputArtifactConnectionFragment on ArtifactConnection {
  totalCount
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...ArtifactFragment
    }
  }
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

RUN_INPUT_ARTIFACTS_GQL = """
query RunInputArtifacts($entity: String!, $project: String!, $runName: String!, $cursor: String, $perPage: Int) {
  project(name: $project, entityName: $entity) {
    run(name: $runName) {
      artifacts: inputArtifacts(after: $cursor, first: $perPage) {
        ...RunInputArtifactConnectionFragment
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment RunInputArtifactConnectionFragment on InputArtifactConnection {
  totalCount
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...ArtifactFragment
    }
  }
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

FETCH_LINKED_ARTIFACTS_GQL = """
query FetchLinkedArtifacts($artifactID: ID!) {
  artifact(id: $artifactID) {
    artifactMemberships {
      edges {
        node {
          aliases {
            ...ArtifactAliasFragment
          }
          versionIndex
          artifactCollection {
            __typename
            ...CollectionInfoFragment
          }
        }
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}
"""

FETCH_ARTIFACT_MANIFEST_GQL = """
query FetchArtifactManifest($id: ID!) {
  artifact(id: $id) {
    currentManifest {
      ...DeferredManifestFragment
    }
  }
}

fragment DeferredManifestFragment on ArtifactManifest {
  file {
    directUrl
  }
}
"""

ARTIFACT_BY_ID_GQL = """
query ArtifactByID($id: ID!) {
  artifact(id: $id) {
    ...ArtifactFragment
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

ARTIFACT_BY_NAME_GQL = """
query ArtifactByName($entity: String!, $project: String!, $name: String!, $enableTracking: Boolean) {
  project(name: $project, entityName: $entity) {
    artifact(name: $name, enableTracking: $enableTracking) {
      ...ArtifactFragment
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

ARTIFACT_MEMBERSHIP_BY_NAME_GQL = """
query ArtifactMembershipByName($entity: String!, $project: String!, $name: String!) {
  project(name: $project, entityName: $entity) {
    artifactCollectionMembership(name: $name) {
      ...ArtifactMembershipFragment
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment ArtifactMembershipFragment on ArtifactCollectionMembership {
  __typename
  id
  versionIndex
  aliases {
    ...ArtifactAliasFragment
  }
  artifactCollection {
    ...CollectionInfoFragment
  }
  artifact {
    ...ArtifactFragment
  }
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

ARTIFACT_USED_BY_GQL = """
query ArtifactUsedBy($id: ID!) {
  artifact(id: $id) {
    usedBy {
      edges {
        node {
          ...RunInfoFragment
        }
      }
    }
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment RunInfoFragment on Run {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}
"""

ARTIFACT_CREATED_BY_GQL = """
query ArtifactCreatedBy($id: ID!) {
  artifact(id: $id) {
    createdBy {
      __typename
      ... on Run {
        ...RunInfoFragment
      }
    }
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment RunInfoFragment on Run {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}
"""

ARTIFACT_TYPE_GQL = """
query ArtifactType($entityName: String, $projectName: String, $name: String!) {
  project(name: $projectName, entityName: $entityName) {
    artifact(name: $name) {
      artifactType {
        name
      }
    }
  }
}
"""

ADD_ALIASES_GQL = """
mutation AddAliases($input: AddAliasesInput!) {
  addAliases(input: $input) {
    success
  }
}
"""

DELETE_ALIASES_GQL = """
mutation DeleteAliases($input: DeleteAliasesInput!) {
  deleteAliases(input: $input) {
    success
  }
}
"""

UPDATE_ARTIFACT_GQL = """
mutation UpdateArtifact($input: UpdateArtifactInput!) {
  updateArtifact(input: $input) {
    artifact {
      ...ArtifactFragment
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

DELETE_ARTIFACT_GQL = """
mutation DeleteArtifact($input: DeleteArtifactInput!) {
  deleteArtifact(input: $input) {
    artifact {
      id
    }
  }
}
"""

LINK_ARTIFACT_GQL = """
mutation LinkArtifact($input: LinkArtifactInput!) {
  linkArtifact(input: $input) {
    versionIndex
    artifactMembership @include(if: true) {
      ...ArtifactMembershipFragment
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment ArtifactMembershipFragment on ArtifactCollectionMembership {
  __typename
  id
  versionIndex
  aliases {
    ...ArtifactAliasFragment
  }
  artifactCollection {
    ...CollectionInfoFragment
  }
  artifact {
    ...ArtifactFragment
  }
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

UNLINK_ARTIFACT_GQL = """
mutation UnlinkArtifact($input: UnlinkArtifactInput!) {
  unlinkArtifact(input: $input) {
    success
  }
}
"""

TYPE_INFO_GQL = """
query TypeInfo($name: String!) {
  __type(name: $name) {
    ...TypeInfoFragment
  }
}

fragment TypeInfoFragment on __Type {
  name
  fields {
    name
    args {
      name
    }
  }
  inputFields {
    name
  }
}
"""

FETCH_ORG_INFO_FROM_ENTITY_GQL = """
query FetchOrgInfoFromEntity($entity: String!) {
  entity(name: $entity) {
    organization {
      ...OrgInfoFragment
    }
    user {
      organizations {
        ...OrgInfoFragment
      }
    }
  }
}

fragment OrgInfoFragment on Organization {
  name
  orgEntity @include(if: true) {
    name
  }
}
"""

REGISTRY_VERSIONS_GQL = """
query RegistryVersions($organization: String!, $registryFilter: JSONString, $collectionFilter: JSONString, $artifactFilter: JSONString, $cursor: String, $perPage: Int) {
  organization(name: $organization) {
    orgEntity {
      name
      artifactMemberships(
        projectFilters: $registryFilter
        collectionFilters: $collectionFilter
        filters: $artifactFilter
        after: $cursor
        first: $perPage
      ) {
        ...RegistryVersionConnectionFragment
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      ...CollectionInfoFragment
    }
    ...ArtifactAliasFragment
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    ...SourceCollectionInfoFragment
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    ...TagFragment
  }
  historyStep @include(if: true)
  state
  size
  digest
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment ArtifactMembershipFragment on ArtifactCollectionMembership {
  __typename
  id
  versionIndex
  aliases {
    ...ArtifactAliasFragment
  }
  artifactCollection {
    ...CollectionInfoFragment
  }
  artifact {
    ...ArtifactFragment
  }
}

fragment CollectionInfoFragment on ArtifactCollection {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment RegistryVersionConnectionFragment on ArtifactCollectionMembershipConnection {
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...ArtifactMembershipFragment
    }
  }
}

fragment SourceCollectionInfoFragment on ArtifactSequence {
  __typename
  id
  name
  project {
    ...ProjectInfoFragment
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

REGISTRY_COLLECTIONS_GQL = """
query RegistryCollections($organization: String!, $registryFilter: JSONString, $collectionFilter: JSONString, $collectionTypes: [ArtifactCollectionType!], $cursor: String, $perPage: Int) {
  organization(name: $organization) {
    orgEntity {
      name
      artifactCollections(
        projectFilters: $registryFilter
        filters: $collectionFilter
        collectionTypes: $collectionTypes
        after: $cursor
        first: $perPage
      ) {
        ...RegistryCollectionConnectionFragment
      }
    }
  }
}

fragment ArtifactAliasFragment on ArtifactAlias {
  __typename
  id
  alias
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment ProjectInfoFragment on Project {
  __typename
  id
  name
  entityName
}

fragment RegistryCollectionConnectionFragment on ArtifactCollectionConnection {
  totalCount
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...RegistryCollectionFragment
    }
  }
}

fragment RegistryCollectionFragment on ArtifactCollection {
  __typename
  id
  name
  description
  createdAt
  tags {
    edges {
      node {
        ...TagFragment
      }
    }
  }
  project {
    ...ProjectInfoFragment
  }
  defaultArtifactType {
    name
  }
  aliases {
    edges {
      node {
        ...ArtifactAliasFragment
      }
    }
  }
}

fragment TagFragment on Tag {
  __typename
  id
  name
}
"""

FETCH_REGISTRIES_GQL = """
query FetchRegistries($organization: String!, $filters: JSONString, $cursor: String, $perPage: Int) {
  organization(name: $organization) {
    orgEntity {
      name
      projects(filters: $filters, after: $cursor, first: $perPage) {
        ...RegistryConnectionFragment
      }
    }
  }
}

fragment PageInfoFragment on PageInfo {
  __typename
  endCursor
  hasNextPage
}

fragment RegistryConnectionFragment on ProjectConnection {
  pageInfo {
    ...PageInfoFragment
  }
  edges {
    node {
      ...RegistryFragment
    }
  }
}

fragment RegistryFragment on Project {
  id
  allowAllArtifactTypesInRegistry
  artifactTypes(includeAll: true) {
    edges {
      node {
        name
      }
    }
  }
  name
  description
  createdAt
  updatedAt
  access
}
"""
