# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bypass_head_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]]] = None,
                 device_orientation: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations_privates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 script_language: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]]] = None,
                 treat_redirect_as_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 validation_string: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_ssl: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[_builtins.str] type: The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[_builtins.bool] bypass_head_request: Monitor should skip default HEAD request and instead use GET verb in check.
               
               The `BROWSER` monitor type supports the following additional arguments:
        :param pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]] custom_headers: Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        :param pulumi.Input[_builtins.str] device_orientation: Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[_builtins.str] device_type: Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_privates: The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] name: The human-readable identifier for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific version of the runtime type selected (`100`).
        :param pulumi.Input[_builtins.str] script_language: The programing language that should execute the script.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SIMPLE` monitor type supports the following additional arguments:
        :param pulumi.Input[_builtins.bool] treat_redirect_as_failure: Categorize redirects during a monitor job as a failure.
        :param pulumi.Input[_builtins.str] uri: The URI the monitor runs against.
        :param pulumi.Input[_builtins.str] validation_string: Validation text for monitor to search for at given URI.
        :param pulumi.Input[_builtins.bool] verify_ssl: Monitor should validate SSL certificate chain.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if browsers is not None:
            pulumi.set(__self__, "browsers", browsers)
        if bypass_head_request is not None:
            pulumi.set(__self__, "bypass_head_request", bypass_head_request)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if device_orientation is not None:
            pulumi.set(__self__, "device_orientation", device_orientation)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if enable_screenshot_on_failure_and_script is not None:
            pulumi.set(__self__, "enable_screenshot_on_failure_and_script", enable_screenshot_on_failure_and_script)
        if locations_privates is not None:
            pulumi.set(__self__, "locations_privates", locations_privates)
        if locations_publics is not None:
            pulumi.set(__self__, "locations_publics", locations_publics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if runtime_type_version is not None:
            pulumi.set(__self__, "runtime_type_version", runtime_type_version)
        if script_language is not None:
            pulumi.set(__self__, "script_language", script_language)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if treat_redirect_as_failure is not None:
            pulumi.set(__self__, "treat_redirect_as_failure", treat_redirect_as_failure)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if use_unsupported_legacy_runtime is not None:
            pulumi.set(__self__, "use_unsupported_legacy_runtime", use_unsupported_legacy_runtime)
        if validation_string is not None:
            pulumi.set(__self__, "validation_string", validation_string)
        if verify_ssl is not None:
            pulumi.set(__self__, "verify_ssl", verify_ssl)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        The run state of the monitor. (`ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def browsers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        """
        return pulumi.get(self, "browsers")

    @browsers.setter
    def browsers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "browsers", value)

    @_builtins.property
    @pulumi.getter(name="bypassHeadRequest")
    def bypass_head_request(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Monitor should skip default HEAD request and instead use GET verb in check.

        The `BROWSER` monitor type supports the following additional arguments:
        """
        return pulumi.get(self, "bypass_head_request")

    @bypass_head_request.setter
    def bypass_head_request(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_head_request", value)

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]]]:
        """
        Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @_builtins.property
    @pulumi.getter(name="deviceOrientation")
    def device_orientation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
        * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        """
        return pulumi.get(self, "device_orientation")

    @device_orientation.setter
    def device_orientation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_orientation", value)

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
        * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_type", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Capture a screenshot during job execution.
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @enable_screenshot_on_failure_and_script.setter
    def enable_screenshot_on_failure_and_script(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_screenshot_on_failure_and_script", value)

    @_builtins.property
    @pulumi.getter(name="locationsPrivates")
    def locations_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        """
        return pulumi.get(self, "locations_privates")

    @locations_privates.setter
    def locations_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations_privates", value)

    @_builtins.property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        """
        return pulumi.get(self, "locations_publics")

    @locations_publics.setter
    def locations_publics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations_publics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable identifier for the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type", value)

    @_builtins.property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specific version of the runtime type selected (`100`).
        """
        return pulumi.get(self, "runtime_type_version")

    @runtime_type_version.setter
    def runtime_type_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type_version", value)

    @_builtins.property
    @pulumi.getter(name="scriptLanguage")
    def script_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The programing language that should execute the script.
        """
        return pulumi.get(self, "script_language")

    @script_language.setter
    def script_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_language", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.

        The `SIMPLE` monitor type supports the following additional arguments:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="treatRedirectAsFailure")
    def treat_redirect_as_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Categorize redirects during a monitor job as a failure.
        """
        return pulumi.get(self, "treat_redirect_as_failure")

    @treat_redirect_as_failure.setter
    def treat_redirect_as_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "treat_redirect_as_failure", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI the monitor runs against.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="useUnsupportedLegacyRuntime")
    def use_unsupported_legacy_runtime(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_unsupported_legacy_runtime")

    @use_unsupported_legacy_runtime.setter
    def use_unsupported_legacy_runtime(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_unsupported_legacy_runtime", value)

    @_builtins.property
    @pulumi.getter(name="validationString")
    def validation_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Validation text for monitor to search for at given URI.
        """
        return pulumi.get(self, "validation_string")

    @validation_string.setter
    def validation_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_string", value)

    @_builtins.property
    @pulumi.getter(name="verifySsl")
    def verify_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Monitor should validate SSL certificate chain.
        """
        return pulumi.get(self, "verify_ssl")

    @verify_ssl.setter
    def verify_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_ssl", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bypass_head_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]]] = None,
                 device_orientation: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations_privates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 script_language: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]]] = None,
                 treat_redirect_as_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 validation_string: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_ssl: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[_builtins.bool] bypass_head_request: Monitor should skip default HEAD request and instead use GET verb in check.
               
               The `BROWSER` monitor type supports the following additional arguments:
        :param pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]] custom_headers: Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        :param pulumi.Input[_builtins.str] device_orientation: Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[_builtins.str] device_type: Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_privates: The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] monitor_id: The monitor id of the Synthetics monitor (not to be confused with the GUID of the monitor).
        :param pulumi.Input[_builtins.str] name: The human-readable identifier for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.int] period_in_minutes: The interval in minutes at which Synthetic monitor should run.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific version of the runtime type selected (`100`).
        :param pulumi.Input[_builtins.str] script_language: The programing language that should execute the script.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SIMPLE` monitor type supports the following additional arguments:
        :param pulumi.Input[_builtins.bool] treat_redirect_as_failure: Categorize redirects during a monitor job as a failure.
        :param pulumi.Input[_builtins.str] type: The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        :param pulumi.Input[_builtins.str] uri: The URI the monitor runs against.
        :param pulumi.Input[_builtins.str] validation_string: Validation text for monitor to search for at given URI.
        :param pulumi.Input[_builtins.bool] verify_ssl: Monitor should validate SSL certificate chain.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if browsers is not None:
            pulumi.set(__self__, "browsers", browsers)
        if bypass_head_request is not None:
            pulumi.set(__self__, "bypass_head_request", bypass_head_request)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if device_orientation is not None:
            pulumi.set(__self__, "device_orientation", device_orientation)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if enable_screenshot_on_failure_and_script is not None:
            pulumi.set(__self__, "enable_screenshot_on_failure_and_script", enable_screenshot_on_failure_and_script)
        if locations_privates is not None:
            pulumi.set(__self__, "locations_privates", locations_privates)
        if locations_publics is not None:
            pulumi.set(__self__, "locations_publics", locations_publics)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_in_minutes is not None:
            pulumi.set(__self__, "period_in_minutes", period_in_minutes)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if runtime_type_version is not None:
            pulumi.set(__self__, "runtime_type_version", runtime_type_version)
        if script_language is not None:
            pulumi.set(__self__, "script_language", script_language)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if treat_redirect_as_failure is not None:
            pulumi.set(__self__, "treat_redirect_as_failure", treat_redirect_as_failure)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if use_unsupported_legacy_runtime is not None:
            pulumi.set(__self__, "use_unsupported_legacy_runtime", use_unsupported_legacy_runtime)
        if validation_string is not None:
            pulumi.set(__self__, "validation_string", validation_string)
        if verify_ssl is not None:
            pulumi.set(__self__, "verify_ssl", verify_ssl)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def browsers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        """
        return pulumi.get(self, "browsers")

    @browsers.setter
    def browsers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "browsers", value)

    @_builtins.property
    @pulumi.getter(name="bypassHeadRequest")
    def bypass_head_request(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Monitor should skip default HEAD request and instead use GET verb in check.

        The `BROWSER` monitor type supports the following additional arguments:
        """
        return pulumi.get(self, "bypass_head_request")

    @bypass_head_request.setter
    def bypass_head_request(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_head_request", value)

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]]]:
        """
        Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @_builtins.property
    @pulumi.getter(name="deviceOrientation")
    def device_orientation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
        * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        """
        return pulumi.get(self, "device_orientation")

    @device_orientation.setter
    def device_orientation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_orientation", value)

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
        * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_type", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Capture a screenshot during job execution.
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @enable_screenshot_on_failure_and_script.setter
    def enable_screenshot_on_failure_and_script(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_screenshot_on_failure_and_script", value)

    @_builtins.property
    @pulumi.getter(name="locationsPrivates")
    def locations_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        """
        return pulumi.get(self, "locations_privates")

    @locations_privates.setter
    def locations_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations_privates", value)

    @_builtins.property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        """
        return pulumi.get(self, "locations_publics")

    @locations_publics.setter
    def locations_publics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations_publics", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monitor id of the Synthetics monitor (not to be confused with the GUID of the monitor).
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable identifier for the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodInMinutes")
    def period_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval in minutes at which Synthetic monitor should run.
        """
        return pulumi.get(self, "period_in_minutes")

    @period_in_minutes.setter
    def period_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type", value)

    @_builtins.property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specific version of the runtime type selected (`100`).
        """
        return pulumi.get(self, "runtime_type_version")

    @runtime_type_version.setter
    def runtime_type_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type_version", value)

    @_builtins.property
    @pulumi.getter(name="scriptLanguage")
    def script_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The programing language that should execute the script.
        """
        return pulumi.get(self, "script_language")

    @script_language.setter
    def script_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_language", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The run state of the monitor. (`ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.

        The `SIMPLE` monitor type supports the following additional arguments:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="treatRedirectAsFailure")
    def treat_redirect_as_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Categorize redirects during a monitor job as a failure.
        """
        return pulumi.get(self, "treat_redirect_as_failure")

    @treat_redirect_as_failure.setter
    def treat_redirect_as_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "treat_redirect_as_failure", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI the monitor runs against.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="useUnsupportedLegacyRuntime")
    def use_unsupported_legacy_runtime(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_unsupported_legacy_runtime")

    @use_unsupported_legacy_runtime.setter
    def use_unsupported_legacy_runtime(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_unsupported_legacy_runtime", value)

    @_builtins.property
    @pulumi.getter(name="validationString")
    def validation_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Validation text for monitor to search for at given URI.
        """
        return pulumi.get(self, "validation_string")

    @validation_string.setter
    def validation_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_string", value)

    @_builtins.property
    @pulumi.getter(name="verifySsl")
    def verify_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Monitor should validate SSL certificate chain.
        """
        return pulumi.get(self, "verify_ssl")

    @verify_ssl.setter
    def verify_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_ssl", value)


@pulumi.type_token("newrelic:synthetics/monitor:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bypass_head_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorCustomHeaderArgs', 'MonitorCustomHeaderArgsDict']]]]] = None,
                 device_orientation: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations_privates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 script_language: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagArgs', 'MonitorTagArgsDict']]]]] = None,
                 treat_redirect_as_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 validation_string: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            name="monitor",
            period="EVERY_MINUTE",
            uri="https://www.one.newrelic.com",
            type="SIMPLE",
            locations_publics=["AP_SOUTH_1"],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            treat_redirect_as_failure=True,
            validation_string="success",
            bypass_head_request=True,
            verify_ssl=True,
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        ##### Type: `SIMPLE BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            name="monitor",
            period="EVERY_MINUTE",
            uri="https://www.one.newrelic.com",
            type="BROWSER",
            locations_publics=["AP_SOUTH_1"],
            enable_screenshot_on_failure_and_script=True,
            validation_string="success",
            verify_ssl=True,
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            script_language="JAVASCRIPT",
            devices=[
                "DESKTOP",
                "TABLET_LANDSCAPE",
                "MOBILE_PORTRAIT",
            ],
            browsers=["CHROME"],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        See additional examples.

        ## Additional Examples

        ### Create a monitor with a private location

        The below example shows how you can define a private location and attach it to a monitor.

        > **NOTE:** It can take up to 10 minutes for a private location to become available.

        ##### Type: `SIMPLE`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Example private location",
            name="private_location",
            verified_script_execution=False)
        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            name="monitor",
            period="EVERY_MINUTE",
            uri="https://www.one.newrelic.com",
            type="SIMPLE",
            locations_privates=[location.id],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            treat_redirect_as_failure=True,
            validation_string="success",
            bypass_head_request=True,
            verify_ssl=True,
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        ##### Type: `BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Example private location",
            name="private-location",
            verified_script_execution=False)
        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            type="BROWSER",
            uri="https://www.one.newrelic.com",
            name="monitor",
            period="EVERY_MINUTE",
            locations_privates=[location.id],
            enable_screenshot_on_failure_and_script=True,
            validation_string="success",
            verify_ssl=True,
            runtime_type_version="100",
            runtime_type="CHROME_BROWSER",
            script_language="JAVASCRIPT",
            devices=[
                "DESKTOP",
                "TABLET_LANDSCAPE",
                "MOBILE_PORTRAIT",
            ],
            browsers=["CHROME"],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```

        ## Import

        Synthetics monitor can be imported using the `guid`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:synthetics/monitor:Monitor monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[_builtins.bool] bypass_head_request: Monitor should skip default HEAD request and instead use GET verb in check.
               
               The `BROWSER` monitor type supports the following additional arguments:
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorCustomHeaderArgs', 'MonitorCustomHeaderArgsDict']]]] custom_headers: Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        :param pulumi.Input[_builtins.str] device_orientation: Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[_builtins.str] device_type: Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_privates: The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] name: The human-readable identifier for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific version of the runtime type selected (`100`).
        :param pulumi.Input[_builtins.str] script_language: The programing language that should execute the script.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagArgs', 'MonitorTagArgsDict']]]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SIMPLE` monitor type supports the following additional arguments:
        :param pulumi.Input[_builtins.bool] treat_redirect_as_failure: Categorize redirects during a monitor job as a failure.
        :param pulumi.Input[_builtins.str] type: The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        :param pulumi.Input[_builtins.str] uri: The URI the monitor runs against.
        :param pulumi.Input[_builtins.str] validation_string: Validation text for monitor to search for at given URI.
        :param pulumi.Input[_builtins.bool] verify_ssl: Monitor should validate SSL certificate chain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            name="monitor",
            period="EVERY_MINUTE",
            uri="https://www.one.newrelic.com",
            type="SIMPLE",
            locations_publics=["AP_SOUTH_1"],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            treat_redirect_as_failure=True,
            validation_string="success",
            bypass_head_request=True,
            verify_ssl=True,
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        ##### Type: `SIMPLE BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            name="monitor",
            period="EVERY_MINUTE",
            uri="https://www.one.newrelic.com",
            type="BROWSER",
            locations_publics=["AP_SOUTH_1"],
            enable_screenshot_on_failure_and_script=True,
            validation_string="success",
            verify_ssl=True,
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            script_language="JAVASCRIPT",
            devices=[
                "DESKTOP",
                "TABLET_LANDSCAPE",
                "MOBILE_PORTRAIT",
            ],
            browsers=["CHROME"],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        See additional examples.

        ## Additional Examples

        ### Create a monitor with a private location

        The below example shows how you can define a private location and attach it to a monitor.

        > **NOTE:** It can take up to 10 minutes for a private location to become available.

        ##### Type: `SIMPLE`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Example private location",
            name="private_location",
            verified_script_execution=False)
        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            name="monitor",
            period="EVERY_MINUTE",
            uri="https://www.one.newrelic.com",
            type="SIMPLE",
            locations_privates=[location.id],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            treat_redirect_as_failure=True,
            validation_string="success",
            bypass_head_request=True,
            verify_ssl=True,
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        ##### Type: `BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Example private location",
            name="private-location",
            verified_script_execution=False)
        monitor = newrelic.synthetics.Monitor("monitor",
            status="ENABLED",
            type="BROWSER",
            uri="https://www.one.newrelic.com",
            name="monitor",
            period="EVERY_MINUTE",
            locations_privates=[location.id],
            enable_screenshot_on_failure_and_script=True,
            validation_string="success",
            verify_ssl=True,
            runtime_type_version="100",
            runtime_type="CHROME_BROWSER",
            script_language="JAVASCRIPT",
            devices=[
                "DESKTOP",
                "TABLET_LANDSCAPE",
                "MOBILE_PORTRAIT",
            ],
            browsers=["CHROME"],
            custom_headers=[{
                "name": "some_name",
                "value": "some_value",
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```

        ## Import

        Synthetics monitor can be imported using the `guid`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:synthetics/monitor:Monitor monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bypass_head_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorCustomHeaderArgs', 'MonitorCustomHeaderArgsDict']]]]] = None,
                 device_orientation: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations_privates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 script_language: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagArgs', 'MonitorTagArgsDict']]]]] = None,
                 treat_redirect_as_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 validation_string: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["browsers"] = browsers
            __props__.__dict__["bypass_head_request"] = bypass_head_request
            __props__.__dict__["custom_headers"] = custom_headers
            __props__.__dict__["device_orientation"] = device_orientation
            __props__.__dict__["device_type"] = device_type
            __props__.__dict__["devices"] = devices
            __props__.__dict__["enable_screenshot_on_failure_and_script"] = enable_screenshot_on_failure_and_script
            __props__.__dict__["locations_privates"] = locations_privates
            __props__.__dict__["locations_publics"] = locations_publics
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["runtime_type"] = runtime_type
            __props__.__dict__["runtime_type_version"] = runtime_type_version
            __props__.__dict__["script_language"] = script_language
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["treat_redirect_as_failure"] = treat_redirect_as_failure
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uri"] = uri
            __props__.__dict__["use_unsupported_legacy_runtime"] = use_unsupported_legacy_runtime
            __props__.__dict__["validation_string"] = validation_string
            __props__.__dict__["verify_ssl"] = verify_ssl
            __props__.__dict__["monitor_id"] = None
            __props__.__dict__["period_in_minutes"] = None
        super(Monitor, __self__).__init__(
            'newrelic:synthetics/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bypass_head_request: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorCustomHeaderArgs', 'MonitorCustomHeaderArgsDict']]]]] = None,
            device_orientation: Optional[pulumi.Input[_builtins.str]] = None,
            device_type: Optional[pulumi.Input[_builtins.str]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
            locations_privates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            period_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
            script_language: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagArgs', 'MonitorTagArgsDict']]]]] = None,
            treat_redirect_as_failure: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None,
            use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
            validation_string: Optional[pulumi.Input[_builtins.str]] = None,
            verify_ssl: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[_builtins.bool] bypass_head_request: Monitor should skip default HEAD request and instead use GET verb in check.
               
               The `BROWSER` monitor type supports the following additional arguments:
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorCustomHeaderArgs', 'MonitorCustomHeaderArgsDict']]]] custom_headers: Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        :param pulumi.Input[_builtins.str] device_orientation: Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[_builtins.str] device_type: Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
               * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_privates: The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] monitor_id: The monitor id of the Synthetics monitor (not to be confused with the GUID of the monitor).
        :param pulumi.Input[_builtins.str] name: The human-readable identifier for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.int] period_in_minutes: The interval in minutes at which Synthetic monitor should run.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific version of the runtime type selected (`100`).
        :param pulumi.Input[_builtins.str] script_language: The programing language that should execute the script.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagArgs', 'MonitorTagArgsDict']]]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SIMPLE` monitor type supports the following additional arguments:
        :param pulumi.Input[_builtins.bool] treat_redirect_as_failure: Categorize redirects during a monitor job as a failure.
        :param pulumi.Input[_builtins.str] type: The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        :param pulumi.Input[_builtins.str] uri: The URI the monitor runs against.
        :param pulumi.Input[_builtins.str] validation_string: Validation text for monitor to search for at given URI.
        :param pulumi.Input[_builtins.bool] verify_ssl: Monitor should validate SSL certificate chain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["browsers"] = browsers
        __props__.__dict__["bypass_head_request"] = bypass_head_request
        __props__.__dict__["custom_headers"] = custom_headers
        __props__.__dict__["device_orientation"] = device_orientation
        __props__.__dict__["device_type"] = device_type
        __props__.__dict__["devices"] = devices
        __props__.__dict__["enable_screenshot_on_failure_and_script"] = enable_screenshot_on_failure_and_script
        __props__.__dict__["locations_privates"] = locations_privates
        __props__.__dict__["locations_publics"] = locations_publics
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_in_minutes"] = period_in_minutes
        __props__.__dict__["runtime_type"] = runtime_type
        __props__.__dict__["runtime_type_version"] = runtime_type_version
        __props__.__dict__["script_language"] = script_language
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["treat_redirect_as_failure"] = treat_redirect_as_failure
        __props__.__dict__["type"] = type
        __props__.__dict__["uri"] = uri
        __props__.__dict__["use_unsupported_legacy_runtime"] = use_unsupported_legacy_runtime
        __props__.__dict__["validation_string"] = validation_string
        __props__.__dict__["verify_ssl"] = verify_ssl
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def browsers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        """
        return pulumi.get(self, "browsers")

    @_builtins.property
    @pulumi.getter(name="bypassHeadRequest")
    def bypass_head_request(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Monitor should skip default HEAD request and instead use GET verb in check.

        The `BROWSER` monitor type supports the following additional arguments:
        """
        return pulumi.get(self, "bypass_head_request")

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorCustomHeader']]]:
        """
        Custom headers to use in monitor job. See Nested custom_header blocks below for details.
        """
        return pulumi.get(self, "custom_headers")

    @_builtins.property
    @pulumi.getter(name="deviceOrientation")
    def device_orientation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Device emulation orientation field. Valid values are `LANDSCAPE` and `PORTRAIT`. 
        * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        """
        return pulumi.get(self, "device_orientation")

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Device emulation type field. Valid values are `MOBILE` and `TABLET`. 
        * We recommend you to use `devices` field instead of `device_type`,`device_orientation` fields, as it allows you to select multiple combinations of device types and orientations.
        """
        return pulumi.get(self, "device_type")

    @_builtins.property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        """
        return pulumi.get(self, "devices")

    @_builtins.property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Capture a screenshot during job execution.
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @_builtins.property
    @pulumi.getter(name="locationsPrivates")
    def locations_privates(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The location the monitor will run from. Accepts a list of private location GUIDs. At least one of either `locations_public` or `locations_private` is required.
        """
        return pulumi.get(self, "locations_privates")

    @_builtins.property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        """
        return pulumi.get(self, "locations_publics")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The monitor id of the Synthetics monitor (not to be confused with the GUID of the monitor).
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable identifier for the monitor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.str]:
        """
        The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodInMinutes")
    def period_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        The interval in minutes at which Synthetic monitor should run.
        """
        return pulumi.get(self, "period_in_minutes")

    @_builtins.property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        """
        return pulumi.get(self, "runtime_type")

    @_builtins.property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specific version of the runtime type selected (`100`).
        """
        return pulumi.get(self, "runtime_type_version")

    @_builtins.property
    @pulumi.getter(name="scriptLanguage")
    def script_language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The programing language that should execute the script.
        """
        return pulumi.get(self, "script_language")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The run state of the monitor. (`ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorTag']]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.

        The `SIMPLE` monitor type supports the following additional arguments:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="treatRedirectAsFailure")
    def treat_redirect_as_failure(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Categorize redirects during a monitor job as a failure.
        """
        return pulumi.get(self, "treat_redirect_as_failure")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The monitor type. Valid values are `SIMPLE` and `BROWSER`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI the monitor runs against.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="useUnsupportedLegacyRuntime")
    def use_unsupported_legacy_runtime(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "use_unsupported_legacy_runtime")

    @_builtins.property
    @pulumi.getter(name="validationString")
    def validation_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Validation text for monitor to search for at given URI.
        """
        return pulumi.get(self, "validation_string")

    @_builtins.property
    @pulumi.getter(name="verifySsl")
    def verify_ssl(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Monitor should validate SSL certificate chain.
        """
        return pulumi.get(self, "verify_ssl")

