# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BigquerySemanticLayerCredentialArgs', 'BigquerySemanticLayerCredential']

@pulumi.input_type
class BigquerySemanticLayerCredentialArgs:
    def __init__(__self__, *,
                 auth_provider_x509_cert_url: pulumi.Input[builtins.str],
                 auth_uri: pulumi.Input[builtins.str],
                 client_email: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 client_x509_cert_url: pulumi.Input[builtins.str],
                 configuration: pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs'],
                 credential: pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs'],
                 private_key: pulumi.Input[builtins.str],
                 private_key_id: pulumi.Input[builtins.str],
                 token_uri: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a BigquerySemanticLayerCredential resource.
        :param pulumi.Input[builtins.str] auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param pulumi.Input[builtins.str] auth_uri: Auth URI for the Service Account
        :param pulumi.Input[builtins.str] client_email: Service Account email
        :param pulumi.Input[builtins.str] client_id: Client ID of the Service Account
        :param pulumi.Input[builtins.str] client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs'] credential: BigQuery credential details, but used in the context of the Semantic Layer.
        :param pulumi.Input[builtins.str] private_key: Private Key for the Service Account
        :param pulumi.Input[builtins.str] private_key_id: Private Key ID for the Service Account
        :param pulumi.Input[builtins.str] token_uri: Token URI for the Service Account
        """
        pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        pulumi.set(__self__, "auth_uri", auth_uri)
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "token_uri", token_uri)

    @property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> pulumi.Input[builtins.str]:
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @auth_provider_x509_cert_url.setter
    def auth_provider_x509_cert_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auth_provider_x509_cert_url", value)

    @property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> pulumi.Input[builtins.str]:
        """
        Auth URI for the Service Account
        """
        return pulumi.get(self, "auth_uri")

    @auth_uri.setter
    def auth_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auth_uri", value)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Input[builtins.str]:
        """
        Service Account email
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        Client ID of the Service Account
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> pulumi.Input[builtins.str]:
        """
        Client X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "client_x509_cert_url")

    @client_x509_cert_url.setter
    def client_x509_cert_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_x509_cert_url", value)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs']:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs']:
        """
        BigQuery credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs']):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[builtins.str]:
        """
        Private Key for the Service Account
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Input[builtins.str]:
        """
        Private Key ID for the Service Account
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key_id", value)

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> pulumi.Input[builtins.str]:
        """
        Token URI for the Service Account
        """
        return pulumi.get(self, "token_uri")

    @token_uri.setter
    def token_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_uri", value)


@pulumi.input_type
class _BigquerySemanticLayerCredentialState:
    def __init__(__self__, *,
                 auth_provider_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
                 auth_uri: Optional[pulumi.Input[builtins.str]] = None,
                 client_email: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs']] = None,
                 credential: Optional[pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs']] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 token_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BigquerySemanticLayerCredential resources.
        :param pulumi.Input[builtins.str] auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param pulumi.Input[builtins.str] auth_uri: Auth URI for the Service Account
        :param pulumi.Input[builtins.str] client_email: Service Account email
        :param pulumi.Input[builtins.str] client_id: Client ID of the Service Account
        :param pulumi.Input[builtins.str] client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs'] credential: BigQuery credential details, but used in the context of the Semantic Layer.
        :param pulumi.Input[builtins.str] private_key: Private Key for the Service Account
        :param pulumi.Input[builtins.str] private_key_id: Private Key ID for the Service Account
        :param pulumi.Input[builtins.str] token_uri: Token URI for the Service Account
        """
        if auth_provider_x509_cert_url is not None:
            pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        if auth_uri is not None:
            pulumi.set(__self__, "auth_uri", auth_uri)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_x509_cert_url is not None:
            pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if token_uri is not None:
            pulumi.set(__self__, "token_uri", token_uri)

    @property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @auth_provider_x509_cert_url.setter
    def auth_provider_x509_cert_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_provider_x509_cert_url", value)

    @property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auth URI for the Service Account
        """
        return pulumi.get(self, "auth_uri")

    @auth_uri.setter
    def auth_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_uri", value)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Account email
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client ID of the Service Account
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "client_x509_cert_url")

    @client_x509_cert_url.setter
    def client_x509_cert_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_x509_cert_url", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs']]:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['BigquerySemanticLayerCredentialConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs']]:
        """
        BigQuery credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['BigquerySemanticLayerCredentialCredentialArgs']]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private Key for the Service Account
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private Key ID for the Service Account
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Token URI for the Service Account
        """
        return pulumi.get(self, "token_uri")

    @token_uri.setter
    def token_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_uri", value)


@pulumi.type_token("dbtcloud:index/bigquerySemanticLayerCredential:BigquerySemanticLayerCredential")
class BigquerySemanticLayerCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_provider_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
                 auth_uri: Optional[pulumi.Input[builtins.str]] = None,
                 client_email: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['BigquerySemanticLayerCredentialConfigurationArgs', 'BigquerySemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['BigquerySemanticLayerCredentialCredentialArgs', 'BigquerySemanticLayerCredentialCredentialArgsDict']]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 token_uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        BigQuery credential resource. This resource is composed of a BigQuery credential and a Semantic Layer configuration. It is used to create a BigQuery credential for the Semantic Layer.

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_bigquery_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_bigquery_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/bigquerySemanticLayerCredential:BigquerySemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/bigquerySemanticLayerCredential:BigquerySemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param pulumi.Input[builtins.str] auth_uri: Auth URI for the Service Account
        :param pulumi.Input[builtins.str] client_email: Service Account email
        :param pulumi.Input[builtins.str] client_id: Client ID of the Service Account
        :param pulumi.Input[builtins.str] client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param pulumi.Input[Union['BigquerySemanticLayerCredentialConfigurationArgs', 'BigquerySemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input[Union['BigquerySemanticLayerCredentialCredentialArgs', 'BigquerySemanticLayerCredentialCredentialArgsDict']] credential: BigQuery credential details, but used in the context of the Semantic Layer.
        :param pulumi.Input[builtins.str] private_key: Private Key for the Service Account
        :param pulumi.Input[builtins.str] private_key_id: Private Key ID for the Service Account
        :param pulumi.Input[builtins.str] token_uri: Token URI for the Service Account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BigquerySemanticLayerCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BigQuery credential resource. This resource is composed of a BigQuery credential and a Semantic Layer configuration. It is used to create a BigQuery credential for the Semantic Layer.

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_bigquery_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_bigquery_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/bigquerySemanticLayerCredential:BigquerySemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/bigquerySemanticLayerCredential:BigquerySemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param BigquerySemanticLayerCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BigquerySemanticLayerCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_provider_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
                 auth_uri: Optional[pulumi.Input[builtins.str]] = None,
                 client_email: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['BigquerySemanticLayerCredentialConfigurationArgs', 'BigquerySemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['BigquerySemanticLayerCredentialCredentialArgs', 'BigquerySemanticLayerCredentialCredentialArgsDict']]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 token_uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BigquerySemanticLayerCredentialArgs.__new__(BigquerySemanticLayerCredentialArgs)

            if auth_provider_x509_cert_url is None and not opts.urn:
                raise TypeError("Missing required property 'auth_provider_x509_cert_url'")
            __props__.__dict__["auth_provider_x509_cert_url"] = auth_provider_x509_cert_url
            if auth_uri is None and not opts.urn:
                raise TypeError("Missing required property 'auth_uri'")
            __props__.__dict__["auth_uri"] = auth_uri
            if client_email is None and not opts.urn:
                raise TypeError("Missing required property 'client_email'")
            __props__.__dict__["client_email"] = client_email
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_x509_cert_url is None and not opts.urn:
                raise TypeError("Missing required property 'client_x509_cert_url'")
            __props__.__dict__["client_x509_cert_url"] = client_x509_cert_url
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if credential is None and not opts.urn:
                raise TypeError("Missing required property 'credential'")
            __props__.__dict__["credential"] = credential
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if private_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_key_id'")
            __props__.__dict__["private_key_id"] = private_key_id
            if token_uri is None and not opts.urn:
                raise TypeError("Missing required property 'token_uri'")
            __props__.__dict__["token_uri"] = token_uri
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BigquerySemanticLayerCredential, __self__).__init__(
            'dbtcloud:index/bigquerySemanticLayerCredential:BigquerySemanticLayerCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_provider_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
            auth_uri: Optional[pulumi.Input[builtins.str]] = None,
            client_email: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_x509_cert_url: Optional[pulumi.Input[builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['BigquerySemanticLayerCredentialConfigurationArgs', 'BigquerySemanticLayerCredentialConfigurationArgsDict']]] = None,
            credential: Optional[pulumi.Input[Union['BigquerySemanticLayerCredentialCredentialArgs', 'BigquerySemanticLayerCredentialCredentialArgsDict']]] = None,
            private_key: Optional[pulumi.Input[builtins.str]] = None,
            private_key_id: Optional[pulumi.Input[builtins.str]] = None,
            token_uri: Optional[pulumi.Input[builtins.str]] = None) -> 'BigquerySemanticLayerCredential':
        """
        Get an existing BigquerySemanticLayerCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param pulumi.Input[builtins.str] auth_uri: Auth URI for the Service Account
        :param pulumi.Input[builtins.str] client_email: Service Account email
        :param pulumi.Input[builtins.str] client_id: Client ID of the Service Account
        :param pulumi.Input[builtins.str] client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param pulumi.Input[Union['BigquerySemanticLayerCredentialConfigurationArgs', 'BigquerySemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input[Union['BigquerySemanticLayerCredentialCredentialArgs', 'BigquerySemanticLayerCredentialCredentialArgsDict']] credential: BigQuery credential details, but used in the context of the Semantic Layer.
        :param pulumi.Input[builtins.str] private_key: Private Key for the Service Account
        :param pulumi.Input[builtins.str] private_key_id: Private Key ID for the Service Account
        :param pulumi.Input[builtins.str] token_uri: Token URI for the Service Account
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BigquerySemanticLayerCredentialState.__new__(_BigquerySemanticLayerCredentialState)

        __props__.__dict__["auth_provider_x509_cert_url"] = auth_provider_x509_cert_url
        __props__.__dict__["auth_uri"] = auth_uri
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_x509_cert_url"] = client_x509_cert_url
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["credential"] = credential
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["token_uri"] = token_uri
        return BigquerySemanticLayerCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> pulumi.Output[builtins.str]:
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> pulumi.Output[builtins.str]:
        """
        Auth URI for the Service Account
        """
        return pulumi.get(self, "auth_uri")

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[builtins.str]:
        """
        Service Account email
        """
        return pulumi.get(self, "client_email")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        Client ID of the Service Account
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> pulumi.Output[builtins.str]:
        """
        Client X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "client_x509_cert_url")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.BigquerySemanticLayerCredentialConfiguration']:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Output['outputs.BigquerySemanticLayerCredentialCredential']:
        """
        BigQuery credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[builtins.str]:
        """
        Private Key for the Service Account
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[builtins.str]:
        """
        Private Key ID for the Service Account
        """
        return pulumi.get(self, "private_key_id")

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> pulumi.Output[builtins.str]:
        """
        Token URI for the Service Account
        """
        return pulumi.get(self, "token_uri")

