# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetBigQueryCredentialResult',
    'AwaitableGetBigQueryCredentialResult',
    'get_big_query_credential',
    'get_big_query_credential_output',
]

@pulumi.output_type
class GetBigQueryCredentialResult:
    """
    A collection of values returned by getBigQueryCredential.
    """
    def __init__(__self__, credential_id=None, dataset=None, id=None, is_active=None, num_threads=None, project_id=None):
        if credential_id and not isinstance(credential_id, int):
            raise TypeError("Expected argument 'credential_id' to be a int")
        pulumi.set(__self__, "credential_id", credential_id)
        if dataset and not isinstance(dataset, str):
            raise TypeError("Expected argument 'dataset' to be a str")
        pulumi.set(__self__, "dataset", dataset)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if num_threads and not isinstance(num_threads, int):
            raise TypeError("Expected argument 'num_threads' to be a int")
        pulumi.set(__self__, "num_threads", num_threads)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> builtins.int:
        """
        Credential ID
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter
    def dataset(self) -> builtins.str:
        """
        Default dataset name
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this data source. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> builtins.bool:
        """
        Whether the BigQuery credential is active
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> builtins.int:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.int:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")


class AwaitableGetBigQueryCredentialResult(GetBigQueryCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBigQueryCredentialResult(
            credential_id=self.credential_id,
            dataset=self.dataset,
            id=self.id,
            is_active=self.is_active,
            num_threads=self.num_threads,
            project_id=self.project_id)


def get_big_query_credential(credential_id: Optional[builtins.int] = None,
                             project_id: Optional[builtins.int] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBigQueryCredentialResult:
    """
    Bigquery credential data source


    :param builtins.int credential_id: Credential ID
    :param builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getBigQueryCredential:getBigQueryCredential', __args__, opts=opts, typ=GetBigQueryCredentialResult).value

    return AwaitableGetBigQueryCredentialResult(
        credential_id=pulumi.get(__ret__, 'credential_id'),
        dataset=pulumi.get(__ret__, 'dataset'),
        id=pulumi.get(__ret__, 'id'),
        is_active=pulumi.get(__ret__, 'is_active'),
        num_threads=pulumi.get(__ret__, 'num_threads'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_big_query_credential_output(credential_id: Optional[pulumi.Input[builtins.int]] = None,
                                    project_id: Optional[pulumi.Input[builtins.int]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBigQueryCredentialResult]:
    """
    Bigquery credential data source


    :param builtins.int credential_id: Credential ID
    :param builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getBigQueryCredential:getBigQueryCredential', __args__, opts=opts, typ=GetBigQueryCredentialResult)
    return __ret__.apply(lambda __response__: GetBigQueryCredentialResult(
        credential_id=pulumi.get(__response__, 'credential_id'),
        dataset=pulumi.get(__response__, 'dataset'),
        id=pulumi.get(__response__, 'id'),
        is_active=pulumi.get(__response__, 'is_active'),
        num_threads=pulumi.get(__response__, 'num_threads'),
        project_id=pulumi.get(__response__, 'project_id')))
