# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentsResult',
    'AwaitableGetEnvironmentsResult',
    'get_environments',
    'get_environments_output',
]

@pulumi.output_type
class GetEnvironmentsResult:
    """
    A collection of values returned by getEnvironments.
    """
    def __init__(__self__, environments=None, id=None, project_id=None):
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetEnvironmentsEnvironmentResult']:
        """
        The list of environments
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.int]:
        """
        The project ID to filter the environments for [Optional]
        """
        return pulumi.get(self, "project_id")


class AwaitableGetEnvironmentsResult(GetEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentsResult(
            environments=self.environments,
            id=self.id,
            project_id=self.project_id)


def get_environments(project_id: Optional[builtins.int] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentsResult:
    """
    Retrieve data for multiple environments


    :param builtins.int project_id: The project ID to filter the environments for [Optional]
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getEnvironments:getEnvironments', __args__, opts=opts, typ=GetEnvironmentsResult).value

    return AwaitableGetEnvironmentsResult(
        environments=pulumi.get(__ret__, 'environments'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_environments_output(project_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvironmentsResult]:
    """
    Retrieve data for multiple environments


    :param builtins.int project_id: The project ID to filter the environments for [Optional]
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getEnvironments:getEnvironments', __args__, opts=opts, typ=GetEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetEnvironmentsResult(
        environments=pulumi.get(__response__, 'environments'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id')))
