# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
    'get_group_output',
]

@pulumi.output_type
class GetGroupResult:
    """
    A collection of values returned by getGroup.
    """
    def __init__(__self__, assign_by_default=None, group_id=None, group_permissions=None, id=None, name=None, sso_mapping_groups=None):
        if assign_by_default and not isinstance(assign_by_default, bool):
            raise TypeError("Expected argument 'assign_by_default' to be a bool")
        pulumi.set(__self__, "assign_by_default", assign_by_default)
        if group_id and not isinstance(group_id, int):
            raise TypeError("Expected argument 'group_id' to be a int")
        pulumi.set(__self__, "group_id", group_id)
        if group_permissions and not isinstance(group_permissions, list):
            raise TypeError("Expected argument 'group_permissions' to be a list")
        pulumi.set(__self__, "group_permissions", group_permissions)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sso_mapping_groups and not isinstance(sso_mapping_groups, list):
            raise TypeError("Expected argument 'sso_mapping_groups' to be a list")
        pulumi.set(__self__, "sso_mapping_groups", sso_mapping_groups)

    @property
    @pulumi.getter(name="assignByDefault")
    def assign_by_default(self) -> builtins.bool:
        """
        Whether the group will be assigned by default to users. The value needs to be the same for all partial permissions for the same group.
        """
        return pulumi.get(self, "assign_by_default")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> builtins.int:
        """
        The ID of the group
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupPermissions")
    def group_permissions(self) -> Sequence['outputs.GetGroupGroupPermissionResult']:
        """
        Partial permissions for the group. Those permissions will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "group_permissions")

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        """
        The ID of this resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Group name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ssoMappingGroups")
    def sso_mapping_groups(self) -> Sequence[builtins.str]:
        """
        SSO mapping group names for this group
        """
        return pulumi.get(self, "sso_mapping_groups")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            assign_by_default=self.assign_by_default,
            group_id=self.group_id,
            group_permissions=self.group_permissions,
            id=self.id,
            name=self.name,
            sso_mapping_groups=self.sso_mapping_groups)


def get_group(group_id: Optional[builtins.int] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Retrieve group details


    :param builtins.int group_id: The ID of the group
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getGroup:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        assign_by_default=pulumi.get(__ret__, 'assign_by_default'),
        group_id=pulumi.get(__ret__, 'group_id'),
        group_permissions=pulumi.get(__ret__, 'group_permissions'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        sso_mapping_groups=pulumi.get(__ret__, 'sso_mapping_groups'))
def get_group_output(group_id: Optional[pulumi.Input[builtins.int]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupResult]:
    """
    Retrieve group details


    :param builtins.int group_id: The ID of the group
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getGroup:getGroup', __args__, opts=opts, typ=GetGroupResult)
    return __ret__.apply(lambda __response__: GetGroupResult(
        assign_by_default=pulumi.get(__response__, 'assign_by_default'),
        group_id=pulumi.get(__response__, 'group_id'),
        group_permissions=pulumi.get(__response__, 'group_permissions'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        sso_mapping_groups=pulumi.get(__response__, 'sso_mapping_groups')))
