# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupUsersResult',
    'AwaitableGetGroupUsersResult',
    'get_group_users',
    'get_group_users_output',
]

@pulumi.output_type
class GetGroupUsersResult:
    """
    A collection of values returned by getGroupUsers.
    """
    def __init__(__self__, group_id=None, id=None, users=None):
        if group_id and not isinstance(group_id, int):
            raise TypeError("Expected argument 'group_id' to be a int")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> builtins.int:
        """
        ID of the group
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetGroupUsersUserResult']:
        """
        List of users (map of ID and email) in the group
        """
        return pulumi.get(self, "users")


class AwaitableGetGroupUsersResult(GetGroupUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupUsersResult(
            group_id=self.group_id,
            id=self.id,
            users=self.users)


def get_group_users(group_id: Optional[builtins.int] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupUsersResult:
    """
    Databricks credential data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_group_users = dbtcloud.get_group_users(group_id=1234)
    ```


    :param builtins.int group_id: ID of the group
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getGroupUsers:getGroupUsers', __args__, opts=opts, typ=GetGroupUsersResult).value

    return AwaitableGetGroupUsersResult(
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        users=pulumi.get(__ret__, 'users'))
def get_group_users_output(group_id: Optional[pulumi.Input[builtins.int]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupUsersResult]:
    """
    Databricks credential data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_group_users = dbtcloud.get_group_users(group_id=1234)
    ```


    :param builtins.int group_id: ID of the group
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getGroupUsers:getGroupUsers', __args__, opts=opts, typ=GetGroupUsersResult)
    return __ret__.apply(lambda __response__: GetGroupUsersResult(
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        users=pulumi.get(__response__, 'users')))
