# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    """
    A collection of values returned by getJob.
    """
    def __init__(__self__, dbt_version=None, deferring_environment_id=None, deferring_job_id=None, description=None, environment=None, environment_id=None, execute_steps=None, execution=None, generate_docs=None, id=None, job_completion_trigger_conditions=None, job_id=None, job_type=None, name=None, project_id=None, run_compare_changes=None, run_generate_sources=None, schedule=None, self_deferring=None, settings=None, timeout_seconds=None, triggers=None, triggers_on_draft_pr=None):
        if dbt_version and not isinstance(dbt_version, str):
            raise TypeError("Expected argument 'dbt_version' to be a str")
        pulumi.set(__self__, "dbt_version", dbt_version)
        if deferring_environment_id and not isinstance(deferring_environment_id, int):
            raise TypeError("Expected argument 'deferring_environment_id' to be a int")
        pulumi.set(__self__, "deferring_environment_id", deferring_environment_id)
        if deferring_job_id and not isinstance(deferring_job_id, int):
            raise TypeError("Expected argument 'deferring_job_id' to be a int")
        pulumi.set(__self__, "deferring_job_id", deferring_job_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if environment_id and not isinstance(environment_id, int):
            raise TypeError("Expected argument 'environment_id' to be a int")
        pulumi.set(__self__, "environment_id", environment_id)
        if execute_steps and not isinstance(execute_steps, list):
            raise TypeError("Expected argument 'execute_steps' to be a list")
        pulumi.set(__self__, "execute_steps", execute_steps)
        if execution and not isinstance(execution, dict):
            raise TypeError("Expected argument 'execution' to be a dict")
        pulumi.set(__self__, "execution", execution)
        if generate_docs and not isinstance(generate_docs, bool):
            raise TypeError("Expected argument 'generate_docs' to be a bool")
        pulumi.set(__self__, "generate_docs", generate_docs)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if job_completion_trigger_conditions and not isinstance(job_completion_trigger_conditions, list):
            raise TypeError("Expected argument 'job_completion_trigger_conditions' to be a list")
        pulumi.set(__self__, "job_completion_trigger_conditions", job_completion_trigger_conditions)
        if job_id and not isinstance(job_id, int):
            raise TypeError("Expected argument 'job_id' to be a int")
        pulumi.set(__self__, "job_id", job_id)
        if job_type and not isinstance(job_type, str):
            raise TypeError("Expected argument 'job_type' to be a str")
        pulumi.set(__self__, "job_type", job_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if run_compare_changes and not isinstance(run_compare_changes, bool):
            raise TypeError("Expected argument 'run_compare_changes' to be a bool")
        pulumi.set(__self__, "run_compare_changes", run_compare_changes)
        if run_generate_sources and not isinstance(run_generate_sources, bool):
            raise TypeError("Expected argument 'run_generate_sources' to be a bool")
        pulumi.set(__self__, "run_generate_sources", run_generate_sources)
        if schedule and not isinstance(schedule, dict):
            raise TypeError("Expected argument 'schedule' to be a dict")
        pulumi.set(__self__, "schedule", schedule)
        if self_deferring and not isinstance(self_deferring, bool):
            raise TypeError("Expected argument 'self_deferring' to be a bool")
        pulumi.set(__self__, "self_deferring", self_deferring)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if timeout_seconds and not isinstance(timeout_seconds, int):
            raise TypeError("Expected argument 'timeout_seconds' to be a int")
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if triggers and not isinstance(triggers, dict):
            raise TypeError("Expected argument 'triggers' to be a dict")
        pulumi.set(__self__, "triggers", triggers)
        if triggers_on_draft_pr and not isinstance(triggers_on_draft_pr, bool):
            raise TypeError("Expected argument 'triggers_on_draft_pr' to be a bool")
        pulumi.set(__self__, "triggers_on_draft_pr", triggers_on_draft_pr)

    @property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> builtins.str:
        """
        The version of dbt used for the job. If not set, the environment version will be used.
        """
        return pulumi.get(self, "dbt_version")

    @property
    @pulumi.getter(name="deferringEnvironmentId")
    def deferring_environment_id(self) -> builtins.int:
        """
        The ID of the environment this job defers to
        """
        return pulumi.get(self, "deferring_environment_id")

    @property
    @pulumi.getter(name="deferringJobId")
    @_utilities.deprecated("""Deferral is now set at the environment level""")
    def deferring_job_id(self) -> builtins.int:
        """
        [Deprectated - Deferral is now set at the environment level] The ID of the job definition this job defers to
        """
        return pulumi.get(self, "deferring_job_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the job
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GetJobEnvironmentResult':
        """
        Details of the environment the job is running in
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> builtins.int:
        """
        The ID of environment
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="executeSteps")
    def execute_steps(self) -> Sequence[builtins.str]:
        """
        The list of steps to run in the job
        """
        return pulumi.get(self, "execute_steps")

    @property
    @pulumi.getter
    def execution(self) -> 'outputs.GetJobExecutionResult':
        return pulumi.get(self, "execution")

    @property
    @pulumi.getter(name="generateDocs")
    def generate_docs(self) -> builtins.bool:
        """
        Whether the job generate docs
        """
        return pulumi.get(self, "generate_docs")

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        """
        The ID of the job
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobCompletionTriggerConditions")
    def job_completion_trigger_conditions(self) -> Sequence['outputs.GetJobJobCompletionTriggerConditionResult']:
        """
        Which other job should trigger this job when it finishes, and on which conditions. Format for the property will change in the next release to match the one from the one from dbtcloud*jobs.
        """
        return pulumi.get(self, "job_completion_trigger_conditions")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> builtins.int:
        """
        The ID of the job
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> builtins.str:
        """
        The type of job (e.g. CI, scheduled)
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the job
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="runCompareChanges")
    def run_compare_changes(self) -> builtins.bool:
        """
        Whether the job should compare data changes introduced by the code change in the PR
        """
        return pulumi.get(self, "run_compare_changes")

    @property
    @pulumi.getter(name="runGenerateSources")
    def run_generate_sources(self) -> builtins.bool:
        """
        Whether the job test source freshness
        """
        return pulumi.get(self, "run_generate_sources")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.GetJobScheduleResult':
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="selfDeferring")
    def self_deferring(self) -> builtins.bool:
        """
        Whether this job defers on a previous run of itself (overrides value in deferring*job*id)
        """
        return pulumi.get(self, "self_deferring")

    @property
    @pulumi.getter
    def settings(self) -> 'outputs.GetJobSettingsResult':
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="timeoutSeconds")
    @_utilities.deprecated("""Moved to execution.timeout_seconds""")
    def timeout_seconds(self) -> builtins.int:
        """
        [Deprectated - Moved to execution.timeout_seconds] Number of seconds before the job times out
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def triggers(self) -> 'outputs.GetJobTriggersResult':
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter(name="triggersOnDraftPr")
    def triggers_on_draft_pr(self) -> builtins.bool:
        """
        Whether the CI job should be automatically triggered on draft PRs
        """
        return pulumi.get(self, "triggers_on_draft_pr")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            dbt_version=self.dbt_version,
            deferring_environment_id=self.deferring_environment_id,
            deferring_job_id=self.deferring_job_id,
            description=self.description,
            environment=self.environment,
            environment_id=self.environment_id,
            execute_steps=self.execute_steps,
            execution=self.execution,
            generate_docs=self.generate_docs,
            id=self.id,
            job_completion_trigger_conditions=self.job_completion_trigger_conditions,
            job_id=self.job_id,
            job_type=self.job_type,
            name=self.name,
            project_id=self.project_id,
            run_compare_changes=self.run_compare_changes,
            run_generate_sources=self.run_generate_sources,
            schedule=self.schedule,
            self_deferring=self.self_deferring,
            settings=self.settings,
            timeout_seconds=self.timeout_seconds,
            triggers=self.triggers,
            triggers_on_draft_pr=self.triggers_on_draft_pr)


def get_job(job_completion_trigger_conditions: Optional[Sequence[Union['GetJobJobCompletionTriggerConditionArgs', 'GetJobJobCompletionTriggerConditionArgsDict']]] = None,
            job_id: Optional[builtins.int] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Get detailed information for a specific dbt Cloud job.


    :param Sequence[Union['GetJobJobCompletionTriggerConditionArgs', 'GetJobJobCompletionTriggerConditionArgsDict']] job_completion_trigger_conditions: Which other job should trigger this job when it finishes, and on which conditions. Format for the property will change in the next release to match the one from the one from dbtcloud*jobs.
    :param builtins.int job_id: The ID of the job
    """
    __args__ = dict()
    __args__['jobCompletionTriggerConditions'] = job_completion_trigger_conditions
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getJob:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        dbt_version=pulumi.get(__ret__, 'dbt_version'),
        deferring_environment_id=pulumi.get(__ret__, 'deferring_environment_id'),
        deferring_job_id=pulumi.get(__ret__, 'deferring_job_id'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        execute_steps=pulumi.get(__ret__, 'execute_steps'),
        execution=pulumi.get(__ret__, 'execution'),
        generate_docs=pulumi.get(__ret__, 'generate_docs'),
        id=pulumi.get(__ret__, 'id'),
        job_completion_trigger_conditions=pulumi.get(__ret__, 'job_completion_trigger_conditions'),
        job_id=pulumi.get(__ret__, 'job_id'),
        job_type=pulumi.get(__ret__, 'job_type'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        run_compare_changes=pulumi.get(__ret__, 'run_compare_changes'),
        run_generate_sources=pulumi.get(__ret__, 'run_generate_sources'),
        schedule=pulumi.get(__ret__, 'schedule'),
        self_deferring=pulumi.get(__ret__, 'self_deferring'),
        settings=pulumi.get(__ret__, 'settings'),
        timeout_seconds=pulumi.get(__ret__, 'timeout_seconds'),
        triggers=pulumi.get(__ret__, 'triggers'),
        triggers_on_draft_pr=pulumi.get(__ret__, 'triggers_on_draft_pr'))
def get_job_output(job_completion_trigger_conditions: Optional[pulumi.Input[Optional[Sequence[Union['GetJobJobCompletionTriggerConditionArgs', 'GetJobJobCompletionTriggerConditionArgsDict']]]]] = None,
                   job_id: Optional[pulumi.Input[builtins.int]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobResult]:
    """
    Get detailed information for a specific dbt Cloud job.


    :param Sequence[Union['GetJobJobCompletionTriggerConditionArgs', 'GetJobJobCompletionTriggerConditionArgsDict']] job_completion_trigger_conditions: Which other job should trigger this job when it finishes, and on which conditions. Format for the property will change in the next release to match the one from the one from dbtcloud*jobs.
    :param builtins.int job_id: The ID of the job
    """
    __args__ = dict()
    __args__['jobCompletionTriggerConditions'] = job_completion_trigger_conditions
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getJob:getJob', __args__, opts=opts, typ=GetJobResult)
    return __ret__.apply(lambda __response__: GetJobResult(
        dbt_version=pulumi.get(__response__, 'dbt_version'),
        deferring_environment_id=pulumi.get(__response__, 'deferring_environment_id'),
        deferring_job_id=pulumi.get(__response__, 'deferring_job_id'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        execute_steps=pulumi.get(__response__, 'execute_steps'),
        execution=pulumi.get(__response__, 'execution'),
        generate_docs=pulumi.get(__response__, 'generate_docs'),
        id=pulumi.get(__response__, 'id'),
        job_completion_trigger_conditions=pulumi.get(__response__, 'job_completion_trigger_conditions'),
        job_id=pulumi.get(__response__, 'job_id'),
        job_type=pulumi.get(__response__, 'job_type'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        run_compare_changes=pulumi.get(__response__, 'run_compare_changes'),
        run_generate_sources=pulumi.get(__response__, 'run_generate_sources'),
        schedule=pulumi.get(__response__, 'schedule'),
        self_deferring=pulumi.get(__response__, 'self_deferring'),
        settings=pulumi.get(__response__, 'settings'),
        timeout_seconds=pulumi.get(__response__, 'timeout_seconds'),
        triggers=pulumi.get(__response__, 'triggers'),
        triggers_on_draft_pr=pulumi.get(__response__, 'triggers_on_draft_pr')))
