# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWebhookResult',
    'AwaitableGetWebhookResult',
    'get_webhook',
    'get_webhook_output',
]

@pulumi.output_type
class GetWebhookResult:
    """
    A collection of values returned by getWebhook.
    """
    def __init__(__self__, account_identifier=None, active=None, client_url=None, description=None, event_types=None, http_status_code=None, id=None, job_ids=None, name=None, webhook_id=None):
        if account_identifier and not isinstance(account_identifier, str):
            raise TypeError("Expected argument 'account_identifier' to be a str")
        pulumi.set(__self__, "account_identifier", account_identifier)
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if client_url and not isinstance(client_url, str):
            raise TypeError("Expected argument 'client_url' to be a str")
        pulumi.set(__self__, "client_url", client_url)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_types and not isinstance(event_types, list):
            raise TypeError("Expected argument 'event_types' to be a list")
        pulumi.set(__self__, "event_types", event_types)
        if http_status_code and not isinstance(http_status_code, str):
            raise TypeError("Expected argument 'http_status_code' to be a str")
        pulumi.set(__self__, "http_status_code", http_status_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_ids and not isinstance(job_ids, list):
            raise TypeError("Expected argument 'job_ids' to be a list")
        pulumi.set(__self__, "job_ids", job_ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if webhook_id and not isinstance(webhook_id, str):
            raise TypeError("Expected argument 'webhook_id' to be a str")
        pulumi.set(__self__, "webhook_id", webhook_id)

    @property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> builtins.str:
        """
        Webhooks Account Identifier
        """
        return pulumi.get(self, "account_identifier")

    @property
    @pulumi.getter
    def active(self) -> builtins.bool:
        """
        Webhooks active flag
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="clientUrl")
    def client_url(self) -> builtins.str:
        """
        Webhooks Client URL
        """
        return pulumi.get(self, "client_url")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Webhooks Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Sequence[builtins.str]:
        """
        Webhooks Event Types
        """
        return pulumi.get(self, "event_types")

    @property
    @pulumi.getter(name="httpStatusCode")
    def http_status_code(self) -> builtins.str:
        """
        Webhooks HTTP Status Code
        """
        return pulumi.get(self, "http_status_code")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Webhook's ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobIds")
    def job_ids(self) -> Sequence[builtins.int]:
        """
        List of job IDs to trigger the webhook
        """
        return pulumi.get(self, "job_ids")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Webhooks Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="webhookId")
    @_utilities.deprecated("""Use `id` instead""")
    def webhook_id(self) -> builtins.str:
        """
        Webhook's ID
        """
        return pulumi.get(self, "webhook_id")


class AwaitableGetWebhookResult(GetWebhookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebhookResult(
            account_identifier=self.account_identifier,
            active=self.active,
            client_url=self.client_url,
            description=self.description,
            event_types=self.event_types,
            http_status_code=self.http_status_code,
            id=self.id,
            job_ids=self.job_ids,
            name=self.name,
            webhook_id=self.webhook_id)


def get_webhook(webhook_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebhookResult:
    """
    Retrieve webhook details


    :param builtins.str webhook_id: Webhook's ID
    """
    __args__ = dict()
    __args__['webhookId'] = webhook_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getWebhook:getWebhook', __args__, opts=opts, typ=GetWebhookResult).value

    return AwaitableGetWebhookResult(
        account_identifier=pulumi.get(__ret__, 'account_identifier'),
        active=pulumi.get(__ret__, 'active'),
        client_url=pulumi.get(__ret__, 'client_url'),
        description=pulumi.get(__ret__, 'description'),
        event_types=pulumi.get(__ret__, 'event_types'),
        http_status_code=pulumi.get(__ret__, 'http_status_code'),
        id=pulumi.get(__ret__, 'id'),
        job_ids=pulumi.get(__ret__, 'job_ids'),
        name=pulumi.get(__ret__, 'name'),
        webhook_id=pulumi.get(__ret__, 'webhook_id'))
def get_webhook_output(webhook_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebhookResult]:
    """
    Retrieve webhook details


    :param builtins.str webhook_id: Webhook's ID
    """
    __args__ = dict()
    __args__['webhookId'] = webhook_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getWebhook:getWebhook', __args__, opts=opts, typ=GetWebhookResult)
    return __ret__.apply(lambda __response__: GetWebhookResult(
        account_identifier=pulumi.get(__response__, 'account_identifier'),
        active=pulumi.get(__response__, 'active'),
        client_url=pulumi.get(__response__, 'client_url'),
        description=pulumi.get(__response__, 'description'),
        event_types=pulumi.get(__response__, 'event_types'),
        http_status_code=pulumi.get(__response__, 'http_status_code'),
        id=pulumi.get(__response__, 'id'),
        job_ids=pulumi.get(__response__, 'job_ids'),
        name=pulumi.get(__response__, 'name'),
        webhook_id=pulumi.get(__response__, 'webhook_id')))
