# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RedshiftCredentialArgs', 'RedshiftCredential']

@pulumi.input_type
class RedshiftCredentialArgs:
    def __init__(__self__, *,
                 default_schema: pulumi.Input[builtins.str],
                 num_threads: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int],
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RedshiftCredential resource.
        :param pulumi.Input[builtins.str] default_schema: Default schema name
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Redshift credential in
        :param pulumi.Input[builtins.bool] is_active: Whether the Redshift credential is active
        :param pulumi.Input[builtins.str] password: The password for the Redshift account
        :param pulumi.Input[builtins.str] username: The username for the Redshift account.
        """
        pulumi.set(__self__, "default_schema", default_schema)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> pulumi.Input[builtins.str]:
        """
        Default schema name
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_schema", value)

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Input[builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "num_threads", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Redshift credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Redshift credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the Redshift account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the Redshift account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _RedshiftCredentialState:
    def __init__(__self__, *,
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 default_schema: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[builtins.int]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RedshiftCredential resources.
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] default_schema: Default schema name
        :param pulumi.Input[builtins.bool] is_active: Whether the Redshift credential is active
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.str] password: The password for the Redshift account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Redshift credential in
        :param pulumi.Input[builtins.str] username: The username for the Redshift account.
        """
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default schema name
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_schema", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Redshift credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the Redshift account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to create the Redshift credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the Redshift account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("dbtcloud:index/redshiftCredential:RedshiftCredential")
class RedshiftCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_schema: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[builtins.int]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Redshift credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        redshift = dbtcloud.RedshiftCredential("redshift",
            num_threads=16,
            project_id=test_project["id"],
            default_schema="my_schema",
            username="my_username",
            password="my_sensitive_password",
            is_active=True)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_redshift_credential.my_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_redshift_credential.my_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/redshiftCredential:RedshiftCredential my_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/redshiftCredential:RedshiftCredential my_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_schema: Default schema name
        :param pulumi.Input[builtins.bool] is_active: Whether the Redshift credential is active
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.str] password: The password for the Redshift account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Redshift credential in
        :param pulumi.Input[builtins.str] username: The username for the Redshift account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedshiftCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Redshift credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        redshift = dbtcloud.RedshiftCredential("redshift",
            num_threads=16,
            project_id=test_project["id"],
            default_schema="my_schema",
            username="my_username",
            password="my_sensitive_password",
            is_active=True)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_redshift_credential.my_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_redshift_credential.my_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/redshiftCredential:RedshiftCredential my_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/redshiftCredential:RedshiftCredential my_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param RedshiftCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedshiftCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_schema: Optional[pulumi.Input[builtins.str]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[builtins.int]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedshiftCredentialArgs.__new__(RedshiftCredentialArgs)

            if default_schema is None and not opts.urn:
                raise TypeError("Missing required property 'default_schema'")
            __props__.__dict__["default_schema"] = default_schema
            __props__.__dict__["is_active"] = is_active
            if num_threads is None and not opts.urn:
                raise TypeError("Missing required property 'num_threads'")
            __props__.__dict__["num_threads"] = num_threads
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["username"] = username
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RedshiftCredential, __self__).__init__(
            'dbtcloud:index/redshiftCredential:RedshiftCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_id: Optional[pulumi.Input[builtins.int]] = None,
            default_schema: Optional[pulumi.Input[builtins.str]] = None,
            is_active: Optional[pulumi.Input[builtins.bool]] = None,
            num_threads: Optional[pulumi.Input[builtins.int]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'RedshiftCredential':
        """
        Get an existing RedshiftCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] default_schema: Default schema name
        :param pulumi.Input[builtins.bool] is_active: Whether the Redshift credential is active
        :param pulumi.Input[builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[builtins.str] password: The password for the Redshift account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Redshift credential in
        :param pulumi.Input[builtins.str] username: The username for the Redshift account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedshiftCredentialState.__new__(_RedshiftCredentialState)

        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["default_schema"] = default_schema
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["num_threads"] = num_threads
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["username"] = username
        return RedshiftCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> pulumi.Output[builtins.str]:
        """
        Default schema name
        """
        return pulumi.get(self, "default_schema")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the Redshift credential is active
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Output[builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password for the Redshift account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        Project ID to create the Redshift credential in
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        The username for the Redshift account.
        """
        return pulumi.get(self, "username")

