# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SemanticLayerConfigurationArgs', 'SemanticLayerConfiguration']

@pulumi.input_type
class SemanticLayerConfigurationArgs:
    def __init__(__self__, *,
                 environment_id: pulumi.Input[builtins.int],
                 project_id: pulumi.Input[builtins.int]):
        """
        The set of arguments for constructing a SemanticLayerConfiguration resource.
        :param pulumi.Input[builtins.int] environment_id: The ID of the environment
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _SemanticLayerConfigurationState:
    def __init__(__self__, *,
                 environment_id: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SemanticLayerConfiguration resources.
        :param pulumi.Input[builtins.int] environment_id: The ID of the environment
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("dbtcloud:index/semanticLayerConfiguration:SemanticLayerConfiguration")
class SemanticLayerConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_id: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        The resource allows basic configuration of the Semantic Layer for a specific project. For the feature to be completely functional, a Semantic Layer Credential is also required.
        See the documentationh ttps://docs.getdbt.com/docs/use-dbt-semantic-layer/dbt-sl for more information on the Semantic Layer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        example = dbtcloud.SemanticLayerConfiguration("example",
            project_id=project_id,
            environment_id=environment_id)
        ```

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_semantic_layer_configuration.example

          id = "project_id:id"

        }

        import {

          to = dbtcloud_semantic_layer_configuration.example

          id = "12345:5678"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerConfiguration:SemanticLayerConfiguration example "project_id:id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerConfiguration:SemanticLayerConfiguration example 12345:5678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] environment_id: The ID of the environment
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SemanticLayerConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource allows basic configuration of the Semantic Layer for a specific project. For the feature to be completely functional, a Semantic Layer Credential is also required.
        See the documentationh ttps://docs.getdbt.com/docs/use-dbt-semantic-layer/dbt-sl for more information on the Semantic Layer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        example = dbtcloud.SemanticLayerConfiguration("example",
            project_id=project_id,
            environment_id=environment_id)
        ```

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_semantic_layer_configuration.example

          id = "project_id:id"

        }

        import {

          to = dbtcloud_semantic_layer_configuration.example

          id = "12345:5678"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerConfiguration:SemanticLayerConfiguration example "project_id:id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerConfiguration:SemanticLayerConfiguration example 12345:5678
        ```

        :param str resource_name: The name of the resource.
        :param SemanticLayerConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SemanticLayerConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_id: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SemanticLayerConfigurationArgs.__new__(SemanticLayerConfigurationArgs)

            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
        super(SemanticLayerConfiguration, __self__).__init__(
            'dbtcloud:index/semanticLayerConfiguration:SemanticLayerConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            environment_id: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None) -> 'SemanticLayerConfiguration':
        """
        Get an existing SemanticLayerConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] environment_id: The ID of the environment
        :param pulumi.Input[builtins.int] project_id: The ID of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SemanticLayerConfigurationState.__new__(_SemanticLayerConfigurationState)

        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["project_id"] = project_id
        return SemanticLayerConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

