# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnowflakeSemanticLayerCredentialArgs', 'SnowflakeSemanticLayerCredential']

@pulumi.input_type
class SnowflakeSemanticLayerCredentialArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs'],
                 credential: pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs']):
        """
        The set of arguments for constructing a SnowflakeSemanticLayerCredential resource.
        :param pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credenttial configuration details.
        :param pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs'] credential: Snowflake credential details, but used in the context of the Semantic Layer.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "credential", credential)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs']:
        """
        Semantic Layer credenttial configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs']:
        """
        Snowflake credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs']):
        pulumi.set(self, "credential", value)


@pulumi.input_type
class _SnowflakeSemanticLayerCredentialState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs']] = None,
                 credential: Optional[pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs']] = None):
        """
        Input properties used for looking up and filtering SnowflakeSemanticLayerCredential resources.
        :param pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credenttial configuration details.
        :param pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs'] credential: Snowflake credential details, but used in the context of the Semantic Layer.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs']]:
        """
        Semantic Layer credenttial configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['SnowflakeSemanticLayerCredentialConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs']]:
        """
        Snowflake credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['SnowflakeSemanticLayerCredentialCredentialArgs']]):
        pulumi.set(self, "credential", value)


@pulumi.type_token("dbtcloud:index/snowflakeSemanticLayerCredential:SnowflakeSemanticLayerCredential")
class SnowflakeSemanticLayerCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['SnowflakeSemanticLayerCredentialConfigurationArgs', 'SnowflakeSemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['SnowflakeSemanticLayerCredentialCredentialArgs', 'SnowflakeSemanticLayerCredentialCredentialArgsDict']]] = None,
                 __props__=None):
        """
        Snowflake credential resource. This resource is composed of a Snowflake credential and a Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_snowflake_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_snowflake_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/snowflakeSemanticLayerCredential:SnowflakeSemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/snowflakeSemanticLayerCredential:SnowflakeSemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SnowflakeSemanticLayerCredentialConfigurationArgs', 'SnowflakeSemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credenttial configuration details.
        :param pulumi.Input[Union['SnowflakeSemanticLayerCredentialCredentialArgs', 'SnowflakeSemanticLayerCredentialCredentialArgsDict']] credential: Snowflake credential details, but used in the context of the Semantic Layer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnowflakeSemanticLayerCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Snowflake credential resource. This resource is composed of a Snowflake credential and a Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_snowflake_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_snowflake_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/snowflakeSemanticLayerCredential:SnowflakeSemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/snowflakeSemanticLayerCredential:SnowflakeSemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param SnowflakeSemanticLayerCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnowflakeSemanticLayerCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['SnowflakeSemanticLayerCredentialConfigurationArgs', 'SnowflakeSemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['SnowflakeSemanticLayerCredentialCredentialArgs', 'SnowflakeSemanticLayerCredentialCredentialArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnowflakeSemanticLayerCredentialArgs.__new__(SnowflakeSemanticLayerCredentialArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if credential is None and not opts.urn:
                raise TypeError("Missing required property 'credential'")
            __props__.__dict__["credential"] = credential
        super(SnowflakeSemanticLayerCredential, __self__).__init__(
            'dbtcloud:index/snowflakeSemanticLayerCredential:SnowflakeSemanticLayerCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['SnowflakeSemanticLayerCredentialConfigurationArgs', 'SnowflakeSemanticLayerCredentialConfigurationArgsDict']]] = None,
            credential: Optional[pulumi.Input[Union['SnowflakeSemanticLayerCredentialCredentialArgs', 'SnowflakeSemanticLayerCredentialCredentialArgsDict']]] = None) -> 'SnowflakeSemanticLayerCredential':
        """
        Get an existing SnowflakeSemanticLayerCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SnowflakeSemanticLayerCredentialConfigurationArgs', 'SnowflakeSemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credenttial configuration details.
        :param pulumi.Input[Union['SnowflakeSemanticLayerCredentialCredentialArgs', 'SnowflakeSemanticLayerCredentialCredentialArgsDict']] credential: Snowflake credential details, but used in the context of the Semantic Layer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnowflakeSemanticLayerCredentialState.__new__(_SnowflakeSemanticLayerCredentialState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["credential"] = credential
        return SnowflakeSemanticLayerCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.SnowflakeSemanticLayerCredentialConfiguration']:
        """
        Semantic Layer credenttial configuration details.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Output['outputs.SnowflakeSemanticLayerCredentialCredential']:
        """
        Snowflake credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

