# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StarburstCredentialArgs', 'StarburstCredential']

@pulumi.input_type
class StarburstCredentialArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.int],
                 schema: pulumi.Input[builtins.str],
                 user: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a StarburstCredential resource.
        :param pulumi.Input[builtins.str] database: The catalog to connect use
        :param pulumi.Input[builtins.str] password: The password for the Starburst/Trino account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Starburst/Trino credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        :param pulumi.Input[builtins.str] user: The username for the Starburst/Trino account
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password for the Starburst/Trino account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.int]:
        """
        Project ID to create the Starburst/Trino credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[builtins.str]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[builtins.str]:
        """
        The username for the Starburst/Trino account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _StarburstCredentialState:
    def __init__(__self__, *,
                 credential_id: Optional[pulumi.Input[builtins.int]] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StarburstCredential resources.
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] database: The catalog to connect use
        :param pulumi.Input[builtins.str] password: The password for the Starburst/Trino account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Starburst/Trino credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        :param pulumi.Input[builtins.str] user: The username for the Starburst/Trino account
        """
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the Starburst/Trino account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Project ID to create the Starburst/Trino credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the Starburst/Trino account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("dbtcloud:index/starburstCredential:StarburstCredential")
class StarburstCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Starburst/Trino credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        example = dbtcloud.StarburstCredential("example",
            project_id=example_dbtcloud_project["id"],
            database="your_catalog",
            schema="your_schema",
            user="your_user",
            password="your_password")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_starburst_credential.my_starburst_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_starburst_credential.my_starburst_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/starburstCredential:StarburstCredential my_starburst_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/starburstCredential:StarburstCredential my_starburst_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: The catalog to connect use
        :param pulumi.Input[builtins.str] password: The password for the Starburst/Trino account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Starburst/Trino credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        :param pulumi.Input[builtins.str] user: The username for the Starburst/Trino account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StarburstCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Starburst/Trino credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        example = dbtcloud.StarburstCredential("example",
            project_id=example_dbtcloud_project["id"],
            database="your_catalog",
            schema="your_schema",
            user="your_user",
            password="your_password")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_starburst_credential.my_starburst_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_starburst_credential.my_starburst_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/starburstCredential:StarburstCredential my_starburst_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/starburstCredential:StarburstCredential my_starburst_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param StarburstCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StarburstCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.int]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StarburstCredentialArgs.__new__(StarburstCredentialArgs)

            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StarburstCredential, __self__).__init__(
            'dbtcloud:index/starburstCredential:StarburstCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_id: Optional[pulumi.Input[builtins.int]] = None,
            database: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.int]] = None,
            schema: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None) -> 'StarburstCredential':
        """
        Get an existing StarburstCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[builtins.str] database: The catalog to connect use
        :param pulumi.Input[builtins.str] password: The password for the Starburst/Trino account
        :param pulumi.Input[builtins.int] project_id: Project ID to create the Starburst/Trino credential in
        :param pulumi.Input[builtins.str] schema: The schema where to create models
        :param pulumi.Input[builtins.str] user: The username for the Starburst/Trino account
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StarburstCredentialState.__new__(_StarburstCredentialState)

        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["database"] = database
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["schema"] = schema
        __props__.__dict__["user"] = user
        return StarburstCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[builtins.str]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password for the Starburst/Trino account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.int]:
        """
        Project ID to create the Starburst/Trino credential in
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[builtins.str]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[builtins.str]:
        """
        The username for the Starburst/Trino account
        """
        return pulumi.get(self, "user")

