#pragma once
#include <array>
#include <cstdint>

static_assert(sizeof(std::uint32_t) == 4);
static_assert(sizeof(unsigned int) == 4);

namespace unplayplay::detail {
    /// In bytes
    constexpr std::size_t kFileIdSize = 20;
    constexpr std::size_t kKeySize = 16;

    /// linked data for 01E132CAE527BD21620E822F58514932
    constexpr std::array<std::uint32_t, 0x3000> kPlayIntentKey = {
        0xBC5821DB, 0xCE131409, 0x47D1599E, 0x616328D5, 0xA19D78EE, 0xD185AFEA, 0x34ED8DB9, 0x8CAAAFE5, 0xCF77E218, 0x510D04B5, 0x8A9CE213, 0xC12F8BCA,
        0xFABF6927, 0x747DAEBC, 0x8E0F7DF3, 0x9FCA7022, 0x215F92BF, 0x40FF373B, 0xEA694507, 0xFC243736, 0x7DB959D3, 0x8F744C02, 0x09329196, 0xFF96D317,
        0x3926B074, 0xBABBD311, 0xFD890544, 0x95748FA7, 0xB8AE053F, 0x3A4327DC, 0x28D08C54, 0xA28ED1E9, 0xBC20A120, 0xCDDB934F, 0x96D95DB5, 0xBA12D34E,
        0x06FBE4CA, 0x2A355A63, 0xABCA7D00, 0xBD856F2F, 0xF7154C8C, 0x78AA6F29, 0x6737D3A1, 0x30359E08, 0x2B9A2871, 0xC385B2D3, 0xBEEA3D3D, 0x7EAAB2CE,
        0x7A0F3D38, 0x689CA1B0, 0xEA31C44D, 0xFBECB67B, 0xC4EA80E2, 0xFE7A5E40, 0x800F80DD, 0x58467D90, 0xF03207F2, 0xEB96925B, 0xFD51848A, 0xA6BB9256,
        0xB8768485, 0x81744EEB, 0x7001B363, 0xF196D600, 0x0351C82F, 0x44B88295, 0xA8206065, 0xD8089761, 0x1842E77A, 0x793D5E7A, 0xF2FBA40F, 0x2C8B816C,
        0xAE20A40A, 0xBFDB9638, 0xB63FD7B8, 0x19A7B588, 0x498FEC84, 0xACF7CA54, 0x4C1D9448, 0xAF857218, 0xC917414F, 0x1FA7F92D, 0x3162EB5C, 0x72C9A5C2,
        0xEC87EB56, 0x0619BA8E, 0x7FD80022, 0xBDA4E96C, 0x210CC73B, 0x78C9E967, 0x742E73D0, 0xEDECB965, 0x077E889C, 0x5E0F407A, 0x77A10FB1, 0xF15F5546,
        0x7A2EB775, 0xDD969545, 0x0D7ECC41, 0x30B841DA, 0x5F740E88, 0xA0DAC8EF, 0x1A990E83, 0x342ADDBA, 0xDEFB6353, 0x36B8857F, 0xE71A9702, 0xA6DB0C93,
        0xA23F96FD, 0x3A2B215F, 0x358FABC9, 0xAF4DF15D, 0xA5B232DE, 0x6EAFFD44, 0xA83FDAA2, 0xB9FACCD1, 0x3B8FEF6E, 0x5EC96507, 0xF6B4EF69, 0xCEEBEC1B,
        0x48AA31B0, 0x623C00E7, 0x2B39CB4E, 0x3CF4BD7C, 0x76849ADA, 0xAD174491, 0xD050BA2A, 0x683C448C, 0x63A0CEF6, 0xDD5F148A, 0x1EC5CEF1, 0x77E968E9,
        0xD650FDCF, 0xE80BEFFD, 0x69A1129B, 0x7B5C04C9, 0x24C61295, 0x368104C4, 0x94E899AA, 0xD7B5CBDD, 0xE970BE0C, 0x6B05E0A9, 0xA495BE07, 0x262AE0A4,
        0x14B8451C, 0x964D67B9, 0xA80859E7, 0x299D7C85, 0x943F99E7, 0xC427D0E3, 0x278FAEB2, 0x161D132A, 0x97B235C7, 0xA96D27F6, 0x2B024A93, 0x649227F1,
        0x5FF6B25B, 0x28F47CC1, 0x35AF2606, 0x991703D6, 0xD2A6E134, 0x543C03D1, 0x65F6F5FF, 0xC45E8AE6, 0xD6197D14, 0xEFAB4C4B, 0xC250BD13, 0xF238F410,
        0x55A0D1DF, 0x675BC40E, 0xC5C358F4, 0xD77E4B23, 0x59136DC0, 0x92A34B1E, 0xF39DC21E, 0x6D5C07B3, 0x63C04933, 0xC7282703, 0x1EE5492E, 0x824D26FD,
        0x9408192C, 0xAD99E863, 0x042AA041, 0x65251742, 0x06B84805, 0x204A173C, 0x83B1F50C, 0xB39A2C08, 0x170209D8, 0x058F6E50, 0x46F628B6, 0xC0B46E4A,
        0x21AEE54B, 0x9B6D2AE0, 0xDCD3E546, 0x0B8FB1F4, 0x4CF66C5B, 0x5EB15E89, 0xC2193C59, 0xDBAB0B90, 0xA4A8D5F7, 0xDE38B354, 0x0CF48003, 0x4E5B3A69,
        0xC8197FFE, 0xE1AB4F35, 0x1B3B2C93, 0x9CD04F30, 0x8B5DB3A8, 0x545B7E0E, 0x4FC00878, 0xD1552B15, 0xE3101D44, 0x84A34E07, 0x7B078F87, 0x8CC281B6,
        0x0E57A453, 0x20129682, 0xE91060E8, 0x0C49D681, 0xA43560E3, 0x7C6C5D96, 0x8E274FC5, 0x0FBC7262, 0x494C4FC0, 0xCAE1725D, 0xDC9C648B, 0xA59A2EF2,
        0x7DD12BA5, 0x15BCB607, 0x11214070, 0x4AB11DCE, 0xCC46406B, 0xBAD3A4E3, 0x3C68C780, 0x958C6178, 0x17218415, 0x3A5AF9AE, 0xD2468410, 0xCDAB0E7A,
        0xBC3872F1, 0x3DCD958F, 0x4F8887BD, 0xF8F29589, 0x52162F81, 0xD3AB521F, 0xE566444D, 0xDBCA85CE, 0x3F32639D, 0x78C240FB, 0xFA576398, 0x0C1255C7,
        0x6A79EAAD, 0xC39D84A5, 0x4532A742, 0x7EC284A0, 0x985453D7, 0x1212996B, 0x0D7723D5, 0x6BDEB8BB, 0x7D99AAEA, 0xFF2ECD87, 0x802752AE, 0x01BC754B,
        0x1377677A, 0x54DE21E0, 0x8399EE8F, 0xC500A8F5, 0x286886C5, 0x3A2378F3, 0x0321435A, 0x3CB120B8, 0x33156238, 0xACD3A7CC, 0xC6657704, 0x4023BC98,
        0x59B58BCF, 0xD373D164, 0xABAACE17, 0x74A8987D, 0xCC65BAA9, 0xC7CA4512, 0x41888AA7, 0x82EF450D, 0xB1AB11BC, 0xF311CC22, 0x6CD011B6, 0x68349C20,
        0x31326687, 0x611A9D83, 0x8454131C, 0xDAE4CAF9, 0xF4769A30, 0x6E34DFC5, 0x87C6AEFC, 0x0184F491, 0x42EBAEF7, 0x9C0F48EF, 0xFA76DDD5, 0xF5DB683F,
        0x6F99ADD3, 0xB100683A, 0x2ABEADCE, 0x2122EF4F, 0x9AE134E3, 0xFBDBABE4, 0x0D969E12, 0x8F2BC0B0, 0xC8BB9E0D, 0x4A50C0AA, 0x2287BD5D, 0x9C4602F2,
        0xB5D7D229, 0xEF67AF87, 0xB86579ED, 0xCA206C1C, 0x4BB58EB9, 0x3A42F331, 0xBBD815CE, 0xB73CA037, 0x58CFD0FB, 0x7261A032, 0x60EF04AA, 0x29ECCF11,
        0x3BA7C13F, 0xBD3CE3DC, 0xF6CCC13A, 0x7861E3D7, 0x8A1CD606, 0xCA57261F, 0xE3E8F556, 0xF5A3E784, 0xE6769D1A, 0xF8318F49, 0x79C6B1E6, 0x8B81A414,
        0xE9E938FB, 0xFBA42B29, 0x1EDDA0C2, 0xB6C92B24, 0xF9965D57, 0x7B2B7FF4, 0x69B8E46C, 0xEB4E0709, 0x24DDE467, 0xA6730704, 0xB82DF933, 0xB392839C,
        0x28508047, 0xB11FE277, 0x1487C047, 0x2642B275, 0xA7D7D512, 0xB992C741, 0x3B27E9DE, 0x29B54E56, 0x4CEEC3EF, 0xE4DA4E51, 0x45D4C551, 0xA93CA321,
        0xE2CC807F, 0x195F2A36, 0x52EF0794, 0x6C80D6CB, 0xE63F1C5F, 0xFFD0EB97, 0xC0F7D8F5, 0x025E935B, 0x4298E373, 0x5453D5A2, 0xD5E8F83F, 0xE7A3EA6E,
        0x290AA4D4, 0x57C67183, 0x992D2BE9, 0x5A541947, 0x73E5E87E, 0xEDA42E13, 0x2F0AE879, 0x9272C649, 0x81002AC0, 0x9A91F9F8, 0x14503F8C, 0x2DE20EC3,
        0xEF08FC21, 0x306FB688, 0xAA2DFC1C, 0xA0923D9C, 0xB24D2FCB, 0x15B50D9B, 0x6D722FC6, 0xD0DA0D96, 0xC73E4F16, 0x88653C74, 0xA1F70BAB, 0x1BB55140,
        0x35472077, 0x6ED6FDD5, 0xD23EDBA4, 0xDEF984E9, 0x426162B9, 0xA35BD9BA, 0x1D1A1F4E, 0x5E80D9B4, 0x703BCBE3, 0xF1D0EE80, 0xE05E52F8, 0x61F37595,
        0x73AE67C4, 0xFEEB30C2, 0x5FE5A7C3, 0xD9A3ED57, 0xD0082ED8, 0xE1C32106, 0x635843A4, 0x9CE82101, 0x1E7D439E, 0x303835CD, 0x707285E6, 0xD16CFCE6,
        0x69588748, 0x8C91FCE1, 0x9E4CEF10, 0x1FE211AD, 0x319D03DC, 0x900498C2, 0xA1BF8AF0, 0x052768C0, 0xA44D32B5, 0x9FB1BD1E, 0x2146DFBB, 0x0FD44433,
        0x916966D0, 0xCAF9442E, 0x4C8E66CB, 0x5E4958FA, 0x27472360, 0x60D700BE, 0x390DFD71, 0xD0F987D3, 0xCC5E123D, 0x4DF334DA, 0x5FAE2708, 0xE14349A5,
        0xCFD0AE1D, 0xC0A363B3, 0xD25E55E1, 0xEBF02519, 0x65AE6AAD, 0x88E7E046, 0xBF7A89FD, 0xF90A675B, 0x7A9F89F8, 0x8C5A7C27, 0xED54F327, 0x8EE823EB,
        0xA879F322, 0xFF0AAB00, 0xFA6F3569, 0x925ABFCB, 0x8DBF4A35, 0x0F546CD2, 0xFDE1D14A, 0x86B1337A, 0x006F790E, 0x1A014845, 0x93BF8DDA, 0xB6F90373,
        0x4EE48DD5, 0x271B8A88, 0xBF0714EA, 0x01D4471D, 0x1B661654, 0x95245BE9, 0xD68B164F, 0x50495BE3, 0x46AD9D64, 0xC06BE2F8, 0xBBD06D62, 0x138D8F8D,
        0xDC8B59F4, 0xEE464C22, 0x2E809C3B, 0x48126B72, 0xC1D0B107, 0xDB62803E, 0x7CF5B102, 0x8EB0A330, 0x8514E4B1, 0x4E12AF17, 0x5FCDA146, 0xC3357F15,
        0x049C397C, 0x7E5A7F10, 0x97EC4E47, 0x8679B2BF, 0x0037F854, 0x419EB2BA, 0x0A9C7D20, 0x1C576F4F, 0x7FBF4D1F, 0x76238E9F, 0xEFE1D434, 0x0973A36B,
        0x430380C8, 0xC498A366, 0x1DBC3D5E, 0x9F515FFB, 0x8DDEC473, 0x0F73E710, 0x4903C46D, 0xAC6BA23D, 0xC5FD7174, 0xD7B863A3, 0x361FF889, 0xB7187DB0,
        0x38ADA04D, 0x4A68927C, 0xCBFDB519, 0xDDB8A748, 0xB5EFA3FA, 0x4DDB2E5D, 0x7114A3F5, 0xF2A9C692, 0x4BCD608A, 0xCD628328, 0x06F26085, 0x3D850A3C,
        0x7714E79A, 0x72797204, 0x0A64FC66, 0x05C986D0, 0x9DB51132, 0xBD54B5AE, 0x66BEC37A, 0x7879B5A9, 0xFA0ED846, 0x0BC9CA74, 0x4559A7D2, 0x7BEC5189,
        0x9F25C722, 0x68239189, 0x79DE83B7, 0xFB73A654, 0x350383B2, 0x4E9552E9, 0xA5260AC7, 0xB6E0FCF6, 0x38761F93, 0x33DAA9FC, 0x132EDC28, 0x366851C1,
        0x6CFAFB78, 0xA68AD8D5, 0xC01CA80D, 0x39DAEDA1, 0x736ACAFF, 0xF4FFED9C, 0xE38D5214, 0xAC8B1C7A, 0xA7EFA6E4, 0x2984C981, 0x3B3FBBB0, 0x92FCDDDB,
        0xF664BBAB, 0xE4F22022, 0x668742BF, 0xC781B9C0, 0x413FFF55, 0x647974ED, 0x9461ABEA, 0xD49BFC02, 0x048432FE, 0x67EC10CE, 0xA952CB34, 0x231110C9,
        0x840B87C9, 0xFDC9CD5E, 0xF42E0EDE, 0x05E9010D, 0x6950DEDC, 0xC10E0108, 0x2475DED7, 0x545E15D4, 0x949865EC, 0xF592DCED, 0x6F512281, 0xB0B7DCE8,
        0xC272CF16, 0x25DAACE6, 0x3295562B, 0x95FD33FB, 0xC5E56AF7, 0x512233F6, 0xB21CAAF6, 0xC3D79D25, 0x456CBFC2, 0x33FA243A, 0x97620209, 0xEF1F2435,
        0x52870204, 0x826F3900, 0x2D3FBE99, 0x23A4001A, 0x5D33DD77, 0xDEC90014, 0xF083F243, 0x721914E0, 0x83D4070F, 0xC40E5727, 0xF3F68E24, 0x5E98AB86,
        0xE02DCE23, 0xF1E8C052, 0x737DE2EF, 0xAD0DC04C, 0xE3A06A04, 0x1D304761, 0x96EE8CF6, 0xB0805C2D, 0x1B22798F, 0xB30E03F1, 0x8B4500A4, 0x0CDA2341,
        0x1E951570, 0xA02A380D, 0xB1E52A3C, 0x2BA36FD0, 0x2207B150, 0x8CA9CEB3, 0x24955915, 0x1FF9E37E, 0xB7E56DE0, 0xDB1EE379, 0x5CB40616, 0x4B416A8E,
        0x5CFC5CBD, 0x25FA2723, 0x37B51952, 0xB94A3BEF, 0xDC83B188, 0x5141AE33, 0x4CA6389D, 0xCE3B5B3A, 0xDFF64D68, 0x19862AC6, 0xE283F52D, 0xFC15C464,
        0x52A67C41, 0x4E0B06AB, 0xE5F6910D, 0x093006A6, 0xA11B9108, 0x9C801B72, 0x8B0D7FEA, 0x540B4A50, 0x6D9D1987, 0xE75B5F1C, 0x20EB3C7A, 0xA2805F17,
        0x7AB75BC9, 0xAA9F92C6, 0x0E077095, 0x65C492C0, 0x10951859, 0x2A26E791, 0xA3E52D25, 0x9272919D, 0x1407B43A, 0x25C2A669, 0x672960CF, 0xCA913E9F,
        0x41E21D64, 0xA549FB34, 0x9BAE3CB4, 0x156C8249, 0x56D33CAF, 0xD0918243, 0xE24C7472, 0xD8B0B5F2, 0x3C1893C2, 0xDB3E5DB7, 0x3EA63B86, 0x6E8E7282,
        0xD1F65052, 0xEB881F89, 0xDA158401, 0x53D3C995, 0x953A83FC, 0x0EF8C990, 0x6FF34091, 0xD35B1E60, 0xE015C7A6, 0x437DA575, 0x84E45FDC, 0x969F520A,
        0x105D979F, 0x29EF66D6, 0x80801EB4, 0x094F80E3, 0x6CB75EB3, 0x9C9F95AF, 0x98042019, 0x2FEFAA7B, 0x53292014, 0x89BBC9CB, 0xC34BA729, 0x8C49718F,
        0x9E0463BE, 0x016C418D, 0x592963B9, 0x3160606B, 0xC94BEACD, 0xC4B07537, 0x5C9BFF99, 0x58008A03, 0x20FE5469, 0x5A8E31C7, 0xB8F5C6AD, 0xCAB0B8DC,
        0xDC6BAB0B, 0x5E00CDA8, 0x813A4340, 0x1925CDA3, 0xF15CCA55, 0xBA5A94BC, 0xCC1586EA, 0xDDD07919, 0x873A86E5, 0x98F57914, 0xF75D0DFA, 0xF2C19864,
        0x8AAD22C6, 0xCD7A54F9, 0x4F0F7796, 0x889F54F4, 0x9A5A4722, 0xF8C1DC09, 0x0A7CCE37, 0x8C11F0D4, 0xC5A1CE32, 0x4736F0CF, 0x8A042302, 0x21EFAD64,
        0xFA26AA17, 0x13B8794E, 0x8D76BEE3, 0xC7069C41, 0x489BBEDE, 0x37292356, 0xB8BE45F3, 0xFB8B7826, 0x53489A51, 0xB6B07821, 0xE698AF1D, 0x4A008CEC,
        0x388DF164, 0xBA231401, 0xF3B2F15F, 0x754813FC, 0xB815462F, 0xE7FD7D2B, 0x4B655AFB, 0x58200440, 0xBB87E210, 0xF517BF6D, 0x76ACE20B, 0x8867D439,
    };
} // namespace unplayplay::detail
