# Generated by Django 4.2.1 on 2023-08-15 12:44

from django.db import migrations
from pulpcore.plugin.migrations import RequireVersion


def check_datarepair(apps, schema_editor):
    ShallowGemContent = apps.get_model("gem", "ShallowGemContent")
    if ShallowGemContent.objects.exists():
        raise RuntimeError("Before continuing with this upgrade, you need to downgrade pulp_gem to ~=0.3, then run the 'datarepair-shallow-gems' command, or remove all remaining broken repository versions.")

    GemContent = apps.get_model("gem", "GemContent")
    if GemContent.objects.filter(platform=None).exists():
        raise RuntimeError("Before continuing with this upgrade, you need to downgrade pulp_gem to ~=0.3, then run the 'datarepair-gemspec-platform' command, or remove all remaining broken repository versions.")


class Migration(migrations.Migration):
    dependencies = [
        ("gem", "0008_gemcontent_platform"),
    ]

    operations = [
        RequireVersion("gem", "0.2.0"),
        migrations.RunPython(code=check_datarepair, reverse_code=migrations.RunPython.noop, elidable=True),
    ]
