# VRIN Hybrid RAG SDK v0.3.4

Enterprise-grade Hybrid RAG system with user-defined AI specialization, multi-hop reasoning, and blazing-fast performance optimization.

## 🚀 New in v0.3.4 - Performance Breakthrough

- ⚡ **Performance Revolution** - Raw fact retrieval in <2s (96.3% faster than full analysis)
- 🚀 **Dual-Speed Processing** - Fast website display + comprehensive expert analysis  
- 🧠 **User-Defined Specialization** - Create custom AI experts for any domain
- 🔗 **Multi-Hop Reasoning** - Cross-document synthesis with reasoning chains
- 📊 **Enhanced Graph Retrieval** - Fixed Neptune storage, now finding 36-50 facts vs 0
- 🎯 **Expert-Level Performance** - 8.5/10 validation against professional analysis
- 🏗️ **Production Infrastructure** - 7 Lambda functions optimized (Python 3.12)
- 💾 **Smart Storage** - 40-60% reduction through intelligent deduplication
- 🔒 **Enterprise Security** - Bearer token auth, user isolation, compliance ready

## 🚀 Core Features

- ⚡ **Hybrid RAG Architecture** - Graph reasoning + Vector similarity search
- 🧠 **User-Defined AI Experts** - Customize reasoning for any domain
- 🔗 **Multi-Hop Reasoning** - Cross-document synthesis and pattern detection
- 📊 **Advanced Fact Extraction** - High-confidence structured knowledge extraction
- 🔍 **Expert-Level Analysis** - Professional-grade insights with reasoning chains
- 📈 **Enterprise-Ready** - User isolation, authentication, and production scaling

## 📦 Installation

```bash
pip install vrin==0.3.4
```

## 🔧 Quick Start

```python
from vrin import VRINClient

# Initialize with your API key
client = VRINClient(api_key="your_vrin_api_key")

# STEP 1: Define your custom AI expert
result = client.specialize(
    custom_prompt="You are a senior M&A legal partner with 25+ years experience...",
    reasoning_focus=["cross_document_synthesis", "causal_chains"],
    analysis_depth="expert"
)

# STEP 2: Insert knowledge with automatic fact extraction
result = client.insert(
    content="Complex M&A legal document content...",
    title="Strategic M&A Assessment"
)
print(f"✅ Extracted {result['facts_count']} facts")
print(f"💾 Storage: {result['storage_details']}")

# STEP 3A: Fast fact retrieval for website display (NEW v0.3.4)
raw_response = client.get_raw_facts_only("What are strategic insights?")
print(f"⚡ Lightning-fast retrieval: {raw_response['search_time']}")  # ~0.7-2s
print(f"📊 Facts found: {raw_response['total_facts']}")

# STEP 3B: Complete expert analysis for comprehensive reports
response = client.query("What are the strategic litigation opportunities?")
print(f"📝 Expert Analysis: {response['summary']}")
print(f"🔗 Multi-hop Chains: {response['multi_hop_chains']}")
print(f"📊 Cross-doc Patterns: {response['cross_document_patterns']}")
print(f"⚡ Full Analysis: {response['search_time']}")  # ~15-20s
```

## 📊 Performance (v0.3.4 Breakthrough)

- **⚡ Raw Fact Retrieval**: 0.7-2s (96.3% faster than full analysis)
- **🧠 Expert Analysis**: 15-20s for comprehensive multi-hop reasoning
- **📊 Graph Retrieval**: Now finding 36-50 facts (fixed from 0 facts)
- **🔗 Multi-hop Reasoning**: 1-10 reasoning chains per complex query  
- **📋 Cross-document Patterns**: 2+ patterns detected per expert analysis
- **💾 Storage Efficiency**: 40-60% reduction through intelligent deduplication
- **🎯 Expert Validation**: 8.5/10 performance on professional M&A analysis
- **🏗️ Infrastructure**: 7 Lambda functions optimized (Python 3.12), sub-second API response

## 🏗️ Architecture

VRIN uses enterprise-grade Hybrid RAG with user-defined specialization:

1. **User Specialization** - Custom AI experts defined by users
2. **Enhanced Fact Extraction** - Fixed Neptune storage with proper edge relationships
3. **Multi-hop Reasoning** - Cross-document synthesis with reasoning chains
4. **Hybrid Retrieval** - Graph traversal + vector similarity (36-50 facts)
5. **Expert Synthesis** - Domain-specific analysis using custom prompts
6. **Production Infrastructure** - 11 Lambda functions on AWS
7. **Enterprise Security** - Bearer token auth, user isolation, compliance

## 🔐 Authentication & Setup

1. Sign up at [VRIN Console](https://console.vrin.ai) (when available)
2. Get your API key from account dashboard
3. Use the API key to initialize your client

```python
client = VRINClient(api_key="vrin_your_api_key_here")
```

## 🏢 Production Ready Features

- **Custom AI Experts**: Define domain-specific reasoning for any field
- **Multi-hop Analysis**: Cross-document synthesis with evidence chains
- **Working Graph Facts**: Fixed Neptune storage now retrieving real relationships
- **Expert Validation**: 8.5/10 performance against professional analysis
- **Production APIs**: Bearer token auth, 99.5% uptime, enterprise ready
- **Smart Deduplication**: 40-60% storage optimization with transparency

## 🎯 Use Cases

- **Legal Analysis**: M&A risk assessment, contract review, litigation strategy
- **Financial Research**: Investment analysis, market research, due diligence
- **Technical Documentation**: API analysis, architecture review, compliance
- **Strategic Planning**: Competitive analysis, market intelligence, decision support

## 🌟 What Makes VRIN Different

### vs. Basic RAG Systems
- ✅ **Multi-hop reasoning** across knowledge graphs
- ✅ **User-defined specialization** instead of rigid templates
- ✅ **Cross-document synthesis** with pattern detection
- ✅ **Expert-level performance** validated against professionals

### vs. Enterprise AI Platforms  
- ✅ **Complete customization** - users define their own AI experts
- ✅ **Production-ready AWS infrastructure** with full authentication
- ✅ **Temporal knowledge graphs** with provenance and graceful fallback handling
- ✅ **Resilient connectivity** - Neptune fallback ensures service continuity
- ✅ **Open SDK** with transparent operations and full API access

## 📄 License

MIT License - see LICENSE file for details.

---

**Built with ❤️ by the VRIN Team**

*Last updated: August 13, 2025 - Production v0.3.3*