# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LiveToolsArpTableArgs', 'LiveToolsArpTable']

@pulumi.input_type
class LiveToolsArpTableArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[_builtins.str],
                 arp_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 callback: Optional[pulumi.Input['LiveToolsArpTableCallbackArgs']] = None):
        """
        The set of arguments for constructing a LiveToolsArpTable resource.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] arp_table_id: Id of the ARP table request. Used to check the status of the request.
        :param pulumi.Input['LiveToolsArpTableCallbackArgs'] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        pulumi.set(__self__, "serial", serial)
        if arp_table_id is not None:
            pulumi.set(__self__, "arp_table_id", arp_table_id)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Input[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter(name="arpTableId")
    def arp_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the ARP table request. Used to check the status of the request.
        """
        return pulumi.get(self, "arp_table_id")

    @arp_table_id.setter
    def arp_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arp_table_id", value)

    @_builtins.property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['LiveToolsArpTableCallbackArgs']]:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['LiveToolsArpTableCallbackArgs']]):
        pulumi.set(self, "callback", value)


@pulumi.input_type
class _LiveToolsArpTableState:
    def __init__(__self__, *,
                 arp_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 callback: Optional[pulumi.Input['LiveToolsArpTableCallbackArgs']] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['LiveToolsArpTableEntryArgs']]]] = None,
                 error: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input['LiveToolsArpTableRequestArgs']] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LiveToolsArpTable resources.
        :param pulumi.Input[_builtins.str] arp_table_id: Id of the ARP table request. Used to check the status of the request.
        :param pulumi.Input['LiveToolsArpTableCallbackArgs'] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[Sequence[pulumi.Input['LiveToolsArpTableEntryArgs']]] entries: The ARP table entries
        :param pulumi.Input[_builtins.str] error: An error message for a failed execution
        :param pulumi.Input['LiveToolsArpTableRequestArgs'] request: ARP table request parameters
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] status: Status of the ARP table request.
        :param pulumi.Input[_builtins.str] url: GET this url to check the status of your ARP table request.
        """
        if arp_table_id is not None:
            pulumi.set(__self__, "arp_table_id", arp_table_id)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="arpTableId")
    def arp_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the ARP table request. Used to check the status of the request.
        """
        return pulumi.get(self, "arp_table_id")

    @arp_table_id.setter
    def arp_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arp_table_id", value)

    @_builtins.property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['LiveToolsArpTableCallbackArgs']]:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['LiveToolsArpTableCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveToolsArpTableEntryArgs']]]]:
        """
        The ARP table entries
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveToolsArpTableEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An error message for a failed execution
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['LiveToolsArpTableRequestArgs']]:
        """
        ARP table request parameters
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['LiveToolsArpTableRequestArgs']]):
        pulumi.set(self, "request", value)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the ARP table request.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        GET this url to check the status of your ARP table request.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("meraki:devices/liveToolsArpTable:LiveToolsArpTable")
class LiveToolsArpTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arp_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 callback: Optional[pulumi.Input[Union['LiveToolsArpTableCallbackArgs', 'LiveToolsArpTableCallbackArgsDict']]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.LiveToolsArpTable("example",
            callback={
                "http_server": {
                    "id": "aHR0cHM6Ly93d3cuZXhhbXBsZS5jb20vd2ViaG9va3M=",
                },
                "payload_template": {
                    "id": "wpt_2100",
                },
                "shared_secret": "secret",
                "url": "https://webhook.site/28efa24e-f830-4d9f-a12b-fbb9e5035031",
            },
            serial="string")
        pulumi.export("merakiDevicesLiveToolsArpTableExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/liveToolsArpTable:LiveToolsArpTable example "arp_table_id,serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arp_table_id: Id of the ARP table request. Used to check the status of the request.
        :param pulumi.Input[Union['LiveToolsArpTableCallbackArgs', 'LiveToolsArpTableCallbackArgsDict']] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LiveToolsArpTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.LiveToolsArpTable("example",
            callback={
                "http_server": {
                    "id": "aHR0cHM6Ly93d3cuZXhhbXBsZS5jb20vd2ViaG9va3M=",
                },
                "payload_template": {
                    "id": "wpt_2100",
                },
                "shared_secret": "secret",
                "url": "https://webhook.site/28efa24e-f830-4d9f-a12b-fbb9e5035031",
            },
            serial="string")
        pulumi.export("merakiDevicesLiveToolsArpTableExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/liveToolsArpTable:LiveToolsArpTable example "arp_table_id,serial"
        ```

        :param str resource_name: The name of the resource.
        :param LiveToolsArpTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LiveToolsArpTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arp_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 callback: Optional[pulumi.Input[Union['LiveToolsArpTableCallbackArgs', 'LiveToolsArpTableCallbackArgsDict']]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LiveToolsArpTableArgs.__new__(LiveToolsArpTableArgs)

            __props__.__dict__["arp_table_id"] = arp_table_id
            __props__.__dict__["callback"] = callback
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["entries"] = None
            __props__.__dict__["error"] = None
            __props__.__dict__["request"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["url"] = None
        super(LiveToolsArpTable, __self__).__init__(
            'meraki:devices/liveToolsArpTable:LiveToolsArpTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arp_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            callback: Optional[pulumi.Input[Union['LiveToolsArpTableCallbackArgs', 'LiveToolsArpTableCallbackArgsDict']]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LiveToolsArpTableEntryArgs', 'LiveToolsArpTableEntryArgsDict']]]]] = None,
            error: Optional[pulumi.Input[_builtins.str]] = None,
            request: Optional[pulumi.Input[Union['LiveToolsArpTableRequestArgs', 'LiveToolsArpTableRequestArgsDict']]] = None,
            serial: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'LiveToolsArpTable':
        """
        Get an existing LiveToolsArpTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arp_table_id: Id of the ARP table request. Used to check the status of the request.
        :param pulumi.Input[Union['LiveToolsArpTableCallbackArgs', 'LiveToolsArpTableCallbackArgsDict']] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[Sequence[pulumi.Input[Union['LiveToolsArpTableEntryArgs', 'LiveToolsArpTableEntryArgsDict']]]] entries: The ARP table entries
        :param pulumi.Input[_builtins.str] error: An error message for a failed execution
        :param pulumi.Input[Union['LiveToolsArpTableRequestArgs', 'LiveToolsArpTableRequestArgsDict']] request: ARP table request parameters
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] status: Status of the ARP table request.
        :param pulumi.Input[_builtins.str] url: GET this url to check the status of your ARP table request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LiveToolsArpTableState.__new__(_LiveToolsArpTableState)

        __props__.__dict__["arp_table_id"] = arp_table_id
        __props__.__dict__["callback"] = callback
        __props__.__dict__["entries"] = entries
        __props__.__dict__["error"] = error
        __props__.__dict__["request"] = request
        __props__.__dict__["serial"] = serial
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        return LiveToolsArpTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="arpTableId")
    def arp_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the ARP table request. Used to check the status of the request.
        """
        return pulumi.get(self, "arp_table_id")

    @_builtins.property
    @pulumi.getter
    def callback(self) -> pulumi.Output['outputs.LiveToolsArpTableCallback']:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence['outputs.LiveToolsArpTableEntry']]:
        """
        The ARP table entries
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def error(self) -> pulumi.Output[_builtins.str]:
        """
        An error message for a failed execution
        """
        return pulumi.get(self, "error")

    @_builtins.property
    @pulumi.getter
    def request(self) -> pulumi.Output['outputs.LiveToolsArpTableRequest']:
        """
        ARP table request parameters
        """
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Output[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the ARP table request.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        GET this url to check the status of your ARP table request.
        """
        return pulumi.get(self, "url")

