# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CellularGatewayUplinkArgs', 'CellularGatewayUplink']

@pulumi.input_type
class CellularGatewayUplinkArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 bandwidth_limits: Optional[pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs']] = None):
        """
        The set of arguments for constructing a CellularGatewayUplink resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs'] bandwidth_limits: The bandwidth settings for the 'cellular' uplink
        """
        pulumi.set(__self__, "network_id", network_id)
        if bandwidth_limits is not None:
            pulumi.set(__self__, "bandwidth_limits", bandwidth_limits)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthLimits")
    def bandwidth_limits(self) -> Optional[pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs']]:
        """
        The bandwidth settings for the 'cellular' uplink
        """
        return pulumi.get(self, "bandwidth_limits")

    @bandwidth_limits.setter
    def bandwidth_limits(self, value: Optional[pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs']]):
        pulumi.set(self, "bandwidth_limits", value)


@pulumi.input_type
class _CellularGatewayUplinkState:
    def __init__(__self__, *,
                 bandwidth_limits: Optional[pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs']] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CellularGatewayUplink resources.
        :param pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs'] bandwidth_limits: The bandwidth settings for the 'cellular' uplink
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        if bandwidth_limits is not None:
            pulumi.set(__self__, "bandwidth_limits", bandwidth_limits)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter(name="bandwidthLimits")
    def bandwidth_limits(self) -> Optional[pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs']]:
        """
        The bandwidth settings for the 'cellular' uplink
        """
        return pulumi.get(self, "bandwidth_limits")

    @bandwidth_limits.setter
    def bandwidth_limits(self, value: Optional[pulumi.Input['CellularGatewayUplinkBandwidthLimitsArgs']]):
        pulumi.set(self, "bandwidth_limits", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/cellularGatewayUplink:CellularGatewayUplink")
class CellularGatewayUplink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_limits: Optional[pulumi.Input[Union['CellularGatewayUplinkBandwidthLimitsArgs', 'CellularGatewayUplinkBandwidthLimitsArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.CellularGatewayUplink("example",
            bandwidth_limits={
                "limit_down": 1000000,
                "limit_up": 1000000,
            },
            network_id="string")
        pulumi.export("merakiNetworksCellularGatewayUplinkExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/cellularGatewayUplink:CellularGatewayUplink example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CellularGatewayUplinkBandwidthLimitsArgs', 'CellularGatewayUplinkBandwidthLimitsArgsDict']] bandwidth_limits: The bandwidth settings for the 'cellular' uplink
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularGatewayUplinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.CellularGatewayUplink("example",
            bandwidth_limits={
                "limit_down": 1000000,
                "limit_up": 1000000,
            },
            network_id="string")
        pulumi.export("merakiNetworksCellularGatewayUplinkExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/cellularGatewayUplink:CellularGatewayUplink example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param CellularGatewayUplinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularGatewayUplinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_limits: Optional[pulumi.Input[Union['CellularGatewayUplinkBandwidthLimitsArgs', 'CellularGatewayUplinkBandwidthLimitsArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularGatewayUplinkArgs.__new__(CellularGatewayUplinkArgs)

            __props__.__dict__["bandwidth_limits"] = bandwidth_limits
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(CellularGatewayUplink, __self__).__init__(
            'meraki:networks/cellularGatewayUplink:CellularGatewayUplink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_limits: Optional[pulumi.Input[Union['CellularGatewayUplinkBandwidthLimitsArgs', 'CellularGatewayUplinkBandwidthLimitsArgsDict']]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CellularGatewayUplink':
        """
        Get an existing CellularGatewayUplink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CellularGatewayUplinkBandwidthLimitsArgs', 'CellularGatewayUplinkBandwidthLimitsArgsDict']] bandwidth_limits: The bandwidth settings for the 'cellular' uplink
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularGatewayUplinkState.__new__(_CellularGatewayUplinkState)

        __props__.__dict__["bandwidth_limits"] = bandwidth_limits
        __props__.__dict__["network_id"] = network_id
        return CellularGatewayUplink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bandwidthLimits")
    def bandwidth_limits(self) -> pulumi.Output['outputs.CellularGatewayUplinkBandwidthLimits']:
        """
        The bandwidth settings for the 'cellular' uplink
        """
        return pulumi.get(self, "bandwidth_limits")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

