# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MerakiAuthUsersArgs', 'MerakiAuthUsers']

@pulumi.input_type
class MerakiAuthUsersArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizations: Optional[pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_password_to_user: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 meraki_auth_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MerakiAuthUsers resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] account_type: Authorization type for user.
        :param pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]] authorizations: User authorization info
        :param pulumi.Input[_builtins.str] email: Email address of the user
        :param pulumi.Input[_builtins.bool] email_password_to_user: Whether or not Meraki should email the password to user. Default is false.
        :param pulumi.Input[_builtins.bool] is_admin: Whether or not the user is a Dashboard administrator
        :param pulumi.Input[_builtins.str] meraki_auth_user_id: merakiAuthUserId path parameter. Meraki auth user ID
        :param pulumi.Input[_builtins.str] name: Name of the user
        :param pulumi.Input[_builtins.str] password: The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        pulumi.set(__self__, "network_id", network_id)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if authorizations is not None:
            pulumi.set(__self__, "authorizations", authorizations)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if email_password_to_user is not None:
            pulumi.set(__self__, "email_password_to_user", email_password_to_user)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if meraki_auth_user_id is not None:
            pulumi.set(__self__, "meraki_auth_user_id", meraki_auth_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authorization type for user.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter
    def authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]]]:
        """
        User authorization info
        """
        return pulumi.get(self, "authorizations")

    @authorizations.setter
    def authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]]]):
        pulumi.set(self, "authorizations", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the user
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="emailPasswordToUser")
    def email_password_to_user(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not Meraki should email the password to user. Default is false.
        """
        return pulumi.get(self, "email_password_to_user")

    @email_password_to_user.setter
    def email_password_to_user(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_password_to_user", value)

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the user is a Dashboard administrator
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_admin", value)

    @_builtins.property
    @pulumi.getter(name="merakiAuthUserId")
    def meraki_auth_user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        merakiAuthUserId path parameter. Meraki auth user ID
        """
        return pulumi.get(self, "meraki_auth_user_id")

    @meraki_auth_user_id.setter
    def meraki_auth_user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meraki_auth_user_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _MerakiAuthUsersState:
    def __init__(__self__, *,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizations: Optional[pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_password_to_user: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 meraki_auth_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MerakiAuthUsers resources.
        :param pulumi.Input[_builtins.str] account_type: Authorization type for user.
        :param pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]] authorizations: User authorization info
        :param pulumi.Input[_builtins.str] created_at: Creation time of the user
        :param pulumi.Input[_builtins.str] email: Email address of the user
        :param pulumi.Input[_builtins.bool] email_password_to_user: Whether or not Meraki should email the password to user. Default is false.
        :param pulumi.Input[_builtins.bool] is_admin: Whether or not the user is a Dashboard administrator
        :param pulumi.Input[_builtins.str] meraki_auth_user_id: merakiAuthUserId path parameter. Meraki auth user ID
        :param pulumi.Input[_builtins.str] name: Name of the user
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] password: The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if authorizations is not None:
            pulumi.set(__self__, "authorizations", authorizations)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if email_password_to_user is not None:
            pulumi.set(__self__, "email_password_to_user", email_password_to_user)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if meraki_auth_user_id is not None:
            pulumi.set(__self__, "meraki_auth_user_id", meraki_auth_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authorization type for user.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter
    def authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]]]:
        """
        User authorization info
        """
        return pulumi.get(self, "authorizations")

    @authorizations.setter
    def authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MerakiAuthUsersAuthorizationArgs']]]]):
        pulumi.set(self, "authorizations", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time of the user
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the user
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="emailPasswordToUser")
    def email_password_to_user(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not Meraki should email the password to user. Default is false.
        """
        return pulumi.get(self, "email_password_to_user")

    @email_password_to_user.setter
    def email_password_to_user(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_password_to_user", value)

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the user is a Dashboard administrator
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_admin", value)

    @_builtins.property
    @pulumi.getter(name="merakiAuthUserId")
    def meraki_auth_user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        merakiAuthUserId path parameter. Meraki auth user ID
        """
        return pulumi.get(self, "meraki_auth_user_id")

    @meraki_auth_user_id.setter
    def meraki_auth_user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meraki_auth_user_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)


@pulumi.type_token("meraki:networks/merakiAuthUsers:MerakiAuthUsers")
class MerakiAuthUsers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MerakiAuthUsersAuthorizationArgs', 'MerakiAuthUsersAuthorizationArgsDict']]]]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_password_to_user: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 meraki_auth_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.MerakiAuthUsers("example",
            account_type="802.1X",
            authorizations=[{
                "expires_at": "2018-03-13T00:00:00.090210Z",
                "ssid_number": 1,
            }],
            email="miles@meraki.com",
            email_password_to_user=False,
            is_admin=False,
            name="Miles Meraki",
            network_id="string",
            password="secret")
        pulumi.export("merakiNetworksMerakiAuthUsersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/merakiAuthUsers:MerakiAuthUsers example "meraki_auth_user_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_type: Authorization type for user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MerakiAuthUsersAuthorizationArgs', 'MerakiAuthUsersAuthorizationArgsDict']]]] authorizations: User authorization info
        :param pulumi.Input[_builtins.str] email: Email address of the user
        :param pulumi.Input[_builtins.bool] email_password_to_user: Whether or not Meraki should email the password to user. Default is false.
        :param pulumi.Input[_builtins.bool] is_admin: Whether or not the user is a Dashboard administrator
        :param pulumi.Input[_builtins.str] meraki_auth_user_id: merakiAuthUserId path parameter. Meraki auth user ID
        :param pulumi.Input[_builtins.str] name: Name of the user
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] password: The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MerakiAuthUsersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.MerakiAuthUsers("example",
            account_type="802.1X",
            authorizations=[{
                "expires_at": "2018-03-13T00:00:00.090210Z",
                "ssid_number": 1,
            }],
            email="miles@meraki.com",
            email_password_to_user=False,
            is_admin=False,
            name="Miles Meraki",
            network_id="string",
            password="secret")
        pulumi.export("merakiNetworksMerakiAuthUsersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/merakiAuthUsers:MerakiAuthUsers example "meraki_auth_user_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param MerakiAuthUsersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MerakiAuthUsersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MerakiAuthUsersAuthorizationArgs', 'MerakiAuthUsersAuthorizationArgsDict']]]]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 email_password_to_user: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 meraki_auth_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MerakiAuthUsersArgs.__new__(MerakiAuthUsersArgs)

            __props__.__dict__["account_type"] = account_type
            __props__.__dict__["authorizations"] = authorizations
            __props__.__dict__["email"] = email
            __props__.__dict__["email_password_to_user"] = email_password_to_user
            __props__.__dict__["is_admin"] = is_admin
            __props__.__dict__["meraki_auth_user_id"] = meraki_auth_user_id
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["created_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MerakiAuthUsers, __self__).__init__(
            'meraki:networks/merakiAuthUsers:MerakiAuthUsers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_type: Optional[pulumi.Input[_builtins.str]] = None,
            authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MerakiAuthUsersAuthorizationArgs', 'MerakiAuthUsersAuthorizationArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            email_password_to_user: Optional[pulumi.Input[_builtins.bool]] = None,
            is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
            meraki_auth_user_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None) -> 'MerakiAuthUsers':
        """
        Get an existing MerakiAuthUsers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_type: Authorization type for user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MerakiAuthUsersAuthorizationArgs', 'MerakiAuthUsersAuthorizationArgsDict']]]] authorizations: User authorization info
        :param pulumi.Input[_builtins.str] created_at: Creation time of the user
        :param pulumi.Input[_builtins.str] email: Email address of the user
        :param pulumi.Input[_builtins.bool] email_password_to_user: Whether or not Meraki should email the password to user. Default is false.
        :param pulumi.Input[_builtins.bool] is_admin: Whether or not the user is a Dashboard administrator
        :param pulumi.Input[_builtins.str] meraki_auth_user_id: merakiAuthUserId path parameter. Meraki auth user ID
        :param pulumi.Input[_builtins.str] name: Name of the user
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] password: The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MerakiAuthUsersState.__new__(_MerakiAuthUsersState)

        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["authorizations"] = authorizations
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["email"] = email
        __props__.__dict__["email_password_to_user"] = email_password_to_user
        __props__.__dict__["is_admin"] = is_admin
        __props__.__dict__["meraki_auth_user_id"] = meraki_auth_user_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["password"] = password
        return MerakiAuthUsers(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[_builtins.str]:
        """
        Authorization type for user.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter
    def authorizations(self) -> pulumi.Output[Sequence['outputs.MerakiAuthUsersAuthorization']]:
        """
        User authorization info
        """
        return pulumi.get(self, "authorizations")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time of the user
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the user
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="emailPasswordToUser")
    def email_password_to_user(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not Meraki should email the password to user. Default is false.
        """
        return pulumi.get(self, "email_password_to_user")

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the user is a Dashboard administrator
        """
        return pulumi.get(self, "is_admin")

    @_builtins.property
    @pulumi.getter(name="merakiAuthUserId")
    def meraki_auth_user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        merakiAuthUserId path parameter. Meraki auth user ID
        """
        return pulumi.get(self, "meraki_auth_user_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the user
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for this user account. Only required If the user is not a Dashboard administrator.
        """
        return pulumi.get(self, "password")

