# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessSsidsDeviceTypeGroupPoliciesArgs', 'WirelessSsidsDeviceTypeGroupPolicies']

@pulumi.input_type
class WirelessSsidsDeviceTypeGroupPoliciesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 number: pulumi.Input[_builtins.str],
                 device_type_policies: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a WirelessSsidsDeviceTypeGroupPolicies resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]] device_type_policies: List of device type policies.
        :param pulumi.Input[_builtins.bool] enabled: If true, the SSID device type group policies are enabled.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if device_type_policies is not None:
            pulumi.set(__self__, "device_type_policies", device_type_policies)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Input[_builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypePolicies")
    def device_type_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]]]:
        """
        List of device type policies.
        """
        return pulumi.get(self, "device_type_policies")

    @device_type_policies.setter
    def device_type_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]]]):
        pulumi.set(self, "device_type_policies", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the SSID device type group policies are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _WirelessSsidsDeviceTypeGroupPoliciesState:
    def __init__(__self__, *,
                 device_type_policies: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WirelessSsidsDeviceTypeGroupPolicies resources.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]] device_type_policies: List of device type policies.
        :param pulumi.Input[_builtins.bool] enabled: If true, the SSID device type group policies are enabled.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        """
        if device_type_policies is not None:
            pulumi.set(__self__, "device_type_policies", device_type_policies)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @_builtins.property
    @pulumi.getter(name="deviceTypePolicies")
    def device_type_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]]]:
        """
        List of device type policies.
        """
        return pulumi.get(self, "device_type_policies")

    @device_type_policies.setter
    def device_type_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs']]]]):
        pulumi.set(self, "device_type_policies", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the SSID device type group policies are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "number", value)


@pulumi.type_token("meraki:networks/wirelessSsidsDeviceTypeGroupPolicies:WirelessSsidsDeviceTypeGroupPolicies")
class WirelessSsidsDeviceTypeGroupPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_type_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs', 'WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.WirelessSsidsDeviceTypeGroupPolicies("example",
            device_type_policies=[{
                "device_policy": "Allowed",
                "device_type": "Android",
            }],
            enabled=True,
            network_id="string",
            number="string")
        pulumi.export("merakiNetworksWirelessSsidsDeviceTypeGroupPoliciesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsDeviceTypeGroupPolicies:WirelessSsidsDeviceTypeGroupPolicies example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs', 'WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgsDict']]]] device_type_policies: List of device type policies.
        :param pulumi.Input[_builtins.bool] enabled: If true, the SSID device type group policies are enabled.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsDeviceTypeGroupPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.WirelessSsidsDeviceTypeGroupPolicies("example",
            device_type_policies=[{
                "device_policy": "Allowed",
                "device_type": "Android",
            }],
            enabled=True,
            network_id="string",
            number="string")
        pulumi.export("merakiNetworksWirelessSsidsDeviceTypeGroupPoliciesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsDeviceTypeGroupPolicies:WirelessSsidsDeviceTypeGroupPolicies example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsDeviceTypeGroupPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsDeviceTypeGroupPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_type_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs', 'WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsDeviceTypeGroupPoliciesArgs.__new__(WirelessSsidsDeviceTypeGroupPoliciesArgs)

            __props__.__dict__["device_type_policies"] = device_type_policies
            __props__.__dict__["enabled"] = enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
        super(WirelessSsidsDeviceTypeGroupPolicies, __self__).__init__(
            'meraki:networks/wirelessSsidsDeviceTypeGroupPolicies:WirelessSsidsDeviceTypeGroupPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device_type_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs', 'WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            number: Optional[pulumi.Input[_builtins.str]] = None) -> 'WirelessSsidsDeviceTypeGroupPolicies':
        """
        Get an existing WirelessSsidsDeviceTypeGroupPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgs', 'WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicyArgsDict']]]] device_type_policies: List of device type policies.
        :param pulumi.Input[_builtins.bool] enabled: If true, the SSID device type group policies are enabled.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsDeviceTypeGroupPoliciesState.__new__(_WirelessSsidsDeviceTypeGroupPoliciesState)

        __props__.__dict__["device_type_policies"] = device_type_policies
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        return WirelessSsidsDeviceTypeGroupPolicies(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deviceTypePolicies")
    def device_type_policies(self) -> pulumi.Output[Sequence['outputs.WirelessSsidsDeviceTypeGroupPoliciesDeviceTypePolicy']]:
        """
        List of device type policies.
        """
        return pulumi.get(self, "device_type_policies")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the SSID device type group policies are enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Output[_builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

