# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessSsidsTrafficShapingRulesArgs', 'WirelessSsidsTrafficShapingRules']

@pulumi.input_type
class WirelessSsidsTrafficShapingRulesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 number: pulumi.Input[_builtins.str],
                 default_rules_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]]] = None,
                 traffic_shaping_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a WirelessSsidsTrafficShapingRules resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        :param pulumi.Input[_builtins.bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        :param pulumi.Input[_builtins.bool] traffic_shaping_enabled: Whether traffic shaping rules are applied to clients on your SSID.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if default_rules_enabled is not None:
            pulumi.set(__self__, "default_rules_enabled", default_rules_enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if traffic_shaping_enabled is not None:
            pulumi.set(__self__, "traffic_shaping_enabled", traffic_shaping_enabled)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Input[_builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter(name="defaultRulesEnabled")
    def default_rules_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        """
        return pulumi.get(self, "default_rules_enabled")

    @default_rules_enabled.setter
    def default_rules_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_rules_enabled", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]]]:
        """
        An array of traffic shaping rules. Rules are applied in the order that
        they are specified in. An empty list (or null) means no rules. Note that
        you are allowed a maximum of 8 rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="trafficShapingEnabled")
    def traffic_shaping_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether traffic shaping rules are applied to clients on your SSID.
        """
        return pulumi.get(self, "traffic_shaping_enabled")

    @traffic_shaping_enabled.setter
    def traffic_shaping_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "traffic_shaping_enabled", value)


@pulumi.input_type
class _WirelessSsidsTrafficShapingRulesState:
    def __init__(__self__, *,
                 default_rules_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]]] = None,
                 traffic_shaping_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering WirelessSsidsTrafficShapingRules resources.
        :param pulumi.Input[_builtins.bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        :param pulumi.Input[_builtins.bool] traffic_shaping_enabled: Whether traffic shaping rules are applied to clients on your SSID.
        """
        if default_rules_enabled is not None:
            pulumi.set(__self__, "default_rules_enabled", default_rules_enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if traffic_shaping_enabled is not None:
            pulumi.set(__self__, "traffic_shaping_enabled", traffic_shaping_enabled)

    @_builtins.property
    @pulumi.getter(name="defaultRulesEnabled")
    def default_rules_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        """
        return pulumi.get(self, "default_rules_enabled")

    @default_rules_enabled.setter
    def default_rules_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_rules_enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]]]:
        """
        An array of traffic shaping rules. Rules are applied in the order that
        they are specified in. An empty list (or null) means no rules. Note that
        you are allowed a maximum of 8 rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsTrafficShapingRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="trafficShapingEnabled")
    def traffic_shaping_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether traffic shaping rules are applied to clients on your SSID.
        """
        return pulumi.get(self, "traffic_shaping_enabled")

    @traffic_shaping_enabled.setter
    def traffic_shaping_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "traffic_shaping_enabled", value)


@pulumi.type_token("meraki:networks/wirelessSsidsTrafficShapingRules:WirelessSsidsTrafficShapingRules")
class WirelessSsidsTrafficShapingRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rules_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsTrafficShapingRulesRuleArgs', 'WirelessSsidsTrafficShapingRulesRuleArgsDict']]]]] = None,
                 traffic_shaping_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.WirelessSsidsTrafficShapingRules("example",
            default_rules_enabled=True,
            network_id="string",
            number="string",
            rules=[{
                "definitions": [{
                    "type": "host",
                    "value": "google.com",
                }],
                "dscp_tag_value": 1,
                "pcp_tag_value": 1,
                "per_client_bandwidth_limits": {
                    "bandwidth_limits": {
                        "limit_down": 1000000,
                        "limit_up": 1000000,
                    },
                    "settings": "custom",
                },
            }],
            traffic_shaping_enabled=True)
        pulumi.export("merakiNetworksWirelessSsidsTrafficShapingRulesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsTrafficShapingRules:WirelessSsidsTrafficShapingRules example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsTrafficShapingRulesRuleArgs', 'WirelessSsidsTrafficShapingRulesRuleArgsDict']]]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        :param pulumi.Input[_builtins.bool] traffic_shaping_enabled: Whether traffic shaping rules are applied to clients on your SSID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsTrafficShapingRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.WirelessSsidsTrafficShapingRules("example",
            default_rules_enabled=True,
            network_id="string",
            number="string",
            rules=[{
                "definitions": [{
                    "type": "host",
                    "value": "google.com",
                }],
                "dscp_tag_value": 1,
                "pcp_tag_value": 1,
                "per_client_bandwidth_limits": {
                    "bandwidth_limits": {
                        "limit_down": 1000000,
                        "limit_up": 1000000,
                    },
                    "settings": "custom",
                },
            }],
            traffic_shaping_enabled=True)
        pulumi.export("merakiNetworksWirelessSsidsTrafficShapingRulesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsTrafficShapingRules:WirelessSsidsTrafficShapingRules example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsTrafficShapingRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsTrafficShapingRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rules_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsTrafficShapingRulesRuleArgs', 'WirelessSsidsTrafficShapingRulesRuleArgsDict']]]]] = None,
                 traffic_shaping_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsTrafficShapingRulesArgs.__new__(WirelessSsidsTrafficShapingRulesArgs)

            __props__.__dict__["default_rules_enabled"] = default_rules_enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["rules"] = rules
            __props__.__dict__["traffic_shaping_enabled"] = traffic_shaping_enabled
        super(WirelessSsidsTrafficShapingRules, __self__).__init__(
            'meraki:networks/wirelessSsidsTrafficShapingRules:WirelessSsidsTrafficShapingRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_rules_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            number: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsTrafficShapingRulesRuleArgs', 'WirelessSsidsTrafficShapingRulesRuleArgsDict']]]]] = None,
            traffic_shaping_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'WirelessSsidsTrafficShapingRules':
        """
        Get an existing WirelessSsidsTrafficShapingRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsTrafficShapingRulesRuleArgs', 'WirelessSsidsTrafficShapingRulesRuleArgsDict']]]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        :param pulumi.Input[_builtins.bool] traffic_shaping_enabled: Whether traffic shaping rules are applied to clients on your SSID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsTrafficShapingRulesState.__new__(_WirelessSsidsTrafficShapingRulesState)

        __props__.__dict__["default_rules_enabled"] = default_rules_enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["rules"] = rules
        __props__.__dict__["traffic_shaping_enabled"] = traffic_shaping_enabled
        return WirelessSsidsTrafficShapingRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultRulesEnabled")
    def default_rules_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        """
        return pulumi.get(self, "default_rules_enabled")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Output[_builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.WirelessSsidsTrafficShapingRulesRule']]:
        """
        An array of traffic shaping rules. Rules are applied in the order that
        they are specified in. An empty list (or null) means no rules. Note that
        you are allowed a maximum of 8 rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="trafficShapingEnabled")
    def traffic_shaping_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether traffic shaping rules are applied to clients on your SSID.
        """
        return pulumi.get(self, "traffic_shaping_enabled")

