# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoginSecurityArgs', 'LoginSecurity']

@pulumi.input_type
class LoginSecurityArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 account_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 api_authentication: Optional[pulumi.Input['LoginSecurityApiAuthenticationArgs']] = None,
                 enforce_account_lockout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_different_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_idle_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_login_ip_ranges: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_password_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_strong_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_two_factor_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 login_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 num_different_passwords: Optional[pulumi.Input[_builtins.int]] = None,
                 password_expiration_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a LoginSecurity resource.
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.int] account_lockout_attempts: Number of consecutive failed login attempts after which users' accounts will be locked.
        :param pulumi.Input['LoginSecurityApiAuthenticationArgs'] api_authentication: Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_account_lockout: Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        :param pulumi.Input[_builtins.bool] enforce_different_passwords: Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        :param pulumi.Input[_builtins.bool] enforce_idle_timeout: Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        :param pulumi.Input[_builtins.bool] enforce_login_ip_ranges: Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_password_expiration: Boolean indicating whether users are forced to change their password every X number of days.
        :param pulumi.Input[_builtins.bool] enforce_strong_passwords: Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        :param pulumi.Input[_builtins.bool] enforce_two_factor_auth: Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        :param pulumi.Input[_builtins.int] idle_timeout_minutes: Number of minutes users can remain idle before being logged out of their accounts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] login_ip_ranges: List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        :param pulumi.Input[_builtins.int] num_different_passwords: Number of recent passwords that new password must be distinct from.
        :param pulumi.Input[_builtins.int] password_expiration_days: Number of days after which users will be forced to change their password.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if account_lockout_attempts is not None:
            pulumi.set(__self__, "account_lockout_attempts", account_lockout_attempts)
        if api_authentication is not None:
            pulumi.set(__self__, "api_authentication", api_authentication)
        if enforce_account_lockout is not None:
            pulumi.set(__self__, "enforce_account_lockout", enforce_account_lockout)
        if enforce_different_passwords is not None:
            pulumi.set(__self__, "enforce_different_passwords", enforce_different_passwords)
        if enforce_idle_timeout is not None:
            pulumi.set(__self__, "enforce_idle_timeout", enforce_idle_timeout)
        if enforce_login_ip_ranges is not None:
            pulumi.set(__self__, "enforce_login_ip_ranges", enforce_login_ip_ranges)
        if enforce_password_expiration is not None:
            pulumi.set(__self__, "enforce_password_expiration", enforce_password_expiration)
        if enforce_strong_passwords is not None:
            pulumi.set(__self__, "enforce_strong_passwords", enforce_strong_passwords)
        if enforce_two_factor_auth is not None:
            pulumi.set(__self__, "enforce_two_factor_auth", enforce_two_factor_auth)
        if idle_timeout_minutes is not None:
            pulumi.set(__self__, "idle_timeout_minutes", idle_timeout_minutes)
        if login_ip_ranges is not None:
            pulumi.set(__self__, "login_ip_ranges", login_ip_ranges)
        if num_different_passwords is not None:
            pulumi.set(__self__, "num_different_passwords", num_different_passwords)
        if password_expiration_days is not None:
            pulumi.set(__self__, "password_expiration_days", password_expiration_days)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="accountLockoutAttempts")
    def account_lockout_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive failed login attempts after which users' accounts will be locked.
        """
        return pulumi.get(self, "account_lockout_attempts")

    @account_lockout_attempts.setter
    def account_lockout_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_lockout_attempts", value)

    @_builtins.property
    @pulumi.getter(name="apiAuthentication")
    def api_authentication(self) -> Optional[pulumi.Input['LoginSecurityApiAuthenticationArgs']]:
        """
        Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        """
        return pulumi.get(self, "api_authentication")

    @api_authentication.setter
    def api_authentication(self, value: Optional[pulumi.Input['LoginSecurityApiAuthenticationArgs']]):
        pulumi.set(self, "api_authentication", value)

    @_builtins.property
    @pulumi.getter(name="enforceAccountLockout")
    def enforce_account_lockout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        """
        return pulumi.get(self, "enforce_account_lockout")

    @enforce_account_lockout.setter
    def enforce_account_lockout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_account_lockout", value)

    @_builtins.property
    @pulumi.getter(name="enforceDifferentPasswords")
    def enforce_different_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        """
        return pulumi.get(self, "enforce_different_passwords")

    @enforce_different_passwords.setter
    def enforce_different_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_different_passwords", value)

    @_builtins.property
    @pulumi.getter(name="enforceIdleTimeout")
    def enforce_idle_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        """
        return pulumi.get(self, "enforce_idle_timeout")

    @enforce_idle_timeout.setter
    def enforce_idle_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="enforceLoginIpRanges")
    def enforce_login_ip_ranges(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        """
        return pulumi.get(self, "enforce_login_ip_ranges")

    @enforce_login_ip_ranges.setter
    def enforce_login_ip_ranges(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_login_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="enforcePasswordExpiration")
    def enforce_password_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users are forced to change their password every X number of days.
        """
        return pulumi.get(self, "enforce_password_expiration")

    @enforce_password_expiration.setter
    def enforce_password_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_password_expiration", value)

    @_builtins.property
    @pulumi.getter(name="enforceStrongPasswords")
    def enforce_strong_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        """
        return pulumi.get(self, "enforce_strong_passwords")

    @enforce_strong_passwords.setter
    def enforce_strong_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_strong_passwords", value)

    @_builtins.property
    @pulumi.getter(name="enforceTwoFactorAuth")
    def enforce_two_factor_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        """
        return pulumi.get(self, "enforce_two_factor_auth")

    @enforce_two_factor_auth.setter
    def enforce_two_factor_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_two_factor_auth", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeoutMinutes")
    def idle_timeout_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes users can remain idle before being logged out of their accounts.
        """
        return pulumi.get(self, "idle_timeout_minutes")

    @idle_timeout_minutes.setter
    def idle_timeout_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout_minutes", value)

    @_builtins.property
    @pulumi.getter(name="loginIpRanges")
    def login_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        """
        return pulumi.get(self, "login_ip_ranges")

    @login_ip_ranges.setter
    def login_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "login_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="numDifferentPasswords")
    def num_different_passwords(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of recent passwords that new password must be distinct from.
        """
        return pulumi.get(self, "num_different_passwords")

    @num_different_passwords.setter
    def num_different_passwords(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_different_passwords", value)

    @_builtins.property
    @pulumi.getter(name="passwordExpirationDays")
    def password_expiration_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days after which users will be forced to change their password.
        """
        return pulumi.get(self, "password_expiration_days")

    @password_expiration_days.setter
    def password_expiration_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_expiration_days", value)


@pulumi.input_type
class _LoginSecurityState:
    def __init__(__self__, *,
                 account_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 api_authentication: Optional[pulumi.Input['LoginSecurityApiAuthenticationArgs']] = None,
                 enforce_account_lockout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_different_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_idle_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_login_ip_ranges: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_password_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_strong_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_two_factor_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 login_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 num_different_passwords: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password_expiration_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering LoginSecurity resources.
        :param pulumi.Input[_builtins.int] account_lockout_attempts: Number of consecutive failed login attempts after which users' accounts will be locked.
        :param pulumi.Input['LoginSecurityApiAuthenticationArgs'] api_authentication: Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_account_lockout: Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        :param pulumi.Input[_builtins.bool] enforce_different_passwords: Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        :param pulumi.Input[_builtins.bool] enforce_idle_timeout: Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        :param pulumi.Input[_builtins.bool] enforce_login_ip_ranges: Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_password_expiration: Boolean indicating whether users are forced to change their password every X number of days.
        :param pulumi.Input[_builtins.bool] enforce_strong_passwords: Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        :param pulumi.Input[_builtins.bool] enforce_two_factor_auth: Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        :param pulumi.Input[_builtins.int] idle_timeout_minutes: Number of minutes users can remain idle before being logged out of their accounts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] login_ip_ranges: List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        :param pulumi.Input[_builtins.int] num_different_passwords: Number of recent passwords that new password must be distinct from.
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.int] password_expiration_days: Number of days after which users will be forced to change their password.
        """
        if account_lockout_attempts is not None:
            pulumi.set(__self__, "account_lockout_attempts", account_lockout_attempts)
        if api_authentication is not None:
            pulumi.set(__self__, "api_authentication", api_authentication)
        if enforce_account_lockout is not None:
            pulumi.set(__self__, "enforce_account_lockout", enforce_account_lockout)
        if enforce_different_passwords is not None:
            pulumi.set(__self__, "enforce_different_passwords", enforce_different_passwords)
        if enforce_idle_timeout is not None:
            pulumi.set(__self__, "enforce_idle_timeout", enforce_idle_timeout)
        if enforce_login_ip_ranges is not None:
            pulumi.set(__self__, "enforce_login_ip_ranges", enforce_login_ip_ranges)
        if enforce_password_expiration is not None:
            pulumi.set(__self__, "enforce_password_expiration", enforce_password_expiration)
        if enforce_strong_passwords is not None:
            pulumi.set(__self__, "enforce_strong_passwords", enforce_strong_passwords)
        if enforce_two_factor_auth is not None:
            pulumi.set(__self__, "enforce_two_factor_auth", enforce_two_factor_auth)
        if idle_timeout_minutes is not None:
            pulumi.set(__self__, "idle_timeout_minutes", idle_timeout_minutes)
        if login_ip_ranges is not None:
            pulumi.set(__self__, "login_ip_ranges", login_ip_ranges)
        if num_different_passwords is not None:
            pulumi.set(__self__, "num_different_passwords", num_different_passwords)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if password_expiration_days is not None:
            pulumi.set(__self__, "password_expiration_days", password_expiration_days)

    @_builtins.property
    @pulumi.getter(name="accountLockoutAttempts")
    def account_lockout_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive failed login attempts after which users' accounts will be locked.
        """
        return pulumi.get(self, "account_lockout_attempts")

    @account_lockout_attempts.setter
    def account_lockout_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_lockout_attempts", value)

    @_builtins.property
    @pulumi.getter(name="apiAuthentication")
    def api_authentication(self) -> Optional[pulumi.Input['LoginSecurityApiAuthenticationArgs']]:
        """
        Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        """
        return pulumi.get(self, "api_authentication")

    @api_authentication.setter
    def api_authentication(self, value: Optional[pulumi.Input['LoginSecurityApiAuthenticationArgs']]):
        pulumi.set(self, "api_authentication", value)

    @_builtins.property
    @pulumi.getter(name="enforceAccountLockout")
    def enforce_account_lockout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        """
        return pulumi.get(self, "enforce_account_lockout")

    @enforce_account_lockout.setter
    def enforce_account_lockout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_account_lockout", value)

    @_builtins.property
    @pulumi.getter(name="enforceDifferentPasswords")
    def enforce_different_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        """
        return pulumi.get(self, "enforce_different_passwords")

    @enforce_different_passwords.setter
    def enforce_different_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_different_passwords", value)

    @_builtins.property
    @pulumi.getter(name="enforceIdleTimeout")
    def enforce_idle_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        """
        return pulumi.get(self, "enforce_idle_timeout")

    @enforce_idle_timeout.setter
    def enforce_idle_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="enforceLoginIpRanges")
    def enforce_login_ip_ranges(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        """
        return pulumi.get(self, "enforce_login_ip_ranges")

    @enforce_login_ip_ranges.setter
    def enforce_login_ip_ranges(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_login_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="enforcePasswordExpiration")
    def enforce_password_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users are forced to change their password every X number of days.
        """
        return pulumi.get(self, "enforce_password_expiration")

    @enforce_password_expiration.setter
    def enforce_password_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_password_expiration", value)

    @_builtins.property
    @pulumi.getter(name="enforceStrongPasswords")
    def enforce_strong_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        """
        return pulumi.get(self, "enforce_strong_passwords")

    @enforce_strong_passwords.setter
    def enforce_strong_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_strong_passwords", value)

    @_builtins.property
    @pulumi.getter(name="enforceTwoFactorAuth")
    def enforce_two_factor_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        """
        return pulumi.get(self, "enforce_two_factor_auth")

    @enforce_two_factor_auth.setter
    def enforce_two_factor_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_two_factor_auth", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeoutMinutes")
    def idle_timeout_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes users can remain idle before being logged out of their accounts.
        """
        return pulumi.get(self, "idle_timeout_minutes")

    @idle_timeout_minutes.setter
    def idle_timeout_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout_minutes", value)

    @_builtins.property
    @pulumi.getter(name="loginIpRanges")
    def login_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        """
        return pulumi.get(self, "login_ip_ranges")

    @login_ip_ranges.setter
    def login_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "login_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="numDifferentPasswords")
    def num_different_passwords(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of recent passwords that new password must be distinct from.
        """
        return pulumi.get(self, "num_different_passwords")

    @num_different_passwords.setter
    def num_different_passwords(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_different_passwords", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="passwordExpirationDays")
    def password_expiration_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days after which users will be forced to change their password.
        """
        return pulumi.get(self, "password_expiration_days")

    @password_expiration_days.setter
    def password_expiration_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_expiration_days", value)


@pulumi.type_token("meraki:organizations/loginSecurity:LoginSecurity")
class LoginSecurity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 api_authentication: Optional[pulumi.Input[Union['LoginSecurityApiAuthenticationArgs', 'LoginSecurityApiAuthenticationArgsDict']]] = None,
                 enforce_account_lockout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_different_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_idle_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_login_ip_ranges: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_password_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_strong_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_two_factor_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 login_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 num_different_passwords: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password_expiration_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.LoginSecurity("example",
            account_lockout_attempts=3,
            api_authentication={
                "ip_restrictions_for_keys": {
                    "enabled": True,
                    "ranges": [
                        "192.195.83.1",
                        "192.168.33.33",
                    ],
                },
            },
            enforce_account_lockout=True,
            enforce_different_passwords=True,
            enforce_idle_timeout=True,
            enforce_login_ip_ranges=True,
            enforce_password_expiration=True,
            enforce_strong_passwords=True,
            enforce_two_factor_auth=True,
            idle_timeout_minutes=30,
            login_ip_ranges=[
                "192.195.83.1",
                "192.195.83.255",
            ],
            num_different_passwords=3,
            organization_id="string",
            password_expiration_days=90)
        pulumi.export("merakiOrganizationsLoginSecurityExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/loginSecurity:LoginSecurity example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_lockout_attempts: Number of consecutive failed login attempts after which users' accounts will be locked.
        :param pulumi.Input[Union['LoginSecurityApiAuthenticationArgs', 'LoginSecurityApiAuthenticationArgsDict']] api_authentication: Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_account_lockout: Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        :param pulumi.Input[_builtins.bool] enforce_different_passwords: Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        :param pulumi.Input[_builtins.bool] enforce_idle_timeout: Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        :param pulumi.Input[_builtins.bool] enforce_login_ip_ranges: Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_password_expiration: Boolean indicating whether users are forced to change their password every X number of days.
        :param pulumi.Input[_builtins.bool] enforce_strong_passwords: Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        :param pulumi.Input[_builtins.bool] enforce_two_factor_auth: Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        :param pulumi.Input[_builtins.int] idle_timeout_minutes: Number of minutes users can remain idle before being logged out of their accounts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] login_ip_ranges: List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        :param pulumi.Input[_builtins.int] num_different_passwords: Number of recent passwords that new password must be distinct from.
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.int] password_expiration_days: Number of days after which users will be forced to change their password.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoginSecurityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.LoginSecurity("example",
            account_lockout_attempts=3,
            api_authentication={
                "ip_restrictions_for_keys": {
                    "enabled": True,
                    "ranges": [
                        "192.195.83.1",
                        "192.168.33.33",
                    ],
                },
            },
            enforce_account_lockout=True,
            enforce_different_passwords=True,
            enforce_idle_timeout=True,
            enforce_login_ip_ranges=True,
            enforce_password_expiration=True,
            enforce_strong_passwords=True,
            enforce_two_factor_auth=True,
            idle_timeout_minutes=30,
            login_ip_ranges=[
                "192.195.83.1",
                "192.195.83.255",
            ],
            num_different_passwords=3,
            organization_id="string",
            password_expiration_days=90)
        pulumi.export("merakiOrganizationsLoginSecurityExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/loginSecurity:LoginSecurity example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param LoginSecurityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoginSecurityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 api_authentication: Optional[pulumi.Input[Union['LoginSecurityApiAuthenticationArgs', 'LoginSecurityApiAuthenticationArgsDict']]] = None,
                 enforce_account_lockout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_different_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_idle_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_login_ip_ranges: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_password_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_strong_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_two_factor_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 login_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 num_different_passwords: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password_expiration_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoginSecurityArgs.__new__(LoginSecurityArgs)

            __props__.__dict__["account_lockout_attempts"] = account_lockout_attempts
            __props__.__dict__["api_authentication"] = api_authentication
            __props__.__dict__["enforce_account_lockout"] = enforce_account_lockout
            __props__.__dict__["enforce_different_passwords"] = enforce_different_passwords
            __props__.__dict__["enforce_idle_timeout"] = enforce_idle_timeout
            __props__.__dict__["enforce_login_ip_ranges"] = enforce_login_ip_ranges
            __props__.__dict__["enforce_password_expiration"] = enforce_password_expiration
            __props__.__dict__["enforce_strong_passwords"] = enforce_strong_passwords
            __props__.__dict__["enforce_two_factor_auth"] = enforce_two_factor_auth
            __props__.__dict__["idle_timeout_minutes"] = idle_timeout_minutes
            __props__.__dict__["login_ip_ranges"] = login_ip_ranges
            __props__.__dict__["num_different_passwords"] = num_different_passwords
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["password_expiration_days"] = password_expiration_days
        super(LoginSecurity, __self__).__init__(
            'meraki:organizations/loginSecurity:LoginSecurity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            api_authentication: Optional[pulumi.Input[Union['LoginSecurityApiAuthenticationArgs', 'LoginSecurityApiAuthenticationArgsDict']]] = None,
            enforce_account_lockout: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_different_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_idle_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_login_ip_ranges: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_password_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_strong_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_two_factor_auth: Optional[pulumi.Input[_builtins.bool]] = None,
            idle_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            login_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            num_different_passwords: Optional[pulumi.Input[_builtins.int]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            password_expiration_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'LoginSecurity':
        """
        Get an existing LoginSecurity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_lockout_attempts: Number of consecutive failed login attempts after which users' accounts will be locked.
        :param pulumi.Input[Union['LoginSecurityApiAuthenticationArgs', 'LoginSecurityApiAuthenticationArgsDict']] api_authentication: Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_account_lockout: Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        :param pulumi.Input[_builtins.bool] enforce_different_passwords: Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        :param pulumi.Input[_builtins.bool] enforce_idle_timeout: Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        :param pulumi.Input[_builtins.bool] enforce_login_ip_ranges: Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        :param pulumi.Input[_builtins.bool] enforce_password_expiration: Boolean indicating whether users are forced to change their password every X number of days.
        :param pulumi.Input[_builtins.bool] enforce_strong_passwords: Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        :param pulumi.Input[_builtins.bool] enforce_two_factor_auth: Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        :param pulumi.Input[_builtins.int] idle_timeout_minutes: Number of minutes users can remain idle before being logged out of their accounts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] login_ip_ranges: List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        :param pulumi.Input[_builtins.int] num_different_passwords: Number of recent passwords that new password must be distinct from.
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.int] password_expiration_days: Number of days after which users will be forced to change their password.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoginSecurityState.__new__(_LoginSecurityState)

        __props__.__dict__["account_lockout_attempts"] = account_lockout_attempts
        __props__.__dict__["api_authentication"] = api_authentication
        __props__.__dict__["enforce_account_lockout"] = enforce_account_lockout
        __props__.__dict__["enforce_different_passwords"] = enforce_different_passwords
        __props__.__dict__["enforce_idle_timeout"] = enforce_idle_timeout
        __props__.__dict__["enforce_login_ip_ranges"] = enforce_login_ip_ranges
        __props__.__dict__["enforce_password_expiration"] = enforce_password_expiration
        __props__.__dict__["enforce_strong_passwords"] = enforce_strong_passwords
        __props__.__dict__["enforce_two_factor_auth"] = enforce_two_factor_auth
        __props__.__dict__["idle_timeout_minutes"] = idle_timeout_minutes
        __props__.__dict__["login_ip_ranges"] = login_ip_ranges
        __props__.__dict__["num_different_passwords"] = num_different_passwords
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["password_expiration_days"] = password_expiration_days
        return LoginSecurity(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountLockoutAttempts")
    def account_lockout_attempts(self) -> pulumi.Output[_builtins.int]:
        """
        Number of consecutive failed login attempts after which users' accounts will be locked.
        """
        return pulumi.get(self, "account_lockout_attempts")

    @_builtins.property
    @pulumi.getter(name="apiAuthentication")
    def api_authentication(self) -> pulumi.Output['outputs.LoginSecurityApiAuthentication']:
        """
        Details for indicating whether organization will restrict access to API (but not Dashboard) to certain IP addresses.
        """
        return pulumi.get(self, "api_authentication")

    @_builtins.property
    @pulumi.getter(name="enforceAccountLockout")
    def enforce_account_lockout(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether users' Dashboard accounts will be locked out after a specified number of consecutive failed login attempts.
        """
        return pulumi.get(self, "enforce_account_lockout")

    @_builtins.property
    @pulumi.getter(name="enforceDifferentPasswords")
    def enforce_different_passwords(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether users, when setting a new password, are forced to choose a new password that is different from any past passwords.
        """
        return pulumi.get(self, "enforce_different_passwords")

    @_builtins.property
    @pulumi.getter(name="enforceIdleTimeout")
    def enforce_idle_timeout(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether users will be logged out after being idle for the specified number of minutes.
        """
        return pulumi.get(self, "enforce_idle_timeout")

    @_builtins.property
    @pulumi.getter(name="enforceLoginIpRanges")
    def enforce_login_ip_ranges(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether organization will restrict access to Dashboard (including the API) from certain IP addresses.
        """
        return pulumi.get(self, "enforce_login_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="enforcePasswordExpiration")
    def enforce_password_expiration(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether users are forced to change their password every X number of days.
        """
        return pulumi.get(self, "enforce_password_expiration")

    @_builtins.property
    @pulumi.getter(name="enforceStrongPasswords")
    def enforce_strong_passwords(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether users will be forced to choose strong passwords for their accounts. Strong passwords are at least 8 characters that contain 3 of the following: number, uppercase letter, lowercase letter, and symbol
        """
        return pulumi.get(self, "enforce_strong_passwords")

    @_builtins.property
    @pulumi.getter(name="enforceTwoFactorAuth")
    def enforce_two_factor_auth(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating whether users in this organization will be required to use an extra verification code when logging in to Dashboard. This code will be sent to their mobile phone via SMS, or can be generated by the authenticator application.
        """
        return pulumi.get(self, "enforce_two_factor_auth")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutMinutes")
    def idle_timeout_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of minutes users can remain idle before being logged out of their accounts.
        """
        return pulumi.get(self, "idle_timeout_minutes")

    @_builtins.property
    @pulumi.getter(name="loginIpRanges")
    def login_ip_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of acceptable IP ranges. Entries can be single IP addresses, IP address ranges, and CIDR subnets.
        """
        return pulumi.get(self, "login_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="numDifferentPasswords")
    def num_different_passwords(self) -> pulumi.Output[_builtins.int]:
        """
        Number of recent passwords that new password must be distinct from.
        """
        return pulumi.get(self, "num_different_passwords")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="passwordExpirationDays")
    def password_expiration_days(self) -> pulumi.Output[_builtins.int]:
        """
        Number of days after which users will be forced to change their password.
        """
        return pulumi.get(self, "password_expiration_days")

