# Generated by Django 2.2.18 on 2021-03-04 14:11

from django.db import migrations, models
from django.db.models.expressions import F


def initial_modified_properties(apps, schema_editor):
    for model in [
        "Case",
        "Flow",
        "Task",
        "TaskFlow",
        "WorkFlow",
        "WorkItem",
    ]:
        Model = apps.get_model(f"caluma_workflow.{model}")
        Model.objects.update(
            modified_by_user=F("created_by_user"),
            modified_by_group=F("created_by_group"),
        )


class Migration(migrations.Migration):
    dependencies = [
        ("caluma_workflow", "0026_auto_20200901_1435"),
    ]

    operations = [
        migrations.AddField(
            model_name="case",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="case",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="flow",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="flow",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalcase",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalcase",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalflow",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalflow",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicaltask",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicaltask",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicaltaskflow",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicaltaskflow",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalworkflow",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalworkflow",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalworkitem",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalworkitem",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="taskflow",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="taskflow",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="workflow",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="workflow",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="workitem",
            name="modified_by_group",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="workitem",
            name="modified_by_user",
            field=models.CharField(
                blank=True, db_index=True, max_length=150, null=True
            ),
        ),
        migrations.RunPython(initial_modified_properties, migrations.RunPython.noop),
    ]
