# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Annotated, TypeAlias

from .._utils import PropertyInfo
from .._models import BaseModel
from .scored_text_input_chunk import ScoredTextInputChunk
from .scored_audio_url_input_chunk import ScoredAudioURLInputChunk
from .scored_image_url_input_chunk import ScoredImageURLInputChunk
from .scored_video_url_input_chunk import ScoredVideoURLInputChunk

__all__ = ["StoreQuestionAnsweringResponse", "Source"]

Source: TypeAlias = Annotated[
    Union[ScoredTextInputChunk, ScoredImageURLInputChunk, ScoredAudioURLInputChunk, ScoredVideoURLInputChunk],
    PropertyInfo(discriminator="type"),
]


class StoreQuestionAnsweringResponse(BaseModel):
    answer: str
    """The answer generated by the LLM"""

    sources: Optional[List[Source]] = None
    """Source documents used to generate the answer"""
