# Foundation Langs Reference Guide

## Official Language Documentation (November 2025 Stable)

### Python Ecosystem

**Official Resources**:
- Python 3.13 Official Docs: https://docs.python.org/3/
- Python Enhancement Proposals (PEPs): https://peps.python.org/
- Python Package Index (PyPI): https://pypi.org/
- Python Version Status: https://devguide.python.org/versions/

**Framework Documentation**:
- FastAPI 0.115.x: https://fastapi.tiangolo.com/
- Django 5.1 Docs: https://docs.djangoproject.com/en/5.1/
- Flask 3.1 Docs: https://flask.palletsprojects.com/
- Pytest 8.3 Documentation: https://docs.pytest.org/

**Data Science Stack**:
- NumPy 2.1 User Guide: https://numpy.org/doc/stable/
- Pandas 2.2 Documentation: https://pandas.pydata.org/docs/
- Scikit-learn 1.5 Docs: https://scikit-learn.org/stable/documentation.html
- PyTorch 2.5 Docs: https://pytorch.org/docs/stable/index.html
- TensorFlow 2.17 Docs: https://www.tensorflow.org/api_docs

**Package Management**:
- uv Documentation: https://docs.astral.sh/uv/
- Poetry Documentation: https://python-poetry.org/docs/
- pip Official Guide: https://pip.pypa.io/en/stable/
- pip-audit: https://github.com/pypa/pip-audit

---

### JavaScript/TypeScript Ecosystem

**Official Resources**:
- Node.js 22.x API Docs: https://nodejs.org/docs/latest-v22.x/api/
- npm Registry: https://www.npmjs.com/
- npm Documentation: https://docs.npmjs.com/
- Yarn Package Manager: https://yarnpkg.com/
- pnpm Documentation: https://pnpm.io/

**TypeScript**:
- TypeScript 5.9 Docs: https://www.typescriptlang.org/docs/
- TypeScript Handbook: https://www.typescriptlang.org/docs/handbook/
- TypeScript Playground: https://www.typescriptlang.org/play

**Web Frameworks**:
- Express.js Guide: https://expressjs.com/
- Fastify 4.28 Documentation: https://www.fastify.io/docs/latest/
- NestJS Docs: https://docs.nestjs.com/
- Next.js 15 Docs: https://nextjs.org/docs
- React 19 Docs: https://react.dev/

**Testing**:
- Vitest 2.x Documentation: https://vitest.dev/
- Jest 29 Documentation: https://jestjs.io/docs/getting-started
- Playwright 1.48 Docs: https://playwright.dev/docs/intro
- Testing Library: https://testing-library.com/

---

### Go Ecosystem

**Official Resources**:
- Go 1.25 Official Docs: https://go.dev/doc/
- Go Packages (Standard Library): https://pkg.go.dev/std
- Go Module Documentation: https://go.dev/doc/modules/managing-dependencies

**Web Frameworks**:
- Gin Web Framework: https://gin-gonic.com/docs/
- Fiber Web Framework: https://docs.gofiber.io/
- Echo Framework: https://echo.labstack.com/
- Chi Router: https://github.com/go-chi/chi

**Database & ORM**:
- GORM Documentation: https://gorm.io/docs/
- sqlc (Type-safe SQL): https://sqlc.dev/

**Testing**:
- Go Testing Package: https://pkg.go.dev/testing
- Testify Assertion Library: https://github.com/stretchr/testify
- GoConvey: https://github.com/smartystreets/goconvey

**Cloud & DevOps**:
- Kubernetes Go Client: https://pkg.go.dev/k8s.io/client-go
- Docker SDK for Go: https://pkg.go.dev/github.com/moby/moby

---

### Rust Ecosystem

**Official Resources**:
- Rust Programming Language Book: https://doc.rust-lang.org/book/
- Rust Standard Library Docs: https://doc.rust-lang.org/std/
- Cargo Book: https://doc.rust-lang.org/cargo/
- Rustlings Course: https://github.com/rust-lang/rustlings

**Web Frameworks**:
- Axum Web Framework: https://github.com/tokio-rs/axum
- Actix-web 4.9: https://actix.rs/
- Rocket Framework: https://rocket.rs/

**Async Runtime**:
- Tokio 1.41 Documentation: https://tokio.rs/
- async-std Documentation: https://async.rs/

**Security & Cryptography**:
- Rustls TLS Library: https://docs.rs/rustls/latest/rustls/
- Ring Cryptography: https://docs.rs/ring/latest/ring/

**Testing**:
- Criterion Benchmarking: https://bheisler.github.io/criterion.rs/book/
- Proptest Property Testing: https://docs.rs/proptest/latest/proptest/

---

### Java Ecosystem

**Official Resources**:
- Java SE 25 Documentation: https://docs.oracle.com/en/java/javase/25/
- Java Language Specification: https://docs.oracle.com/javase/specs/
- OpenJDK Project: https://openjdk.org/
- Maven Central Repository: https://mvnrepository.com/

**Build Tools**:
- Apache Maven: https://maven.apache.org/
- Gradle Build Tool: https://gradle.org/

**Web Frameworks**:
- Spring Framework 6.1: https://spring.io/projects/spring-framework
- Spring Boot 3.3: https://spring.io/projects/spring-boot
- Quarkus Framework: https://quarkus.io/
- Micronaut: https://micronaut.io/

**Testing**:
- JUnit 5 Documentation: https://junit.org/junit5/docs/current/user-guide/
- Mockito: https://javadoc.io/doc/org.mockito/mockito-core/latest/org/mockito/Mockito.html

---

### PHP Ecosystem

**Official Resources**:
- PHP 8.4 Official Documentation: https://www.php.net/docs.php
- PHP Package Repository (Packagist): https://packagist.org/
- Composer Dependency Manager: https://getcomposer.org/
- PSR Standards: https://www.php-fig.org/psr/

**Web Frameworks**:
- Laravel 11: https://laravel.com/docs/11.x
- Symfony 7.1: https://symfony.com/doc/current/index.html
- WordPress VIP: https://wpvip.com/

**Testing**:
- PHPUnit 11: https://docs.phpunit.de/en/11.0/
- Pest Testing Framework: https://pestphp.com/

**Code Quality**:
- PHPStan: https://phpstan.org/
- PHP-CS-Fixer: https://cs.symfony.com/

---

### C++ Standards

**Official Resources**:
- ISO C++ Standard Committee: https://isocpp.org/
- C++23 Standard Status: https://en.cppreference.com/w/cpp/23
- cppreference.com (Community Reference): https://en.cppreference.com/w/
- C++ Core Guidelines: https://github.com/isocpp/CppCoreGuidelines

**Compiler Support**:
- GCC Compiler: https://gcc.gnu.org/
- Clang/LLVM: https://clang.llvm.org/
- MSVC: https://learn.microsoft.com/en-us/cpp/

---

### C# & .NET

**Official Resources**:
- C# 13 Language Docs: https://learn.microsoft.com/en-us/dotnet/csharp/
- .NET 9 Documentation: https://learn.microsoft.com/en-us/dotnet/
- .NET API Browser: https://learn.microsoft.com/en-us/dotnet/api/

**Web Frameworks**:
- ASP.NET Core 9: https://learn.microsoft.com/en-us/aspnet/core/
- Entity Framework Core 9: https://learn.microsoft.com/en-us/ef/core/

**Testing**:
- xUnit.net: https://xunit.net/
- NUnit: https://nunit.org/

---

### Kotlin Ecosystem

**Official Resources**:
- Kotlin Programming Language: https://kotlinlang.org/
- Kotlin Documentation: https://kotlinlang.org/docs/home.html
- Kotlin Playground: https://play.kotlinlang.org/

**Android Development**:
- Android Kotlin Docs: https://developer.android.com/kotlin
- Jetpack Compose: https://developer.android.com/jetpack/compose

**JVM Frameworks**:
- Ktor Web Framework: https://ktor.io/
- Spring Kotlin Support: https://spring.io/guides/tutorials/spring-boot-kotlin/

---

## Version Management Tools

### JavaScript/TypeScript
- **Node Version Manager (nvm)**: https://github.com/nvm-sh/nvm
- **fnm (Fast Node Manager)**: https://github.com/Schniz/fnm
- **n (Node.js Version Manager)**: https://github.com/tj/n
- **volta**: https://docs.volta.sh/guide/

### Python
- **pyenv**: https://github.com/pyenv/pyenv
- **uv**: https://docs.astral.sh/uv/
- **Poetry**: https://python-poetry.org/docs/
- **pipenv**: https://pipenv.pypa.io/

### Go
- **gvm (Go Version Manager)**: https://github.com/moovweb/gvm

### Rust
- **rustup**: https://rustup.rs/ (official version manager)

### Java
- **SDKMAN!**: https://sdkman.io/
- **asdf**: https://asdf-vm.com/ (multi-language)

---

## Security & Vulnerability Scanning

### Dependency Auditing
- **Snyk**: https://snyk.io/ (all languages)
- **WhiteSource**: https://www.whitesourcesoftware.com/ (enterprise)
- **npm audit**: Built-in npm command
- **cargo audit**: https://github.com/rustsec/cargo-audit
- **pip-audit**: https://github.com/pypa/pip-audit
- **govulncheck**: https://golang.org/x/vuln/cmd/govulncheck

### Code Security Analysis
- **SonarQube**: https://www.sonarqube.org/
- **OWASP Dependency-Check**: https://owasp.org/www-project-dependency-check/
- **Bandit (Python)**: https://bandit.readthedocs.io/
- **ESLint Security Plugin**: https://github.com/nodesecurity/eslint-plugin-security

---

## Performance Profiling & Benchmarking

### Python
- **cProfile**: Built-in standard library
- **line_profiler**: https://github.com/kernprof/line_profiler
- **memory_profiler**: https://github.com/pythonprofilers/memory_profiler
- **py-spy**: https://github.com/benfred/py-spy

### JavaScript
- **Node.js Profiler**: https://nodejs.org/en/docs/guides/simple-profiling/
- **0x**: https://github.com/clinicjs/node-clinic
- **autocannon**: https://github.com/mcollina/autocannon

### Go
- **pprof**: Built-in Go profiling (https://pkg.go.dev/net/http/pprof)
- **go-torch**: https://github.com/uber-archive/go-torch

### Rust
- **Criterion.rs**: https://bheisler.github.io/criterion.rs/book/
- **flamegraph**: https://github.com/flamegraph-rs/flamegraph
- **perf**: Built-in Linux tool

---

## CI/CD Integration

### Version Pinning in CI/CD

**GitHub Actions**:
```yaml
# Node.js
- uses: actions/setup-node@v4
  with:
    node-version: '22.11'

# Python
- uses: actions/setup-python@v5
  with:
    python-version: '3.13'

# Go
- uses: actions/setup-go@v5
  with:
    go-version: '1.25'
```

**GitLab CI/CD**:
```yaml
image: node:22.11

python:
  image: python:3.13

go:
  image: golang:1.25
```

---

## Changelog & Migration Guides

### Recent Major Changes (November 2025)

**Python 3.13** (Oct 2024):
- No more nested shell expansion in f-strings
- Performance improvements (~5-10% faster)
- New `typing.TypeVar` default syntax
- PEP 701: Flexible function and variable annotations

**Node.js 22.x** (Apr 2024, LTS Sept 2024):
- Default WebSocket client implementation
- Stable Watch Mode
- Module.register for custom loaders
- Deprecation of some internal modules

**Go 1.25** (Aug 2025):
- Improved profile-guided optimization
- Enhanced range over integers
- Built-in `math/rand/v2` for cryptographic randomness

**Rust 1.91** (Oct 2025):
- Continue stabilization of async traits
- Improved error messages
- Standard library enhancements

**Java 25** (Sept 2025):
- Record patterns (preview)
- Pattern matching enhancements
- Primitive type variables (preview)
- Virtual threads stabilization

---

## Quick Reference Links by Category

### Learning Resources
- Awesome Lists: https://github.com/sindresorhus/awesome
- Free Code Camp: https://www.freecodecamp.org/
- Exercism: https://exercism.org/
- Codecademy: https://www.codecademy.com/

### Online Playgrounds
- TypeScript Playground: https://www.typescriptlang.org/play
- Go Playground: https://go.dev/play/
- Rust Playground: https://play.rust-lang.org/
- Python Repl.it: https://replit.com/
- JDoodle: https://www.jdoodle.com/

### Framework Decision Tools
- Full Stack Python: https://www.fullstackpython.com/
- Awesome Go: https://awesome-go.com/
- Awesome Rust: https://github.com/rust-unofficial/awesome-rust
- Awesome JavaScript: https://github.com/sorrycc/awesome-javascript

---

## Summary

This reference guide provides direct links to:
- Official language documentation for 25+ languages
- Framework & ecosystem specific guides
- Version management tools
- Security scanning & auditing tools
- Performance profiling resources
- CI/CD integration examples
- Changelog & migration guides

**Use this when**: You need to consult official documentation, find tools, or understand specific framework features.
