# SAML 2.0 & OIDC - Official Documentation & Resources

## SAML 2.0 Specifications

1. [OASIS SAML 2.0 Core Specification](https://docs.oasis-open.org/security/saml/v2.0/saml-core-2.0-os.pdf)
2. [OASIS SAML 2.0 Bindings Specification](https://docs.oasis-open.org/security/saml/v2.0/saml-bindings-2.0-os.pdf)
3. [OASIS SAML 2.0 Metadata Specification](https://docs.oasis-open.org/security/saml/v2.0/saml-metadata-2.0-os.pdf)
4. [OASIS SAML 2.0 Profiles Specification](https://docs.oasis-open.org/security/saml/v2.0/saml-profiles-2.0-os.pdf)

## OpenID Connect (OIDC)

5. [OpenID Connect Core 1.0 Specification](https://openid.net/specs/openid-connect-core-1_0.html)
6. [OpenID Connect Discovery 1.0](https://openid.net/specs/openid-connect-discovery-1_0.html)
7. [OpenID Connect Session Management 1.0](https://openid.net/specs/openid-connect-session-1_0.html)
8. [OpenID Connect Dynamic Client Registration 1.0](https://openid.net/specs/openid-connect-registration-1_0.html)

## OAuth 2.0 & JWT

9. [OAuth 2.0 Authorization Framework (RFC 6749)](https://tools.ietf.org/html/rfc6749)
10. [OAuth 2.0 Bearer Token Usage (RFC 6750)](https://tools.ietf.org/html/rfc6750)
11. [JSON Web Token (JWT) - RFC 7519](https://tools.ietf.org/html/rfc7519)
12. [JSON Web Signature (JWS) - RFC 7515](https://tools.ietf.org/html/rfc7515)
13. [JSON Web Encryption (JWE) - RFC 7516](https://tools.ietf.org/html/rfc7516)

## Node.js Libraries

14. [passport-saml npm](https://www.npmjs.com/package/passport-saml)
15. [@node-saml/passport-saml npm](https://www.npmjs.com/package/@node-saml/passport-saml)
16. [openid-client npm](https://www.npmjs.com/package/openid-client)
17. [passport-openidconnect npm](https://www.npmjs.com/package/passport-openidconnect)
18. [jsonwebtoken npm](https://www.npmjs.com/package/jsonwebtoken)

## SCIM (System for Cross-domain Identity Management)

19. [SCIM 2.0 Core Schema (RFC 7643)](https://tools.ietf.org/html/rfc7643)
20. [SCIM 2.0 Protocol (RFC 7644)](https://tools.ietf.org/html/rfc7644)

## Identity Providers

21. [Auth0 SAML Configuration](https://auth0.com/docs/get-started/authentication-and-authorization-flow/industry-specific-oauth-and-oidc-implementations)
22. [Okta SAML & OIDC](https://developer.okta.com/docs/concepts/saml/)
23. [Keycloak SAML & OIDC](https://www.keycloak.org/documentation.html)
24. [Azure AD SAML & OIDC](https://docs.microsoft.com/en-us/azure/active-directory/develop/active-directory-protocols-oauth-code)

## Security Considerations

25. [OWASP SAML Security](https://owasp.org/www-community/attacks/SAML_Injection)
26. [OWASP OAuth 2.0 Security Best Practices](https://datatracker.ietf.org/doc/html/draft-ietf-oauth-security-topics)
27. [JWT Best Practices (RFC 8725)](https://tools.ietf.org/html/rfc8725)

## Context7 MCP Integration

28. [Context7 Identity Threat Intelligence](https://context7.ai/threat-intelligence/identity)
29. [Context7 SAML/OIDC Detection Rules](https://context7.ai/rules/identity)

