# Threat Modeling & IDS/IPS - Official Documentation & Resources

## STRIDE Threat Modeling

1. [Microsoft STRIDE Threat Modeling](https://learn.microsoft.com/en-us/azure/security/develop/threat-modeling-tool)
2. [STRIDE Methodology Guide](https://www.microsoft.com/en-us/securityengineering/sdl/practices)
3. [OWASP Threat Modeling](https://owasp.org/www-community/Threat_Modeling)
4. [Threat Modeling: A Practical Guide (Adam Shostack)](https://www.wiley.com/en-us/Threat+Modeling%3A+Designing+for+Security-p-9781118809990)

## Data Flow Diagrams (DFD)

5. [DFD Tutorial](https://www.lucidchart.com/pages/data-flow-diagram)
6. [NIST Guidelines for DFD](https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-14.pdf)

## Attack Trees

7. [Attack Trees Documentation](https://scholarsarchive.byu.edu/cgi/viewcontent.cgi?article=1821&context=facpub)
8. [NIST Attack Tree Analysis](https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-12r1.pdf)

## Snort 3.x IDS/IPS

9. [Snort 3.x Official Documentation](https://www.snort.org/documents)
10. [Snort Rule Writing Guide](https://docs.snort.org/rules)
11. [Snort Community Rules](https://www.snort.org/community)
12. [Snort Emerging Threats Rules](https://rules.emergingthreats.net/)

## Suricata 7.x IDS/IPS

13. [Suricata Official Documentation](https://suricata.io/documentation/)
14. [Suricata Rule Format](https://docs.suricata.io/en/latest/rules/index.html)
15. [Suricata Detection Engine](https://docs.suricata.io/en/latest/detection-engine/index.html)
16. [Suricata Configuration Guide](https://docs.suricata.io/en/latest/configuration/index.html)

## ModSecurity 3.x WAF

17. [ModSecurity Official Documentation](https://modsecurity.org/documentation)
18. [ModSecurity Rule Language v3](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual)
19. [OWASP CRS (Core Rule Set)](https://coreruleset.org/)
20. [ModSecurity Installation Guide](https://github.com/SpiderLabs/ModSecurity/wiki/Installation)

## WAF Deployment

21. [NIST Guidelines on WAF](https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-61r2.pdf)
22. [OWASP WAF Best Practices](https://owasp.org/www-community/attacks/xss/)

## IDS/IPS Tuning

23. [Snort Tuning Guide](https://docs.snort.org/start/snort3-quick-start)
24. [Suricata Tuning Guide](https://docs.suricata.io/en/latest/performance/tuning.html)
25. [False Positive Reduction in IDS/IPS](https://www.sans.org/white-papers/false-positives-ids-ips-7819/)

## Threat Intelligence

26. [NIST Cybersecurity Framework](https://www.nist.gov/cyberframework)
27. [MITRE ATT&CK Framework](https://attack.mitre.org/)
28. [MITRE CVE Database](https://cve.mitre.org/)
29. [OWASP Top 10 2021](https://owasp.org/Top10/)

## Context7 MCP Integration

30. [Context7 Threat Intelligence API](https://context7.ai/threat-intelligence)
31. [Context7 IDS/IPS Rules](https://context7.ai/rules/ids-ips)
32. [Context7 Alert Enrichment](https://context7.ai/enrichment)

