#!/usr/bin/env python3
# encoding: utf-8

__all__ = ["ERROR_CODE_TO_MESSAGE"]

from typing import Final


APP_ID: Final = "8025431004"
CLIENT_TYPE: Final = "10020"
RETURN_URL: Final = "https://m.cloud.189.cn/zhuanti/2020/loginErrorPc/index.html"

WEB_URL: Final       = "https://cloud.189.cn"
MOBIE_URL: Final     = "https://m.cloud.189.cn"
API_URL: Final       = "https://api.cloud.189.cn"
AUTH_URL: Final      = "https://open.e.189.cn"
USER_AUTH_URL: Final = "https://user.e.189.cn"
H5_URL: Final        = "https://h5.cloud.189.cn"
LOGIN_URL: Final     = "https://login.189pan.com"
UPLOAD_URL: Final    = "https://upload.cloud.189.cn"


#: 接口响应的报错码与对应的解释
ERROR_CODE_TO_MESSAGE: Final = {
    "AccessDenyOfHighFrequency": "由于访问频率过高，拒绝访问", 
    "AccessTimesOverLimited": "访问过于频繁，请稍后重试", 
    "AccountNotBind": "家庭云账号未绑定", 
    "AppNotExist": "合作应用不存在", 
    "Attach189SaveErrorCode": "访问189账号错误", 
    "AuditErrorCode": "文件名含敏感词", 
    "BusiAccountInvalid": "业务号不合法", 
    "BusiAccountUsed": "业务号已使用", 
    "CancelDeniedPermissions": "不具备家庭云注销权限", 
    "ClientTypeError": "客户端类型错误", 
    "CopyFileErrorCode": "复制文件错误", 
    "CreateFileError": "创建文件对象错误", 
    "CreateFolderErrorCode": "创建文件夹错误", 
    "CreateGroupErrorCode": "创建群组错误", 
    "DeleteDeniedPermission": "不具备家庭云删除权限", 
    "DeviceAlreadyBind": "设备与家庭云已绑定", 
    "DeviceBindCodeInvaliad": "设备绑定码错误", 
    "DeviceInfoNotFound": "设备不存在", 
    "DeviceNotBind": "设备与家庭云未绑定", 
    "DeviceNotExist": "设备不存在", 
    "DownloadFileMD5ErrorCode": "部分文件受版权限制，不支持下载", 
    "DynamicPwdNotfound": "动态密码不存在", 
    "ExitDeniedPermissions": "不具备家庭云退出权限", 
    "ExpiredVerifyCode": "验证码已失效", 
    "FamilyAccessPermissionDenied": "天翼账号接口权限不足", 
    "FamilyAccessRatesExceedLimit": "天翼账号接口访问频率太快", 
    "FamilyAccessTokenInvalid": "无效的家庭云AccessToken", 
    "FamilyAlreadyBind": "家庭云已被设备绑定", 
    "FamilyAlreadyOrderEnjoy": "已订购过乐享包", 
    "FamilyAlreadyOrderFlow": "已订购过流量包", 
    "FamilyBroadbandNoAlreadyBind": "宽带账号已绑定", 
    "FamilyBroadbandNoBindInfoNotFound": "未查询到宽带绑定信息", 
    "FamilyBroadbandNoInvaliad": "宽带账号无效", 
    "FamilyBroadbandNoNotFound": "未查询到宽带信息", 
    "FamilyBroadbandNoOpreateTypeInvalid": "操作类型无效", 
    "FamilyBroadbandNoOrderTypeInvalid": "订单类型无效", 
    "FamilyBroadbandNoRateStatusInvalid": "宽带速率无效", 
    "FamilyBroadbandNoStatusInvalid": "宽带状态无效", 
    "FamilyBroadbandNoValidateFailed": "宽带认证失败", 
    "FamilyBroadbandNotFound": "宽带账号不存在", 
    "FamilyBroadbandNotGD": "非广东宽带号码", 
    "FamilyBroadbandPwdInvalid": "宽带密码错误", 
    "FamilyBroadbandWeakPasswords": "宽带弱密码", 
    "FamilyCanNotAccess": "不允许访问家庭云", 
    "FamilyCanNotCreateFamily": "无法创建家庭云", 
    "FamilyDeviceNotPreBind": "设备未进行预绑定", 
    "FamilyEnjoyPackCanNotOrder": "无法订购家庭云乐享包", 
    "FamilyEnjoyStatusInProcess": "乐享包包为处理中状态", 
    "FamilyExistUnfinishedOrder": "存在未完成订单，不能办理当前业务", 
    "FamilyFlowOrderNotFound": "家庭云成员未办理定向流量", 
    "FamilyFlowPackNotSupportOrder": "不支持定向流量订购", 
    "FamilyFlowStatusInProcess": "定向流量包为处理中状态", 
    "FamilyIdCardInvaliad": "身份证无效", 
    "FamilyInfoExist": "家庭云已存在", 
    "FamilyInfoNotExist": "家庭云不存在", 
    "FamilyMobileAlreadyBind": "手机号码已绑定过宽带", 
    "FamilyMobileInvaliad": "手机号码无效", 
    "FamilyNoneOrderEnjoy": "未订购过乐享包", 
    "FamilyNoneOrderFlow": "未订购过流量包", 
    "FamilyNotTelcomMobile": "非电信手机号码", 
    "FamilyOperateFileNumberOverLimit": "家庭云操作文件个数超过限制", 
    "FamilyOrderFlowFailed": "流量包订购失败", 
    "FamilyParasDecryptError": "天翼账号签名解析错误", 
    "FamilySignInvaliad": "天翼账号接口签名无效", 
    "FamilySpecialCharacterInvaliad": "文件包含无效特殊字符", 
    "FamilySpeedAlreadStop": "宽带提速已经关闭", 
    "FamilySpeedExistOtherProdError": "同一线路已经使用其他产品在提速，不能再次提速", 
    "FamilySpeedQueryError": "宽带提速信息查询出错", 
    "FamilySpeedRepeatStartupError": "用户已经提速，不能再次提速", 
    "FamilySpeedRepeatStopError": "用户已经停止提速，不能再次停止提速", 
    "FamilySpeedStartupError": "启动提速出错", 
    "FamilySpeedStopError": "停止提速出错", 
    "FamilySpeedTimeOver": "家庭云智能提速时间已经使用完", 
    "FamilyTaskStatusInvaliad": "设备任务状态无效", 
    "FamilyTextAuditErrorCode": "家庭云敏感词检查失败", 
    "FamilyUseTimeOver": "家庭云试用时间到期", 
    "FamilyUserStatusInvaliad": "家庭云账号状态无效", 
    "FamilyVedioTranscodeFailed": "家庭云视频转码失败", 
    "FileAlreadyExists": "文件或文件夹已存在", 
    "FileCopyToSubFolderError": "复制文件到子目录错误", 
    "FileIconNotFoundErrorCode": "未找到文件缩略图错误", 
    "FileLengthVerifyFailed": "文件长度检查错误", 
    "FileMD5VerifyFailed": "文件MD5检查错误", 
    "FileNotFileErrorCode": "不正确的文件格式", 
    "FileNotFolderErrorCode": "文件不存在于文件夹中错误", 
    "FileNotFound": "文件或文件夹不存在", 
    "FileOwnerDirtyDataErrorCode": "用户文件脏数据错误", 
    "FileTooLarge": "上传文件超过最大限制", 
    "FolderShareLimited": "暂不支持该类文件分享", 
    "ForceDeletePermittionError": "不具备强力删除权限", 
    "GetAreaCodeFail": "获取地市编码失败", 
    "GetDynamicPwdFail": "获取动态密码失败", 
    "GetInputStreamError": "获取上传流接口错误", 
    "GetOOSSiteError": "获取OOS站点错误", 
    "GetParametersFailed": "参数有误", 
    "GetSignatureFailed": "获取签名失败", 
    "HttpMultiPartErrorCode": "Http传输多部分错误", 
    "HttpParseFieldErrorCode": "Http传输分析域错误", 
    "InfoSecurityErrorCode": "信息安全检查异常", 
    "InfosecuMD5CheckError": "转存的文件包含违规文件", 
    "InputStreamReadError": "上传流读取错误", 
    "InsufficientStorageSpace": "剩余存储空间不足", 
    "InsufficientStorageSpace_enjoy": "乐享包用户断点续传空间不足", 
    "InternalError": "内部错误", 
    "InvalidAccessToken": "AccessToken无效", 
    "InvalidAppSignature": "无效的appSignature签名", 
    "InvalidArgument": "无效参数", 
    "InvalidDeviceStatus": "设备异常：被登出、被锁定", 
    "InvalidHttpReq": "Http Multi格式错误", 
    "InvalidParamError": "无效参数", 
    "InvalidParentFolder": "无效父目录", 
    "InvalidPassword": "密码不正确", 
    "InvalidSessionKey": "无效会话信息", 
    "InvalidSignature": "无效签名", 
    "InvalidUploadFileStatus": "文件上传状态错误", 
    "InvalidVerifyCode": "验证码错误", 
    "IptvLoginFail": "IPTV免密登录失败", 
    "ListUserFileErrorCode": "获取用户文件列表错误", 
    "MemberCountExceedLimits": "家庭云成员个数超过上限", 
    "MemberInfoExist": "成员信息已存在", 
    "MemberInfoNotExist": "成员信息不存在", 
    "MobileFormatNotCorrect": "手机号码格式不正确", 
    "MoveFileValidError": "文件移动类型检查错误", 
    "NoSuchUser": "用户账号不存在", 
    "NullParameters": "必要参数为空", 
    "OfflineTaskCreateFailed": "离线任务创建失败", 
    "OpenAccountQueryFailed": "用户信息查询失败", 
    "OpenUserNameNone": "用户名称为空", 
    "OperationFailed": "操作失败", 
    "ParentNotFolder": "父文件夹类型不正确", 
    "PermissionDenied": "访问权限不足", 
    "QrCodeRollLoginFail": "二维码轮询登录失败", 
    "ReceiveDataUploadOOSErrorCode": "获取数据上传错误", 
    "RequestHeaderError": "请求头有误", 
    "RequestTooFast": "请求频率过高", 
    "SMSOverLimited": "当天验证码发送已达到上限", 
    "SafeAccessLoginTimeout": "私密空间文件访问超时", 
    "SaveFMFileOwnerErrorCode": "保存文件所属错误", 
    "SaveFMFileSyncOperErrorCode": "保存文件同步信息错误", 
    "SaveFMFlatDirErrorCode": "保存文件表路径错误", 
    "SaveFMMD5ErrorCode": "保存文件MD5码错误", 
    "SaveFileError": "保存文件错误", 
    "SaveFileIconErrorCode": "保存用户缩略图错误", 
    "SaveNetdisk2FMStorageObjectErrorCode": "保存网盘的存储对象到文件表错误", 
    "SaveNetdiskFileRelationErrorCode": "保存网盘文件关系错误", 
    "SaveStorageObjectErrorCode": "保存存储对象错误", 
    "SaveUserFileErrorCode": "保存用户文件错误", 
    "SaveUserStatusErrorCode": "保存用户状态错误", 
    "SendTooManyMessagesEveryDay": "每天短信发送次数过多", 
    "ServerInternalError": "服务器处理错误", 
    "ServiceNotOpen": "云存储服务尚未开通", 
    "ShareDumpFileOverload": "分享转存文件数目超限", 
    "ShareFileMD5ErrorCode": "部分文件受版权限制，不支持分享", 
    "ShareFileTypeFolderLimit": "暂不支持该类文件分享", 
    "ShareFileTypeLimit": "暂不支持该类文件分享", 
    "ShareOverLimitedNumber": "您分享的次数已达上限，请明天再来吧", 
    "SignatureError": "签名生成错误", 
    "StorageProviderTypeError": "资源池类型错误", 
    "SystemBusy": "系统繁忙", 
    "TaskAlreadyExist": "设备任务已经存在", 
    "TimestampExpired": "时间戳出错", 
    "TokenNotExist": "Token不存在", 
    "TriedTooManyTimes": "请求频率过高", 
    "UNKNOWN_ERROR": "未知错误", 
    "UnknownError": "未知错误", 
    "UploadDate2CSRPErrorCode": "上传日到客户同步资源错误", 
    "UploadDate2OOSErrorCode": "上传日期面向对象存储错误", 
    "UploadFileAccessFail": "断点续传重入错误", 
    "UploadFileAccessViolation": "上传文件访问冲突", 
    "UploadFileCompeletedError": "文件上传状态错误", 
    "UploadFileIdVerifyFailed": "断点续传文件Id无效", 
    "UploadFileNotFound": "上传记录不存在", 
    "UploadFileSaveFailed": "断点续传记录保存错误", 
    "UploadFileStatusVerifyFailed": "文件上传状态错误", 
    "UploadFileVerifyFailed": "文件上传状态错误", 
    "UploadOffsetVerifyFailed": "断点续传偏移错误", 
    "UploadToSwiftError": "上传到swift错误", 
    "UserApplyExistsError": "用户申请记录已存在", 
    "UserApplyNoneError": "用户未申请体验智能分类", 
    "UserDateMovingErrorCode": "用户时间变动错误", 
    "UserDayFlowOverLimited": "用户当日流量超过上限", 
    "UserInfoNotExist": "天翼云用户信息不存在", 
    "VerifyCodeHasSend": "验证码已发送，180秒内不允许重复发送", 
}
