import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for starting a job run with StartJobRun.
 *
 * @stability stable
 */
export interface GlueDataBrewStartJobRunProps extends sfn.TaskStateBaseProps {
    /**
     * Glue DataBrew Job to run.
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Start a Job run as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-databrew.html
 * @stability stable
 */
export declare class GlueDataBrewStartJobRun extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: GlueDataBrewStartJobRunProps);
    /**
     * Provides the Glue DataBrew Start Job Run task configuration
     * @internal
     */
    protected _renderTask(): any;
}
