import requests
import xml.etree.ElementTree as ET
from urllib.parse import urlparse
import pandas as pd


class SimpleSitemapParser:
    def __init__(self, sitemap_url: str):
        self.sitemap_url = sitemap_url

    def fetch(self):
        response = requests.get(self.sitemap_url, timeout=20)
        response.raise_for_status()
        return response.text

    def parse(self):
        xml_data = self.fetch()
        root = ET.fromstring(xml_data)
        namespace = {"ns": "http://www.sitemaps.org/schemas/sitemap/0.9"}

        rows = []

        for url_tag in root.findall("ns:url", namespace):
            loc_tag = url_tag.find("ns:loc", namespace)
            if loc_tag is None:
                continue

            full_url = loc_tag.text.strip()
            path = urlparse(full_url).path.strip("/")

            if path == "":
                category = ""
                slug = ""
            else:
                parts = path.split("/")
                category = parts[0]
                slug = "/".join(parts[1:]) if len(parts) > 1 else ""

            rows.append([full_url, category, slug])

        df = pd.DataFrame(rows, columns=["url", "category", "slug"])
        return df
